/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2yed;

import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.cif2yed.CifToYedColors;
import org.eclipse.escet.cif.cif2yed.CifToYedDiagram;
import org.eclipse.escet.cif.cif2yed.options.ModelFilter;
import org.eclipse.escet.cif.cif2yed.options.ModelFiltersOption;
import org.eclipse.escet.cif.common.CifEdgeUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.ComponentDef;
import org.eclipse.escet.cif.metamodel.cif.ComponentInst;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.IoDecl;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.SupKind;
import org.eclipse.escet.cif.metamodel.cif.annotations.Annotation;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.prettyprinter.CifPrettyPrinter;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.Termination;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.w3c.dom.Element;

public class CifToYedModelDiagram
extends CifToYedDiagram {
    private Set<ModelFilter> filters;

    @Override
    protected void addSpec(Specification spec, String absSpecPath, Element root, Termination termination) {
        this.filters = ModelFiltersOption.getFilters();
        this.rootGraph = this.doc.createElement("graph");
        root.appendChild(this.rootGraph);
        this.rootGraph.setAttribute("id", CifToYedModelDiagram.getId((PositionObject)spec));
        this.rootGraph.setAttribute("edgedefault", "directed");
        this.addCompBody((ComplexComponent)spec, this.rootGraph);
    }

    private void addComp(Component comp, Element parent) {
        if (comp instanceof Group) {
            this.addGroup((Group)comp, parent);
        } else if (comp instanceof Automaton) {
            this.addAutomaton((Automaton)comp, parent);
        } else {
            if (comp instanceof ComponentInst) {
                throw new RuntimeException("Should not get here.");
            }
            throw new RuntimeException("Unknown component: " + String.valueOf(comp));
        }
    }

    private void addGroup(Group group, Element parent) {
        parent = this.addCompNode((Component)group, parent);
        this.addCompBody((ComplexComponent)group, parent);
    }

    private void addAutomaton(Automaton aut, Element parent) {
        parent = this.addCompNode((Component)aut, parent);
        this.addCompBody((ComplexComponent)aut, parent);
    }

    private void addCompDef(ComponentDef cdef, Element parent) {
        ComplexComponent body = cdef.getBody();
        parent = this.addCompNode((Component)body, parent);
        this.addCompBody(body, parent);
    }

    private Element addCompNode(Component comp, Element parent) {
        CifToYedColors bgColor;
        Object title;
        Object kindText;
        boolean isBody = comp.eContainer() instanceof ComponentDef;
        ComponentDef cdef = null;
        Component body = comp;
        if (isBody) {
            cdef = (ComponentDef)comp.eContainer();
        }
        boolean isAut = body instanceof Automaton;
        boolean isGroup = body instanceof Group;
        Assert.check((isAut || isGroup ? 1 : 0) != 0);
        Element nodeElem = this.doc.createElement("node");
        parent.appendChild(nodeElem);
        String id = CifToYedModelDiagram.getId((PositionObject)comp);
        nodeElem.setAttribute("id", id);
        parent = nodeElem;
        nodeElem.setAttribute("yfiles.foldertype", "group");
        Element dnDataElem = this.doc.createElement("data");
        nodeElem.appendChild(dnDataElem);
        dnDataElem.setAttribute("key", "dn");
        Element ngDataElem = this.doc.createElement("data");
        nodeElem.appendChild(ngDataElem);
        ngDataElem.setAttribute("key", "ng");
        Element pabnElem = this.doc.createElement("y:ProxyAutoBoundsNode");
        ngDataElem.appendChild(pabnElem);
        Element realElem = this.doc.createElement("y:Realizers");
        pabnElem.appendChild(realElem);
        realElem.setAttribute("active", "0");
        if (isAut) {
            kindText = "automaton";
            SupKind kind = ((Automaton)body).getKind();
            if (kind != SupKind.NONE) {
                kindText = CifTextUtils.kindToStr((SupKind)kind) + " " + (String)kindText;
            }
        } else if (isGroup) {
            kindText = "group";
        } else {
            throw new RuntimeException("Unknown component: " + String.valueOf(comp));
        }
        if (cdef == null) {
            title = (String)kindText + " " + comp.getName();
            bgColor = CifToYedColors.COMP_HEADER_COLOR;
        } else {
            MemoryCodeBox cdefHeaderBox = new MemoryCodeBox(2);
            CifPrettyPrinter pprinter = new CifPrettyPrinter((CodeBox)cdefHeaderBox);
            pprinter.addHeader(cdef);
            String cdefHeaderText = cdefHeaderBox.toString();
            Assert.check((boolean)cdefHeaderText.endsWith(":"));
            title = Strings.slice((String)cdefHeaderText, null, (Integer)-1);
            bgColor = CifToYedColors.DEF_HEADER_COLOR;
        }
        dnDataElem.setTextContent((String)title);
        Iterator iterator = Lists.list((Object[])new Boolean[]{false, true}).iterator();
        while (iterator.hasNext()) {
            boolean closed = (Boolean)iterator.next();
            Element gnElem = this.doc.createElement("y:GroupNode");
            realElem.appendChild(gnElem);
            if (closed) {
                Element geoElem = this.doc.createElement("y:Geometry");
                gnElem.appendChild(geoElem);
                Rectangle2D size = this.guessTextSize((String)title, 5);
                double width = size.getWidth() + 40.0;
                double height = size.getHeight();
                geoElem.setAttribute("width", Strings.str((Object)width));
                geoElem.setAttribute("height", Strings.str((Object)height));
            }
            Object label = title;
            label = Strings.spaces((int)5) + (String)label;
            label = this.highlight((String)label);
            Element nlElem = this.doc.createElement("y:NodeLabel");
            gnElem.appendChild(nlElem);
            nlElem.setAttribute("alignment", "left");
            nlElem.setAttribute("autoSizePolicy", "node_width");
            nlElem.setAttribute("backgroundColor", bgColor.color);
            nlElem.setAttribute("modelName", "internal");
            nlElem.setAttribute("modelPosition", "t");
            nlElem.setAttribute("fontStyle", isGroup ? "italic" : "plain");
            nlElem.setTextContent((String)label);
            Element fillElem = this.doc.createElement("y:Fill");
            gnElem.appendChild(fillElem);
            CifToYedColors fillColor = closed ? CifToYedColors.COMP_BG_CLOSED_COLOR : CifToYedColors.COMP_BG_OPENED_COLOR;
            fillElem.setAttribute("color", fillColor.color);
            Element shapeElem = this.doc.createElement("y:Shape");
            gnElem.appendChild(shapeElem);
            shapeElem.setAttribute("type", "rectangle");
            Element stateElem = this.doc.createElement("y:State");
            gnElem.appendChild(stateElem);
            stateElem.setAttribute("closed", Strings.str((Object)closed));
        }
        Element graphElem = this.doc.createElement("graph");
        parent.appendChild(graphElem);
        graphElem.setAttribute("id", id + ":");
        graphElem.setAttribute("edgedefault", "directed");
        parent = graphElem;
        return parent;
    }

    private void addCompInsts(List<ComponentInst> insts, Element parent) {
        if (insts.isEmpty()) {
            return;
        }
        Element nodeElem = this.doc.createElement("node");
        parent.appendChild(nodeElem);
        Object id = parent.getAttribute("id");
        Assert.check((boolean)((String)id).endsWith(":"));
        id = (String)id + ":insts";
        nodeElem.setAttribute("id", (String)id);
        MemoryCodeBox code = new MemoryCodeBox(2);
        CifPrettyPrinter pprinter = new CifPrettyPrinter((CodeBox)code);
        for (ComponentInst inst : insts) {
            pprinter.add(inst);
        }
        String text = code.toString();
        nodeElem.setAttribute("yfiles.foldertype", "group");
        String title = "Instantiations";
        Element dnDataElem = this.doc.createElement("data");
        nodeElem.appendChild(dnDataElem);
        dnDataElem.setAttribute("key", "dn");
        dnDataElem.setTextContent(title);
        Element ngDataElem = this.doc.createElement("data");
        nodeElem.appendChild(ngDataElem);
        ngDataElem.setAttribute("key", "ng");
        Element pabnElem = this.doc.createElement("y:ProxyAutoBoundsNode");
        ngDataElem.appendChild(pabnElem);
        Element realElem = this.doc.createElement("y:Realizers");
        pabnElem.appendChild(realElem);
        realElem.setAttribute("active", "0");
        Iterator iterator = Lists.list((Object[])new Boolean[]{false, true}).iterator();
        while (iterator.hasNext()) {
            boolean closed = (Boolean)iterator.next();
            Element gnElem = this.doc.createElement("y:GroupNode");
            realElem.appendChild(gnElem);
            Object labelHeader = title;
            labelHeader = Strings.spaces((int)5) + (String)labelHeader;
            String labelText = closed ? "..." : text;
            Element geoElem = this.doc.createElement("y:Geometry");
            gnElem.appendChild(geoElem);
            Rectangle2D sizeHeader = this.guessTextSize((String)labelHeader, 5);
            Rectangle2D sizeText = this.guessTextSize(labelText, 5);
            double width = Math.max(sizeHeader.getWidth(), sizeText.getWidth());
            double height = sizeHeader.getHeight() + sizeText.getHeight() - 6.0;
            geoElem.setAttribute("width", Strings.str((Object)width));
            geoElem.setAttribute("height", Strings.str((Object)height));
            Element nlElemHeader = this.doc.createElement("y:NodeLabel");
            gnElem.appendChild(nlElemHeader);
            nlElemHeader.setAttribute("alignment", "left");
            nlElemHeader.setAttribute("autoSizePolicy", "node_width");
            nlElemHeader.setAttribute("backgroundColor", CifToYedColors.INST_HEADER_COLOR.color);
            nlElemHeader.setAttribute("modelName", "internal");
            nlElemHeader.setAttribute("modelPosition", "t");
            nlElemHeader.setTextContent((String)labelHeader);
            labelHeader = this.highlight((String)labelHeader);
            if (!closed) {
                labelText = this.highlight(labelText);
            }
            Element nlElemText = this.doc.createElement("y:NodeLabel");
            gnElem.appendChild(nlElemText);
            nlElemText.setAttribute("alignment", "left");
            nlElemText.setAttribute("autoSizePolicy", "content");
            nlElemText.setAttribute("modelName", "internal");
            nlElemText.setAttribute("modelPosition", "t");
            nlElemText.setAttribute("borderDistance", "18");
            nlElemText.setAttribute("topInset", "3");
            nlElemText.setAttribute("bottomInset", "3");
            nlElemText.setAttribute("leftInset", "3");
            nlElemText.setAttribute("rightInset", "3");
            nlElemText.setTextContent(labelText);
            Element fillElem = this.doc.createElement("y:Fill");
            gnElem.appendChild(fillElem);
            CifToYedColors fillColor = closed ? CifToYedColors.COMP_BG_CLOSED_COLOR : CifToYedColors.COMP_BG_OPENED_COLOR;
            fillElem.setAttribute("color", fillColor.color);
            Element shapeElem = this.doc.createElement("y:Shape");
            gnElem.appendChild(shapeElem);
            shapeElem.setAttribute("type", "rectangle");
            Element stateElem = this.doc.createElement("y:State");
            gnElem.appendChild(stateElem);
            stateElem.setAttribute("closed", Strings.str((Object)closed));
        }
    }

    private void addCompBody(ComplexComponent comp, Element parent) {
        if (comp instanceof Group) {
            for (ComponentDef cdef : ((Group)comp).getDefinitions()) {
                this.addCompDef(cdef, parent);
            }
            List insts = Lists.list();
            List others = Lists.list();
            for (Component child : ((Group)comp).getComponents()) {
                if (child instanceof ComponentInst) {
                    insts.add((ComponentInst)child);
                    continue;
                }
                boolean isAut = child instanceof Automaton;
                boolean isGroup = child instanceof Group;
                Assert.check((isAut || isGroup ? 1 : 0) != 0);
                others.add((ComplexComponent)child);
            }
            for (Component child : others) {
                this.addComp(child, parent);
            }
            this.addCompInsts(insts, parent);
        }
        MemoryCodeBox codeAnnos = new MemoryCodeBox(2);
        CifPrettyPrinter annosPrinter = new CifPrettyPrinter((CodeBox)codeAnnos);
        for (Annotation anno : comp.getAnnotations()) {
            annosPrinter.add(anno);
        }
        MemoryCodeBox codeAlphabetMonitors = new MemoryCodeBox(2);
        if (this.filters.contains((Object)ModelFilter.DECLS)) {
            CifPrettyPrinter pprinter = new CifPrettyPrinter((CodeBox)codeAlphabetMonitors);
            if (comp instanceof Automaton) {
                Automaton aut = (Automaton)comp;
                pprinter.add(aut.getAlphabet());
                pprinter.add(aut.getMonitors());
            }
        }
        MemoryCodeBox codeDecls = new MemoryCodeBox(2);
        if (this.filters.contains((Object)ModelFilter.DECLS)) {
            CifPrettyPrinter pprinter = new CifPrettyPrinter((CodeBox)codeDecls);
            for (Declaration decl : comp.getDeclarations()) {
                pprinter.add(decl);
            }
        }
        MemoryCodeBox codeInitInvEqnMark = new MemoryCodeBox(2);
        if (this.filters.contains((Object)ModelFilter.DECLS)) {
            CifPrettyPrinter pprinter = new CifPrettyPrinter((CodeBox)codeInitInvEqnMark);
            pprinter.addInitInvEqnsMarked((List)comp.getInitials(), (List)comp.getInvariants(), (List)comp.getEquations(), (List)comp.getMarkeds(), false);
        }
        MemoryCodeBox codeIoDecls = new MemoryCodeBox(2);
        if (this.filters.contains((Object)ModelFilter.IO)) {
            CifPrettyPrinter pprinter = new CifPrettyPrinter((CodeBox)codeIoDecls);
            for (IoDecl ioDecl : comp.getIoDecls()) {
                pprinter.add(ioDecl);
            }
        }
        MemoryCodeBox code = new MemoryCodeBox(2);
        CodeBox[] codeBoxArray = new CodeBox[]{codeAnnos, codeAlphabetMonitors, codeDecls, codeInitInvEqnMark, codeIoDecls};
        int n = codeBoxArray.length;
        int n2 = 0;
        while (n2 < n) {
            CodeBox c = codeBoxArray[n2];
            if (!c.getLines().isEmpty()) {
                if (!code.getLines().isEmpty()) {
                    code.add();
                }
                code.add(c.getLines());
            }
            ++n2;
        }
        this.addCifCodeNode((CodeBox)code, parent);
        if (comp instanceof Automaton) {
            Automaton aut = (Automaton)comp;
            int i = 0;
            while (i < aut.getLocations().size()) {
                Location loc = (Location)aut.getLocations().get(i);
                this.addLocation(loc, i, parent);
                ++i;
            }
        }
    }

    private void addCifCodeNode(CodeBox code, Element parent) {
        String text = code.toString();
        if (text.isEmpty()) {
            return;
        }
        Element nodeElem = this.doc.createElement("node");
        parent.appendChild(nodeElem);
        Object id = parent.getAttribute("id");
        Assert.check((boolean)((String)id).endsWith(":"));
        id = (String)id + ":code";
        nodeElem.setAttribute("id", (String)id);
        nodeElem.setAttribute("yfiles.foldertype", "group");
        String title = "Declarations";
        Element dnDataElem = this.doc.createElement("data");
        nodeElem.appendChild(dnDataElem);
        dnDataElem.setAttribute("key", "dn");
        dnDataElem.setTextContent(title);
        Element ngDataElem = this.doc.createElement("data");
        nodeElem.appendChild(ngDataElem);
        ngDataElem.setAttribute("key", "ng");
        Element pabnElem = this.doc.createElement("y:ProxyAutoBoundsNode");
        ngDataElem.appendChild(pabnElem);
        Element realElem = this.doc.createElement("y:Realizers");
        pabnElem.appendChild(realElem);
        realElem.setAttribute("active", "0");
        Iterator iterator = Lists.list((Object[])new Boolean[]{false, true}).iterator();
        while (iterator.hasNext()) {
            boolean closed = (Boolean)iterator.next();
            Element gnElem = this.doc.createElement("y:GroupNode");
            realElem.appendChild(gnElem);
            Object labelHeader = title;
            labelHeader = Strings.spaces((int)5) + (String)labelHeader;
            String labelText = closed ? "..." : text;
            Element geoElem = this.doc.createElement("y:Geometry");
            gnElem.appendChild(geoElem);
            Rectangle2D sizeHeader = this.guessTextSize((String)labelHeader, 5);
            Rectangle2D sizeText = this.guessTextSize(labelText, 5);
            double width = Math.max(sizeHeader.getWidth(), sizeText.getWidth());
            double height = sizeHeader.getHeight() + sizeText.getHeight() - 6.0;
            geoElem.setAttribute("width", Strings.str((Object)width));
            geoElem.setAttribute("height", Strings.str((Object)height));
            Element nlElemHeader = this.doc.createElement("y:NodeLabel");
            gnElem.appendChild(nlElemHeader);
            nlElemHeader.setAttribute("alignment", "left");
            nlElemHeader.setAttribute("autoSizePolicy", "node_width");
            nlElemHeader.setAttribute("backgroundColor", CifToYedColors.CODE_HEADER_COLOR.color);
            nlElemHeader.setAttribute("modelName", "internal");
            nlElemHeader.setAttribute("modelPosition", "t");
            nlElemHeader.setTextContent((String)labelHeader);
            labelHeader = this.highlight((String)labelHeader);
            if (!closed) {
                labelText = this.highlight(labelText);
            }
            Element nlElemText = this.doc.createElement("y:NodeLabel");
            gnElem.appendChild(nlElemText);
            nlElemText.setAttribute("alignment", "left");
            nlElemText.setAttribute("autoSizePolicy", "content");
            nlElemText.setAttribute("modelName", "internal");
            nlElemText.setAttribute("modelPosition", "t");
            nlElemText.setAttribute("borderDistance", "18");
            nlElemText.setAttribute("topInset", "3");
            nlElemText.setAttribute("bottomInset", "3");
            nlElemText.setAttribute("leftInset", "3");
            nlElemText.setAttribute("rightInset", "3");
            nlElemText.setTextContent(labelText);
            Element bsElem = this.doc.createElement("y:BorderStyle");
            gnElem.appendChild(bsElem);
            bsElem.setAttribute("lineType", "dashed");
            Element fillElem = this.doc.createElement("y:Fill");
            gnElem.appendChild(fillElem);
            fillElem.setAttribute("color", CifToYedColors.CODE_BG_COLOR.color);
            Element shapeElem = this.doc.createElement("y:Shape");
            gnElem.appendChild(shapeElem);
            shapeElem.setAttribute("type", "rectangle");
            Element stateElem = this.doc.createElement("y:State");
            gnElem.appendChild(stateElem);
            stateElem.setAttribute("closed", Strings.str((Object)closed));
        }
    }

    private void addLocation(Location loc, int idx, Element parent) {
        Element nodeElem = this.doc.createElement("node");
        parent.appendChild(nodeElem);
        String parentId = parent.getAttribute("id");
        Assert.check((boolean)parentId.endsWith(":"));
        String locId = parentId + ":loc" + Strings.str((Object)idx);
        nodeElem.setAttribute("id", locId);
        MemoryCodeBox code1 = new MemoryCodeBox(2);
        if (!loc.getAnnotations().isEmpty()) {
            CifPrettyPrinter pprinter1 = new CifPrettyPrinter((CodeBox)code1);
            pprinter1.add((List)loc.getAnnotations());
        }
        if (loc.getName() != null) {
            code1.add(loc.getName());
        }
        MemoryCodeBox code2 = new MemoryCodeBox(2);
        if (this.filters.contains((Object)ModelFilter.LOC_DECLS)) {
            CifPrettyPrinter pprinter2 = new CifPrettyPrinter((CodeBox)code2);
            pprinter2.addInitInvEqnsMarked(Collections.emptyList(), (List)loc.getInvariants(), (List)loc.getEquations(), (List)loc.getMarkeds(), true);
            if (loc.isUrgent()) {
                code2.add("urgent;");
            }
        }
        Object description = "location";
        if (loc.getName() != null) {
            description = (String)description + " " + loc.getName();
        }
        MemoryCodeBox code = new MemoryCodeBox(2);
        CodeBox[] codeBoxArray = new CodeBox[]{code1, code2};
        int n = codeBoxArray.length;
        int n2 = 0;
        while (n2 < n) {
            CodeBox c = codeBoxArray[n2];
            if (!c.getLines().isEmpty()) {
                if (!code.getLines().isEmpty()) {
                    code.add();
                }
                code.add(c.getLines());
            }
            ++n2;
        }
        String label = code.toString();
        Element dnDataElem = this.doc.createElement("data");
        nodeElem.appendChild(dnDataElem);
        dnDataElem.setAttribute("key", "dn");
        dnDataElem.setTextContent((String)description);
        Element ngDataElem = this.doc.createElement("data");
        nodeElem.appendChild(ngDataElem);
        ngDataElem.setAttribute("key", "ng");
        Element snElem = this.doc.createElement("y:ShapeNode");
        ngDataElem.appendChild(snElem);
        Element geoElem = this.doc.createElement("y:Geometry");
        snElem.appendChild(geoElem);
        Rectangle2D size = this.guessTextSize(label, 5);
        double width = size.getWidth() + 30.0;
        double height = size.getHeight();
        geoElem.setAttribute("width", Strings.str((Object)width));
        geoElem.setAttribute("height", Strings.str((Object)height));
        label = this.highlight(label);
        Element nlElem = this.doc.createElement("y:NodeLabel");
        snElem.appendChild(nlElem);
        nlElem.setAttribute("alignment", "left");
        nlElem.setAttribute("autoSizePolicy", "content");
        nlElem.setAttribute("modelName", "internal");
        nlElem.setAttribute("modelPosition", "c");
        nlElem.setTextContent(label);
        Element fillElem = this.doc.createElement("y:Fill");
        snElem.appendChild(fillElem);
        fillElem.setAttribute("color", CifToYedColors.LOC_BG_COLOR.color);
        Element shapeElem = this.doc.createElement("y:Shape");
        snElem.appendChild(shapeElem);
        shapeElem.setAttribute("type", "roundrectangle");
        this.addLocInit(loc, locId, parent);
        for (Edge edge : loc.getEdges()) {
            Automaton aut = (Automaton)loc.eContainer();
            Location tgtLoc = CifEdgeUtils.getTarget((Edge)edge);
            int tgtIdx = aut.getLocations().indexOf((Object)tgtLoc);
            String tgtId = parentId + ":loc" + Strings.str((Object)tgtIdx);
            this.addEdge(edge, locId, tgtId, parent);
        }
    }

    private void addLocInit(Location loc, String locId, Element parent) {
        boolean hasInit;
        EList inits = loc.getInitials();
        boolean bl = hasInit = !inits.isEmpty() && !CifValueUtils.isTriviallyFalse((List)inits, (boolean)true, (boolean)true);
        if (!hasInit) {
            return;
        }
        Element initNodeElem = this.doc.createElement("node");
        parent.appendChild(initNodeElem);
        String initId = locId + "::init";
        initNodeElem.setAttribute("id", initId);
        Element dnDataElem = this.doc.createElement("data");
        initNodeElem.appendChild(dnDataElem);
        dnDataElem.setAttribute("key", "dn");
        dnDataElem.setTextContent("<init>");
        Element initNgDataElem = this.doc.createElement("data");
        initNodeElem.appendChild(initNgDataElem);
        initNgDataElem.setAttribute("key", "ng");
        Element initSnElem = this.doc.createElement("y:ShapeNode");
        initNgDataElem.appendChild(initSnElem);
        Element initGeoElem = this.doc.createElement("y:Geometry");
        initSnElem.appendChild(initGeoElem);
        initGeoElem.setAttribute("width", "1");
        initGeoElem.setAttribute("height", "1");
        Element initBsElem = this.doc.createElement("y:BorderStyle");
        initSnElem.appendChild(initBsElem);
        initBsElem.setAttribute("hasColor", "false");
        Element initFillElem = this.doc.createElement("y:Fill");
        initSnElem.appendChild(initFillElem);
        initFillElem.setAttribute("transparent", "true");
        Element initEdgeElem = this.doc.createElement("edge");
        parent.appendChild(initEdgeElem);
        initEdgeElem.setAttribute("source", initId);
        initEdgeElem.setAttribute("target", locId);
        Element initEdgeEgDataElem = this.doc.createElement("data");
        initEdgeElem.appendChild(initEdgeEgDataElem);
        initEdgeEgDataElem.setAttribute("key", "eg");
        Element initEdgePleElem = this.doc.createElement("y:PolyLineEdge");
        initEdgeEgDataElem.appendChild(initEdgePleElem);
        Element initEdgeArrElem = this.doc.createElement("y:Arrows");
        initEdgePleElem.appendChild(initEdgeArrElem);
        initEdgeArrElem.setAttribute("source", "none");
        initEdgeArrElem.setAttribute("target", "arrow");
        Element initEdgeBsElem = this.doc.createElement("y:BendStyle");
        initEdgePleElem.appendChild(initEdgeBsElem);
        initEdgeBsElem.setAttribute("smoothed", "true");
        if (!CifValueUtils.isTriviallyTrue((List)inits, (boolean)true, (boolean)true)) {
            CifPrettyPrinter pprinter = new CifPrettyPrinter(null);
            String label = pprinter.pprint((List)inits, ", ");
            Element edgeLblElem = this.doc.createElement("y:EdgeLabel");
            initEdgePleElem.appendChild(edgeLblElem);
            edgeLblElem.setAttribute("alignment", "center");
            edgeLblElem.setAttribute("modelName", "six_pos");
            edgeLblElem.setAttribute("modelPosition", "tail");
            this.addEdgeLabelBackground(edgeLblElem);
            label = this.highlight(label);
            edgeLblElem.setTextContent(label);
        }
    }

    private void addEdge(Edge edge, String src, String tgt, Element parent) {
        EList edgeEvents;
        Element edgeElem = this.doc.createElement("edge");
        parent.appendChild(edgeElem);
        edgeElem.setAttribute("source", src);
        edgeElem.setAttribute("target", tgt);
        Element edgeEgDataElem = this.doc.createElement("data");
        edgeElem.appendChild(edgeEgDataElem);
        edgeEgDataElem.setAttribute("key", "eg");
        Element edgePleElem = this.doc.createElement("y:PolyLineEdge");
        edgeEgDataElem.appendChild(edgePleElem);
        Element edgeArrElem = this.doc.createElement("y:Arrows");
        edgePleElem.appendChild(edgeArrElem);
        edgeArrElem.setAttribute("source", "none");
        edgeArrElem.setAttribute("target", "arrow");
        Element edgeBsElem = this.doc.createElement("y:BendStyle");
        edgePleElem.appendChild(edgeBsElem);
        edgeBsElem.setAttribute("smoothed", "true");
        List texts = Lists.listc((int)1);
        MemoryCodeBox annoBox = new MemoryCodeBox(2);
        CifPrettyPrinter pprinter = new CifPrettyPrinter((CodeBox)annoBox);
        EList guards = edge.getGuards();
        EList updates = edge.getUpdates();
        if (!edge.getAnnotations().isEmpty()) {
            pprinter.add((List)edge.getAnnotations());
            texts.addAll(annoBox.getLines());
        }
        if ((edgeEvents = edge.getEvents()).isEmpty()) {
            if (guards.isEmpty() && !edge.isUrgent() && updates.isEmpty()) {
                texts.add("tau");
            }
        } else {
            texts.add(pprinter.pprintEdgeEvents((List)edgeEvents));
        }
        if (this.filters.contains((Object)ModelFilter.GUARDS) && !guards.isEmpty()) {
            texts.add("when " + pprinter.pprint((List)guards, ", "));
        }
        if (this.filters.contains((Object)ModelFilter.GUARDS) && edge.isUrgent()) {
            texts.add("now");
        }
        if (this.filters.contains((Object)ModelFilter.UPDATES) && !updates.isEmpty()) {
            texts.add("do " + pprinter.pprintUpdates((List)updates));
        }
        String text = String.join((CharSequence)"\n", texts);
        Element edgeLblElem = this.doc.createElement("y:EdgeLabel");
        edgePleElem.appendChild(edgeLblElem);
        edgeLblElem.setAttribute("alignment", "center");
        this.addEdgeLabelBackground(edgeLblElem);
        String label = this.highlight(text);
        edgeLblElem.setTextContent(label);
    }

    private static String getId(PositionObject obj) {
        String name = CifTextUtils.getAbsName((PositionObject)obj, (boolean)false);
        return "cif:" + name.replace('.', ':');
    }
}

