/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.util;

import org.apache.qpid.jms.message.JmsInboundMessageDispatch;
import org.apache.qpid.jms.util.MessageQueue;

public abstract class AbstractMessageQueue
implements MessageQueue {
    private volatile boolean closed;
    private volatile boolean running;
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final JmsInboundMessageDispatch peek() {
        Object object = this.lock;
        synchronized (object) {
            return this.peekFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final JmsInboundMessageDispatch dequeue(long timeout) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (timeout != 0L && !this.closed && this.isEmpty() && this.running) {
                if (timeout == -1L) {
                    this.lock.wait();
                    continue;
                }
                long start = System.currentTimeMillis();
                this.lock.wait(timeout);
                timeout = Math.max(timeout + start - System.currentTimeMillis(), 0L);
            }
            if (this.closed || !this.running || this.isEmpty()) {
                return null;
            }
            return this.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final JmsInboundMessageDispatch dequeueNoWait() {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed || !this.running || this.isEmpty()) {
                return null;
            }
            return this.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void start() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.closed) {
                this.running = true;
            }
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void stop() {
        Object object = this.lock;
        synchronized (object) {
            this.running = false;
            this.lock.notifyAll();
        }
    }

    @Override
    public final boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        Object object = this.lock;
        synchronized (object) {
            this.running = false;
            this.closed = true;
            this.lock.notifyAll();
        }
    }

    @Override
    public final boolean isClosed() {
        return this.closed;
    }

    @Override
    public final Object getLock() {
        return this.lock;
    }

    protected abstract JmsInboundMessageDispatch removeFirst();

    protected abstract JmsInboundMessageDispatch peekFirst();
}

