/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.ble.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.internal.ble.util.BTSnoopListener;
import org.eclipse.kura.internal.ble.util.BTSnoopParser;
import org.eclipse.kura.internal.ble.util.BluetoothProcessListener;

public class BluetoothProcess {
    private static final Logger logger = LogManager.getLogger(BluetoothProcess.class);
    private static final ExecutorService streamGobblers = Executors.newCachedThreadPool();
    private Process process;
    private Future<?> futureInputGobbler;
    private Future<?> futureErrorGobbler;
    private BufferedWriter bufferedWriter;
    private BTSnoopParser parser;
    private boolean btSnoopReady;

    public BufferedWriter getWriter() {
        return this.bufferedWriter;
    }

    void exec(String[] cmdArray, BluetoothProcessListener listener) throws IOException {
        logger.debug("Executing: {}", (Object)Arrays.toString(cmdArray));
        ProcessBuilder pb = new ProcessBuilder(cmdArray);
        this.process = pb.start();
        this.bufferedWriter = new BufferedWriter(new OutputStreamWriter(this.process.getOutputStream()));
        this.futureInputGobbler = streamGobblers.submit(() -> {
            Thread.currentThread().setName("BluetoothProcess Input Stream Gobbler");
            try {
                this.readInputStreamFully(this.process.getInputStream(), listener);
            }
            catch (IOException | KuraException e) {
                logger.error("Process input stream failed", e);
            }
        });
        this.futureErrorGobbler = streamGobblers.submit(() -> {
            Thread.currentThread().setName("BluetoothProcess ErrorStream Gobbler");
            try {
                this.readErrorStreamFully(this.process.getErrorStream(), listener);
            }
            catch (IOException | KuraException e) {
                logger.error("Process error stream failed", e);
            }
        });
    }

    void execSnoop(String[] cmdArray, BTSnoopListener listener) throws IOException {
        this.btSnoopReady = true;
        if (this.parser == null) {
            this.parser = new BTSnoopParser();
        }
        logger.debug("Executing: {}", (Object)Arrays.toString(cmdArray));
        ProcessBuilder pb = new ProcessBuilder(cmdArray);
        this.process = pb.start();
        this.bufferedWriter = new BufferedWriter(new OutputStreamWriter(this.process.getOutputStream()));
        this.futureInputGobbler = streamGobblers.submit(() -> {
            Thread.currentThread().setName("BluetoothProcess BTSnoop Gobbler");
            try {
                this.readBTSnoopStreamFully(this.process.getInputStream(), listener);
            }
            catch (IOException e) {
                logger.error("Process snoop input stream failed", (Throwable)e);
            }
        });
        this.futureErrorGobbler = streamGobblers.submit(() -> {
            Thread.currentThread().setName("BluetoothProcess BTSnoop ErrorStream Gobbler");
            try {
                this.readBTErrorStreamFully(this.process.getErrorStream(), listener);
            }
            catch (IOException e) {
                logger.error("Process snoop error stream failed", (Throwable)e);
            }
        });
    }

    public void destroy() {
        if (this.process != null) {
            this.closeStreams();
            this.process.destroy();
            this.process = null;
        }
    }

    public void destroyBTSnoop() {
        if (this.process != null) {
            this.btSnoopReady = false;
        }
    }

    private String readStream(InputStream is) throws IOException {
        String line;
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        while ((line = br.readLine()) != null) {
            stringBuilder.append(String.valueOf(line) + "\n");
        }
        logger.debug("End of stream!");
        return stringBuilder.toString();
    }

    private void readInputStreamFully(InputStream is, BluetoothProcessListener listener) throws IOException, KuraException {
        listener.processInputStream(this.readStream(is));
    }

    private void readBTSnoopStreamFully(InputStream is, BTSnoopListener listener) throws IOException {
        this.parser.setInputStream(is);
        while (this.btSnoopReady) {
            if (is == null) continue;
            byte[] packet = this.parser.readRecord();
            listener.processBTSnoopRecord(packet);
        }
        this.closeStreams();
        this.process.destroy();
        this.process = null;
        logger.debug("End of stream!");
    }

    private void readErrorStreamFully(InputStream is, BluetoothProcessListener listener) throws IOException, KuraException {
        listener.processErrorStream(this.readStream(is));
    }

    private void readBTErrorStreamFully(InputStream is, BTSnoopListener listener) throws IOException {
        listener.processBTSnoopErrorStream(this.readStream(is));
    }

    private void closeStreams() {
        logger.info("Closing streams and killing...");
        if (this.futureInputGobbler != null) {
            this.futureInputGobbler.cancel(true);
        }
        if (this.futureErrorGobbler != null) {
            this.futureErrorGobbler.cancel(true);
        }
        this.closeQuietly(this.process.getErrorStream());
        this.closeQuietly(this.process.getOutputStream());
        this.closeQuietly(this.process.getInputStream());
    }

    private void closeQuietly(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                logger.warn("Failed to close process input stream", (Throwable)e);
            }
        }
    }

    private void closeQuietly(OutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException e) {
                logger.warn("Failed to close process output stream", (Throwable)e);
            }
        }
    }
}

