/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.librato.metrics.reporter.Librato;
import io.moquette.broker.NettyUtils;
import io.moquette.broker.config.IConfig;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageType;
import java.util.concurrent.TimeUnit;

@ChannelHandler.Sharable
public final class DropWizardMetricsHandler
extends ChannelInboundHandlerAdapter {
    private MetricRegistry metrics;
    private Meter publishesMetrics;
    private Meter subscribeMetrics;
    private Counter connectedClientsMetrics;

    public void init(IConfig props) {
        this.metrics = new MetricRegistry();
        this.publishesMetrics = this.metrics.meter("publish.requests");
        this.subscribeMetrics = this.metrics.meter("subscribe.requests");
        this.connectedClientsMetrics = this.metrics.counter("connect.num_clients");
        String email = props.getProperty("metrics.librato.email");
        String token = props.getProperty("metrics.librato.token");
        String source = props.getProperty("metrics.librato.source");
        Librato.reporter(this.metrics, email, token).setSource(source).start(10L, TimeUnit.SECONDS);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object message) {
        MqttMessage msg = (MqttMessage)message;
        MqttMessageType messageType = msg.fixedHeader().messageType();
        switch (messageType) {
            case PUBLISH: {
                this.publishesMetrics.mark();
                break;
            }
            case SUBSCRIBE: {
                this.subscribeMetrics.mark();
                break;
            }
            case CONNECT: {
                this.connectedClientsMetrics.inc();
                break;
            }
            case DISCONNECT: {
                this.connectedClientsMetrics.dec();
                break;
            }
        }
        ctx.fireChannelRead(message);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        String clientID = NettyUtils.clientID(ctx.channel());
        if (clientID != null && !clientID.isEmpty()) {
            this.connectedClientsMetrics.dec();
        }
        ctx.fireChannelInactive();
    }
}

