/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.core;

import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.IAxisSet;
import org.eclipse.swtchart.IBarSeries;
import org.eclipse.swtchart.ICircularSeries;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.ITitle;
import org.eclipse.swtchart.LineStyle;
import org.eclipse.swtchart.Range;
import org.eclipse.swtchart.extensions.barcharts.IBarSeriesSettings;
import org.eclipse.swtchart.extensions.clipboard.IImageClipboardSupplier;
import org.eclipse.swtchart.extensions.core.AbstractExtendedChart;
import org.eclipse.swtchart.extensions.core.ChartSettings;
import org.eclipse.swtchart.extensions.core.IAxisScaleConverter;
import org.eclipse.swtchart.extensions.core.IAxisSettings;
import org.eclipse.swtchart.extensions.core.IChartDataCoordinates;
import org.eclipse.swtchart.extensions.core.IChartSettings;
import org.eclipse.swtchart.extensions.core.ICustomSelectionHandler;
import org.eclipse.swtchart.extensions.core.IExtendedChart;
import org.eclipse.swtchart.extensions.core.IKeyboardSupport;
import org.eclipse.swtchart.extensions.core.IRangeSupport;
import org.eclipse.swtchart.extensions.core.ISecondaryAxisSettings;
import org.eclipse.swtchart.extensions.core.ISeriesData;
import org.eclipse.swtchart.extensions.core.ISeriesModificationListener;
import org.eclipse.swtchart.extensions.core.ISeriesSettings;
import org.eclipse.swtchart.extensions.core.ISeriesStatusListener;
import org.eclipse.swtchart.extensions.core.MappingsSupport;
import org.eclipse.swtchart.extensions.core.Messages;
import org.eclipse.swtchart.extensions.core.RangeRestriction;
import org.eclipse.swtchart.extensions.core.ResourceSupport;
import org.eclipse.swtchart.extensions.core.SeriesMapper;
import org.eclipse.swtchart.extensions.core.UserSelection;
import org.eclipse.swtchart.extensions.dialogs.ClickBindingHelpDialog;
import org.eclipse.swtchart.extensions.events.CircularMouseDownEvent;
import org.eclipse.swtchart.extensions.events.IEventProcessor;
import org.eclipse.swtchart.extensions.events.IHandledEventProcessor;
import org.eclipse.swtchart.extensions.exceptions.SeriesException;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesSettings;
import org.eclipse.swtchart.extensions.model.CustomSeries;
import org.eclipse.swtchart.extensions.model.ICustomSeries;
import org.eclipse.swtchart.extensions.piecharts.ICircularSeriesSettings;
import org.eclipse.swtchart.extensions.scattercharts.IScatterSeriesSettings;
import org.eclipse.swtchart.model.Node;
import org.eclipse.swtchart.model.NodeDataModel;

public class BaseChart
extends AbstractExtendedChart
implements IChartDataCoordinates,
IRangeSupport,
IExtendedChart,
IKeyboardSupport {
    public static final int ID_PRIMARY_X_AXIS = 0;
    public static final int ID_PRIMARY_Y_AXIS = 0;
    public static final String DEFAULT_TITLE_X_AXIS = Messages.getString("X_AXIS");
    public static final String DEFAULT_TITLE_Y_AXIS = Messages.getString("Y_AXIS");
    public static final String SELECTED_SERIES_NONE = Messages.getString("NONE");
    private Map<Integer, Map<Integer, Map<Integer, List<IEventProcessor>>>> registeredEvents;
    private IChartSettings chartSettings;
    private static final int MIN_SELECTION_PERCENTAGE = 30;
    public static final long DELTA_CLICK_TIME = 100L;
    private int redrawFrequency = 1;
    private int redrawCounter = 0;
    private List<ICustomSelectionHandler> customRangeSelectionHandlers;
    private List<ICustomSelectionHandler> customPointSelectionHandlers;
    private List<ISeriesModificationListener> seriesModificationListeners;
    private List<ISeriesStatusListener> seriesStatusListeners;
    private UserSelection userSelection;
    private long clickStartTime;
    private Set<String> selectedSeriesIds;
    private Stack<double[]> handledSelectionEvents;
    private double[] redoSelection;
    public static final int SHIFT_CONSTRAINT_NONE = 0;
    public static final int SHIFT_CONSTRAINT_RANGE_SELECTION = 1;
    public static final int SHIFT_CONSTRAINT_DELETE_X = 2;
    public static final int SHIFT_CONSTRAINT_DELETE_Y = 4;
    public static final int SHIFT_CONSTRAINT_CLINCH_X = 8;
    public static final int SHIFT_CONSTRAINT_STRETCH_X = 16;
    public static final int SHIFT_CONSTRAINT_BROADEN_X = 32;
    public static final int SHIFT_CONSTRAINT_NARROW_X = 64;
    private int shiftConstraints = 0;
    public static final long DELTA_MOVE_TIME = 350L;
    private long moveStartTime = 0L;
    private int xMoveStart = 0;
    private int yMoveStart = 0;
    private Map<String, List<double[]>> dataShiftHistory;
    private IImageClipboardSupplier imageClipboardSupplier = null;
    private List<ICustomSeries> customSeriesList = new ArrayList<ICustomSeries>();
    private IPreferenceStore preferenceStore = ResourceSupport.getPreferenceStore();
    private ClickBindingHelpDialog clickBindingPopup;

    public BaseChart(Composite parent, int style) {
        super(parent, style);
        this.chartSettings = new ChartSettings();
        this.userSelection = new UserSelection();
        this.customRangeSelectionHandlers = new ArrayList<ICustomSelectionHandler>();
        this.customPointSelectionHandlers = new ArrayList<ICustomSelectionHandler>();
        this.seriesModificationListeners = new ArrayList<ISeriesModificationListener>();
        this.seriesStatusListeners = new ArrayList<ISeriesStatusListener>();
        this.selectedSeriesIds = new HashSet<String>();
        this.initializeEventProcessors();
        IAxisSet axisSet = this.getAxisSet();
        IAxis xAxisPrimary = axisSet.getXAxis(0);
        ITitle titleX = xAxisPrimary.getTitle();
        titleX.setText(DEFAULT_TITLE_X_AXIS);
        titleX.setVisible(true);
        xAxisPrimary.setPosition(IAxis.Position.Primary);
        xAxisPrimary.getTick().setFormat((Format)new DecimalFormat());
        xAxisPrimary.enableLogScale(false);
        xAxisPrimary.enableCategory(false);
        xAxisPrimary.setReversed(false);
        xAxisPrimary.setDrawAxisLine(true);
        xAxisPrimary.setCategorySeries(new String[0]);
        xAxisPrimary.setIntegerDataPointAxis(false);
        IAxis yAxisPrimary = axisSet.getYAxis(0);
        ITitle titleY = yAxisPrimary.getTitle();
        titleY.setText(DEFAULT_TITLE_Y_AXIS);
        titleY.setVisible(true);
        yAxisPrimary.setPosition(IAxis.Position.Primary);
        yAxisPrimary.getTick().setFormat((Format)new DecimalFormat());
        yAxisPrimary.enableLogScale(false);
        yAxisPrimary.enableCategory(false);
        yAxisPrimary.setReversed(false);
        yAxisPrimary.setDrawAxisLine(true);
        yAxisPrimary.setIntegerDataPointAxis(false);
        this.handledSelectionEvents = new Stack();
        this.redoSelection = null;
        this.dataShiftHistory = new HashMap<String, List<double[]>>();
        this.setData("org.eclipse.e4.ui.css.CssClassName", "BaseChart");
    }

    public List<ICustomSeries> getCustomSeries() {
        return Collections.unmodifiableList(this.customSeriesList);
    }

    public ICustomSeries createCustomSeries(String label, String description) {
        CustomSeries customSeries = new CustomSeries();
        customSeries.setLabel(label);
        customSeries.setDescription(description);
        this.customSeriesList.add(customSeries);
        return customSeries;
    }

    public void deleteCustomSeries(String id) {
        ICustomSeries customSeriesDelete = null;
        for (ICustomSeries customSeries : this.customSeriesList) {
            if (!customSeries.getId().equals(id)) continue;
            customSeriesDelete = customSeries;
            break;
        }
        if (customSeriesDelete != null) {
            this.customSeriesList.remove(customSeriesDelete);
        }
    }

    private void initializeEventProcessors() {
        this.registeredEvents = new HashMap<Integer, Map<Integer, Map<Integer, List<IEventProcessor>>>>();
        this.initializeEvents();
    }

    private void initializeEvents() {
        this.registeredEvents.put(1, new HashMap());
        this.registeredEvents.put(2, new HashMap());
        this.registeredEvents.put(3, new HashMap());
        this.registeredEvents.put(4, new HashMap());
        this.registeredEvents.put(5, new HashMap());
        this.registeredEvents.put(6, new HashMap());
        this.registeredEvents.put(7, new HashMap());
    }

    public void clearEventProcessors() {
        this.registeredEvents.clear();
        this.initializeEvents();
    }

    public void resetSeriesSettings(ISeries<?> series) {
        this.resetSeriesSettings(series.getId());
    }

    public void addEventProcessor(IHandledEventProcessor handledEventProcessor) {
        int stateMask;
        List<IEventProcessor> handledEventProcessors;
        int button;
        Map<Integer, Map<Integer, List<IEventProcessor>>> eventProcessors = this.registeredEvents.get(handledEventProcessor.getEvent());
        Map<Integer, List<IEventProcessor>> buttonEventProcessors = eventProcessors.get(button = handledEventProcessor.getButton());
        if (buttonEventProcessors == null) {
            buttonEventProcessors = new HashMap<Integer, List<IEventProcessor>>();
            eventProcessors.put(button, buttonEventProcessors);
        }
        if ((handledEventProcessors = buttonEventProcessors.get(stateMask = handledEventProcessor.getStateMask())) == null) {
            handledEventProcessors = new ArrayList<IEventProcessor>();
        }
        handledEventProcessors.add(handledEventProcessor);
        buttonEventProcessors.put(stateMask, handledEventProcessors);
    }

    public void setChartSettings(IChartSettings chartSettings) {
        this.chartSettings = chartSettings;
    }

    public IChartSettings getChartSettings() {
        return this.chartSettings;
    }

    public long getMoveStartTime() {
        return this.moveStartTime;
    }

    public void setMoveStartTime(long moveStartTime) {
        this.moveStartTime = moveStartTime;
    }

    public int getXMoveStart() {
        return this.xMoveStart;
    }

    public void setXMoveStart(int xMoveStart) {
        this.xMoveStart = xMoveStart;
    }

    public int getYMoveStart() {
        return this.yMoveStart;
    }

    public void setYMoveStart(int yMoveStart) {
        this.yMoveStart = yMoveStart;
    }

    public UserSelection getUserSelection() {
        return this.userSelection;
    }

    public void increaseRedrawCounter() {
        ++this.redrawCounter;
    }

    public void resetRedrawCounter() {
        this.redrawCounter = 0;
    }

    public long getClickStartTime() {
        return this.clickStartTime;
    }

    public void setClickStartTime(long clickStartTime) {
        this.clickStartTime = clickStartTime;
    }

    public boolean isRedraw() {
        return this.redrawCounter >= this.redrawFrequency;
    }

    public double getShiftValue(int positionStart, int positionStop, String orientation) {
        int length;
        double stop;
        double start;
        double shiftValue = 0.0;
        if (orientation.equals("X_AXIS")) {
            axis = this.getAxisSet().getXAxis(0);
            start = axis.getRange().lower;
            stop = axis.getRange().upper;
            length = this.getPlotArea().getSize().x;
        } else {
            axis = this.getAxisSet().getYAxis(0);
            start = axis.getRange().lower;
            stop = axis.getRange().upper;
            length = this.getPlotArea().getSize().y;
        }
        if (positionStart > 0 && positionStop > 0 && positionStart < length && positionStop < length) {
            double percentageStop;
            double percentageStart;
            double delta = stop - start;
            if (orientation.equals("X_AXIS")) {
                percentageStart = 100.0 / (double)length * (double)positionStart / 100.0;
                percentageStop = 100.0 / (double)length * (double)positionStop / 100.0;
            } else {
                percentageStart = (100.0 - 100.0 / (double)length * (double)positionStart) / 100.0;
                percentageStop = (100.0 - 100.0 / (double)length * (double)positionStop) / 100.0;
            }
            shiftValue = start + delta * percentageStop - (start + delta * percentageStart);
        }
        return shiftValue;
    }

    @Override
    public ISeries<?> createSeries(ISeriesData seriesData, ISeriesSettings seriesSettings) throws SeriesException {
        ISeries<?> series = super.createSeries(seriesData, seriesSettings);
        this.calculateRedrawFrequency();
        return series;
    }

    @Override
    public void deleteSeries(String id) {
        super.deleteSeries(id);
        this.calculateRedrawFrequency();
        this.dataShiftHistory.remove(id);
    }

    @Override
    public void deleteSeries() {
        super.deleteSeries();
        this.calculateRedrawFrequency();
        this.dataShiftHistory.clear();
    }

    @Override
    public void appendSeries(ISeriesData seriesData) {
        super.appendSeries(seriesData);
        this.calculateRedrawFrequency();
    }

    private void calculateRedrawFrequency() {
        this.redrawFrequency = 2;
    }

    public double getSelectedPrimaryAxisValue(int position, String orientation) {
        double primaryValue;
        int length;
        double stop;
        double start;
        if (orientation.equals("X_AXIS")) {
            axis = this.getAxisSet().getXAxis(0);
            if (axis.isReversed()) {
                start = axis.getRange().upper;
                stop = axis.getRange().lower;
            } else {
                start = axis.getRange().lower;
                stop = axis.getRange().upper;
            }
            length = this.getPlotArea().getSize().x;
        } else {
            axis = this.getAxisSet().getYAxis(0);
            if (axis.isReversed()) {
                start = axis.getRange().upper;
                stop = axis.getRange().lower;
            } else {
                start = axis.getRange().lower;
                stop = axis.getRange().upper;
            }
            length = this.getPlotArea().getSize().y;
        }
        if (position <= 0) {
            primaryValue = start;
        } else if (position > length) {
            primaryValue = stop;
        } else {
            double delta = stop - start;
            double percentage = orientation.equals("X_AXIS") ? 100.0 / (double)length * (double)position / 100.0 : (100.0 - 100.0 / (double)length * (double)position) / 100.0;
            primaryValue = start + delta * percentage;
        }
        return primaryValue;
    }

    public boolean addCustomRangeSelectionHandler(ICustomSelectionHandler customSelectionHandler) {
        return this.customRangeSelectionHandlers.add(customSelectionHandler);
    }

    public boolean removeCustomRangeSelectionHandler(ICustomSelectionHandler customSelectionHandler) {
        return this.customRangeSelectionHandlers.remove(customSelectionHandler);
    }

    public boolean addCustomPointSelectionHandler(ICustomSelectionHandler customSelectionHandler) {
        return this.customPointSelectionHandlers.add(customSelectionHandler);
    }

    public boolean removeCustomPointSelectionHandler(ICustomSelectionHandler customSelectionHandler) {
        return this.customPointSelectionHandlers.remove(customSelectionHandler);
    }

    public boolean addSeriesModificationListener(ISeriesModificationListener seriesModificationListener) {
        return this.seriesModificationListeners.add(seriesModificationListener);
    }

    public boolean removeSeriesModificationListener(ISeriesModificationListener seriesModificationListener) {
        return this.seriesModificationListeners.remove(seriesModificationListener);
    }

    public boolean addSeriesStatusListener(ISeriesStatusListener seriesSelectionListener) {
        return this.seriesStatusListeners.add(seriesSelectionListener);
    }

    public boolean removeSeriesStatusListener(ISeriesStatusListener seriesSelectionListener) {
        return this.seriesStatusListeners.remove(seriesSelectionListener);
    }

    public boolean hasSelectedSeries() {
        return !this.selectedSeriesIds.isEmpty();
    }

    public Set<String> getSelectedSeriesIds() {
        return Collections.unmodifiableSet(this.selectedSeriesIds);
    }

    public Set<String> getSeriesIds() {
        ISeries[] series;
        HashSet<String> seriesIds = new HashSet<String>();
        ISeries[] iSeriesArray = series = this.getSeriesSet().getSeries();
        int n = series.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries serie = iSeriesArray[n2];
            seriesIds.add(serie.getId());
            ++n2;
        }
        return seriesIds;
    }

    public boolean isSeriesContained(String seriesId) {
        return this.getSeriesSet().getSeries(seriesId) != null;
    }

    @Override
    public void paintControl(PaintEvent e) {
        if (this.userSelection.isActive()) {
            int currentLineStyle = e.gc.getLineStyle();
            e.gc.setLineStyle(3);
            int xMin = Math.min(this.userSelection.getStartX(), this.userSelection.getStopX());
            int xMax = Math.max(this.userSelection.getStartX(), this.userSelection.getStopX());
            int yMin = Math.min(this.userSelection.getStartY(), this.userSelection.getStopY());
            int yMax = Math.max(this.userSelection.getStartY(), this.userSelection.getStopY());
            RangeRestriction rangeRestriction = this.getRangeRestriction();
            if (this.isSelectXY(rangeRestriction)) {
                e.gc.drawRectangle(xMin, yMin, xMax - xMin, yMax - yMin);
            } else if (rangeRestriction.isRestrictSelectX()) {
                e.gc.drawLine(xMin, yMin, xMax, yMin);
            } else if (rangeRestriction.isRestrictSelectY()) {
                e.gc.drawLine(xMin, yMin, xMin, yMax);
            }
            e.gc.setLineStyle(currentLineStyle);
        }
    }

    @Override
    public void handleMouseDownEvent(Event event) {
        this.handleEvent(this.registeredEvents.get(3).get(event.button), event);
    }

    @Override
    public void handleMouseMoveEvent(Event event) {
        this.handleEvent(this.registeredEvents.get(4).get(5), event);
    }

    @Override
    public void handleMouseUpEvent(Event event) {
        this.handleEvent(this.registeredEvents.get(5).get(event.button), event);
    }

    @Override
    public void handleMouseWheel(Event event) {
        this.handleEvent(this.registeredEvents.get(2).get(4), event);
    }

    @Override
    public void handleMouseDoubleClick(Event event) {
        this.handleEvent(this.registeredEvents.get(1).get(event.button), event);
    }

    @Override
    public void handleKeyDownEvent(Event event) {
        this.handleEvent(this.registeredEvents.get(6).get(event.keyCode), event);
    }

    @Override
    public void handleKeyUpEvent(Event event) {
        this.handleEvent(this.registeredEvents.get(7).get(event.keyCode), event);
    }

    private void handleEvent(Map<Integer, List<IEventProcessor>> eventProcessorMap, Event event) {
        if (eventProcessorMap != null) {
            if (event.stateMask == 0) {
                List<IEventProcessor> eventProcessors = eventProcessorMap.get(0);
                this.handleEventProcessors(eventProcessors, event);
            } else {
                for (int eventMask : eventProcessorMap.keySet()) {
                    if (eventMask == 0 || (event.stateMask & eventMask) != eventMask) continue;
                    List<IEventProcessor> eventProcessors = eventProcessorMap.get(eventMask);
                    this.handleEventProcessors(eventProcessors, event);
                    break;
                }
            }
        }
    }

    private void handleEventProcessors(List<IEventProcessor> eventProcessors, Event event) {
        if (eventProcessors != null) {
            for (IEventProcessor eventProcessor : eventProcessors) {
                if (eventProcessor == null) continue;
                eventProcessor.handleEvent(this, event);
            }
        }
    }

    public void openShortcutPopup(String shortcut, String name, String description) {
        if (!this.preferenceStore.getBoolean("showHelpForEvents")) {
            return;
        }
        this.closeShortcutPopup();
        int timeToClose = this.preferenceStore.getInt("showHelpForEvents_timeToClose");
        this.clickBindingPopup = new ClickBindingHelpDialog(this.getShell(), timeToClose);
        this.clickBindingPopup.setShortcut(shortcut, name, description);
        this.clickBindingPopup.open();
    }

    private void closeShortcutPopup() {
        if (this.clickBindingPopup != null) {
            this.clickBindingPopup.close();
            this.clickBindingPopup = null;
        }
    }

    public void selectSeries(String selectedSeriesId) {
        this.selectSeries(selectedSeriesId, true);
    }

    public void selectSeries(String selectedSeriesId, boolean fireUpdate) {
        if (this.isSeriesContained(selectedSeriesId)) {
            ISeries dataSeries = this.getSeriesSet().getSeries(selectedSeriesId);
            ISeriesSettings seriesSettings = this.getSeriesSettings(selectedSeriesId);
            this.selectedSeriesIds.add(selectedSeriesId);
            this.applySeriesSettings(dataSeries, seriesSettings.getSeriesSettingsHighlight());
            if (fireUpdate) {
                this.fireSeriesStatusEvent(selectedSeriesId, 1);
            }
        }
    }

    public void hideSeries(String selectedSeriesId) {
        this.hideSeries(selectedSeriesId, true);
    }

    public void hideSeries(String selectedSeriesId, boolean fireUpdate) {
        ISeries dataSeries = this.getSeriesSet().getSeries(selectedSeriesId);
        if (dataSeries != null) {
            this.selectedSeriesIds.remove(selectedSeriesId);
            dataSeries.setVisible(false);
            dataSeries.setVisibleInLegend(false);
            if (fireUpdate) {
                this.fireSeriesStatusEvent(selectedSeriesId, 2);
            }
        }
    }

    public void resetSeriesSettings() {
        this.resetSeriesSettings(true);
    }

    public void resetSeriesSettings(boolean fireUpdate) {
        this.applySeriesSettings();
        this.selectedSeriesIds.clear();
        this.redraw();
        if (fireUpdate) {
            this.fireSeriesStatusEvent(SELECTED_SERIES_NONE, 3);
        }
    }

    public void showSeries(String selectedSeriesId) {
        ISeries dataSeries = this.getSeriesSet().getSeries(selectedSeriesId);
        if (dataSeries != null) {
            dataSeries.setVisible(true);
            dataSeries.setVisibleInLegend(true);
        }
    }

    public void applySeriesSettings() {
        ISeries[] seriesSet;
        ISeries[] iSeriesArray = seriesSet = this.getSeriesSet().getSeries();
        int n = seriesSet.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries series = iSeriesArray[n2];
            ISeriesSettings seriesSettings = this.getSeriesSettings(series.getId());
            this.applySeriesSettings(series, seriesSettings);
            ++n2;
        }
    }

    public void applySeriesSettings(ISeries<?> series, ISeriesSettings seriesSettings) {
        this.applySeriesSettings(series, seriesSettings, false);
    }

    public void applySeriesSettings(ISeries<?> series, ISeriesSettings seriesSettings, boolean updateAvailableMapping) {
        ISeriesSettings seriesSettingsMapping = SeriesMapper.get(series, this);
        if (seriesSettingsMapping != null) {
            String originalDescriptionSeries = seriesSettings.getDescription();
            String originalDescriptionMapping = seriesSettingsMapping.getDescription();
            if (seriesSettings.isHighlight()) {
                if (updateAvailableMapping) {
                    MappingsSupport.transferSettings(seriesSettings, seriesSettingsMapping.getSeriesSettingsHighlight());
                } else {
                    MappingsSupport.transferSettings(seriesSettingsMapping.getSeriesSettingsHighlight(), seriesSettings);
                }
            } else if (updateAvailableMapping) {
                MappingsSupport.transferSettings(seriesSettings, seriesSettingsMapping);
            } else {
                MappingsSupport.transferSettings(seriesSettingsMapping, seriesSettings);
            }
            if (this.preferenceStore != null && this.preferenceStore.getBoolean("keepSeriesDescription")) {
                if (updateAvailableMapping) {
                    seriesSettingsMapping.setDescription(originalDescriptionMapping);
                } else {
                    seriesSettings.setDescription(originalDescriptionSeries);
                }
            }
        }
        if (series instanceof ILineSeries) {
            ILineSeries lineSeries = (ILineSeries)series;
            if (seriesSettings instanceof ILineSeriesSettings) {
                ILineSeriesSettings lineSeriesSettings = (ILineSeriesSettings)seriesSettings;
                this.applyLineSeriesSettings(lineSeries, lineSeriesSettings);
            } else if (seriesSettings instanceof IScatterSeriesSettings) {
                IScatterSeriesSettings scatterSeriesSettings = (IScatterSeriesSettings)seriesSettings;
                this.applyScatterSeriesSettings(lineSeries, scatterSeriesSettings);
            }
        } else if (series instanceof IBarSeries) {
            IBarSeries barSeries = (IBarSeries)series;
            if (seriesSettings instanceof IBarSeriesSettings) {
                IBarSeriesSettings barSeriesSettings = (IBarSeriesSettings)seriesSettings;
                this.applyBarSeriesSettings(barSeries, barSeriesSettings);
            }
        } else if (series instanceof ICircularSeries) {
            ICircularSeries circularSeries = (ICircularSeries)series;
            if (seriesSettings instanceof ICircularSeriesSettings) {
                Node node;
                ICircularSeriesSettings circularSeriesSettings = (ICircularSeriesSettings)seriesSettings;
                this.applyCircularSeriesSettings(circularSeries, circularSeriesSettings);
                String id = circularSeries.getId();
                NodeDataModel nodeDataModel = circularSeries.getNodeDataModel();
                if (nodeDataModel != null && (node = nodeDataModel.getNodeById(id)) != null) {
                    Node highlightedNode = circularSeries.getHighlightedNode();
                    if (node == highlightedNode) {
                        ICircularSeriesSettings circularSeriesSettingsHighlight = (ICircularSeriesSettings)seriesSettings.getSeriesSettingsHighlight();
                        node.setVisible(circularSeriesSettingsHighlight.isVisible());
                        node.setVisibleInLegend(circularSeriesSettingsHighlight.isVisibleInLegend());
                        node.setSliceColor(circularSeriesSettingsHighlight.getSliceColor());
                        node.setDescription(circularSeriesSettingsHighlight.getDescription());
                    } else {
                        node.setVisible(circularSeriesSettings.isVisible());
                        node.setVisibleInLegend(circularSeriesSettings.isVisibleInLegend());
                        node.setSliceColor(circularSeriesSettings.getSliceColor());
                        node.setDescription(circularSeriesSettings.getDescription());
                    }
                }
            }
        }
    }

    private void applyLineSeriesSettings(ILineSeries<?> lineSeries, ILineSeriesSettings lineSeriesSettings) {
        this.applyBaseSeriesSettings((ISeries<?>)lineSeries, lineSeriesSettings);
        lineSeries.setAntialias(lineSeriesSettings.getAntialias());
        lineSeries.enableArea(lineSeriesSettings.isEnableArea());
        lineSeries.setAreaStrict(lineSeriesSettings.isAreaStrict());
        lineSeries.setSymbolType(lineSeriesSettings.getSymbolType());
        lineSeries.setSymbolSize(lineSeriesSettings.getSymbolSize());
        lineSeries.setSymbolColor(lineSeriesSettings.getSymbolColor());
        lineSeries.setLineColor(lineSeriesSettings.getLineColor());
        lineSeries.setLineWidth(lineSeriesSettings.getLineWidth());
        lineSeries.enableStack(lineSeriesSettings.isEnableStack());
        lineSeries.enableStep(lineSeriesSettings.isEnableStep());
        lineSeries.setLineStyle(lineSeriesSettings.getLineStyle());
    }

    private void applyScatterSeriesSettings(ILineSeries<?> scatterSeries, IScatterSeriesSettings scatterSeriesSettings) {
        this.applyBaseSeriesSettings((ISeries<?>)scatterSeries, scatterSeriesSettings);
        scatterSeries.enableArea(false);
        scatterSeries.setAreaStrict(false);
        scatterSeries.setSymbolType(scatterSeriesSettings.getSymbolType());
        scatterSeries.setSymbolSize(scatterSeriesSettings.getSymbolSize());
        scatterSeries.setSymbolColor(scatterSeriesSettings.getSymbolColor());
        scatterSeries.setLineStyle(LineStyle.NONE);
    }

    private void applyBarSeriesSettings(IBarSeries<?> barSeries, IBarSeriesSettings barSeriesSettings) {
        this.applyBaseSeriesSettings((ISeries<?>)barSeries, barSeriesSettings);
        barSeries.setBarColor(barSeriesSettings.getBarColor());
        barSeries.setBarPadding(barSeriesSettings.getBarPadding());
        barSeries.setBarWidth(barSeriesSettings.getBarWidth());
        barSeries.setBarOverlay(barSeriesSettings.isBarOverlay());
        barSeries.enableStack(barSeriesSettings.isEnableStack());
    }

    private void applyCircularSeriesSettings(ICircularSeries<?> circularSeries, ICircularSeriesSettings circularSeriesSettings) {
        IHandledEventProcessor processor;
        this.applyBaseSeriesSettings((ISeries<?>)circularSeries, circularSeriesSettings);
        this.getTitle().setText(circularSeriesSettings.getDescription());
        circularSeries.setSliceColor(circularSeriesSettings.getSliceColor());
        circularSeries.setBorderColor(circularSeriesSettings.getBorderColor());
        circularSeries.setBorderWidth(circularSeriesSettings.getBorderWidth());
        circularSeries.setBorderStyle(circularSeriesSettings.getBorderStyle().value());
        ISeriesSettings seriesSettingsHighlight = circularSeriesSettings.getSeriesSettingsHighlight();
        if (seriesSettingsHighlight instanceof ICircularSeriesSettings) {
            ICircularSeriesSettings circularSeriesSettingsHighlight = (ICircularSeriesSettings)seriesSettingsHighlight;
            circularSeries.setSliceColorHighlight(circularSeriesSettingsHighlight.getSliceColor());
            circularSeries.setBorderColorHighlight(circularSeriesSettingsHighlight.getBorderColor());
            circularSeries.setBorderWidthHighlight(circularSeriesSettingsHighlight.getBorderWidth());
            circularSeries.setBorderStyleHighlight(circularSeriesSettingsHighlight.getBorderStyle().value());
        }
        if ((processor = (IHandledEventProcessor)this.registeredEvents.get(3).get(1).get(0).get(0)) instanceof CircularMouseDownEvent) {
            CircularMouseDownEvent mouseDownEvent = (CircularMouseDownEvent)this.registeredEvents.get(3).get(1).get(0).get(0);
            mouseDownEvent.setRedrawOnClick(circularSeriesSettings.isRedrawOnClick());
            mouseDownEvent.setFillEntireSpace(circularSeriesSettings.isEntireSpaceFilled());
        }
    }

    private void applyBaseSeriesSettings(ISeries<?> series, ISeriesSettings seriesSettings) {
        series.setDescription(seriesSettings.getDescription());
        series.setVisible(seriesSettings.isVisible());
        series.setVisibleInLegend(seriesSettings.isVisibleInLegend());
    }

    public List<double[]> getDataShiftHistory(String selectedSeriesId) {
        List<double[]> dataShifts = this.dataShiftHistory.get(selectedSeriesId);
        if (dataShifts != null) {
            return Collections.unmodifiableList(dataShifts);
        }
        return Collections.emptyList();
    }

    public boolean isDataShifted() {
        for (Collection collection : this.dataShiftHistory.values()) {
            if (collection == null) continue;
            return true;
        }
        return false;
    }

    public void scaleSeries(String seriesId, String axis, double start, double stop) {
        this.scaleSeries(seriesId, axis, start, Double.NaN, stop);
    }

    public void scaleSeries(String seriesId, String axis, double start, double center, double stop) {
        ISeries series = this.getSeriesSet().getSeries(seriesId);
        if (series != null && stop > start) {
            boolean calculateCoordinates = false;
            if ("X_AXIS".equals(axis)) {
                if (Double.isNaN(center)) {
                    double[] seriesX = series.getXSeries();
                    int size = seriesX.length;
                    double intervalX = (stop - start) / (double)size;
                    double x = start;
                    int i = 0;
                    while (i < size) {
                        seriesX[i] = x;
                        x += intervalX;
                        ++i;
                    }
                    series.setXSeries(seriesX);
                    calculateCoordinates = true;
                } else if (center >= start && center <= stop) {
                    int index = -1;
                    double[] seriesX = series.getXSeries();
                    int size = seriesX.length;
                    int i = 0;
                    while (i < size) {
                        if (seriesX[i] >= center) {
                            index = i;
                            break;
                        }
                        ++i;
                    }
                    if (index > -1) {
                        double intervalLeft = (center - start) / (double)index;
                        double xLeft = start;
                        int i2 = 0;
                        while (i2 < index) {
                            seriesX[i2] = xLeft;
                            xLeft += intervalLeft;
                            ++i2;
                        }
                        double intervalRight = (stop - center) / (double)(size - index);
                        double xRight = center;
                        int i3 = index;
                        while (i3 < size) {
                            seriesX[i3] = xRight;
                            xRight += intervalRight;
                            ++i3;
                        }
                        series.setXSeries(seriesX);
                        calculateCoordinates = true;
                    }
                }
            } else if ("Y_AXIS".equals(axis)) {
                if (Double.isNaN(center)) {
                    double[] seriesY = series.getYSeries();
                    int size = seriesY.length;
                    double intervalY = (stop - start) / (double)size;
                    double y = start;
                    int i = 0;
                    while (i < size) {
                        seriesY[i] = y;
                        y += intervalY;
                        ++i;
                    }
                    series.setYSeries(seriesY);
                    calculateCoordinates = true;
                } else if (center >= start && center <= stop) {
                    int index = -1;
                    double[] seriesY = series.getYSeries();
                    int size = seriesY.length;
                    int i = 0;
                    while (i < size) {
                        if (seriesY[i] >= center) {
                            index = i;
                            break;
                        }
                        ++i;
                    }
                    if (index > -1) {
                        double intervalBottom = (center - start) / (double)index;
                        double xBottom = start;
                        int i4 = 0;
                        while (i4 < index) {
                            seriesY[i4] = xBottom;
                            xBottom += intervalBottom;
                            ++i4;
                        }
                        double intervalTop = (stop - center) / (double)(size - index);
                        double xTop = center;
                        int i5 = index;
                        while (i5 < size) {
                            seriesY[i5] = xTop;
                            xTop += intervalTop;
                            ++i5;
                        }
                        series.setYSeries(seriesY);
                        calculateCoordinates = true;
                    }
                }
            }
            if (calculateCoordinates) {
                this.calculateCoordinates(series);
                this.fireSeriesModificationEvent();
            }
        }
    }

    public void shiftSeries(String seriesId, String axis, double shift) {
        ISeries series = this.getSeriesSet().getSeries(seriesId);
        if (series != null && shift != 0.0) {
            boolean calculateCoordinates = false;
            if ("X_AXIS".equals(axis)) {
                double[] seriesX = series.getXSeries();
                int i = 0;
                while (i < seriesX.length) {
                    int n = i++;
                    seriesX[n] = seriesX[n] + shift;
                }
                series.setXSeries(seriesX);
                calculateCoordinates = true;
            } else if ("Y_AXIS".equals(axis)) {
                double[] seriesY = series.getYSeries();
                int i = 0;
                while (i < seriesY.length) {
                    int n = i++;
                    seriesY[n] = seriesY[n] + shift;
                }
                series.setYSeries(seriesY);
                calculateCoordinates = true;
            }
            if (calculateCoordinates) {
                this.calculateCoordinates(series);
                this.fireSeriesModificationEvent();
            }
        }
    }

    public void setShiftConstraints(int shiftConstraints) {
        this.shiftConstraints = shiftConstraints;
    }

    public void shiftSeries(String seriesId, double shiftX, double shiftY) {
        ISeries dataSeries = this.getSeriesSet().getSeries(seriesId);
        if (dataSeries != null && (shiftX != 0.0 || shiftY != 0.0)) {
            if (shiftX != 0.0) {
                double[] xSeriesShifted = this.adjustArray(dataSeries.getXSeries(), shiftX, "X_AXIS");
                dataSeries.setXSeries(xSeriesShifted);
            }
            if (shiftY != 0.0) {
                double[] ySeriesShifted = this.adjustArray(dataSeries.getYSeries(), shiftY, "Y_AXIS");
                dataSeries.setYSeries(ySeriesShifted);
            }
            Range rangeX = this.getAxisSet().getXAxis(0).getRange();
            Range rangeY = this.getAxisSet().getYAxis(0).getRange();
            List<double[]> shiftRecord = this.getShiftRecord(seriesId);
            shiftRecord.add(new double[]{rangeX.lower, rangeX.upper, shiftX, rangeY.lower, rangeY.upper, shiftY, this.shiftConstraints});
            this.calculateCoordinates(dataSeries);
            this.fireSeriesModificationEvent();
        }
    }

    private List<double[]> getShiftRecord(String selectedSeriesId) {
        List<double[]> shiftRecord = this.dataShiftHistory.get(selectedSeriesId);
        if (shiftRecord == null) {
            shiftRecord = new ArrayList<double[]>();
            this.dataShiftHistory.put(selectedSeriesId, shiftRecord);
        }
        return shiftRecord;
    }

    private double[] adjustArray(double[] series, double shift, String axisOrientation) {
        boolean deleteShiftedData;
        series = this.shiftConstraints == 0 ? this.adjustArrayWithoutConstraints(series, shift) : ((deleteShiftedData = this.isDeleteShiftedData(axisOrientation)) ? this.adjustArrayWithConstraints(series, shift) : this.adjustArrayWithoutConstraints(series, shift));
        return series;
    }

    private double[] adjustArrayWithoutConstraints(double[] series, double shift) {
        int i = 0;
        while (i < series.length) {
            int n = i++;
            series[n] = series[n] + shift;
        }
        return series;
    }

    private double[] adjustArrayWithConstraints(double[] series, double shift) {
        double lowerBorder = 0.0;
        int i = 0;
        while (i < series.length) {
            double valueShifted = series[i] + shift;
            series[i] = valueShifted >= lowerBorder ? valueShifted : 0.0;
            ++i;
        }
        return series;
    }

    private boolean isDeleteShiftedData(String axisOrientation) {
        if (axisOrientation.equals("X_AXIS")) {
            return (this.shiftConstraints & 2) == 2 && this.chartSettings.getRangeRestriction().isZeroX();
        }
        return (this.shiftConstraints & 4) == 4 && this.chartSettings.getRangeRestriction().isZeroY();
    }

    public void multiplySeries(String selectedSeriesId, String axisId, double factor) {
        ISeries series = this.getSeriesSet().getSeries(selectedSeriesId);
        if (series != null) {
            double[] xSeries = series.getXSeries();
            double[] ySeries = series.getYSeries();
            if ("X_AXIS".equals(axisId)) {
                series.setXSeries(this.multiplySeries(xSeries, factor));
            } else if ("Y_AXIS".equals(axisId)) {
                series.setYSeries(this.multiplySeries(ySeries, factor));
            }
            this.calculateCoordinates(series);
            this.fireSeriesModificationEvent();
        }
    }

    private double[] multiplySeries(double[] series, double factor) {
        int i = 0;
        while (i < series.length) {
            int n = i++;
            series[n] = series[n] * factor;
        }
        return series;
    }

    public String[] getAxisLabels(String axisOrientation) {
        List<IAxisSettings> axisSettingsList = this.getAxisSettings(axisOrientation);
        int size = axisSettingsList.size();
        String[] items = new String[size];
        int i = 0;
        while (i < size) {
            IAxisSettings axisSettings = axisSettingsList.get(i);
            String label = axisSettings != null ? axisSettings.getLabel() : Messages.getString("NOT_SET");
            items[i] = label;
            ++i;
        }
        return items;
    }

    public List<IAxisSettings> getAxisSettings(String axisOrientation) {
        ArrayList<IAxisSettings> axisSettingsList = new ArrayList<IAxisSettings>();
        IAxis[] axes = this.getAxes(axisOrientation);
        int i = 0;
        while (i < axes.length) {
            IAxisSettings axisSettings = this.getAxisSettings(axisOrientation, i);
            if (axisSettings != null) {
                axisSettingsList.add(axisSettings);
            }
            ++i;
        }
        return axisSettingsList;
    }

    public DecimalFormat getDecimalFormat(String axisOrientation, int id) {
        IAxisSettings axisSettings = this.getAxisSettings(axisOrientation, id);
        DecimalFormat decimalFormat = axisSettings != null ? axisSettings.getDecimalFormat() : new DecimalFormat();
        return decimalFormat;
    }

    public IAxisScaleConverter getAxisScaleConverter(String axisOrientation, int id) {
        IAxisScaleConverter axisScaleConverter = null;
        IAxisSettings axisSettings = null;
        axisSettings = axisOrientation.equals("X_AXIS") ? this.getXAxisSettings(id) : this.getYAxisSettings(id);
        if (axisSettings instanceof ISecondaryAxisSettings) {
            ISecondaryAxisSettings secondaryAxisSettings = (ISecondaryAxisSettings)axisSettings;
            axisScaleConverter = secondaryAxisSettings.getAxisScaleConverter();
        }
        return axisScaleConverter;
    }

    protected void fireUpdateCustomRangeSelectionHandlers() {
        Event event = new Event();
        this.fireUpdateCustomRangeSelectionHandlers(event);
    }

    public void fireUpdateCustomRangeSelectionHandlers(Event event) {
        for (ICustomSelectionHandler customSelectionHandler : this.customRangeSelectionHandlers) {
            try {
                customSelectionHandler.handleUserSelection(event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void fireUpdateCustomPointSelectionHandlers() {
        Event event = new Event();
        this.fireUpdateCustomPointSelectionHandlers(event);
    }

    public void fireUpdateCustomPointSelectionHandlers(Event event) {
        for (ICustomSelectionHandler customSelectionHandler : this.customPointSelectionHandlers) {
            try {
                customSelectionHandler.handleUserSelection(event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void fireSeriesModificationEvent() {
        for (ISeriesModificationListener seriesModificationListener : this.seriesModificationListeners) {
            try {
                seriesModificationListener.handleSeriesModificationEvent();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void fireSeriesStatusEvent(String seriesId, int status) {
        for (ISeriesStatusListener seriesStatusListener : this.seriesStatusListeners) {
            try {
                switch (status) {
                    case 1: {
                        seriesStatusListener.handleSeriesSelectionEvent(seriesId);
                        break;
                    }
                    case 2: {
                        seriesStatusListener.handleSeriesHideEvent(seriesId);
                        break;
                    }
                    case 3: {
                        seriesStatusListener.handleSeriesResetEvent(seriesId);
                        break;
                    }
                    case 4: {
                        seriesStatusListener.handleRedrawEvent();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void zoomX(IAxis xAxis, Event event) {
        double coordinateX;
        this.trackUndoSelection();
        boolean isZoomReferenceX0 = this.getChartSettings().getRangeRestriction().isReferenceZoomZeroX();
        double d = coordinateX = isZoomReferenceX0 ? 0.0 : xAxis.getDataCoordinate(event.x);
        if (event.count > 0) {
            xAxis.zoomIn(coordinateX);
        } else if (isZoomReferenceX0) {
            xAxis.zoomOut();
        } else {
            xAxis.zoomOut(coordinateX);
        }
        this.trackRedoSelection();
    }

    public void zoomY(IAxis yAxis, Event event) {
        double coordinateY;
        this.trackUndoSelection();
        boolean isZoomReferenceY0 = this.getChartSettings().getRangeRestriction().isReferenceZoomZeroY();
        double d = coordinateY = isZoomReferenceY0 ? 0.0 : yAxis.getDataCoordinate(event.y);
        if (event.count > 0) {
            yAxis.zoomIn(coordinateY);
        } else if (isZoomReferenceY0) {
            yAxis.zoomOut();
        } else {
            yAxis.zoomOut(coordinateY);
        }
        this.trackRedoSelection();
    }

    public String getSelectedseriesId(Event event) {
        ISeries[] series = this.getSeriesSet().getSeries();
        String selectedSeriesId = "";
        ISeries[] iSeriesArray = series;
        int n = series.length;
        int n2 = 0;
        block0: while (n2 < n) {
            ISeries dataSeries = iSeriesArray[n2];
            if (dataSeries != null && dataSeries.isVisible()) {
                int size = dataSeries.getXSeries().length;
                int i = 0;
                while (i < size) {
                    Point point = dataSeries.getPixelCoordinates(i);
                    if (this.isDataSeriesSelected(point, event, 8)) {
                        selectedSeriesId = dataSeries.getId();
                        break block0;
                    }
                    ++i;
                }
            }
            ++n2;
        }
        return selectedSeriesId;
    }

    private boolean isDataSeriesSelected(Point point, Event event, int delta) {
        return point.x >= event.x - delta && point.x <= event.x + delta && point.y >= event.y - delta && point.y <= event.y + delta;
    }

    public void handleUserSelection(Event event) {
        int deltaHeight;
        int minSelectedHeight;
        int deltaWidth;
        int minSelectedWidth;
        Point point = this.getPlotArea().getSize();
        if (this.getOrientation() == 256) {
            minSelectedWidth = point.x / 30;
            deltaWidth = Math.abs(this.userSelection.getStartX() - event.x);
            minSelectedHeight = point.y / 30;
            deltaHeight = Math.abs(this.userSelection.getStartY() - event.y);
        } else {
            minSelectedWidth = point.y / 30;
            deltaWidth = Math.abs(this.userSelection.getStartY() - event.y);
            minSelectedHeight = point.x / 30;
            deltaHeight = Math.abs(this.userSelection.getStartX() - event.x);
        }
        RangeRestriction rangeRestriction = this.getRangeRestriction();
        if (rangeRestriction.isRestrictSelectY()) {
            if (deltaHeight >= minSelectedHeight) {
                this.handleUserSelectionXY(event);
            }
        } else if (deltaWidth >= minSelectedWidth) {
            this.handleUserSelectionXY(event);
        }
        this.userSelection.reset();
        this.redraw();
    }

    public void redraw() {
        super.redraw();
        this.fireSeriesStatusEvent("", 4);
    }

    public boolean isBufferActive() {
        return this.getPlotArea().isBuffered();
    }

    private void handleUserSelectionXY(Event event) {
        this.trackUndoSelection();
        int xStart = this.userSelection.getStartX();
        int xStop = this.userSelection.getStopX();
        int yStart = this.userSelection.getStartY();
        int yStop = this.userSelection.getStopY();
        this.setSelectionXY(xStart, xStop, yStart, yStop);
        this.trackRedoSelection();
        this.fireUpdateCustomRangeSelectionHandlers(event);
    }

    private void trackUndoSelection() {
        Range xRange = this.getAxisSet().getXAxis(0).getRange();
        Range yRange = this.getAxisSet().getYAxis(0).getRange();
        this.handledSelectionEvents.push(new double[]{xRange.lower, xRange.upper, yRange.lower, yRange.upper});
    }

    private void trackRedoSelection() {
        Range xRange = this.getAxisSet().getXAxis(0).getRange();
        Range yRange = this.getAxisSet().getYAxis(0).getRange();
        this.redoSelection = new double[]{xRange.lower, xRange.upper, yRange.lower, yRange.upper};
    }

    public void undoSelection() {
        try {
            if (!this.handledSelectionEvents.isEmpty()) {
                double[] undoSelection = this.handledSelectionEvents.pop();
                this.handleSelection(undoSelection);
            }
        }
        catch (EmptyStackException e) {
            e.printStackTrace();
        }
    }

    public void redoSelection() {
        if (this.redoSelection != null) {
            this.handleSelection(this.redoSelection);
            this.redoSelection = null;
        }
    }

    private void handleSelection(double[] selection) {
        double xStart = selection[0];
        double xStop = selection[1];
        double yStart = selection[2];
        double yStop = selection[3];
        IAxis xAxis = this.getAxisSet().getXAxis(0);
        IAxis yAxis = this.getAxisSet().getYAxis(0);
        this.setRange(xAxis, xStart, xStop, false);
        this.setRange(yAxis, yStart, yStop, false);
    }

    private void setSelectionXY(int xStart, int xStop, int yStart, int yStop) {
        IAxis xAxis = this.getAxisSet().getXAxis(0);
        IAxis yAxis = this.getAxisSet().getYAxis(0);
        if (this.getOrientation() == 256) {
            this.setHorizontalRange(xAxis, yAxis, xStart, xStop, yStart, yStop);
        } else {
            this.setVerticalRange(xAxis, yAxis, xStart, xStop, yStart, yStop);
        }
    }

    private void setHorizontalRange(IAxis xAxis, IAxis yAxis, int xStart, int xStop, int yStart, int yStop) {
        RangeRestriction rangeRestriction = this.getRangeRestriction();
        if (this.isSelectXY(rangeRestriction)) {
            this.setRange(xAxis, xStart, xStop, true);
            this.setRange(yAxis, yStart, yStop, true);
        } else if (rangeRestriction.isRestrictSelectX()) {
            this.setRange(xAxis, xStart, xStop, true);
        } else if (rangeRestriction.isRestrictSelectY()) {
            this.setRange(yAxis, yStart, yStop, true);
        }
    }

    private void setVerticalRange(IAxis xAxis, IAxis yAxis, int xStart, int xStop, int yStart, int yStop) {
        RangeRestriction rangeRestriction = this.getRangeRestriction();
        if (this.isSelectXY(rangeRestriction)) {
            this.setRange(xAxis, yStart, yStop, true);
            this.setRange(yAxis, xStart, xStop, true);
        } else if (rangeRestriction.isRestrictSelectX()) {
            this.setRange(xAxis, yStart, yStop, true);
        } else if (rangeRestriction.isRestrictSelectY()) {
            this.setRange(yAxis, xStart, xStop, true);
        }
    }

    private IAxis[] getAxes(String axisOrientation) {
        IAxisSet axisSet = this.getAxisSet();
        if (axisOrientation.equals("X_AXIS")) {
            return axisSet.getXAxes();
        }
        return axisSet.getYAxes();
    }

    private IAxisSettings getAxisSettings(String axisOrientation, int id) {
        IAxisSettings axisSettings = null;
        axisSettings = axisOrientation.equals("X_AXIS") ? this.getXAxisSettings(id) : this.getYAxisSettings(id);
        return axisSettings;
    }

    @Deprecated
    public boolean isZoomXAndY(RangeRestriction rangeRestriction) {
        return this.isSelectXY(rangeRestriction);
    }

    public boolean isSelectXY(RangeRestriction rangeRestriction) {
        boolean enableAction = false;
        if (!rangeRestriction.isRestrictSelectX() && !rangeRestriction.isRestrictSelectY()) {
            enableAction = true;
        } else if (rangeRestriction.isRestrictSelectX() && rangeRestriction.isRestrictSelectY()) {
            enableAction = true;
        }
        return enableAction;
    }

    public boolean isZoomXY(RangeRestriction rangeRestriction) {
        boolean enableAction = false;
        if (!rangeRestriction.isRestrictZoomX() && !rangeRestriction.isRestrictZoomY()) {
            enableAction = true;
        } else if (rangeRestriction.isRestrictZoomX() && rangeRestriction.isRestrictZoomY()) {
            enableAction = true;
        }
        return enableAction;
    }

    public IImageClipboardSupplier getImageClipboardSupplier() {
        return this.imageClipboardSupplier;
    }

    public void setImageClipboardSupplier(IImageClipboardSupplier imageClipboardSupplier) {
        this.imageClipboardSupplier = imageClipboardSupplier;
    }
}

