/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.metrics.util;

import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.Tag;

public enum MetricDefinition {
    INVOCATIONS("ft.invocations.total", Counter.class, InvocationResult.class, InvocationFallback.class),
    RETRY_CALLS("ft.retry.calls.total", Counter.class, RetryRetried.class, RetryResult.class),
    RETRY_RETRIES("ft.retry.retries.total", Counter.class, new Class[0]),
    TIMEOUT_CALLS("ft.timeout.calls.total", Counter.class, TimeoutTimedOut.class),
    TIMEOUT_EXECUTION_DURATION("ft.timeout.executionDuration", Histogram.class, "nanoseconds", new Class[0]),
    CIRCUITBREAKER_CALLS("ft.circuitbreaker.calls.total", Counter.class, CircuitBreakerResult.class),
    CIRCUITBREAKER_STATE("ft.circuitbreaker.state.total", Gauge.class, "nanoseconds", CircuitBreakerState.class),
    CIRCUITBREAKER_OPENED("ft.circuitbreaker.opened.total", Counter.class, new Class[0]),
    BULKHEAD_CALLS("ft.bulkhead.calls.total", Counter.class, BulkheadResult.class),
    BULKHEAD_EXECUTIONS_RUNNING("ft.bulkhead.executionsRunning", Gauge.class, new Class[0]),
    BULKHEAD_EXECUTIONS_WAITING("ft.bulkhead.executionsWaiting", Gauge.class, new Class[0]),
    BULKHEAD_RUNNING_DURATION("ft.bulkhead.runningDuration", Histogram.class, "nanoseconds", new Class[0]),
    BULKHEAD_WAITING_DURATION("ft.bulkhead.waitingDuration", Histogram.class, "nanoseconds", new Class[0]);

    private String name;
    private String unit;
    private Class<? extends Metric> metricClass;
    private Class<? extends TagValue>[] tagClasses;

    @SafeVarargs
    private MetricDefinition(String name, Class<? extends Metric> metricClass, String unit, Class<? extends TagValue> ... tagClasses) {
        this.name = name;
        this.unit = unit;
        this.metricClass = metricClass;
        this.tagClasses = tagClasses;
    }

    @SafeVarargs
    private MetricDefinition(String name, Class<? extends Metric> metricClass, Class<? extends TagValue> ... tagClasses) {
        this(name, metricClass, "none", tagClasses);
    }

    public String getName() {
        return this.name;
    }

    public String getUnit() {
        return this.unit;
    }

    public Class<? extends Metric> getMetricClass() {
        return this.metricClass;
    }

    public Class<? extends TagValue>[] getTagClasses() {
        return this.tagClasses;
    }

    public static enum TimeoutTimedOut implements TagValue
    {
        TRUE("true"),
        FALSE("false");

        private Tag tag;

        private TimeoutTimedOut(String tagValue) {
            this.tag = new Tag("timedOut", tagValue);
        }

        @Override
        public Tag getTag() {
            return this.tag;
        }
    }

    public static enum RetryRetried implements TagValue
    {
        TRUE("true"),
        FALSE("false");

        private Tag tag;

        private RetryRetried(String tagValue) {
            this.tag = new Tag("retried", tagValue);
        }

        @Override
        public Tag getTag() {
            return this.tag;
        }
    }

    public static enum RetryResult implements TagValue
    {
        VALUE_RETURNED("valueReturned"),
        EXCEPTION_NOT_RETRYABLE("exceptionNotRetryable"),
        MAX_RETRIES_REACHED("maxRetriesReached"),
        MAX_DURATION_REACHED("maxDurationReached");

        private Tag tag;

        private RetryResult(String tagValue) {
            this.tag = new Tag("retryResult", tagValue);
        }

        @Override
        public Tag getTag() {
            return this.tag;
        }
    }

    public static enum InvocationResult implements TagValue
    {
        VALUE_RETURNED("valueReturned"),
        EXCEPTION_THROWN("exceptionThrown");

        private Tag tag;

        private InvocationResult(String tagValue) {
            this.tag = new Tag("result", tagValue);
        }

        @Override
        public Tag getTag() {
            return this.tag;
        }
    }

    public static enum InvocationFallback implements TagValue
    {
        APPLIED("applied"),
        NOT_APPLIED("notApplied"),
        NOT_DEFINED("notDefined");

        private Tag tag;

        private InvocationFallback(String tagValue) {
            this.tag = new Tag("fallback", tagValue);
        }

        @Override
        public Tag getTag() {
            return this.tag;
        }
    }

    public static enum CircuitBreakerState implements TagValue
    {
        OPEN("open"),
        CLOSED("closed"),
        HALF_OPEN("halfOpen");

        private Tag tag;

        private CircuitBreakerState(String tagValue) {
            this.tag = new Tag("state", tagValue);
        }

        @Override
        public Tag getTag() {
            return this.tag;
        }
    }

    public static enum CircuitBreakerResult implements TagValue
    {
        SUCCESS("success"),
        FAILURE("failure"),
        CIRCUIT_BREAKER_OPEN("circuitBreakerOpen");

        private Tag tag;

        private CircuitBreakerResult(String tagValue) {
            this.tag = new Tag("circuitBreakerResult", tagValue);
        }

        @Override
        public Tag getTag() {
            return this.tag;
        }
    }

    public static enum BulkheadResult implements TagValue
    {
        ACCEPTED("accepted"),
        REJECTED("rejected");

        private Tag tag;

        private BulkheadResult(String tagValue) {
            this.tag = new Tag("bulkheadResult", tagValue);
        }

        @Override
        public Tag getTag() {
            return this.tag;
        }
    }

    public static interface TagValue {
        public Tag getTag();
    }
}

