/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators.tck;

import java.util.ArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreamsFactory;
import org.eclipse.microprofile.reactive.streams.operators.spi.ReactiveStreamsEngine;
import org.eclipse.microprofile.reactive.streams.operators.tck.DefaultReactiveStreamsFactory;
import org.eclipse.microprofile.reactive.streams.operators.tck.api.ReactiveStreamsApiVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.ReactiveStreamsSpiVerification;
import org.reactivestreams.tck.TestEnvironment;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.Factory;

public abstract class ReactiveStreamsTck<E extends ReactiveStreamsEngine> {
    private final TestEnvironment testEnvironment;
    private E engine;
    private ReactiveStreamsFactory rs;
    private ScheduledExecutorService executorService;

    public ReactiveStreamsTck(TestEnvironment testEnvironment) {
        this.testEnvironment = testEnvironment;
    }

    protected abstract E createEngine();

    protected ReactiveStreamsFactory createFactory() {
        return new DefaultReactiveStreamsFactory();
    }

    protected void shutdownEngine(E engine) {
    }

    protected boolean isEnabled(Object test) {
        return true;
    }

    @AfterSuite(alwaysRun=true)
    public void shutdownEngine() {
        if (this.engine != null) {
            this.shutdownEngine(this.engine);
        }
        if (this.executorService != null) {
            this.shutdownExecutorService(this.executorService);
        }
    }

    protected ScheduledExecutorService createExecutorService() {
        return Executors.newScheduledThreadPool(4);
    }

    protected void shutdownExecutorService(ScheduledExecutorService executorService) {
        executorService.shutdown();
    }

    @Factory
    public Object[] allTests() {
        this.engine = this.createEngine();
        this.rs = this.createFactory();
        this.executorService = this.createExecutorService();
        ReactiveStreamsApiVerification apiVerification = new ReactiveStreamsApiVerification(this.rs);
        ReactiveStreamsSpiVerification spiVerification = new ReactiveStreamsSpiVerification(this.testEnvironment, this.rs, (ReactiveStreamsEngine)this.engine, this.executorService);
        ArrayList<Object> allTests = new ArrayList<Object>();
        allTests.addAll(apiVerification.allTests());
        allTests.addAll(spiVerification.allTests());
        return allTests.stream().filter(this::isEnabled).toArray();
    }
}

