/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators.tck.spi;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.AbstractStageVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.ReactiveStreamsSpiVerification;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.testng.annotations.Test;

public class SubscriberStageVerification
extends AbstractStageVerification {
    SubscriberStageVerification(ReactiveStreamsSpiVerification.VerificationDeps deps) {
        super(deps);
    }

    @Test
    public void subscriberStageShouldRedeemCompletionStageWhenCompleted() {
        CompletionStage result = this.rs.of(new Object[0]).to((Subscriber)this.rs.builder().ignore().build(this.getEngine())).run(this.getEngine());
        this.await(result);
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="failed")
    public void subscriberStageShouldRedeemCompletionStageWhenFailed() {
        CompletionStage result = this.rs.failed((Throwable)new RuntimeException("failed")).to((Subscriber)this.rs.builder().ignore().build(this.getEngine())).run(this.getEngine());
        this.await(result);
    }

    @Test(expectedExceptions={CancellationException.class})
    public void subscriberStageShouldRedeemCompletionStageWithCancellationExceptionWhenCancelled() {
        CompletionStage result = this.rs.fromPublisher(subscriber -> subscriber.onSubscribe(new Subscription(){

            public void request(long n) {
            }

            public void cancel() {
            }
        })).to((Subscriber)this.rs.builder().cancel().build(this.getEngine())).run(this.getEngine());
        this.await(result);
    }

    @Override
    List<Object> reactiveStreamsTckVerifiers() {
        return Collections.emptyList();
    }
}

