/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck.cditests;

import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.eclipse.microprofile.rest.client.inject.RegisterRestClient;
import org.eclipse.microprofile.rest.client.inject.RestClient;
import org.eclipse.microprofile.rest.client.tck.interfaces.ConfigKeyClient;
import org.eclipse.microprofile.rest.client.tck.interfaces.SimpleGetApi;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HasRequestScopeTest
extends Arquillian {
    @Inject
    private BeanManager beanManager;

    @Deployment
    public static WebArchive createDeployment() {
        String url = SimpleGetApi.class.getName() + "/mp-rest/url=http://localhost:8080";
        String url2 = MyRequestScopedApi.class.getName() + "/mp-rest/url=http://localhost:8080";
        String scope = SimpleGetApi.class.getName() + "/mp-rest/scope=" + RequestScoped.class.getName();
        String configKeyScope = "myConfigKey/mp-rest/scope=" + RequestScoped.class.getName();
        String simpleName = HasRequestScopeTest.class.getSimpleName();
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)(simpleName + ".jar"))).addClasses(new Class[]{SimpleGetApi.class, MyRequestScopedApi.class, ConfigKeyClient.class})).addAsManifestResource((Asset)new StringAsset(url + "\n" + scope + "\n" + url2 + "\n" + configKeyScope), "microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(simpleName + ".war"))).addAsLibrary((Archive)jar)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    public void testHasRequestScoped() {
        Set beans = this.beanManager.getBeans(SimpleGetApi.class, new Annotation[]{RestClient.LITERAL});
        Bean resolved = this.beanManager.resolve(beans);
        Assert.assertEquals((Object)resolved.getScope(), RequestScoped.class);
    }

    @Test
    public void testHasRequestScopedFromConfigKey() {
        Set beans = this.beanManager.getBeans(ConfigKeyClient.class, new Annotation[]{RestClient.LITERAL});
        Bean resolved = this.beanManager.resolve(beans);
        Assert.assertEquals((Object)resolved.getScope(), RequestScoped.class);
    }

    @Test
    public void testHasRequestScopedWhenAnnotated() {
        Set beans = this.beanManager.getBeans(MyRequestScopedApi.class, new Annotation[]{RestClient.LITERAL});
        Bean resolved = this.beanManager.resolve(beans);
        Assert.assertEquals((Object)resolved.getScope(), RequestScoped.class);
    }

    @RequestScoped
    @RegisterRestClient
    @Path(value="/")
    public static interface MyRequestScopedApi {
        @GET
        public Response get();
    }
}

