/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtp2qvts;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Edge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.EdgeRole;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Node;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Region;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.GraphStringBuilder;

public abstract class AbstractEdge
implements Edge {
    private @NonNull EdgeRole edgeRole;
    protected final @NonNull Region region;
    private @NonNull Node sourceNode;
    private @NonNull Node targetNode;
    protected final @Nullable String name;

    protected AbstractEdge(@NonNull EdgeRole edgeRole, @NonNull Region region, @NonNull Node sourceNode, @Nullable String name, @NonNull Node targetNode) {
        this.edgeRole = edgeRole;
        this.region = region;
        this.sourceNode = sourceNode;
        this.name = name;
        this.targetNode = targetNode;
        region.addEdge(this);
        sourceNode.addOutgoingEdge(this);
        targetNode.addIncomingEdge(this);
    }

    public void appendEdgeAttributes(@NonNull GraphStringBuilder s, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull GraphStringBuilder.GraphNode source, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull GraphStringBuilder.GraphNode target) {
        String arrowhead;
        String style;
        s.setColor(this.getColor());
        String label = this.getLabel();
        if (label != null) {
            s.setLabel(label);
        }
        if ((style = this.getStyle()) != null) {
            s.setStyle(style);
        }
        if ((arrowhead = this.getArrowhead()) != null) {
            s.setArrowhead(arrowhead);
        }
        s.setPenwidth(this.getPenwidth());
        s.appendAttributedEdge(source, (GraphStringBuilder.GraphEdge)this, target);
    }

    protected void appendEdgeWithNode(@NonNull GraphStringBuilder s) {
        Node sourceNode = this.getSource();
        Node targetNode = this.getTarget();
        s.appendEdge((GraphStringBuilder.GraphNode)sourceNode, (GraphStringBuilder.GraphEdge)this, (GraphStringBuilder.GraphNode)targetNode);
    }

    @Override
    public void destroy() {
        this.sourceNode.removeOutgoingEdge(this);
        this.targetNode.removeIncomingEdge(this);
        this.region.removeEdge(this);
    }

    @Override
    public String getArrowhead() {
        return this.edgeRole.getArrowhead();
    }

    @Override
    public @NonNull String getColor() {
        return this.edgeRole.getColor();
    }

    @Override
    public @NonNull EdgeRole getEdgeRole() {
        return this.edgeRole;
    }

    @Override
    public @Nullable String getLabel() {
        return this.name;
    }

    @Override
    public @Nullable String getName() {
        return this.name;
    }

    public @NonNull Integer getPenwidth() {
        Integer penwidth = this.edgeRole.getPenwidth();
        return penwidth;
    }

    @Override
    public @NonNull Region getRegion() {
        return this.region;
    }

    @Override
    public @NonNull Node getSource() {
        return this.sourceNode;
    }

    public @Nullable String getStyle() {
        return this.edgeRole.getStyle();
    }

    @Override
    public @NonNull Node getTarget() {
        return this.targetNode;
    }

    @Override
    public boolean isArgument() {
        return this.edgeRole.isArgument();
    }

    @Override
    public boolean isCast() {
        return this.edgeRole.isCast();
    }

    @Override
    public boolean isComputation() {
        return this.edgeRole.isComputation();
    }

    @Override
    public boolean isConstant() {
        return this.edgeRole.isConstant();
    }

    @Override
    public boolean isKnown() {
        return this.sourceNode.isKnown();
    }

    @Override
    public boolean isLoaded() {
        return this.edgeRole.isLoaded();
    }

    @Override
    public boolean isMergeable() {
        return this.edgeRole.isMergeable();
    }

    @Override
    public boolean isNavigable() {
        return this.edgeRole.isNavigable();
    }

    @Override
    public boolean isNavigation() {
        return this.edgeRole.isNavigation();
    }

    @Override
    public boolean isPredicated() {
        return this.edgeRole.isPredicated();
    }

    @Override
    public boolean isRealized() {
        return this.edgeRole.isRealized();
    }

    @Override
    public boolean isRecursion() {
        return this.edgeRole.isRecursion();
    }

    @Override
    public boolean isResult() {
        return this.edgeRole.isResult();
    }

    protected void mergeRole(@NonNull EdgeRole edgeRole) {
        if (this.edgeRole != edgeRole) {
            this.edgeRole = this.edgeRole.merge(edgeRole);
        }
    }

    @Override
    public void setSource(@NonNull Node sourceNode) {
        this.sourceNode.removeOutgoingEdge(this);
        this.sourceNode = sourceNode;
        this.sourceNode.addOutgoingEdge(this);
    }

    @Override
    public void setTarget(@NonNull Node targetNode) {
        this.targetNode.removeIncomingEdge(this);
        this.targetNode = targetNode;
        this.targetNode.addIncomingEdge(this);
    }

    @Override
    public void toGraph(@NonNull GraphStringBuilder s) {
        s.appendEdge((GraphStringBuilder.GraphNode)this.getSource(), (GraphStringBuilder.GraphEdge)this, (GraphStringBuilder.GraphNode)this.getTarget());
    }

    public @NonNull String toString() {
        return String.valueOf(this.edgeRole.toString()) + "(" + this.getSource().toString() + "=>" + this.getName() + "=>" + this.getTarget().toString() + ")";
    }
}

