/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.debug.launching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.vm.utils.MiscUtil;
import org.eclipse.qvtd.compiler.DefaultCompilerOptions;
import org.eclipse.qvtd.debug.core.QVTiDebugCore;
import org.eclipse.qvtd.debug.launching.QVTcompiledJob;
import org.eclipse.qvtd.debug.launching.QVTiLaunchConstants;
import org.eclipse.qvtd.debug.launching.QVTimperativeJob;
import org.eclipse.qvtd.debug.launching.QVTinterpretedJob;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTransformation;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiExecutor;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiIncrementalExecutor;
import org.eclipse.qvtd.runtime.evaluation.Transformer;

public class QVTiLaunchConfigurationDelegate
extends LaunchConfigurationDelegate
implements QVTiLaunchConstants {
    public static final @NonNull String @NonNull [] compileStepKeys = new String[]{"QVTi"};
    public static final @NonNull String @NonNull [] generateStepKeys = new String[]{"Java", "Class"};
    protected static final int LAUNCH_ERROR_CODE = 210;
    protected static final IStatus fgLaunchErrorStatus = new Status(4, "org.eclipse.qvtd.debug", 210, "Launch configuration error", null);
    protected @Nullable Class<? extends Transformer> txClass = null;

    protected @NonNull DefaultCompilerOptions createCompilerOptions() {
        return new DefaultCompilerOptions();
    }

    protected @NonNull QVTiExecutor createExecutor(@NonNull QVTiEnvironmentFactory envFactory, @NonNull ImperativeTransformation transformation) {
        return new QVTiIncrementalExecutor(envFactory, transformation, QVTiIncrementalExecutor.Mode.LAZY);
    }

    protected @NonNull QVTiDebugCore getDebugCore() {
        return QVTiDebugCore.INSTANCE;
    }

    protected @NonNull URI getTransformationURI(ILaunchConfiguration configuration) throws CoreException {
        String txName = configuration.getAttribute("tx", "");
        return URI.createURI((String)txName, (boolean)true);
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        assert (launch != null);
        assert (configuration != null);
        try {
            QVTimperativeJob executionJob = this.txClass != null ? new QVTcompiledJob(this, launch, configuration, this.txClass) : new QVTinterpretedJob(this, launch, configuration);
            launch.addProcess((IProcess)executionJob);
            executionJob.schedule();
        }
        catch (Exception e) {
            throw new CoreException(MiscUtil.makeErrorStatus((Exception)e));
        }
    }
}

