/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.transaction.tests;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.AbortExecutionException;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.examples.extlibrary.Book;
import org.eclipse.emf.examples.extlibrary.EXTLibraryFactory;
import org.eclipse.emf.examples.extlibrary.EXTLibraryPackage;
import org.eclipse.emf.examples.extlibrary.Writer;
import org.eclipse.emf.transaction.DemultiplexingListener;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.TriggerListener;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.transaction.internal.EMFTransactionPlugin;
import org.eclipse.emf.transaction.tests.AbstractTest;
import org.eclipse.emf.transaction.tests.fixtures.LogCapture;
import org.eclipse.emf.transaction.tests.fixtures.TestListener;

public class ValidationRollbackTest
extends AbstractTest {
    public static boolean validationEnabled = false;

    public ValidationRollbackTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(ValidationRollbackTest.class, "Validation and Rollback Tests");
    }

    public void test_rollback() {
        try {
            InternalTransaction xa = ((InternalTransactionalEditingDomain)this.domain).startTransaction(false, null);
            final Book book = (Book)this.find("root/Root Book");
            ValidationRollbackTest.assertNotNull((Object)book);
            final String oldTitle = book.getTitle();
            final Writer oldAuthor = book.getAuthor();
            String newTitle = "New Title";
            Writer newAuthor = (Writer)this.find("root/level1/Level1 Writer");
            ValidationRollbackTest.assertNotNull((Object)newAuthor);
            book.setTitle(newTitle);
            newAuthor.getBooks().add((Object)book);
            ValidationRollbackTest.assertSame((Object)newTitle, (Object)book.getTitle());
            ValidationRollbackTest.assertSame((Object)newAuthor, (Object)book.getAuthor());
            xa.rollback();
            this.domain.runExclusive(new Runnable(){

                @Override
                public void run() {
                    ValidationRollbackTest.assertSame((Object)oldTitle, (Object)book.getTitle());
                    ValidationRollbackTest.assertSame((Object)oldAuthor, (Object)book.getAuthor());
                }
            });
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public void test_rollback_nested() {
        try {
            InternalTransaction xa = ((InternalTransactionalEditingDomain)this.domain).startTransaction(false, null);
            final Book book = (Book)this.find("root/Root Book");
            ValidationRollbackTest.assertNotNull((Object)book);
            book.setTitle("Intermediate Title");
            Writer writer = (Writer)this.find("root/level1/level2/Level2 Writer");
            ValidationRollbackTest.assertNotNull((Object)writer);
            book.setAuthor(writer);
            final String oldTitle = book.getTitle();
            final Writer oldAuthor = book.getAuthor();
            InternalTransaction inner = ((InternalTransactionalEditingDomain)this.domain).startTransaction(false, null);
            String newTitle = "New Title";
            Writer newAuthor = (Writer)this.find("root/level1/Level1 Writer");
            ValidationRollbackTest.assertNotNull((Object)newAuthor);
            book.setTitle(newTitle);
            newAuthor.getBooks().add((Object)book);
            ValidationRollbackTest.assertSame((Object)newTitle, (Object)book.getTitle());
            ValidationRollbackTest.assertSame((Object)newAuthor, (Object)book.getAuthor());
            inner.rollback();
            ValidationRollbackTest.assertSame((Object)oldTitle, (Object)book.getTitle());
            ValidationRollbackTest.assertSame((Object)oldAuthor, (Object)book.getAuthor());
            xa.commit();
            this.domain.runExclusive(new Runnable(){

                @Override
                public void run() {
                    ValidationRollbackTest.assertSame((Object)oldTitle, (Object)book.getTitle());
                    ValidationRollbackTest.assertSame((Object)oldAuthor, (Object)book.getAuthor());
                }
            });
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public void test_rollback_outer() {
        try {
            InternalTransaction xa = ((InternalTransactionalEditingDomain)this.domain).startTransaction(false, null);
            final Book book = (Book)this.find("root/Root Book");
            ValidationRollbackTest.assertNotNull((Object)book);
            final String oldTitle = book.getTitle();
            final Writer oldAuthor = book.getAuthor();
            InternalTransaction inner = ((InternalTransactionalEditingDomain)this.domain).startTransaction(false, null);
            String newTitle = "New Title";
            Writer newAuthor = (Writer)this.find("root/level1/Level1 Writer");
            ValidationRollbackTest.assertNotNull((Object)newAuthor);
            book.setTitle(newTitle);
            newAuthor.getBooks().add((Object)book);
            inner.commit();
            ValidationRollbackTest.assertSame((Object)newTitle, (Object)book.getTitle());
            ValidationRollbackTest.assertSame((Object)newAuthor, (Object)book.getAuthor());
            xa.rollback();
            this.domain.runExclusive(new Runnable(){

                @Override
                public void run() {
                    ValidationRollbackTest.assertSame((Object)oldTitle, (Object)book.getTitle());
                    ValidationRollbackTest.assertSame((Object)oldAuthor, (Object)book.getAuthor());
                }
            });
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public void test_validation() {
        InternalTransaction xa = null;
        IStatus status = null;
        try {
            xa = ((InternalTransactionalEditingDomain)this.domain).startTransaction(false, null);
            Book book = (Book)this.find("root/Root Book");
            ValidationRollbackTest.assertNotNull((Object)book);
            book.setTitle(null);
            xa.commit();
            ValidationRollbackTest.fail((String)"Should have thrown RollbackException");
        }
        catch (RollbackException e) {
            status = e.getStatus();
            ValidationRollbackTest.trace("Got expected exception: " + e.getLocalizedMessage());
        }
        catch (Exception e) {
            this.fail(e);
        }
        ValidationRollbackTest.assertNotNull((Object)xa);
        ValidationRollbackTest.assertNotNull((Object)status);
        ValidationRollbackTest.assertSame((Object)status, (Object)xa.getStatus());
    }

    public void test_validation_nestedCommitted() {
        try {
            InternalTransaction xa = ((InternalTransactionalEditingDomain)this.domain).startTransaction(false, null);
            Book book = (Book)this.find("root/Root Book");
            ValidationRollbackTest.assertNotNull((Object)book);
            InternalTransaction inner = ((InternalTransactionalEditingDomain)this.domain).startTransaction(false, null);
            book.setTitle(null);
            try {
                inner.commit();
            }
            catch (Exception e) {
                this.fail(e);
            }
            xa.commit();
            ValidationRollbackTest.fail((String)"Should have thrown RollbackException");
        }
        catch (RollbackException e) {
            ValidationRollbackTest.trace("Got expected exception: " + e.getLocalizedMessage());
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public void test_validation_nestedRolledBack() {
        try {
            InternalTransaction xa = ((InternalTransactionalEditingDomain)this.domain).startTransaction(false, null);
            final Book book = (Book)this.find("root/Root Book");
            ValidationRollbackTest.assertNotNull((Object)book);
            String newTitle = "New Title";
            book.setTitle("New Title");
            InternalTransaction inner = ((InternalTransactionalEditingDomain)this.domain).startTransaction(false, null);
            book.setTitle(null);
            inner.rollback();
            xa.commit();
            this.domain.runExclusive(new Runnable(){

                @Override
                public void run() {
                    ValidationRollbackTest.assertSame((Object)"New Title", (Object)book.getTitle());
                }
            });
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    public void test_abort() {
        InternalTransaction xa = null;
        IStatus status = Status.CANCEL_STATUS;
        try {
            xa = ((InternalTransactionalEditingDomain)this.domain).startTransaction(false, null);
            xa.abort(status);
            xa.commit();
            ValidationRollbackTest.fail((String)"Should have thrown RollbackException");
        }
        catch (RollbackException e) {
            ValidationRollbackTest.trace("Got expected exception: " + e.getLocalizedMessage());
            ValidationRollbackTest.assertSame((Object)status, (Object)e.getStatus());
        }
        catch (Exception e) {
            this.fail(e);
        }
        ValidationRollbackTest.assertNotNull((Object)xa);
        ValidationRollbackTest.assertSame((Object)status, (Object)xa.getStatus());
    }

    public void test_rollbackNestingTransactionOnException_135673() {
        RecordingCommand command = new RecordingCommand(this.domain, ""){

            public boolean canUndo() {
                return true;
            }

            protected void doExecute() {
                try {
                    ((InternalTransactionalEditingDomain)ValidationRollbackTest.this.domain).startTransaction(false, null);
                    ((InternalTransactionalEditingDomain)ValidationRollbackTest.this.domain).startTransaction(false, null);
                }
                catch (Exception e) {
                    ValidationRollbackTest.fail((String)("Failed to start nested transaction: " + e.getLocalizedMessage()));
                }
                throw new TestError("intentional error");
            }
        };
        try {
            this.getCommandStack().execute((Command)command);
        }
        catch (TestError testError) {
        }
        catch (IllegalArgumentException e) {
            ValidationRollbackTest.fail((String)("Rolled back out of order: " + e.getLocalizedMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test_danglingTransactionOnException_149340() {
        final Error error = new Error();
        DemultiplexingListener testListener = new DemultiplexingListener(){

            protected void handleNotification(TransactionalEditingDomain domain, Notification notification) {
                throw error;
            }
        };
        try {
            TestThread testThread;
            this.domain.addResourceSetListener((ResourceSetListener)testListener);
            try {
                this.domain.getCommandStack().execute((Command)new RecordingCommand(this.domain){

                    protected void doExecute() {
                        ValidationRollbackTest.this.root.getWriters().clear();
                        ValidationRollbackTest.this.root.getStock().clear();
                        ValidationRollbackTest.this.root.getBranches().clear();
                    }
                });
                ValidationRollbackTest.fail((String)"Should have thrown Error");
            }
            catch (Error e) {
                ValidationRollbackTest.assertSame((Object)error, (Object)e);
            }
            class TestThread
            implements Runnable {
                boolean ran = false;

                TestThread() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ValidationRollbackTest.this.domain.runExclusive(new Runnable(){

                            @Override
                            public void run() {
                            }
                        });
                    }
                    catch (InterruptedException ex) {
                        ValidationRollbackTest.fail((String)"Interrupted");
                    }
                    TestThread testThread = this;
                    synchronized (testThread) {
                        this.ran = true;
                        this.notifyAll();
                    }
                }
            }
            TestThread testThread2 = testThread = new TestThread();
            synchronized (testThread2) {
                Thread t = new Thread(testThread);
                t.setDaemon(true);
                t.start();
                try {
                    testThread.wait(2000L);
                }
                catch (InterruptedException ex) {
                    ValidationRollbackTest.fail((String)"Interrupted");
                }
                ValidationRollbackTest.assertTrue((String)"Dangling transaction lock", (boolean)testThread.ran);
            }
        }
        finally {
            this.domain.removeResourceSetListener((ResourceSetListener)testListener);
        }
    }

    public void test_triggerRollback_146853() {
        final RuntimeException error = new RuntimeException();
        TriggerListener testListener = new TriggerListener(){

            protected Command trigger(TransactionalEditingDomain domain, Notification notification) {
                return new RecordingCommand(domain, "Error"){

                    protected void doExecute() {
                        throw error;
                    }
                };
            }
        };
        LogCapture logCapture = new LogCapture(this.getCommandStack(), EMFTransactionPlugin.getPlugin().getBundle());
        try {
            this.domain.addResourceSetListener((ResourceSetListener)testListener);
            this.domain.getCommandStack().execute((Command)new RecordingCommand(this.domain){

                protected void doExecute() {
                    ValidationRollbackTest.this.root.getWriters().clear();
                    ValidationRollbackTest.this.root.getStock().clear();
                    ValidationRollbackTest.this.root.getBranches().clear();
                }
            });
            logCapture.assertLogged(error);
            ValidationRollbackTest.assertFalse((boolean)this.root.getWriters().isEmpty());
            ValidationRollbackTest.assertFalse((boolean)this.root.getStock().isEmpty());
            ValidationRollbackTest.assertFalse((boolean)this.root.getBranches().isEmpty());
        }
        finally {
            logCapture.stop();
            this.domain.removeResourceSetListener((ResourceSetListener)testListener);
        }
    }

    public void test_triggerRollback_cancel_146853() {
        OperationCanceledException error = new OperationCanceledException();
        TriggerListener testListener = new TriggerListener((RuntimeException)error){
            private final /* synthetic */ RuntimeException val$error;
            {
                this.val$error = runtimeException;
            }

            protected Command trigger(TransactionalEditingDomain domain, Notification notification) {
                return new RecordingCommand(domain, "Error"){

                    protected void doExecute() {
                        throw val$error;
                    }
                };
            }
        };
        LogCapture logCapture = new LogCapture(this.getCommandStack(), EMFTransactionPlugin.getPlugin().getBundle());
        try {
            this.domain.addResourceSetListener((ResourceSetListener)testListener);
            this.domain.getCommandStack().execute((Command)new RecordingCommand(this.domain){

                protected void doExecute() {
                    ValidationRollbackTest.this.root.getWriters().clear();
                    ValidationRollbackTest.this.root.getStock().clear();
                    ValidationRollbackTest.this.root.getBranches().clear();
                }
            });
            IStatus log = logCapture.getLastLog();
            ValidationRollbackTest.assertNull((Object)log);
            ValidationRollbackTest.assertFalse((boolean)this.root.getWriters().isEmpty());
            ValidationRollbackTest.assertFalse((boolean)this.root.getStock().isEmpty());
            ValidationRollbackTest.assertFalse((boolean)this.root.getBranches().isEmpty());
        }
        finally {
            logCapture.stop();
            this.domain.removeResourceSetListener((ResourceSetListener)testListener);
        }
    }

    public void test_rollbackNotifiesCommandStackListeners_175725() {
        CommandStack stack;
        class TestCSL
        implements CommandStackListener {
            int invocationCount = 0;

            TestCSL() {
            }

            public void commandStackChanged(EventObject event) {
                ++this.invocationCount;
            }
        }
        TestCSL listener;
        block5: {
            listener = new TestCSL();
            stack = this.domain.getCommandStack();
            stack.addCommandStackListener((CommandStackListener)listener);
            Book book = (Book)this.find("root/Root Book");
            ValidationRollbackTest.assertNotNull((Object)book);
            Command command = SetCommand.create((EditingDomain)this.domain, (Object)book, (Object)EXTLibraryPackage.Literals.BOOK__TITLE, null);
            try {
                try {
                    stack.execute(command);
                }
                catch (Exception e) {
                    this.fail(e);
                    stack.removeCommandStackListener((CommandStackListener)listener);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                stack.removeCommandStackListener((CommandStackListener)listener);
                throw throwable;
            }
            stack.removeCommandStackListener((CommandStackListener)listener);
        }
        ValidationRollbackTest.assertEquals((String)"Command-stack listener invoked wrong number of times", (int)2, (int)listener.invocationCount);
        ValidationRollbackTest.assertFalse((String)"Should not have an undo command", (boolean)stack.canUndo());
    }

    public void test_rollbackOnRuntimeException_185040() {
        final Book book = (Book)this.find("root/Root Book");
        ValidationRollbackTest.assertNotNull((Object)book);
        RecordingCommand command = new RecordingCommand(this.domain){

            protected void doExecute() {
                book.setTitle("New Title");
                throw new NullPointerException();
            }
        };
        try {
            this.getCommandStack().execute((Command)command, Collections.EMPTY_MAP);
            ValidationRollbackTest.fail((String)"Should have rolled back");
        }
        catch (RollbackException e) {
            System.out.println("Got expected rollback");
            ValidationRollbackTest.assertEquals((String)"Root Book", (String)book.getTitle());
        }
        catch (InterruptedException e) {
            ValidationRollbackTest.fail((String)"Interrupted");
        }
    }

    public void test_rollback_nesting_noNotifications_206819() {
        TestListener l = new TestListener(NotificationFilter.NOT_TOUCH);
        this.domain.addResourceSetListener((ResourceSetListener)l);
        try {
            try {
                this.startReading();
                Book book = (Book)this.find("root/Root Book");
                ValidationRollbackTest.assertNotNull((Object)book);
                String oldTitle = book.getTitle();
                Writer oldAuthor = book.getAuthor();
                this.commit();
                l.reset();
                InternalTransaction xa = ((InternalTransactionalEditingDomain)this.domain).startTransaction(false, null);
                book.setTitle("Intermediate Title");
                Writer writer = (Writer)this.find("root/level1/level2/Level2 Writer");
                ValidationRollbackTest.assertNotNull((Object)writer);
                book.setAuthor(writer);
                InternalTransaction inner = ((InternalTransactionalEditingDomain)this.domain).startTransaction(false, null);
                String newTitle = "New Title";
                Writer newAuthor = (Writer)this.find("root/level1/Level1 Writer");
                ValidationRollbackTest.assertNotNull((Object)newAuthor);
                book.setTitle(newTitle);
                newAuthor.getBooks().add((Object)book);
                inner.commit();
                xa.rollback();
                List<Notification> notifications = l.postcommitNotifications;
                this.startReading();
                ValidationRollbackTest.assertSame((Object)oldTitle, (Object)book.getTitle());
                ValidationRollbackTest.assertSame((Object)oldAuthor, (Object)book.getAuthor());
                this.commit();
                if (notifications != null) {
                    ValidationRollbackTest.fail((String)("Got " + notifications.size() + " post-commit notifications"));
                }
            }
            catch (Exception e) {
                this.fail(e);
                this.domain.removeResourceSetListener((ResourceSetListener)l);
            }
        }
        finally {
            this.domain.removeResourceSetListener((ResourceSetListener)l);
        }
    }

    public void test_rollback_nesting_trailingNotifications_206819() {
        TestListener l = new TestListener(NotificationFilter.NOT_TOUCH);
        this.domain.addResourceSetListener((ResourceSetListener)l);
        try {
            try {
                this.startReading();
                Book book = (Book)this.find("root/Root Book");
                ValidationRollbackTest.assertNotNull((Object)book);
                String oldTitle = book.getTitle();
                Writer oldAuthor = book.getAuthor();
                this.commit();
                l.reset();
                InternalTransaction xa = ((InternalTransactionalEditingDomain)this.domain).startTransaction(false, null);
                book.setTitle("Intermediate Title");
                Writer writer = (Writer)this.find("root/level1/level2/Level2 Writer");
                ValidationRollbackTest.assertNotNull((Object)writer);
                book.setAuthor(writer);
                InternalTransaction inner = ((InternalTransactionalEditingDomain)this.domain).startTransaction(false, null);
                String newTitle = "New Title";
                Writer newAuthor = (Writer)this.find("root/level1/Level1 Writer");
                ValidationRollbackTest.assertNotNull((Object)newAuthor);
                book.setTitle(newTitle);
                newAuthor.getBooks().add((Object)book);
                InternalTransaction inner2 = ((InternalTransactionalEditingDomain)this.domain).startTransaction(false, null);
                book.setTitle("Something else");
                inner2.commit();
                book.setTitle("Something else again");
                inner.commit();
                book.setTitle("Yet another something");
                xa.rollback();
                List<Notification> notifications = l.postcommitNotifications;
                this.startReading();
                ValidationRollbackTest.assertSame((Object)oldTitle, (Object)book.getTitle());
                ValidationRollbackTest.assertSame((Object)oldAuthor, (Object)book.getAuthor());
                this.commit();
                if (notifications != null) {
                    ValidationRollbackTest.fail((String)("Got " + notifications.size() + " post-commit notifications"));
                }
            }
            catch (Exception e) {
                this.fail(e);
                this.domain.removeResourceSetListener((ResourceSetListener)l);
            }
        }
        finally {
            this.domain.removeResourceSetListener((ResourceSetListener)l);
        }
    }

    public void test_rollback_nestedTransactions_illegalSubList_227429() {
        TestListener tl = new TestListener(NotificationFilter.NOT_TOUCH);
        this.domain.addResourceSetListener((ResourceSetListener)tl);
        final boolean[] enable = new boolean[1];
        final Writer[] writer = new Writer[1];
        final Random random = new Random(System.currentTimeMillis());
        final Runnable run = new Runnable(){
            Resource resource = null;

            @Override
            public void run() {
                if (this.resource == null) {
                    this.resource = ValidationRollbackTest.this.domain.getResourceSet().createResource(URI.createURI((String)"http://localhost/foo.xmi"));
                }
                Book book = EXTLibraryFactory.eINSTANCE.createBook();
                book.setTitle("Book " + random.nextInt(1000) + "1");
                book.setAuthor(writer[0]);
                this.resource.setURI(URI.createURI((String)("http://localhost/" + random.nextInt(1000) + "/foo.xmi")));
            }
        };
        TriggerListener pl = new TriggerListener(NotificationFilter.NOT_TOUCH){

            protected Command trigger(TransactionalEditingDomain domain, Notification notification) {
                if (enable[0]) {
                    enable[0] = false;
                    return new AbstractCommand("Test"){

                        protected boolean prepare() {
                            return true;
                        }

                        void undoRedo() {
                            InternalTransactionalEditingDomain idomain = (InternalTransactionalEditingDomain)(this).ValidationRollbackTest.this.domain;
                            try {
                                InternalTransaction xa = idomain.startTransaction(false, idomain.getUndoRedoOptions());
                                run.run();
                                xa.commit();
                            }
                            catch (Exception e) {
                                ValidationRollbackTest.this.fail(e);
                            }
                        }

                        public void undo() {
                            this.undoRedo();
                        }

                        public void redo() {
                            this.undoRedo();
                        }

                        public void execute() {
                            run.run();
                        }
                    };
                }
                return null;
            }
        };
        this.domain.addResourceSetListener((ResourceSetListener)pl);
        ResourceSetListenerImpl pl2 = new ResourceSetListenerImpl(NotificationFilter.NOT_TOUCH){

            public boolean isPrecommitOnly() {
                return true;
            }

            public boolean isAggregatePrecommitListener() {
                return true;
            }

            public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
                throw new RollbackException((IStatus)new Status(4, "org.eclipse.emf.transaction.tests", "Please, roll back."));
            }
        };
        this.domain.addResourceSetListener((ResourceSetListener)pl2);
        try {
            try {
                this.startReading();
                writer[0] = (Writer)this.find("root/level1/level2/Level2 Writer");
                ValidationRollbackTest.assertNotNull((Object)writer[0]);
                this.commit();
                InternalTransaction xa = ((InternalTransactionalEditingDomain)this.domain).startTransaction(false, null);
                run.run();
                InternalTransaction inner = ((InternalTransactionalEditingDomain)this.domain).startTransaction(false, null);
                run.run();
                inner.commit();
                run.run();
                inner = ((InternalTransactionalEditingDomain)this.domain).startTransaction(false, null);
                run.run();
                enable[0] = true;
                inner.commit();
                xa.commit();
                ValidationRollbackTest.fail((String)"Commit of root transaction should have failed.");
            }
            catch (RollbackException xa) {
                this.domain.removeResourceSetListener((ResourceSetListener)pl2);
                this.domain.removeResourceSetListener((ResourceSetListener)pl);
                this.domain.removeResourceSetListener((ResourceSetListener)tl);
            }
            catch (Exception e) {
                this.fail(e);
                this.domain.removeResourceSetListener((ResourceSetListener)pl2);
                this.domain.removeResourceSetListener((ResourceSetListener)pl);
                this.domain.removeResourceSetListener((ResourceSetListener)tl);
            }
        }
        finally {
            this.domain.removeResourceSetListener((ResourceSetListener)pl2);
            this.domain.removeResourceSetListener((ResourceSetListener)pl);
            this.domain.removeResourceSetListener((ResourceSetListener)tl);
        }
    }

    public void test_rollbackOnAbortExecutionException_230129() {
        RecordingCommand command = new RecordingCommand(this.domain){

            protected void doExecute() {
                throw new AbortExecutionException("Cancel me");
            }
        };
        try {
            this.getCommandStack().execute((Command)command, Collections.EMPTY_MAP);
            ValidationRollbackTest.assertFalse((boolean)this.getCommandStack().canUndo());
        }
        catch (RollbackException e) {
            ValidationRollbackTest.fail((String)("Should not have rolled back: " + e.getLocalizedMessage()));
        }
        catch (InterruptedException e) {
            ValidationRollbackTest.fail((String)"Interrupted");
        }
    }

    @Override
    protected void doSetUp() throws Exception {
        super.doSetUp();
        validationEnabled = true;
    }

    @Override
    protected void doTearDown() throws Exception {
        validationEnabled = false;
        super.doTearDown();
    }

    static class TestError
    extends Error {
        private static final long serialVersionUID = 1502966836790504386L;

        TestError(String msg) {
            super(msg);
        }
    }
}

