/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.outline;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoEditor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.outline.AcceleoOutlinePageContentProvider;
import org.eclipse.acceleo.internal.ide.ui.editors.template.outline.AcceleoOutlinePageItemProviderAdapterFactory;
import org.eclipse.acceleo.internal.ide.ui.editors.template.outline.AcceleoOutlinePageLabelProvider;
import org.eclipse.acceleo.internal.ide.ui.editors.template.outline.actions.HideNonPublicAction;
import org.eclipse.acceleo.internal.ide.ui.editors.template.outline.actions.HideQueriesAction;
import org.eclipse.acceleo.internal.ide.ui.editors.template.outline.actions.HideTemplatesAction;
import org.eclipse.acceleo.internal.ide.ui.editors.template.outline.actions.SortElementAction;
import org.eclipse.acceleo.internal.ide.ui.editors.template.outline.actions.SortTypeAction;
import org.eclipse.acceleo.parser.cst.Module;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class AcceleoOutlinePage
extends Page
implements IContentOutlinePage,
ISelectionChangedListener {
    protected AcceleoEditor editor;
    protected AdapterFactory adapterFactory;
    protected AdapterFactoryEditingDomain editingDomain;
    protected AcceleoOutlinePageItemProviderAdapterFactory outlinePageItemProvider;
    private ListenerList selectionChangedListeners = new ListenerList();
    private TreeViewer treeViewer;
    private RefreshViewJob refreshViewJob = new RefreshViewJob();

    public AcceleoOutlinePage(AcceleoEditor editor) {
        this.editor = editor;
        this.outlinePageItemProvider = new AcceleoOutlinePageItemProviderAdapterFactory();
        ArrayList<ReflectiveItemProviderAdapterFactory> factories = new ArrayList<ReflectiveItemProviderAdapterFactory>();
        factories.add(this.outlinePageItemProvider);
        factories.add((ReflectiveItemProviderAdapterFactory)new ResourceItemProviderAdapterFactory());
        factories.add((ReflectiveItemProviderAdapterFactory)new EcoreItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        this.adapterFactory = new ComposedAdapterFactory(factories);
        BasicCommandStack commandStack = new BasicCommandStack();
        this.editingDomain = new AdapterFactoryEditingDomain(this.adapterFactory, (CommandStack)commandStack, new HashMap());
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    public void createControl(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 770);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.treeViewer.setContentProvider((IContentProvider)new AcceleoOutlinePageContentProvider(this.adapterFactory));
        AcceleoOutlinePageLabelProvider lp = new AcceleoOutlinePageLabelProvider(this.adapterFactory);
        ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)lp, decorator));
        this.setInput((EObject)this.editor.getContent().getCST());
    }

    public void setActionBars(IActionBars actionBars) {
        super.setActionBars(actionBars);
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        toolBarManager.add((IAction)new SortElementAction(this.treeViewer));
        toolBarManager.add((IAction)new SortTypeAction(this.treeViewer));
        toolBarManager.add((IAction)new HideNonPublicAction(this.treeViewer));
        toolBarManager.add((IAction)new HideQueriesAction(this.treeViewer));
        toolBarManager.add((IAction)new HideTemplatesAction(this.treeViewer));
        actionBars.updateActionBars();
    }

    protected void fireSelectionChanged(ISelection selection) {
        final SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        Object[] listeners = this.selectionChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final ISelectionChangedListener l = (ISelectionChangedListener)listeners[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
            ++i;
        }
    }

    public Control getControl() {
        if (this.treeViewer == null) {
            return null;
        }
        return this.treeViewer.getControl();
    }

    public ISelection getSelection() {
        if (this.treeViewer == null) {
            return StructuredSelection.EMPTY;
        }
        return this.treeViewer.getSelection();
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        pageSite.setSelectionProvider((ISelectionProvider)this);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.fireSelectionChanged(event.getSelection());
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    public void setSelection(ISelection selection) {
        if (this.treeViewer != null) {
            this.treeViewer.setSelection(selection);
        }
    }

    private void setInput(EObject root) {
        if (root != null && root.eContents().size() > 0) {
            if (root.eContents().size() == 1) {
                this.getTreeViewer().setInput((Object)((EObject)root.eContents().get(0)).eContents());
            } else {
                this.getTreeViewer().setInput((Object)root.eContents());
            }
        } else {
            this.getTreeViewer().setInput(null);
        }
    }

    public void refresh(Object element) {
        if (element instanceof EObject && ((EObject)element).eContainer() != null) {
            this.refreshViewJob.refreshView(((EObject)element).eContainer());
        } else {
            this.refreshViewJob.refreshView(element);
        }
    }

    protected void refreshContainer(Object element) {
        if (element instanceof Module) {
            int selection = -1;
            if (this.getTreeViewer().getControl() instanceof Scrollable && !((Scrollable)this.getTreeViewer().getControl()).isDisposed() && ((Scrollable)this.getTreeViewer().getControl()).getVerticalBar() != null) {
                selection = ((Scrollable)this.getTreeViewer().getControl()).getVerticalBar().getSelection();
            }
            TreePath[] treePaths = this.getTreeViewer().getExpandedTreePaths();
            this.getTreeViewer().setInput(element);
            this.getTreeViewer().setExpandedTreePaths(treePaths);
            if (selection > -1 && this.getTreeViewer().getControl() instanceof Scrollable && ((Scrollable)this.getTreeViewer().getControl()).getVerticalBar() != null) {
                ((Scrollable)this.getTreeViewer().getControl()).getVerticalBar().setSelection(selection);
            }
        } else if (!this.getTreeViewer().getTree().isDisposed()) {
            TreePath[] treePaths = this.getTreeViewer().getExpandedTreePaths();
            this.getTreeViewer().refresh(element);
            this.getTreeViewer().setExpandedTreePaths(treePaths);
        }
    }

    protected TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    class RefreshViewJob {
        Object element;
        Job refreshJob;

        RefreshViewJob() {
        }

        public void refreshView(Object elem) {
            if (this.refreshJob != null) {
                this.refreshJob.cancel();
            }
            this.element = elem;
            this.refreshJob = new Job("Acceleo"){

                protected IStatus run(IProgressMonitor monitor) {
                    if (!AcceleoOutlinePage.this.getTreeViewer().getControl().isDisposed()) {
                        AcceleoOutlinePage.this.getTreeViewer().getControl().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                AcceleoOutlinePage.this.refreshContainer((this).RefreshViewJob.this.element);
                            }
                        });
                    }
                    return new Status(0, "org.eclipse.acceleo.ide.ui", "OK");
                }
            };
            this.refreshJob.setPriority(50);
            this.refreshJob.setSystem(true);
            int schedule = 2000;
            this.refreshJob.schedule(2000L);
        }
    }
}

