/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.menu.handlers;

import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.SetCanonicalCommand;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.infra.gmfdiag.menu.handlers.AbstractGraphicalCommandHandler;

public class ToggleCanonicalHandler
extends AbstractGraphicalCommandHandler {
    @Override
    protected Command getCommand() {
        UnexecutableCommand result;
        List<IGraphicalEditPart> selection = this.getSelectedElements();
        if (selection.isEmpty()) {
            result = UnexecutableCommand.INSTANCE;
        } else {
            CompositeTransactionalCommand command = new CompositeTransactionalCommand(this.getEditingDomain(), "Toggle Synchronize with Model");
            for (IGraphicalEditPart editPart : this.getSelectedElements()) {
                if (editPart.getNotationView() == null) continue;
                command = command.compose((IUndoableOperation)new SetCanonicalCommand(this.getEditingDomain(), editPart.getNotationView(), !DiagramEditPartsUtil.isCanonical((EditPart)editPart)));
            }
            result = new ICommandProxy(command.reduce());
        }
        return result;
    }
}

