/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.data.convert;

import java.text.ParseException;
import org.eclipse.nebula.widgets.nattable.data.convert.NumericDisplayConverter;

public class DefaultLongDisplayConverter
extends NumericDisplayConverter {
    public DefaultLongDisplayConverter() {
        this(true);
    }

    public DefaultLongDisplayConverter(boolean useNumberFormat) {
        if (!useNumberFormat) {
            this.nf = null;
        }
    }

    @Override
    protected Object convertToNumericValue(String value) {
        if (this.nf != null) {
            try {
                return this.nf.parse(value).longValue();
            }
            catch (ParseException e) {
                throw new NumberFormatException(e.getLocalizedMessage());
            }
        }
        return Long.valueOf(value);
    }
}

