/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.common.services;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Abstraction;
import org.eclipse.uml2.uml.Artifact;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.CollaborationUse;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.ComponentRealization;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.DeploymentTarget;
import org.eclipse.uml2.uml.Extend;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Include;
import org.eclipse.uml2.uml.InformationFlow;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.Manifestation;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageSort;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.PackageMerge;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Realization;
import org.eclipse.uml2.uml.Substitution;
import org.eclipse.uml2.uml.Usage;
import org.eclipse.uml2.uml.UseCase;

public class SemanticCandidatesServices {
    public Collection<Abstraction> getAbstractionCandidates(EObject semanticContext) {
        return this.getDependencyCandidates(semanticContext).stream().filter(Abstraction.class::isInstance).map(Abstraction.class::cast).collect(Collectors.toList());
    }

    public Collection<Association> getAssociationCandidates(EObject semanticContext) {
        if (semanticContext instanceof Package) {
            Package pack = (Package)semanticContext;
            return this.getAllAssociations(pack);
        }
        return Collections.emptyList();
    }

    private final Collection<Association> getAllAssociations(Package pack) {
        HashSet<Association> associations = new HashSet<Association>();
        for (PackageableElement current : pack.getPackagedElements()) {
            if (current instanceof Package) {
                associations.addAll(this.getAllAssociations((Package)current));
            }
            if (!(current instanceof Association)) continue;
            associations.add((Association)current);
        }
        return associations;
    }

    public Collection<Connector> getConnectorCandidates(EObject semanticContext) {
        if (semanticContext instanceof Namespace) {
            Namespace namespace = (Namespace)semanticContext;
            return SemanticCandidatesServices.getAllConnectors(namespace);
        }
        return Collections.emptyList();
    }

    private static final Collection<Connector> getAllConnectors(Namespace namespace) {
        HashSet<Connector> connectors = new HashSet<Connector>();
        for (NamedElement current : namespace.getOwnedMembers()) {
            if (current instanceof Class) {
                connectors.addAll((Collection<Connector>)((Class)current).getOwnedConnectors());
            }
            if (!(current instanceof Namespace)) continue;
            connectors.addAll(SemanticCandidatesServices.getAllConnectors((Namespace)current));
        }
        return connectors;
    }

    public Collection<EObject> getConstraintCandidates(EObject semanticContext) {
        HashSet<EObject> constraints = new HashSet<EObject>();
        if (semanticContext instanceof Namespace) {
            Namespace namespace = (Namespace)semanticContext;
            constraints.addAll((Collection<EObject>)namespace.getOwnedRules());
        }
        return constraints;
    }

    public Collection<Dependency> getDependencyCandidates(EObject semanticContext) {
        if (semanticContext instanceof Namespace) {
            Namespace namespace = (Namespace)semanticContext;
            return this.getAllDependency(namespace);
        }
        return List.of();
    }

    private final Collection<Dependency> getAllDependency(Namespace namespace) {
        HashSet<Dependency> dependencies = new HashSet<Dependency>();
        for (NamedElement current : namespace.getMembers()) {
            if (current instanceof Namespace) {
                dependencies.addAll(this.getAllDependency((Namespace)current));
            } else if (current instanceof Dependency) {
                dependencies.add((Dependency)current);
            }
            if (current instanceof Classifier) {
                ((Classifier)current).getCollaborationUses().forEach(collaborationUse -> dependencies.addAll(this.getAllDependency((CollaborationUse)collaborationUse)));
            }
            if (current instanceof Artifact) {
                Artifact artifact = (Artifact)current;
                dependencies.addAll((Collection<Dependency>)artifact.getManifestations());
            }
            if (!(current instanceof DeploymentTarget)) continue;
            DeploymentTarget deploymentTarget = (DeploymentTarget)current;
            dependencies.addAll((Collection<Dependency>)deploymentTarget.getDeployments());
        }
        return dependencies;
    }

    private final Collection<Dependency> getAllDependency(CollaborationUse collaborationUse) {
        return collaborationUse.getRoleBindings().stream().filter(Dependency.class::isInstance).map(Dependency.class::cast).collect(Collectors.toList());
    }

    public Collection<Extend> getExtendCandidates(EObject semanticContext) {
        if (semanticContext instanceof Namespace) {
            Namespace namespace = (Namespace)semanticContext;
            return this.getAllExtends(namespace);
        }
        return Collections.emptyList();
    }

    private final Collection<Extend> getAllExtends(Namespace namespace) {
        HashSet<Extend> extendsList = new HashSet<Extend>();
        for (NamedElement current : namespace.getMembers()) {
            if (current instanceof Namespace) {
                extendsList.addAll(this.getAllExtends((Namespace)current));
            }
            if (!(current instanceof UseCase)) continue;
            extendsList.addAll((Collection<Extend>)((UseCase)current).getExtends());
        }
        return extendsList;
    }

    public Collection<Extension> getExtensionCandidates(EObject semanticContext) {
        if (semanticContext instanceof Profile) {
            Profile profile = (Profile)semanticContext;
            return this.getAllElementsByType((Package)profile, Extension.class);
        }
        return Collections.emptyList();
    }

    public Collection<Generalization> getGeneralizationCandidates(EObject semanticContext) {
        if (semanticContext instanceof Namespace) {
            Namespace namespace = (Namespace)semanticContext;
            return SemanticCandidatesServices.getAllGeneralizations(namespace);
        }
        return Collections.emptyList();
    }

    private static final Collection<Generalization> getAllGeneralizations(Namespace namespace) {
        HashSet<Generalization> generalizations = new HashSet<Generalization>();
        for (NamedElement current : namespace.getOwnedMembers()) {
            if (current instanceof Classifier) {
                generalizations.addAll((Collection<Generalization>)((Classifier)current).getGeneralizations());
            }
            if (!(current instanceof Namespace)) continue;
            generalizations.addAll(SemanticCandidatesServices.getAllGeneralizations((Namespace)current));
        }
        return generalizations;
    }

    public Collection<InterfaceRealization> getInterfaceRealizationCandidates(EObject semanticContext) {
        if (semanticContext instanceof Namespace) {
            Namespace namespace = (Namespace)semanticContext;
            return SemanticCandidatesServices.getAllInterfaceRealizations(namespace);
        }
        return Collections.emptyList();
    }

    private static final Collection<InterfaceRealization> getAllInterfaceRealizations(Namespace namespace) {
        HashSet<InterfaceRealization> interfaceRealizations = new HashSet<InterfaceRealization>();
        for (NamedElement current : namespace.getOwnedMembers()) {
            if (current instanceof BehavioredClassifier) {
                interfaceRealizations.addAll((Collection<InterfaceRealization>)((BehavioredClassifier)current).getInterfaceRealizations());
            }
            if (!(current instanceof Namespace)) continue;
            interfaceRealizations.addAll(SemanticCandidatesServices.getAllInterfaceRealizations((Namespace)current));
        }
        return interfaceRealizations;
    }

    public Collection<ComponentRealization> getComponentRealizationCandidates(EObject semanticContext) {
        if (semanticContext instanceof Namespace) {
            Namespace namespace = (Namespace)semanticContext;
            return SemanticCandidatesServices.getAllComponentRealizations(namespace);
        }
        return Collections.emptyList();
    }

    private static final Collection<ComponentRealization> getAllComponentRealizations(Namespace namespace) {
        HashSet<ComponentRealization> componentRealizations = new HashSet<ComponentRealization>();
        for (NamedElement current : namespace.getOwnedMembers()) {
            if (current instanceof Component) {
                componentRealizations.addAll((Collection<ComponentRealization>)((Component)current).getRealizations());
            }
            if (!(current instanceof Namespace)) continue;
            componentRealizations.addAll(SemanticCandidatesServices.getAllComponentRealizations((Namespace)current));
        }
        return componentRealizations;
    }

    public Collection<Include> getIncludeCandidates(EObject semanticContext) {
        if (semanticContext instanceof Namespace) {
            Namespace namespace = (Namespace)semanticContext;
            return this.getAllIncludes(namespace);
        }
        return Collections.emptyList();
    }

    private final Collection<Include> getAllIncludes(Namespace namespace) {
        HashSet<Include> includes = new HashSet<Include>();
        for (NamedElement current : namespace.getMembers()) {
            if (current instanceof Namespace) {
                includes.addAll(this.getAllIncludes((Namespace)current));
            }
            if (!(current instanceof UseCase)) continue;
            includes.addAll((Collection<Include>)((UseCase)current).getIncludes());
        }
        return includes;
    }

    public Collection<InformationFlow> getInformationFlowCandidates(EObject semanticContext) {
        if (semanticContext instanceof Package) {
            Package pack = (Package)semanticContext;
            return this.getAllElementsByType(pack, InformationFlow.class);
        }
        return List.of();
    }

    public Collection<Manifestation> getManifestationCandidates(EObject semanticContext) {
        if (semanticContext instanceof Package) {
            Package pack = (Package)semanticContext;
            return this.getAllManifestations(pack);
        }
        return Collections.emptyList();
    }

    private final Collection<Manifestation> getAllManifestations(Package pack) {
        HashSet<Manifestation> manifestations = new HashSet<Manifestation>();
        for (NamedElement current : pack.getMembers()) {
            if (current instanceof Package) {
                manifestations.addAll(this.getAllManifestations((Package)current));
            }
            if (!(current instanceof Manifestation)) continue;
            manifestations.add((Manifestation)current);
        }
        return manifestations;
    }

    public Collection<PackageMerge> getPackageMergeCandidates(EObject semanticContext) {
        if (semanticContext instanceof Package) {
            Package pack = (Package)semanticContext;
            return this.getAllPackagesMerge(pack);
        }
        return Collections.emptyList();
    }

    private final Collection<PackageMerge> getAllPackagesMerge(Package pack) {
        HashSet<PackageMerge> packagesMerge = new HashSet<PackageMerge>();
        packagesMerge.addAll((Collection<PackageMerge>)pack.getPackageMerges());
        for (PackageableElement packageableElement : pack.getPackagedElements()) {
            if (!(packageableElement instanceof Package)) continue;
            packagesMerge.addAll(this.getAllPackagesMerge((Package)packageableElement));
        }
        return packagesMerge;
    }

    public Collection<PackageImport> getPackageImportCandidates(EObject semanticContext) {
        if (semanticContext instanceof Namespace) {
            Namespace namespace = (Namespace)semanticContext;
            return this.getAllPackagesImport(namespace);
        }
        return Collections.emptyList();
    }

    private final Collection<PackageImport> getAllPackagesImport(Namespace namespace) {
        HashSet<PackageImport> packageImports = new HashSet<PackageImport>();
        packageImports.addAll((Collection<PackageImport>)namespace.getPackageImports());
        if (namespace instanceof Package) {
            Package pack = (Package)namespace;
            for (PackageableElement packageableElement : pack.getPackagedElements()) {
                if (!(packageableElement instanceof Namespace)) continue;
                packageImports.addAll(this.getAllPackagesImport((Namespace)packageableElement));
            }
        }
        return packageImports;
    }

    public Collection<Realization> getRealizationCandidates(EObject semanticContext) {
        return this.getDependencyCandidates(semanticContext).stream().filter(Realization.class::isInstance).map(Realization.class::cast).collect(Collectors.toList());
    }

    public Collection<Substitution> getSubstitutionCandidates(EObject semanticContext) {
        if (semanticContext instanceof Namespace) {
            Namespace namespace = (Namespace)semanticContext;
            return this.getAllSubstitutions(namespace);
        }
        return Collections.emptyList();
    }

    private final Collection<Substitution> getAllSubstitutions(Namespace namespace) {
        HashSet<Substitution> substitutions = new HashSet<Substitution>();
        for (NamedElement current : namespace.getOwnedMembers()) {
            if (current instanceof Classifier) {
                substitutions.addAll((Collection<Substitution>)((Classifier)current).getSubstitutions());
            }
            if (!(current instanceof Namespace)) continue;
            substitutions.addAll(this.getAllSubstitutions((Namespace)current));
        }
        return substitutions;
    }

    public Collection<Usage> getUsageCandidates(EObject semanticContext) {
        return this.getDependencyCandidates(semanticContext).stream().filter(Usage.class::isInstance).map(Usage.class::cast).collect(Collectors.toList());
    }

    public Collection<Message> getMessageCandidates(Interaction interaction) {
        return interaction.getMessages().stream().filter(msg -> MessageSort.CREATE_MESSAGE_LITERAL != msg.getMessageSort() && MessageSort.DELETE_MESSAGE_LITERAL != msg.getMessageSort()).toList();
    }

    public Collection<Message> getMessageCreateCandidates(Interaction interaction) {
        return interaction.getMessages().stream().filter(msg -> MessageSort.CREATE_MESSAGE_LITERAL == msg.getMessageSort()).toList();
    }

    public Collection<Message> getMessageDeleteCandidates(Interaction interaction) {
        return interaction.getMessages().stream().filter(msg -> MessageSort.DELETE_MESSAGE_LITERAL == msg.getMessageSort()).toList();
    }

    private final <T> Collection<T> getAllElementsByType(Package pack, java.lang.Class<T> clazz) {
        HashSet<Object> elements = new HashSet<Object>();
        for (NamedElement current : pack.getMembers()) {
            if (current instanceof Package) {
                elements.addAll(this.getAllElementsByType((Package)current, clazz));
            }
            if (!clazz.isInstance(current)) continue;
            elements.add(current);
        }
        return elements;
    }
}

