/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.m2m.qvto.tests.tools.tests;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.internal.jobs.Worker;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.junit.framework.classification.tests.AbstractPapyrusTest;
import org.eclipse.papyrus.junit.utils.DisplayUtils;
import org.eclipse.papyrus.junit.utils.ProjectUtils;
import org.eclipse.papyrus.junit.utils.rules.ModelSetFixture;
import org.eclipse.papyrus.uml.m2m.qvto.common.MigrationParameters.MigrationParametersFactory;
import org.eclipse.papyrus.uml.m2m.qvto.common.MigrationParameters.ThreadConfig;
import org.eclipse.papyrus.uml.m2m.qvto.common.transformation.AbstractImportTransformationLauncher;
import org.eclipse.papyrus.uml.m2m.qvto.tests.tools.Activator;
import org.eclipse.papyrus.uml.m2m.qvto.tests.tools.tests.EMFCompareUtils;
import org.eclipse.uml2.uml.Package;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractImportModelTests
extends AbstractPapyrusTest {
    protected static final String XMI_ID_ATTRIBUTE_NAME = "xmi:id";
    protected Set<IFile> filesToImport = new HashSet<IFile>();
    @Rule
    public final ModelSetFixture expectedResultFixture = new ModelSetFixture();
    protected final ResourceSet resultingResourceSet = new ResourceSetImpl();
    protected Resource diResource = null;
    protected Resource notationResource = null;
    protected Resource umlResource = null;
    protected IProject project;
    protected String modelName;
    protected String resourcePath;
    protected IFile outputUmlFile = null;
    protected IFile outputNotationFile = null;
    protected IFile outputDiFile = null;
    protected AbstractImportTransformationLauncher launcher;

    public void initTest(String projectName, String modelName, String sourceExtension, String resourcePath, Bundle bundle) throws CoreException, IOException, URISyntaxException {
        this.modelName = modelName;
        this.project = ProjectUtils.createProject((String)projectName);
        this.importModelIntoProject(modelName, resourcePath, sourceExtension, bundle, this.project);
        this.executeTransformation(this.filesToImport);
        DisplayUtils.flushEventLoop();
        this.waitEndOfImportThread();
        DisplayUtils.flushEventLoop();
        this.initOutputIFilesFields();
    }

    protected void initOutputIFilesFields() {
        if (this.outputUmlFile == null) {
            this.outputUmlFile = this.checkUMLFileCreationAndGetIt();
        }
        if (this.outputNotationFile == null) {
            this.outputNotationFile = this.checkNotationFileCreationAndGetIt();
        }
        if (this.outputDiFile == null) {
            this.outputDiFile = this.checkDiFileCreationAndGetIt();
        }
    }

    protected void initOutputResourcesFields() {
        this.initOutputIFilesFields();
        if (this.umlResource == null) {
            this.umlResource = this.addFileToResourceSet(this.resultingResourceSet, this.outputUmlFile);
        }
        if (this.notationResource == null) {
            this.notationResource = this.addFileToResourceSet(this.resultingResourceSet, this.outputNotationFile);
        }
        if (this.diResource == null) {
            this.diResource = this.addFileToResourceSet(this.resultingResourceSet, this.outputDiFile);
        }
    }

    public final void importModelIntoProject(String modelName, String sourcePath, String sourceExtension, Bundle sourceBundle, IProject targetProject) throws URISyntaxException, IOException {
        String currentPath = sourcePath + modelName + "." + sourceExtension;
        URL url = sourceBundle.getResource(currentPath);
        java.net.URI uri = FileLocator.resolve((URL)url).toURI();
        URI currentURI = this.copyOldProjectToNewFolder(URI.createFileURI((String)uri.getRawPath()), URI.createFileURI((String)targetProject.getLocationURI().getRawPath()));
        try {
            this.project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Activator.log.error((Throwable)e);
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPath location = Path.fromOSString((String)currentURI.toFileString());
        IFile ifile = workspace.getRoot().getFileForLocation(location);
        this.filesToImport.add(ifile);
    }

    protected URI copyOldProjectToNewFolder(URI initialProjectURI, URI newPath) {
        URI uri = initialProjectURI.trimSegments(1);
        File projectFolder = new File(uri.toFileString());
        ArrayList<File> duplicatedFile = new ArrayList<File>();
        if (projectFolder.exists() && projectFolder.isDirectory()) {
            File[] fileArray = projectFolder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File subFile = fileArray[n2];
                duplicatedFile.addAll(this.copyFile(subFile, newPath));
                ++n2;
            }
        }
        for (File current : duplicatedFile) {
            URI newURI = URI.createFileURI((String)current.getPath());
            if (!this.isNeededSourceExtension(newURI.fileExtension())) continue;
            return newURI;
        }
        return null;
    }

    protected boolean isNeededSourceExtension(String fileExtension) {
        return "uml".equals(fileExtension);
    }

    public List<File> copyFile(File src, URI target) {
        ArrayList<File> duplicatedFile = new ArrayList<File>();
        URI copiedFileURI = URI.createFileURI((String)target.devicePath());
        copiedFileURI = copiedFileURI.appendSegment(src.getName());
        if (src.isDirectory()) {
            File folder = new File(copiedFileURI.devicePath());
            folder.mkdir();
            File[] fileArray = src.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                duplicatedFile.addAll(this.copyFile(f, copiedFileURI));
                ++n2;
            }
        } else {
            File newFile = new File(copiedFileURI.devicePath());
            try {
                Files.copy((File)src, (File)newFile);
                duplicatedFile.add(newFile);
            }
            catch (IOException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return duplicatedFile;
    }

    protected void executeTransformation(Set<IFile> files) {
        ArrayList<URI> urisToImport = new ArrayList<URI>();
        for (IFile current : files) {
            String path = null;
            if (current instanceof IFile) {
                path = current.getFullPath().toString();
            }
            if (path == null) continue;
            URI uri = URI.createPlatformResourceURI((String)path, (boolean)true);
            urisToImport.add(uri);
        }
        ThreadConfig config = MigrationParametersFactory.eINSTANCE.createThreadConfig();
        this.launcher = this.createLauncher(config);
        this.launcher.run(urisToImport);
    }

    public abstract AbstractImportTransformationLauncher createLauncher(ThreadConfig var1);

    protected IFile checkUMLFileCreationAndGetIt() {
        Object outputFolder = this.getOutputFolder();
        if (!((String)outputFolder).isEmpty() && !((String)outputFolder).endsWith(File.separator)) {
            outputFolder = (String)outputFolder + File.separator;
        }
        IFile umlFile = this.project.getFile((String)outputFolder + this.getOutputModelName() + ".uml");
        try {
            umlFile.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Activator.log.error((Throwable)e);
        }
        Assert.assertTrue((String)("The uml file has not been created: " + String.valueOf(umlFile.getFullPath())), (boolean)umlFile.exists());
        return umlFile;
    }

    protected IFile checkNotationFileCreationAndGetIt() {
        Object outputFolder = this.getOutputFolder();
        if (!((String)outputFolder).isEmpty() && !((String)outputFolder).endsWith(File.separator)) {
            outputFolder = (String)outputFolder + File.separator;
        }
        IFile notationFile = this.project.getFile((String)outputFolder + this.getOutputModelName() + ".notation");
        Assert.assertTrue((String)("The notation file has not been created: " + String.valueOf(notationFile.getFullPath())), (boolean)notationFile.exists());
        return notationFile;
    }

    protected IFile checkDiFileCreationAndGetIt() {
        Object outputFolder = this.getOutputFolder();
        if (!((String)outputFolder).isEmpty() && !((String)outputFolder).endsWith(File.separator)) {
            outputFolder = (String)outputFolder + File.separator;
        }
        IFile diFile = this.project.getFile((String)outputFolder + this.getOutputModelName() + ".di");
        Assert.assertTrue((String)("The di file has not been created: " + String.valueOf(diFile.getFullPath())), (boolean)diFile.exists());
        return diFile;
    }

    protected String getOutputFolder() {
        return "";
    }

    protected String getOutputModelName() {
        return this.modelName;
    }

    protected void waitEndOfImportThread() {
        Set<Thread> threads = Thread.getAllStackTraces().keySet();
        for (Thread thread : threads) {
            Job job;
            if (!(thread instanceof Worker) || (job = ((Worker)thread).currentJob()) == null || !job.getName().equals("Import Models")) continue;
            try {
                job.join();
            }
            catch (InterruptedException e1) {
                Activator.log.error((Throwable)e1);
            }
        }
    }

    protected Resource addFileToResourceSet(ResourceSet resourceSet, IFile fileToAdd) {
        String path = fileToAdd.getFullPath().toPortableString();
        URI uri = URI.createURI((String)path);
        boolean exist = resourceSet.getURIConverter().exists(uri, null);
        Assert.assertTrue((boolean)exist);
        return resourceSet.getResource(uri, true);
    }

    @Test
    public void checkTransformedUMLModel() {
        this.initOutputResourcesFields();
        Assert.assertTrue((String)"The created uml resource is empty.", (this.umlResource.getContents().size() > 0 ? 1 : 0) != 0);
        Iterator iter = this.umlResource.getContents().iterator();
        Package root = null;
        while (root == null && iter.hasNext()) {
            EObject tmp = (EObject)iter.next();
            if (!(tmp instanceof Package)) continue;
            root = (Package)tmp;
        }
        Assert.assertNotNull((String)"The root of the imported model has not been found", root);
        this.checkUMLModelSpecificities(root);
    }

    @Test
    public void checkTransformedNotationModel() {
        this.initOutputResourcesFields();
        Assert.assertTrue((String)"The created notation resource is empty.", (this.notationResource.getContents().size() > 0 ? 1 : 0) != 0);
        for (EObject current : this.notationResource.getContents()) {
            if (current instanceof Diagram) {
                this.checkNotationElementSpecificities((EModelElement)((Diagram)current));
                continue;
            }
            if (!(current instanceof Table)) continue;
            this.checkNotationElementSpecificities((EModelElement)((Table)current));
        }
    }

    protected abstract void checkUMLModelSpecificities(Package var1);

    protected abstract void checkNotationElementSpecificities(EModelElement var1);

    @Test
    public void checkSemanticWithEMFCompare() {
        this.initOutputResourcesFields();
        ResourceSetImpl resultSet = new ResourceSetImpl();
        Resource currentResultResource = resultSet.getResource(this.umlResource.getURI(), true);
        ArrayList<EObject> currentContents = new ArrayList<EObject>((Collection<EObject>)currentResultResource.getContents());
        currentContents.sort(new XMIIDSorter());
        currentResultResource.getContents().clear();
        currentResultResource.getContents().addAll(currentContents);
        ResourceSetImpl expectedSet = new ResourceSetImpl();
        Resource expectedResource = expectedSet.getResource(this.expectedResultFixture.getModelResource().getURI(), true);
        ArrayList<EObject> expectedContents = new ArrayList<EObject>((Collection<EObject>)expectedResource.getContents());
        expectedContents.sort(new XMIIDSorter());
        expectedResource.getContents().clear();
        expectedResource.getContents().addAll(expectedContents);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)resultSet, (Notifier)expectedSet, null);
        Comparison result = EMFCompareUtils.createEMFCompare().compare((IComparisonScope)scope);
        EList conflicts = result.getConflicts();
        Assert.assertEquals((String)"Conflicts have been detected", (long)0L, (long)conflicts.size());
        List<Diff> differences = this.getFilteredDiffForUMLModel(new ArrayList<Diff>((Collection<Diff>)result.getDifferences()));
        if (!differences.isEmpty()) {
            StringBuilder builder = new StringBuilder(NLS.bind((String)"{0} differences have been detected: \n", (Object)differences.size()));
            Iterator<Diff> iter = differences.iterator();
            while (iter.hasNext()) {
                Diff current = iter.next();
                builder.append(current.toString());
                if (!iter.hasNext()) continue;
                builder.append("\n");
            }
            Assert.assertEquals((String)builder.toString(), (long)0L, (long)differences.size());
        }
    }

    protected List<Diff> getFilteredDiffForUMLModel(List<Diff> diff) {
        return diff;
    }

    @Test
    public void checkNotationWithEMFCompare() {
        if (this.compareNotation()) {
            this.initOutputResourcesFields();
            ResourceSetImpl resultSet = new ResourceSetImpl();
            resultSet.getResource(this.umlResource.getURI(), true);
            resultSet.getResource(this.notationResource.getURI(), true);
            ResourceSetImpl expectedSet = new ResourceSetImpl();
            expectedSet.getResource(this.expectedResultFixture.getModelResource().getURI(), true);
            expectedSet.getResource(this.expectedResultFixture.getModelResource().getURI().trimFileExtension().appendFileExtension("notation"), true);
            DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)resultSet, (Notifier)expectedSet, null);
            Comparison result = EMFCompareUtils.createEMFCompare().compare((IComparisonScope)scope);
            EList conflicts = result.getConflicts();
            Assert.assertEquals((String)"Conflicts have been detected", (long)0L, (long)conflicts.size());
            List<Diff> differences = this.getFilteredDiffForNotationModel(new ArrayList<Diff>((Collection<Diff>)result.getDifferences()));
            if (!differences.isEmpty()) {
                StringBuilder builder = new StringBuilder(NLS.bind((String)"{0} differences have been detected: \n", (Object)differences.size()));
                Iterator<Diff> iter = differences.iterator();
                while (iter.hasNext()) {
                    Diff current = iter.next();
                    builder.append(current.toString());
                    if (!iter.hasNext()) continue;
                    builder.append("\n");
                }
                Assert.assertEquals((String)builder.toString(), (long)0L, (long)differences.size());
            }
        }
    }

    protected boolean compareNotation() {
        return true;
    }

    protected List<Diff> getFilteredDiffForNotationModel(List<Diff> diff) {
        return diff;
    }

    @Test
    public void checkUnicityOfXMIIDInUMLFile() throws Exception {
        DocumentBuilder dBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = dBuilder.parse(this.getUMLOutputFile());
        ArrayList<String> ids = new ArrayList<String>();
        List<Node> nodes = this.flattenDocument(document);
        for (Node node : nodes) {
            Node item;
            if (node.getAttributes() == null || (item = node.getAttributes().getNamedItem(XMI_ID_ATTRIBUTE_NAME)) == null) continue;
            String value = item.getNodeValue();
            ids.add(value);
        }
        HashSet uniqueIds = new HashSet(ids);
        for (String t : uniqueIds) {
            ids.remove(t);
        }
        Assert.assertEquals((String)("Some ids are duplicated in the UML model: " + ((Object)ids).toString()), (long)0L, (long)ids.size());
    }

    @Test
    public void checkUnicityOfXMIIDInNotationFile() throws Exception {
        DocumentBuilder dBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = dBuilder.parse(this.getNotationOutputFile());
        ArrayList<String> ids = new ArrayList<String>();
        List<Node> nodes = this.flattenDocument(document);
        for (Node node : nodes) {
            Node item;
            if (node.getAttributes() == null || (item = node.getAttributes().getNamedItem(XMI_ID_ATTRIBUTE_NAME)) == null) continue;
            String value = item.getNodeValue();
            ids.add(value);
        }
        HashSet uniqueIds = new HashSet(ids);
        for (String t : uniqueIds) {
            ids.remove(t);
        }
        Assert.assertEquals((String)("Some ids are duplicated in the Notation model: " + ((Object)ids).toString()), (long)0L, (long)ids.size());
    }

    @Test
    public void checkAllElementInUMLFileHaveAnID() throws Exception {
        DocumentBuilder dBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = dBuilder.parse(this.getUMLOutputFile());
        ArrayList<String> ids = new ArrayList<String>();
        List<Node> nodes = this.flattenDocument(document);
        for (Node node : nodes) {
            Node item;
            if (node.getAttributes() == null || (item = node.getAttributes().getNamedItem(XMI_ID_ATTRIBUTE_NAME)) == null) continue;
            String value = item.getNodeValue();
            ids.add(value);
        }
        int nbElements = 0;
        this.initOutputResourcesFields();
        TreeIterator iter = this.umlResource.getAllContents();
        while (iter.hasNext()) {
            iter.next();
            ++nbElements;
        }
        Assert.assertEquals((String)"I don't found the same number of XMI_ID than the number of element in the file", (long)nbElements, (long)ids.size());
    }

    @Test
    public void checkAllElementInNotationFileHaveAnID() throws Exception {
        DocumentBuilder dBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = dBuilder.parse(this.getNotationOutputFile());
        ArrayList<String> ids = new ArrayList<String>();
        List<Node> nodes = this.flattenDocument(document);
        for (Node node : nodes) {
            Node item;
            if (node.getAttributes() == null || (item = node.getAttributes().getNamedItem(XMI_ID_ATTRIBUTE_NAME)) == null) continue;
            String value = item.getNodeValue();
            ids.add(value);
        }
        int nbElements = 0;
        this.initOutputResourcesFields();
        TreeIterator iter = this.notationResource.getAllContents();
        while (iter.hasNext()) {
            iter.next();
            ++nbElements;
        }
        Assert.assertEquals((String)"I don't found the same number of XMI_ID than the number of element in the file", (long)nbElements, (long)ids.size());
    }

    public List<Node> flattenDocument(Document document) {
        return this.getAllChildren(document.getChildNodes());
    }

    public List<Node> getAllChildren(NodeList nodeList) {
        ArrayList<Node> objects = new ArrayList<Node>();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            objects.add(node);
            objects.addAll(this.getAllChildren(node.getChildNodes()));
            ++i;
        }
        return objects;
    }

    protected File getUMLOutputFile() {
        IPath path = this.outputUmlFile.getRawLocation();
        File file = path.toFile();
        return file;
    }

    protected File getNotationOutputFile() {
        IPath path = this.outputNotationFile.getRawLocation();
        File file = path.toFile();
        return file;
    }

    public class XMIIDSorter
    implements Comparator<EObject> {
        @Override
        public int compare(EObject o1, EObject o2) {
            XMIResource res1 = (XMIResource)o1.eResource();
            XMIResource res2 = (XMIResource)o2.eResource();
            String id1 = res1.getID(o1);
            String id2 = res2.getID(o2);
            return id1.compareTo(id2);
        }
    }
}

