/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.editor.welcome.internal.modelelements;

import java.util.Objects;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.sasheditor.SashModel;
import org.eclipse.papyrus.infra.core.resource.sasheditor.SashModelUtils;
import org.eclipse.papyrus.infra.core.sashwindows.di.SashWindowsMngr;
import org.eclipse.papyrus.infra.core.sashwindows.di.util.DiUtils;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.utils.TransactionHelper;
import org.eclipse.papyrus.infra.editor.welcome.internal.Activator;
import org.eclipse.papyrus.infra.editor.welcome.internal.modelelements.WelcomeModelElement;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResourceSet;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.ui.internal.commands.SashLayoutCommandFactory;
import org.eclipse.papyrus.infra.ui.services.SaveLayoutBeforeClose;

public abstract class AbstractPageLayoutToggleValue
extends AbstractObservableValue<Boolean> {
    protected final EditingDomain domain;
    protected final SashModel sashModel;

    public AbstractPageLayoutToggleValue(WelcomeModelElement owner) {
        this(Realm.getDefault(), owner);
    }

    public AbstractPageLayoutToggleValue(Realm realm, WelcomeModelElement owner) {
        super(realm);
        this.domain = owner.getDomain();
        this.sashModel = SashModelUtils.getSashModel((ModelSet)((ModelSet)this.domain.getResourceSet()));
    }

    public Object getValueType() {
        return Boolean.class;
    }

    protected SashWindowsMngr getSashWindowsMngr() {
        return this.getSashWindowsMngr(this.sashModel.getResource());
    }

    protected SashWindowsMngr getSashWindowsMngr(Resource resource) {
        return DiUtils.lookupSashWindowsMngr((Resource)resource);
    }

    protected abstract Command getToggleCommand(SashLayoutCommandFactory var1);

    protected void doSetValue(Boolean value) {
        Boolean oldValue = (Boolean)this.getValue();
        if (!Objects.equals(oldValue, value)) {
            IMultiDiagramEditor editor;
            try {
                editor = (IMultiDiagramEditor)ServiceUtilsForResourceSet.getInstance().getService(IMultiDiagramEditor.class, (Object)this.domain.getResourceSet());
                Command command = this.getToggleCommand(new SashLayoutCommandFactory(editor));
                if (command.canExecute()) {
                    try {
                        TransactionHelper.run((EditingDomain)this.domain, () -> command.execute());
                        this.fireValueChange(Diffs.createValueDiff((Object)oldValue, (Object)value));
                    }
                    catch (Exception e) {
                        Activator.log.error("Failed to toggle editor page layout option", (Throwable)e);
                    }
                }
            }
            catch (ServiceException e) {
                throw new IllegalStateException("No editor available in the service registry", e);
            }
            try {
                SaveLayoutBeforeClose saveLayout = (SaveLayoutBeforeClose)editor.getServicesRegistry().getService(SaveLayoutBeforeClose.class);
                saveLayout.saveBeforeClose(editor);
            }
            catch (ServiceException e) {
                Activator.log.error("Failed to save page layout", (Throwable)e);
            }
        }
    }
}

