/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.internationalization.controlmode.commands;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.internationalization.modelresource.InternationalizationModelResource;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.commands.CreateControlResource;

public class CreatePropertiesControlResourceCommand
extends CreateControlResource {
    private Locale locale;
    private Resource createdResource;
    private InternationalizationModelResource internationalizationModelResource;

    public CreatePropertiesControlResourceCommand(ControlModeRequest request, String newFileExtension, Locale locale) {
        super(request, newFileExtension);
        this.locale = locale;
    }

    public URI getTargetUri() {
        return this.getModifiedURI(this.getRequest().getNewURI());
    }

    protected URI getModifiedURI(URI initialURI) {
        URI targetURI = initialURI;
        if (this.locale != null) {
            String existingFileExtension = targetURI.fileExtension();
            Object lastSegment = targetURI.trimFileExtension().lastSegment();
            lastSegment = (String)lastSegment + "_" + this.locale.toString();
            targetURI = targetURI.trimFileExtension().trimSegments(1).appendSegment((String)lastSegment).appendFileExtension(existingFileExtension);
        }
        if (this.newFileExtension != null) {
            targetURI = targetURI.trimFileExtension().appendFileExtension(this.newFileExtension);
        }
        return targetURI;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        CommandResult res = super.doExecuteWithResult(progressMonitor, info);
        this.createdResource = this.getRequest().getTargetResource(this.newFileExtension);
        if (this.getRequest().getParameter("createdPropertiesResources") == null) {
            this.getRequest().setParameter("createdPropertiesResources", new HashMap());
        }
        ((Map)this.getRequest().getParameter("createdPropertiesResources")).put(this.locale, this.createdResource);
        InternationalizationModelResource modelResource = this.getInternationalizationModelResource();
        if (modelResource != null) {
            modelResource.addResourceToModel(this.getRequest().getNewURI().trimFileExtension(), this.createdResource, this.locale);
        }
        return res;
    }

    protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.getRequest().setTargetResource(this.createdResource, this.getFileExtension());
        InternationalizationModelResource modelResource = this.getInternationalizationModelResource();
        if (modelResource != null) {
            modelResource.unload(this.createdResource);
            modelResource.getResources().remove(this.createdResource);
        }
        return super.doUndo(monitor, info);
    }

    protected IStatus doRedo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.getRequest().setTargetResource(this.createdResource, this.getFileExtension());
        IStatus result = super.doRedo(monitor, info);
        InternationalizationModelResource modelResource = this.getInternationalizationModelResource();
        if (modelResource != null) {
            modelResource.addResourceToModel(this.getRequest().getNewURI().trimFileExtension(), this.createdResource, this.locale);
        }
        return result;
    }

    protected URI getNewURI() {
        return this.getModifiedURI(this.getRequest().getNewURI());
    }

    protected Resource getTargetResrource(EObject objectToUncontrol) {
        InternationalizationModelResource modelResource;
        Resource resultResource = null;
        URI targetURI = null;
        if (objectToUncontrol != null) {
            targetURI = objectToUncontrol.eResource().getURI().trimFileExtension();
            if (this.locale != null) {
                Object lastSegment = targetURI.lastSegment();
                lastSegment = (String)lastSegment + "_" + this.locale.toString();
                targetURI = targetURI.trimSegments(1).appendSegment((String)lastSegment);
            }
            targetURI = targetURI.appendFileExtension(this.getFileExtension());
        }
        if (targetURI != null && (modelResource = this.getInternationalizationModelResource()) != null) {
            resultResource = modelResource.getResourceForURIAndLocale(objectToUncontrol.eResource().getURI().trimFileExtension().appendFileExtension(this.getFileExtension()), this.locale);
        }
        return resultResource;
    }

    protected InternationalizationModelResource getInternationalizationModelResource() {
        ModelSet modelSet;
        if (this.internationalizationModelResource == null && (modelSet = this.getRequest().getModelSet()) != null) {
            try {
                this.internationalizationModelResource = (InternationalizationModelResource)modelSet.getModelChecked("org.eclipse.papyrus.infra.internationalization.resource.InternationalizationModel");
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        return this.internationalizationModelResource;
    }

    public void dispose() {
        this.internationalizationModelResource = null;
        this.createdResource = null;
        this.locale = null;
        super.dispose();
    }
}

