/*****************************************************************************
 * Copyright (c) 2012 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *  Camille Letavernier (CEA LIST) camille.letavernier@cea.fr - Initial API and implementation
 *****************************************************************************/
package org.eclipse.papyrus.infra.gmfdiag.css.style.impl;

import org.eclipse.gmf.runtime.notation.LineStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ExtendedCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.style.CSSLineStyle;
import org.w3c.dom.css.CSSValue;

public class CSSLineStyleDelegate implements CSSLineStyle {

	private LineStyle lineStyle;

	private ExtendedCSSEngine engine;

	public CSSLineStyleDelegate(LineStyle lineStyle, ExtendedCSSEngine engine) {
		this.lineStyle = lineStyle;
		this.engine = engine;
	}

	// //////////////////////////////////////////////
	// Implements a getter for each CSS property //
	// //////////////////////////////////////////////

	@Override
	public int getCSSLineColor() {
		CSSValue cssValue = engine.retrievePropertyValue(lineStyle, "lineColor");
		if (cssValue == null) {
			Object defaultValue = NotationPackage.eINSTANCE.getLineStyle_LineColor().getDefaultValue();
			return (Integer) defaultValue;
		}
		return (Integer) engine.convert(cssValue, "GMFColor", null);
	}

	@Override
	public int getCSSLineWidth() {
		CSSValue cssValue = engine.retrievePropertyValue(lineStyle, "lineWidth");
		if (cssValue == null) {
			Object defaultValue = NotationPackage.eINSTANCE.getLineStyle_LineWidth().getDefaultValue();
			return (Integer) defaultValue;
		}
		return (Integer) engine.convert(cssValue, Integer.class, null);
	}
}
