/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.common.checkers;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.AbstractPluginChecker;

public class ModelValidationChecker
extends AbstractPluginChecker {
    private final Resource resource;

    public ModelValidationChecker(IFile modelFile, Resource resource, String markerType) {
        super(modelFile.getProject(), modelFile, markerType);
        this.resource = resource;
    }

    @Override
    public void check(DiagnosticChain diagnostics, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)("Validate file '" + this.getModelFile().getName() + "'."), (int)1);
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        EValidator.SubstitutionLabelProvider labels = ModelValidationChecker.createSubstitutionLabelProvider((AdapterFactory)adapterFactory);
        HashMap<Class<EValidator.SubstitutionLabelProvider>, EValidator.SubstitutionLabelProvider> context = new HashMap<Class<EValidator.SubstitutionLabelProvider>, EValidator.SubstitutionLabelProvider>();
        context.put(EValidator.SubstitutionLabelProvider.class, labels);
        try {
            BasicDiagnostic validationResults = new BasicDiagnostic();
            Diagnostician.INSTANCE.validate((EObject)this.resource.getContents().get(0), (DiagnosticChain)validationResults, context);
            if (validationResults.getSeverity() > 0) {
                diagnostics.merge(this.wrap((Diagnostic)validationResults));
            }
        }
        finally {
            adapterFactory.dispose();
        }
        subMonitor.worked(1);
        SubMonitor.done((IProgressMonitor)monitor);
    }

    public static EValidator.SubstitutionLabelProvider createSubstitutionLabelProvider(final AdapterFactory adapterFactory) {
        return new EValidator.SubstitutionLabelProvider(){

            public String getObjectLabel(EObject eObject) {
                String result = null;
                if (eObject.eIsProxy()) {
                    result = EcoreUtil.getURI((EObject)eObject).toString();
                } else {
                    IItemLabelProvider labels = (IItemLabelProvider)adapterFactory.adapt((Notifier)eObject, IItemLabelProvider.class);
                    if (labels != null) {
                        result = labels.getText((Object)eObject);
                    }
                }
                if (result == null) {
                    result = EcoreUtil.getIdentification((EObject)eObject);
                }
                return result;
            }

            public String getFeatureLabel(EStructuralFeature eStructuralFeature) {
                return eStructuralFeature.getName();
            }

            public String getValueLabel(EDataType eDataType, Object value) {
                return EcoreUtil.convertToString((EDataType)eDataType, (Object)value);
            }
        };
    }
}

