/*
 * Decompiled with CFR 0.152.
 */
package impl.diagram.editparts;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import impl.diagram.editparts.TextAware;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.gmf.codegen.gmfgen.FigureViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenChildNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenChildSideAffixedNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenContainerBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenExternalNodeLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenLabel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenTopLevelNode;
import org.eclipse.papyrus.gmf.codegen.gmfgen.InnerClassViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ParentAssignedViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.RefreshHook;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ResizeConstraints;
import org.eclipse.papyrus.gmf.codegen.gmfgen.SnippetViewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.Viewmap;
import org.eclipse.papyrus.gmf.codegen.gmfgen.ViewmapLayoutType;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import utils.EditPartsUtils_qvto;
import xpt.CodeStyle;
import xpt.Common_qvto;
import xpt.diagram.ViewmapAttributesUtils_qvto;
import xpt.diagram.editparts.Common;
import xpt.diagram.editparts.EditPartFactory;
import xpt.diagram.editparts.Utils_qvto;
import xpt.editor.VisualIDRegistry;
import xpt.providers.ElementTypes;

@Singleton
public class NodeEditPart {
    @Inject
    @Extension
    private CodeStyle _codeStyle;
    @Inject
    @Extension
    private xpt.Common _common;
    @Inject
    @Extension
    private Common_qvto _common_qvto;
    @Inject
    @Extension
    private ViewmapAttributesUtils_qvto _viewmapAttributesUtils_qvto;
    @Inject
    @Extension
    private Utils_qvto _utils_qvto;
    @Inject
    @Extension
    private xpt.diagram.Utils_qvto _utils_qvto_1;
    @Inject
    @Extension
    private VisualIDRegistry _visualIDRegistry;
    @Inject
    @Extension
    private EditPartsUtils_qvto _editPartsUtils_qvto;
    @Inject
    private Common xptEditpartsCommon;
    @Inject
    private TextAware xptTextAware;
    @Inject
    private VisualIDRegistry xptVisualIDRegistry;
    @Inject
    private ElementTypes xptElementTypes;
    @Inject
    private EditPartFactory xptEditPartFactory;

    public CharSequence className(GenNode it) {
        StringConcatenation _builder = new StringConcatenation();
        String _editPartClassName = it.getEditPartClassName();
        _builder.append(_editPartClassName);
        return _builder;
    }

    public CharSequence packageName(GenNode it) {
        StringConcatenation _builder = new StringConcatenation();
        String _editPartsPackageName = it.getDiagram().getEditPartsPackageName();
        _builder.append(_editPartsPackageName);
        return _builder;
    }

    protected CharSequence _extendsListContents(GenNode it) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _superEditPart = it.getSuperEditPart();
        boolean bl = _tripleNotEquals = _superEditPart != null;
        if (_tripleNotEquals) {
            String _superEditPart_1 = it.getSuperEditPart();
            _builder.append(_superEditPart_1);
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("org.eclipse.papyrus.infra.gmfdiag.common.editpart.NodeEditPart");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence _extendsListContents(GenChildSideAffixedNode it) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _superEditPart = it.getSuperEditPart();
        boolean bl = _tripleNotEquals = _superEditPart != null;
        if (_tripleNotEquals) {
            String _superEditPart_1 = it.getSuperEditPart();
            _builder.append(_superEditPart_1);
            _builder.newLineIfNotEmpty();
        } else {
            boolean _hasBorderItems = this._utils_qvto.hasBorderItems((GenNode)it);
            if (_hasBorderItems) {
                _builder.append("org.eclipse.papyrus.uml.diagram.common.editparts.BorderedBorderItemEditPart");
                _builder.newLine();
            } else {
                _builder.append("org.eclipse.papyrus.uml.diagram.common.editparts.AbstractBorderItemEditPart");
                _builder.newLine();
            }
        }
        return _builder;
    }

    public CharSequence constructor(GenNode it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public ");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className);
        _builder.append("(org.eclipse.gmf.runtime.notation.View view) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("super(view);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence createDefaultEditPoliciesBody(GenNode it) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _installCreationRolePolicy = this.installCreationRolePolicy(it);
        _builder.append((Object)_installCreationRolePolicy);
        _builder.newLineIfNotEmpty();
        _builder.append("super.createDefaultEditPolicies();");
        _builder.newLine();
        CharSequence _installPrimaryDragEditPolicy = this.installPrimaryDragEditPolicy(it);
        _builder.append((Object)_installPrimaryDragEditPolicy);
        _builder.newLineIfNotEmpty();
        CharSequence _installSemanticEditPolicy = this.xptEditpartsCommon.installSemanticEditPolicy((GenCommonBase)it);
        _builder.append((Object)_installSemanticEditPolicy);
        _builder.newLineIfNotEmpty();
        CharSequence _installGraphicalNodeEditPolicy = this.installGraphicalNodeEditPolicy(it);
        _builder.append((Object)_installGraphicalNodeEditPolicy);
        _builder.newLineIfNotEmpty();
        boolean _isEmpty = it.getChildNodes().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("installEditPolicy(org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles.DRAG_DROP_ROLE, new org.eclipse.gmf.runtime.diagram.ui.editpolicies.DragDropEditPolicy());");
            _builder.newLine();
        }
        CharSequence _installCanonicalEditPolicy = this.xptEditpartsCommon.installCanonicalEditPolicy((GenContainerBase)it);
        _builder.append((Object)_installCanonicalEditPolicy);
        _builder.newLineIfNotEmpty();
        _builder.append("installEditPolicy(org.eclipse.gef.EditPolicy.LAYOUT_ROLE, createLayoutEditPolicy());");
        _builder.newLine();
        CharSequence _behaviour = this.xptEditpartsCommon.behaviour((GenCommonBase)it);
        _builder.append((Object)_behaviour);
        _builder.newLineIfNotEmpty();
        _builder.append("// XXX need an SCR to runtime to have another abstract superclass that would let children add reasonable editpolicies");
        _builder.newLine();
        _builder.append("// removeEditPolicy(org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles.CONNECTION_HANDLES_ROLE);");
        _builder.newLine();
        return _builder;
    }

    public CharSequence installGraphicalNodeEditPolicy(GenNode it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("installEditPolicy(org.eclipse.gef.EditPolicy.GRAPHICAL_NODE_ROLE, new org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.DefaultGraphicalNodeEditPolicy());");
        _builder.newLine();
        return _builder;
    }

    public CharSequence installCreationRolePolicy(GenNode it) {
        StringConcatenation _builder = new StringConcatenation();
        if (!it.getChildNodes().isEmpty() || this._utils_qvto.hasChildrenInListCompartments(it)) {
            CharSequence _installCreationEditPolicy = this.xptEditpartsCommon.installCreationEditPolicy((GenCommonBase)it);
            _builder.append((Object)_installCreationEditPolicy);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _installPrimaryDragEditPolicy(GenNode it) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    protected CharSequence _installPrimaryDragEditPolicy(GenChildSideAffixedNode it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("installEditPolicy(org.eclipse.gef.EditPolicy.PRIMARY_DRAG_ROLE, getPrimaryDragEditPolicy());");
        _builder.newLine();
        return _builder;
    }

    public CharSequence createLayoutEditPolicy(GenNode it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("protected org.eclipse.gef.editpolicies.LayoutEditPolicy createLayoutEditPolicy() {");
        _builder.newLine();
        _builder.append("\t");
        CharSequence _createLayoutEditPolicyBody = this.createLayoutEditPolicyBody(it);
        _builder.append((Object)_createLayoutEditPolicyBody, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence createLayoutEditPolicyBody(GenNode it) {
        StringConcatenation _builder = new StringConcatenation();
        ViewmapLayoutType _layoutType = it.getLayoutType();
        boolean _equals = Objects.equals(ViewmapLayoutType.XY_LAYOUT_LITERAL, _layoutType);
        if (_equals) {
            CharSequence _createLayoutEditPolicyBody_XY_LAYOUT = this.createLayoutEditPolicyBody_XY_LAYOUT(it);
            _builder.append((Object)_createLayoutEditPolicyBody_XY_LAYOUT);
            _builder.newLineIfNotEmpty();
        } else {
            ViewmapLayoutType _layoutType_1 = it.getLayoutType();
            boolean _equals_1 = Objects.equals(ViewmapLayoutType.TOOLBAR_LAYOUT_LITERAL, _layoutType_1);
            if (_equals_1) {
                CharSequence _createLayoutEditPolicyBody_TOOLBAR_LAYOUT = this.createLayoutEditPolicyBody_TOOLBAR_LAYOUT(it);
                _builder.append((Object)_createLayoutEditPolicyBody_TOOLBAR_LAYOUT);
                _builder.newLineIfNotEmpty();
            } else {
                ViewmapLayoutType _layoutType_2 = it.getLayoutType();
                boolean _equals_2 = Objects.equals(ViewmapLayoutType.FLOW_LAYOUT_LITERAL, _layoutType_2);
                if (_equals_2) {
                    CharSequence _createLayoutEditPolicyBody_FLOW_LAYOUT = this.createLayoutEditPolicyBody_FLOW_LAYOUT(it);
                    _builder.append((Object)_createLayoutEditPolicyBody_FLOW_LAYOUT);
                    _builder.newLineIfNotEmpty();
                } else {
                    CharSequence _createLayoutEditPolicyBody_DEFAULT = this.createLayoutEditPolicyBody_DEFAULT(it);
                    _builder.append((Object)_createLayoutEditPolicyBody_DEFAULT);
                    _builder.newLineIfNotEmpty();
                }
            }
        }
        return _builder;
    }

    public CharSequence createLayoutEditPolicyBody_XY_LAYOUT(GenNode it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("\t");
        _builder.append("org.eclipse.gmf.runtime.diagram.ui.editpolicies.XYLayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.XYLayoutEditPolicy() {");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append((Object)_overrideC, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("protected org.eclipse.gef.EditPolicy createChildEditPolicy(org.eclipse.gef.EditPart child) {");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _borderItemSelectionEditPolicy = this.borderItemSelectionEditPolicy(it);
        _builder.append((Object)_borderItemSelectionEditPolicy, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("org.eclipse.gef.EditPolicy result = super.createChildEditPolicy(child);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (result == null) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("return new org.eclipse.gmf.runtime.diagram.ui.editpolicies.ResizableShapeEditPolicy();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return result;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("};");
        _builder.newLine();
        _builder.append("return lep;");
        _builder.newLine();
        return _builder;
    }

    public CharSequence createLayoutEditPolicyBody_TOOLBAR_LAYOUT(GenNode it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("org.eclipse.gmf.runtime.diagram.ui.editpolicies.ConstrainedToolbarLayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.ConstrainedToolbarLayoutEditPolicy() {");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append((Object)_overrideC, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("protected org.eclipse.gef.EditPolicy createChildEditPolicy(org.eclipse.gef.EditPart child) {");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _borderItemSelectionEditPolicy = this.borderItemSelectionEditPolicy(it);
        _builder.append((Object)_borderItemSelectionEditPolicy, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("if (child.getEditPolicy(org.eclipse.gef.EditPolicy.PRIMARY_DRAG_ROLE) == null) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("if (child instanceof org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart) {");
        _builder.newLine();
        _builder.append("\t\t\t\t");
        _builder.append("return new org.eclipse.papyrus.uml.diagram.common.editpolicies.UMLTextSelectionEditPolicy();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return super.createChildEditPolicy(child);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("};");
        _builder.newLine();
        _builder.append("return lep;");
        _builder.newLine();
        return _builder;
    }

    public CharSequence createLayoutEditPolicyBody_FLOW_LAYOUT(GenNode it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("org.eclipse.gmf.runtime.diagram.ui.editpolicies.FlowLayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.FlowLayoutEditPolicy() {");
        _builder.newLine();
        boolean _hasBorderItems = this._utils_qvto.hasBorderItems(it);
        if (_hasBorderItems) {
            _builder.append("\t");
            CharSequence _overrideC = this._codeStyle.overrideC(it);
            _builder.append((Object)_overrideC, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("protected org.eclipse.gef.EditPolicy createChildEditPolicy(org.eclipse.gef.EditPart child) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            CharSequence _borderItemSelectionEditPolicy = this.borderItemSelectionEditPolicy(it);
            _builder.append((Object)_borderItemSelectionEditPolicy, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return super.createChildEditPolicy(child);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("\t");
        CharSequence _overrideC_1 = this._codeStyle.overrideC(it);
        _builder.append((Object)_overrideC_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("protected org.eclipse.gef.commands.Command createAddCommand(org.eclipse.gef.EditPart child, org.eclipse.gef.EditPart after) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return null;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _overrideC_2 = this._codeStyle.overrideC(it);
        _builder.append((Object)_overrideC_2, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("protected org.eclipse.gef.commands.Command createMoveChildCommand(org.eclipse.gef.EditPart child, org.eclipse.gef.EditPart after) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return null;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _overrideC_3 = this._codeStyle.overrideC(it);
        _builder.append((Object)_overrideC_3, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("protected org.eclipse.gef.commands.Command getCreateCommand(org.eclipse.gef.requests.CreateRequest request) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return null;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("};");
        _builder.newLine();
        _builder.append("return lep;");
        _builder.newLine();
        return _builder;
    }

    public CharSequence createLayoutEditPolicyBody_DEFAULT(GenNode it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy() {");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append((Object)_overrideC, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("protected org.eclipse.gef.EditPolicy createChildEditPolicy(org.eclipse.gef.EditPart child) {");
        _builder.newLine();
        _builder.append("\t\t");
        CharSequence _borderItemSelectionEditPolicy = this.borderItemSelectionEditPolicy(it);
        _builder.append((Object)_borderItemSelectionEditPolicy, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("org.eclipse.gef.EditPolicy result = child.getEditPolicy(org.eclipse.gef.EditPolicy.PRIMARY_DRAG_ROLE);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (result == null) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("result = new org.eclipse.gef.editpolicies.NonResizableEditPolicy();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return result;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _overrideC_1 = this._codeStyle.overrideC(it);
        _builder.append((Object)_overrideC_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("protected org.eclipse.gef.commands.Command getMoveChildrenCommand(org.eclipse.gef.Request request) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return null;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _overrideC_2 = this._codeStyle.overrideC(it);
        _builder.append((Object)_overrideC_2, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("protected org.eclipse.gef.commands.Command getCreateCommand(org.eclipse.gef.requests.CreateRequest request) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return null;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("};");
        _builder.newLine();
        _builder.append("return lep;");
        _builder.newLine();
        return _builder;
    }

    public CharSequence borderItemSelectionEditPolicy(GenNode it) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasBorderItems = this._utils_qvto.hasBorderItems(it);
        if (_hasBorderItems) {
            int _size_1;
            boolean _greaterThan_1;
            boolean _greaterThan;
            _builder.append("org.eclipse.gmf.runtime.notation.View childView = (org.eclipse.gmf.runtime.notation.View) child.getModel();");
            _builder.newLine();
            _builder.append("String vid = ");
            CharSequence _visualIDMethodCall = this._visualIDRegistry.getVisualIDMethodCall(it.getDiagram());
            _builder.append((Object)_visualIDMethodCall);
            _builder.append("(childView);");
            _builder.newLineIfNotEmpty();
            _builder.append("if (vid != null) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("switch (vid) {");
            _builder.newLine();
            int _size = IterableExtensions.size(this._utils_qvto.getExternalLabels(it));
            boolean bl = _greaterThan = _size > 0;
            if (_greaterThan) {
                Iterable<GenExternalNodeLabel> _externalLabels = this._utils_qvto.getExternalLabels(it);
                for (GenExternalNodeLabel nextLabel : _externalLabels) {
                    _builder.append("\t\t");
                    CharSequence _caseVisualID = this._visualIDRegistry.caseVisualID((GenCommonBase)nextLabel);
                    _builder.append((Object)_caseVisualID, "\t\t");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t\t");
                _builder.append("return ");
                CharSequence _borderItemSelectionEP = this.borderItemSelectionEP(it);
                _builder.append((Object)_borderItemSelectionEP, "\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            boolean bl2 = _greaterThan_1 = (_size_1 = IterableExtensions.size(this._utils_qvto.getSideAffixedChildren(it))) > 0;
            if (_greaterThan_1) {
                Iterable<GenChildSideAffixedNode> _sideAffixedChildren = this._utils_qvto.getSideAffixedChildren(it);
                for (GenChildSideAffixedNode nextBorderItem : _sideAffixedChildren) {
                    _builder.append("\t\t");
                    CharSequence _caseVisualID_1 = this._visualIDRegistry.caseVisualID((GenCommonBase)nextBorderItem);
                    _builder.append((Object)_caseVisualID_1, "\t\t");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t\t");
                _builder.append("return new org.eclipse.papyrus.uml.diagram.common.editpolicies.BorderItemResizableEditPolicy();");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence borderItemSelectionEP(GenNode it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("new org.eclipse.gmf.runtime.diagram.ui.editpolicies.BorderItemSelectionEditPolicy() {");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append((Object)_overrideC, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("protected java.util.List<?> createSelectionHandles() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("org.eclipse.gef.handles.MoveHandle mh = new org.eclipse.gef.handles.MoveHandle((org.eclipse.gef.GraphicalEditPart) getHost());");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("mh.setBorder(null);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return java.util.Collections.singletonList(mh);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _createNodeShape(Viewmap it, GenNode node) {
        StringConcatenation _builder = new StringConcatenation();
        this._common_qvto.ERROR("Unknown viewmap: " + String.valueOf(it) + " for node: " + String.valueOf(node));
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _createNodeShape(FigureViewmap it, GenNode node) {
        StringConcatenation _xblockexpression = null;
        String _xifexpression = null;
        String _figureQualifiedClassName = it.getFigureQualifiedClassName();
        boolean _tripleEquals = _figureQualifiedClassName == null;
        _xifexpression = _tripleEquals ? "org.eclipse.draw2d.RectangleFigure" : it.getFigureQualifiedClassName();
        String fqn = _xifexpression;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append((Object)_overrideC);
        _builder.newLineIfNotEmpty();
        _builder.append("protected org.eclipse.draw2d.IFigure createNodeShape() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return primaryShape = new ");
        _builder.append(fqn, "\t");
        _builder.append("()");
        CharSequence _forceUseLocalCoordinatesAnonymousClassBody = this.forceUseLocalCoordinatesAnonymousClassBody(node);
        _builder.append((Object)_forceUseLocalCoordinatesAnonymousClassBody, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        CharSequence _primaryShapeMethod = this.getPrimaryShapeMethod(fqn, node);
        _builder.append((Object)_primaryShapeMethod);
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    protected CharSequence _createNodeShape(SnippetViewmap it, GenNode node) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append((Object)_overrideC);
        _builder.newLineIfNotEmpty();
        _builder.append("protected org.eclipse.draw2d.IFigure createNodeShape() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return ");
        String _body = it.getBody();
        _builder.append(_body, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _createNodeShape(InnerClassViewmap it, GenNode node) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append((Object)_overrideC);
        _builder.newLineIfNotEmpty();
        _builder.append("protected org.eclipse.draw2d.IFigure createNodeShape() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return primaryShape = new ");
        String _className = it.getClassName();
        _builder.append(_className, "\t");
        _builder.append("()");
        CharSequence _forceUseLocalCoordinatesAnonymousClassBody = this.forceUseLocalCoordinatesAnonymousClassBody(node);
        _builder.append((Object)_forceUseLocalCoordinatesAnonymousClassBody, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        CharSequence _primaryShapeMethod = this.getPrimaryShapeMethod(it.getClassName(), node);
        _builder.append((Object)_primaryShapeMethod);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence forceUseLocalCoordinatesAnonymousClassBody(GenNode node) {
        StringConcatenation _builder = new StringConcatenation();
        if (!node.getChildNodes().isEmpty() && Objects.equals(node.getLayoutType(), ViewmapLayoutType.XY_LAYOUT_LITERAL)) {
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("protected boolean useLocalCoordinates() {");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("return true;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence getPrimaryShapeMethod(String fqn, GenNode node) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment(fqn);
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideC = this._codeStyle.overrideC(this);
        _builder.append((Object)_overrideC);
        _builder.newLineIfNotEmpty();
        _builder.append("public ");
        _builder.append(fqn);
        _builder.append(" getPrimaryShape() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return (");
        _builder.append(fqn, "\t");
        _builder.append(") primaryShape;");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence addFixedChild(GenNode it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("protected boolean addFixedChild(org.eclipse.gef.EditPart childEditPart) {");
        _builder.newLine();
        _builder.append("\t");
        Iterable<? extends GenLabel> _innerFixedLabels = this._utils_qvto.getInnerFixedLabels(it);
        for (GenLabel genLabel : _innerFixedLabels) {
            Viewmap _viewmap = genLabel.getViewmap();
            ParentAssignedViewmap childViewmap = (ParentAssignedViewmap)_viewmap;
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("if (childEditPart instanceof ");
            CharSequence _editPartQualifiedClassName = this.xptEditPartFactory.getEditPartQualifiedClassName((GenCommonBase)genLabel);
            _builder.append((Object)_editPartQualifiedClassName, "\t\t");
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("((");
            CharSequence _editPartQualifiedClassName_1 = this.xptEditPartFactory.getEditPartQualifiedClassName((GenCommonBase)genLabel);
            _builder.append((Object)_editPartQualifiedClassName_1, "\t\t\t");
            _builder.append(") childEditPart).");
            CharSequence _labelSetterName = this.xptTextAware.labelSetterName((Viewmap)childViewmap);
            _builder.append((Object)_labelSetterName, "\t\t\t");
            _builder.append("(getPrimaryShape().");
            String _getterName = childViewmap.getGetterName();
            _builder.append(_getterName, "\t\t\t");
            _builder.append("());");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("return true;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        Iterable<GenCompartment> _pinnedCompartments = this._utils_qvto.getPinnedCompartments(it);
        for (GenCompartment genCompartment : _pinnedCompartments) {
            Viewmap _viewmap_1 = genCompartment.getViewmap();
            ParentAssignedViewmap childViewmap_1 = (ParentAssignedViewmap)_viewmap_1;
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("if (childEditPart instanceof ");
            String _editPartQualifiedClassName_2 = genCompartment.getEditPartQualifiedClassName();
            _builder.append(_editPartQualifiedClassName_2, "\t\t");
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("org.eclipse.draw2d.IFigure pane = getPrimaryShape().");
            String _getterName_1 = childViewmap_1.getGetterName();
            _builder.append(_getterName_1, "\t\t\t");
            _builder.append("();");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("setupContentPane(pane); // FIXME each comparment should handle his content pane in his own way");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("pane.add(((");
            String _editPartQualifiedClassName_3 = genCompartment.getEditPartQualifiedClassName();
            _builder.append(_editPartQualifiedClassName_3, "\t\t\t");
            _builder.append(") childEditPart).getFigure());");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("return true;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}\t");
            _builder.newLine();
        }
        Iterable<GenChildSideAffixedNode> _sideAffixedChildren = this._utils_qvto.getSideAffixedChildren(it);
        for (GenChildSideAffixedNode genChildSideAffixedNode : _sideAffixedChildren) {
            boolean _tripleNotEquals;
            String _locatorClassName = genChildSideAffixedNode.getLocatorClassName();
            boolean bl = _tripleNotEquals = _locatorClassName != null;
            if (_tripleNotEquals) {
                _builder.append("\t");
                CharSequence _genSpecificLocator = this.genSpecificLocator(genChildSideAffixedNode);
                _builder.append((Object)_genSpecificLocator, "\t");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append("\t");
            _builder.append("if (childEditPart instanceof ");
            String _editPartQualifiedClassName_4 = genChildSideAffixedNode.getEditPartQualifiedClassName();
            _builder.append(_editPartQualifiedClassName_4, "\t");
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemLocator locator = new org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemLocator(getMainFigure(), org.eclipse.draw2d.PositionConstants.");
            String _preferredSideName = genChildSideAffixedNode.getPreferredSideName();
            _builder.append(_preferredSideName, "\t\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("getBorderedFigure().getBorderItemContainer().add(((");
            String _editPartQualifiedClassName_5 = genChildSideAffixedNode.getEditPartQualifiedClassName();
            _builder.append(_editPartQualifiedClassName_5, "\t\t");
            _builder.append(") childEditPart).getFigure(), locator);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return true;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence removeFixedChild(GenNode it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("protected boolean removeFixedChild(org.eclipse.gef.EditPart childEditPart) {");
        _builder.newLine();
        Iterable<? extends GenLabel> _innerFixedLabels = this._utils_qvto.getInnerFixedLabels(it);
        for (GenLabel genLabel : _innerFixedLabels) {
            _builder.append("\t");
            _builder.append("if (childEditPart instanceof ");
            CharSequence _editPartQualifiedClassName = this.xptEditPartFactory.getEditPartQualifiedClassName((GenCommonBase)genLabel);
            _builder.append((Object)_editPartQualifiedClassName, "\t");
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return true;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        Iterable<GenCompartment> _pinnedCompartments = this._utils_qvto.getPinnedCompartments(it);
        for (GenCompartment genCompartment : _pinnedCompartments) {
            _builder.append("\t");
            Viewmap _viewmap = genCompartment.getViewmap();
            ParentAssignedViewmap childViewmap = (ParentAssignedViewmap)_viewmap;
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("if (childEditPart instanceof ");
            CharSequence _editPartQualifiedClassName_1 = this.xptEditPartFactory.getEditPartQualifiedClassName((GenCommonBase)genCompartment);
            _builder.append((Object)_editPartQualifiedClassName_1, "\t");
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("org.eclipse.draw2d.IFigure pane = getPrimaryShape().");
            String _getterName = childViewmap.getGetterName();
            _builder.append(_getterName, "\t\t");
            _builder.append("();");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("pane.remove(((");
            CharSequence _editPartQualifiedClassName_2 = this.xptEditPartFactory.getEditPartQualifiedClassName((GenCommonBase)genCompartment);
            _builder.append((Object)_editPartQualifiedClassName_2, "\t\t");
            _builder.append(") childEditPart).getFigure());");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return true;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}\t");
            _builder.newLine();
        }
        Iterable<GenChildSideAffixedNode> _sideAffixedChildren = this._utils_qvto.getSideAffixedChildren(it);
        for (GenChildSideAffixedNode genChildSideAffixedNode : _sideAffixedChildren) {
            _builder.append("\t");
            _builder.append("if (childEditPart instanceof ");
            CharSequence _editPartQualifiedClassName_3 = this.xptEditPartFactory.getEditPartQualifiedClassName((GenCommonBase)genChildSideAffixedNode);
            _builder.append((Object)_editPartQualifiedClassName_3, "\t");
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("getBorderedFigure().getBorderItemContainer().remove(((");
            CharSequence _editPartQualifiedClassName_4 = this.xptEditPartFactory.getEditPartQualifiedClassName((GenCommonBase)genChildSideAffixedNode);
            _builder.append((Object)_editPartQualifiedClassName_4, "\t\t");
            _builder.append(") childEditPart).getFigure());");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return true;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence addChildVisual(GenNode it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append((Object)_overrideC);
        _builder.newLineIfNotEmpty();
        _builder.append("protected void addChildVisual(org.eclipse.gef.EditPart childEditPart, int index) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (addFixedChild(childEditPart)) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("super.addChildVisual(childEditPart, -1);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence removeChildVisual(GenNode it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append((Object)_overrideC);
        _builder.newLineIfNotEmpty();
        _builder.append("protected void removeChildVisual(org.eclipse.gef.EditPart childEditPart) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (removeFixedChild(childEditPart)){");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("super.removeChildVisual(childEditPart);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getContentPaneFor(GenNode it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append((Object)_overrideC);
        _builder.newLineIfNotEmpty();
        _builder.append("protected org.eclipse.draw2d.IFigure getContentPaneFor(org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart editPart) {");
        _builder.newLine();
        Iterable<GenCompartment> _pinnedCompartments = this._utils_qvto.getPinnedCompartments(it);
        for (GenCompartment compartment : _pinnedCompartments) {
            _builder.append("\t");
            Viewmap _viewmap = compartment.getViewmap();
            ParentAssignedViewmap childViewmap = (ParentAssignedViewmap)_viewmap;
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("if (editPart instanceof ");
            CharSequence _editPartQualifiedClassName = this.xptEditPartFactory.getEditPartQualifiedClassName((GenCommonBase)compartment);
            _builder.append((Object)_editPartQualifiedClassName, "\t");
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return getPrimaryShape().");
            String _getterName = childViewmap.getGetterName();
            _builder.append(_getterName, "\t\t");
            _builder.append("();");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}\t");
            _builder.newLine();
        }
        boolean _hasBorderItems = this._utils_qvto.hasBorderItems(it);
        if (_hasBorderItems) {
            _builder.append("if (editPart instanceof org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("return getBorderedFigure().getBorderItemContainer();");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("return getContentPane();");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence addBorderItem(GenNode it) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        int _size = IterableExtensions.size(this._utils_qvto.getExternalLabels(it));
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            boolean _greaterThan_1;
            CharSequence _generatedMemberComment = this._common.generatedMemberComment();
            _builder.append((Object)_generatedMemberComment);
            _builder.newLineIfNotEmpty();
            CharSequence _overrideC = this._codeStyle.overrideC(it);
            _builder.append((Object)_overrideC);
            _builder.newLineIfNotEmpty();
            _builder.append("protected void addBorderItem(org.eclipse.draw2d.IFigure borderItemContainer, org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart borderItemEditPart) {");
            _builder.newLine();
            int _size_1 = this._editPartsUtils_qvto.getExternalLabelsWithoutSpecificLocator(it).size();
            boolean bl2 = _greaterThan_1 = _size_1 > 0;
            if (_greaterThan_1) {
                _builder.append("if (");
                List<GenExternalNodeLabel> _externalLabelsWithoutSpecificLocator = this._editPartsUtils_qvto.getExternalLabelsWithoutSpecificLocator(it);
                boolean _hasElements = false;
                for (GenExternalNodeLabel label : _externalLabelsWithoutSpecificLocator) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)" || ", "");
                    }
                    _builder.append("borderItemEditPart instanceof ");
                    String _editPartQualifiedClassName = label.getEditPartQualifiedClassName();
                    _builder.append(_editPartQualifiedClassName);
                }
                _builder.append(") {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemLocator locator = new org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemLocator(getMainFigure(), org.eclipse.draw2d.PositionConstants.SOUTH);");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("locator.setBorderItemOffset(new org.eclipse.draw2d.geometry.Dimension(-20, -20));");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("borderItemContainer.add(borderItemEditPart.getFigure(), locator);");
                _builder.newLine();
                _builder.append("} else");
                _builder.newLine();
            }
            List<GenExternalNodeLabel> _externalLabelsWithSpecificLocator = this._editPartsUtils_qvto.getExternalLabelsWithSpecificLocator(it);
            for (GenExternalNodeLabel label_1 : _externalLabelsWithSpecificLocator) {
                _builder.append("if (borderItemEditPart instanceof ");
                String _editPartQualifiedClassName_1 = label_1.getEditPartQualifiedClassName();
                _builder.append(_editPartQualifiedClassName_1);
                _builder.append(") {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator locator = new ");
                String _specificLocator = this._editPartsUtils_qvto.getSpecificLocator(label_1);
                _builder.append(_specificLocator, "\t");
                _builder.append("(getMainFigure());");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("borderItemContainer.add(borderItemEditPart.getFigure(), locator);");
                _builder.newLine();
                _builder.append("} else");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.append("{");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("super.addBorderItem(borderItemContainer, borderItemEditPart);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence createNodePlate(GenNode it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append((Object)_overrideC);
        _builder.newLineIfNotEmpty();
        _builder.append("protected org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure createNodePlate() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("org.eclipse.papyrus.infra.gmfdiag.common.figure.node.RoundedRectangleNodePlateFigure result = new org.eclipse.papyrus.infra.gmfdiag.common.figure.node.RoundedRectangleNodePlateFigure(");
        boolean _isPixelMapMode = this._utils_qvto_1.isPixelMapMode(it.getDiagram());
        if (_isPixelMapMode) {
            int _defaultSizeWidth = this._viewmapAttributesUtils_qvto.defaultSizeWidth(it.getViewmap(), 40);
            _builder.append((Object)_defaultSizeWidth, "\t");
            _builder.append(", ");
            int _defaultSizeHeight = this._viewmapAttributesUtils_qvto.defaultSizeHeight(it.getViewmap(), 40);
            _builder.append((Object)_defaultSizeHeight, "\t");
        } else {
            _builder.append("getMapMode().DPtoLP(");
            int _defaultSizeWidth_1 = this._viewmapAttributesUtils_qvto.defaultSizeWidth(it.getViewmap(), 40);
            _builder.append((Object)_defaultSizeWidth_1, "\t");
            _builder.append("), getMapMode().DPtoLP(");
            int _defaultSizeHeight_1 = this._viewmapAttributesUtils_qvto.defaultSizeHeight(it.getViewmap(), 40);
            _builder.append((Object)_defaultSizeHeight_1, "\t");
            _builder.append(")");
        }
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("return result;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getPrimaryDragEditPolicy(GenNode it) {
        StringConcatenation _builder = new StringConcatenation();
        ResizeConstraints rc = this._viewmapAttributesUtils_qvto.getResizeConstraints(it.getViewmap());
        _builder.newLineIfNotEmpty();
        if (it.getPrimaryDragEditPolicyQualifiedClassName() != null || rc != null) {
            boolean _tripleNotEquals;
            CharSequence _generatedMemberComment = this._common.generatedMemberComment();
            _builder.append((Object)_generatedMemberComment);
            _builder.newLineIfNotEmpty();
            CharSequence _overrideC = this._codeStyle.overrideC(it);
            _builder.append((Object)_overrideC);
            _builder.newLineIfNotEmpty();
            _builder.append("public org.eclipse.gef.EditPolicy getPrimaryDragEditPolicy() {");
            _builder.newLine();
            String _primaryDragEditPolicyQualifiedClassName = it.getPrimaryDragEditPolicyQualifiedClassName();
            boolean bl = _tripleNotEquals = _primaryDragEditPolicyQualifiedClassName != null;
            if (_tripleNotEquals) {
                _builder.append("\t");
                _builder.append("return new ");
                String _primaryDragEditPolicyQualifiedClassName_1 = it.getPrimaryDragEditPolicyQualifiedClassName();
                _builder.append(_primaryDragEditPolicyQualifiedClassName_1, "\t");
                _builder.append("();");
                _builder.newLineIfNotEmpty();
            } else {
                boolean _not;
                _builder.append("\t");
                _builder.append("org.eclipse.gef.EditPolicy result = super.getPrimaryDragEditPolicy();");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("if (result instanceof org.eclipse.gef.editpolicies.ResizableEditPolicy) {");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("org.eclipse.gef.editpolicies.ResizableEditPolicy ep = (org.eclipse.gef.editpolicies.ResizableEditPolicy) result;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("ep.setResizeDirections(");
                boolean _isEmpty = rc.getResizeHandleNames().isEmpty();
                boolean bl2 = _not = !_isEmpty;
                if (_not) {
                    EList _resizeHandleNames = rc.getResizeHandleNames();
                    boolean _hasElements = false;
                    for (String name : _resizeHandleNames) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder.appendImmediate((Object)" | ", "\t\t");
                        }
                        _builder.append("org.eclipse.draw2d.PositionConstants.");
                        _builder.append(name, "\t\t");
                    }
                } else {
                    _builder.append("org.eclipse.draw2d.PositionConstants.NONE");
                }
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("return result;");
                _builder.newLine();
            }
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence createFigure(GenNode it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment("Creates figure for this edit part.\n\nBody of this method does not depend on settings in generation model\nso you may safely remove <i>generated</i> tag and modify it.");
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append((Object)_overrideC);
        _builder.newLineIfNotEmpty();
        _builder.append("protected org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure create");
        boolean _hasBorderItems = this._utils_qvto.hasBorderItems(it);
        if (_hasBorderItems) {
            _builder.append("Main");
        } else {
            _builder.append("Node");
        }
        _builder.append("Figure() {");
        _builder.newLineIfNotEmpty();
        if (it instanceof GenChildSideAffixedNode) {
            _builder.append("\t");
            _builder.append("org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure figure = createNodePlate();");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("figure.setLayoutManager(new org.eclipse.draw2d.StackLayout());");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("org.eclipse.draw2d.IFigure shape = createNodeShape();");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("figure.add(shape);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("contentPane = setupContentPane(shape);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("return figure;");
            _builder.newLine();
        } else {
            _builder.append("\t");
            _builder.append("return new org.eclipse.papyrus.infra.gmfdiag.common.figure.node.SelectableBorderedNodeFigure(createMainFigureWithSVG());");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence setupContentPane(GenNode it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment("Default implementation treats passed figure as content pane.\nRespects layout one may have set for generated figure.\n\n@param nodeShape\n           instance of generated figure class");
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append((Object)_overrideC);
        _builder.newLineIfNotEmpty();
        _builder.append("protected org.eclipse.draw2d.IFigure setupContentPane(org.eclipse.draw2d.IFigure nodeShape) {");
        _builder.newLine();
        if (!it.getChildNodes().isEmpty() || !it.getCompartments().isEmpty() || IterableExtensions.exists((Iterable)it.getLabels(), l -> {
            boolean _oclIsKindOf = this._common_qvto.oclIsKindOf(l, GenExternalNodeLabel.class);
            return !_oclIsKindOf;
        })) {
            _builder.append("\t");
            _builder.append("if (nodeShape.getLayoutManager() == null) {");
            _builder.newLine();
            ViewmapLayoutType _layoutType = it.getLayoutType();
            boolean _equals = Objects.equals(_layoutType, ViewmapLayoutType.XY_LAYOUT_LITERAL);
            if (_equals) {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("nodeShape.setLayoutManager(new org.eclipse.draw2d.FreeformLayout() {");
                _builder.newLine();
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("public Object getConstraint(org.eclipse.draw2d.IFigure figure) {");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("Object result = constraints.get(figure);");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("if (result == null) {");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t\t\t");
                _builder.append("result = new org.eclipse.draw2d.geometry.Rectangle(0, 0, -1, -1);");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("return result;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("});");
                _builder.newLine();
            } else {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout layout =new org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout();");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("layout.setSpacing(");
                boolean _isPixelMapMode = this._utils_qvto_1.isPixelMapMode(it.getDiagram());
                if (_isPixelMapMode) {
                    _builder.append("5");
                } else {
                    _builder.append("getMapMode().DPtoLP(5)");
                }
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("nodeShape.setLayoutManager(layout);");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("return nodeShape; // use nodeShape itself as contentPane");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getContentPane(GenNode it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append((Object)_overrideC);
        _builder.newLineIfNotEmpty();
        _builder.append("public org.eclipse.draw2d.IFigure getContentPane() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (contentPane != null) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return contentPane;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return super.getContentPane();");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence setForegroundColor(GenNode it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append((Object)_overrideC);
        _builder.newLineIfNotEmpty();
        _builder.append("protected void setForegroundColor(org.eclipse.swt.graphics.Color color) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (primaryShape != null) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("primaryShape.setForegroundColor(color);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence setBackgroundColor(GenNode it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append((Object)_overrideC);
        _builder.newLineIfNotEmpty();
        _builder.append("protected void setBackgroundColor(org.eclipse.swt.graphics.Color color) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (primaryShape != null) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("primaryShape.setBackgroundColor(color);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence setLineWidth(GenNode it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append((Object)_overrideC);
        _builder.newLineIfNotEmpty();
        _builder.append("protected void setLineWidth(int width) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("super.setLineWidth(width);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence setLineStyle(GenNode it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append((Object)_overrideC);
        _builder.newLineIfNotEmpty();
        _builder.append("protected void setLineType(int style) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (primaryShape instanceof org.eclipse.papyrus.infra.gmfdiag.common.figure.node.IPapyrusNodeFigure) {\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("((org.eclipse.papyrus.infra.gmfdiag.common.figure.node.IPapyrusNodeFigure) primaryShape).setLineStyle(style);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence getPrimaryChildEditPart(GenNode it) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = it.getLabels().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            CharSequence _generatedMemberComment = this._common.generatedMemberComment();
            _builder.append((Object)_generatedMemberComment);
            _builder.newLineIfNotEmpty();
            CharSequence _overrideC = this._codeStyle.overrideC(it);
            _builder.append((Object)_overrideC);
            _builder.newLineIfNotEmpty();
            _builder.append("public org.eclipse.gef.EditPart getPrimaryChildEditPart() {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("return getChildBySemanticHint(");
            CharSequence _typeMethodCall = this.xptVisualIDRegistry.typeMethodCall((GenCommonBase)IterableExtensions.head((Iterable)it.getLabels()));
            _builder.append((Object)_typeMethodCall, "\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence handleNotificationEventBody(GenTopLevelNode it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("if (event.getNotifier() == getModel() && org.eclipse.emf.ecore.EcorePackage.eINSTANCE.getEModelElement_EAnnotations().equals(event.getFeature())) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("handleMajorSemanticChange();");
        _builder.newLine();
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("super.handleNotificationEvent(event);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _innerClassDeclaration(Viewmap it) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    protected CharSequence _innerClassDeclaration(InnerClassViewmap it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("\t");
        String _classBody = it.getClassBody();
        _builder.append(_classBody, "\t");
        return _builder;
    }

    public CharSequence getTargetEditPartMethod(GenNode it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        CharSequence _overrideC = this._codeStyle.overrideC(it);
        _builder.append((Object)_overrideC);
        _builder.newLineIfNotEmpty();
        _builder.append("public org.eclipse.gef.EditPart getTargetEditPart(org.eclipse.gef.Request request) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (request instanceof org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter adapter = ((org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest) request).getViewAndElementDescriptor().getCreateElementRequestAdapter();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("org.eclipse.gmf.runtime.emf.type.core.IElementType type = (org.eclipse.gmf.runtime.emf.type.core.IElementType) adapter.getAdapter(org.eclipse.gmf.runtime.emf.type.core.IElementType.class);");
        _builder.newLine();
        EList _compartments = it.getCompartments();
        for (GenCompartment compartment : _compartments) {
            boolean _listCompartmentHasChildren = this._utils_qvto.listCompartmentHasChildren(compartment);
            if (!_listCompartmentHasChildren) continue;
            EList _childNodes = compartment.getChildNodes();
            for (GenChildNode childNode : _childNodes) {
                _builder.append("if (");
                CharSequence _className = this.xptElementTypes.className(it.getDiagram());
                _builder.append((Object)_className);
                _builder.append(".isKindOf(type, ");
                CharSequence _accessElementType = this.xptElementTypes.accessElementType((GenCommonBase)childNode);
                _builder.append((Object)_accessElementType);
                _builder.append(")) {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("return getChildBySemanticHint(");
                CharSequence _typeMethodCall = this.xptVisualIDRegistry.typeMethodCall((GenCommonBase)compartment);
                _builder.append((Object)_typeMethodCall, "\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                _builder.append("}");
                _builder.newLine();
            }
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return super.getTargetEditPart(request);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence genSpecificLocator(GenChildSideAffixedNode it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("if (childEditPart instanceof ");
        String _editPartQualifiedClassName = it.getEditPartQualifiedClassName();
        _builder.append(_editPartQualifiedClassName);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator locator = new ");
        String _locatorClassName = it.getLocatorClassName();
        _builder.append(_locatorClassName, "\t");
        _builder.append("(getMainFigure(), org.eclipse.draw2d.PositionConstants.");
        String _preferredSideName = it.getPreferredSideName();
        _builder.append(_preferredSideName, "\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("getBorderedFigure().getBorderItemContainer().add(((");
        String _editPartQualifiedClassName_1 = it.getEditPartQualifiedClassName();
        _builder.append(_editPartQualifiedClassName_1, "\t");
        _builder.append(") childEditPart).getFigure(), locator);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return true;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence specificHandleNotificationEvent(GenNode it) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isSpecificNotificationEvent = it.isSpecificNotificationEvent();
        if (_isSpecificNotificationEvent) {
            boolean _tripleNotEquals;
            boolean _notEquals;
            _builder.append("/**");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* Papyrus codeGen");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("*");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* @generated");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("**/");
            _builder.newLine();
            CharSequence _overrideC = this._codeStyle.overrideC(it);
            _builder.append((Object)_overrideC);
            _builder.newLineIfNotEmpty();
            _builder.append("protected void handleNotificationEvent(org.eclipse.emf.common.notify.Notification event) {");
            _builder.newLine();
            int _size = IterableExtensions.size((Iterable)Iterables.filter((Iterable)it.getLabels(), GenExternalNodeLabel.class));
            boolean bl = _notEquals = _size != 0;
            if (_notEquals) {
                _builder.append("\t");
                _builder.append("/*");
                _builder.newLine();
                _builder.append("\t");
                _builder.append(" ");
                _builder.append("* when a node have external node labels, the methods refreshChildren() remove the EditPart corresponding to the Label from the EditPart");
                _builder.newLine();
                _builder.append("\t");
                _builder.append(" ");
                _builder.append("* Registry. After that, we can't reset the visibility to true (using the Show/Hide Label Action)!");
                _builder.newLine();
                _builder.append("\t");
                _builder.append(" ");
                _builder.append("*/");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("if(org.eclipse.gmf.runtime.notation.NotationPackage.eINSTANCE.getView_Visible().equals(event.getFeature())) {");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("Object notifier = event.getNotifier();");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("java.util.List<?> modelChildren = ((org.eclipse.gmf.runtime.notation.View)getModel()).getChildren();");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("if (false == notifier instanceof org.eclipse.gmf.runtime.notation.Edge ");
                _builder.append("&& false == notifier instanceof org.eclipse.gmf.runtime.notation.BasicCompartment) {");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("if(modelChildren.contains(event.getNotifier())) {");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t\t\t");
                _builder.append("return;");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.append("super.handleNotificationEvent(event);");
            _builder.newLine();
            RefreshHook _refreshHook = it.getRefreshHook();
            boolean bl2 = _tripleNotEquals = _refreshHook != null;
            if (_tripleNotEquals) {
                _builder.append("\t");
                CharSequence _specificHandleNotificationEventBody = this.specificHandleNotificationEventBody(it.getRefreshHook());
                _builder.append((Object)_specificHandleNotificationEventBody, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence specificHandleNotificationEventBody(RefreshHook it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("if (resolveSemanticElement() != null) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if(");
        String _refreshCondition = it.getRefreshCondition();
        _builder.append(_refreshCondition, "\t");
        _builder.append("){ ");
        CharSequence _nonNLS = this._common.nonNLS(it.getRefreshCondition());
        _builder.append((Object)_nonNLS, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        String _refreshAction = it.getRefreshAction();
        _builder.append(_refreshAction, "\t\t");
        _builder.append("; ");
        CharSequence _nonNLS_1 = this._common.nonNLS(it.getRefreshAction());
        _builder.append((Object)_nonNLS_1, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("refreshVisuals();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    @XbaseGenerated
    public CharSequence extendsListContents(GenNode it) {
        if (it instanceof GenChildSideAffixedNode) {
            return this._extendsListContents((GenChildSideAffixedNode)it);
        }
        if (it != null) {
            return this._extendsListContents(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    @XbaseGenerated
    public CharSequence installPrimaryDragEditPolicy(GenNode it) {
        if (it instanceof GenChildSideAffixedNode) {
            return this._installPrimaryDragEditPolicy((GenChildSideAffixedNode)it);
        }
        if (it != null) {
            return this._installPrimaryDragEditPolicy(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }

    @XbaseGenerated
    public CharSequence createNodeShape(Viewmap it, GenNode node) {
        if (it instanceof FigureViewmap) {
            return this._createNodeShape((FigureViewmap)it, node);
        }
        if (it instanceof InnerClassViewmap) {
            return this._createNodeShape((InnerClassViewmap)it, node);
        }
        if (it instanceof SnippetViewmap) {
            return this._createNodeShape((SnippetViewmap)it, node);
        }
        if (it != null) {
            return this._createNodeShape(it, node);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, node).toString());
    }

    @XbaseGenerated
    public CharSequence innerClassDeclaration(Viewmap it) {
        if (it instanceof InnerClassViewmap) {
            return this._innerClassDeclaration((InnerClassViewmap)it);
        }
        if (it != null) {
            return this._innerClassDeclaration(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }
}

