/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.core;

import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ErrorHandler {
    private static final boolean PRINT = true;
    private static final boolean DUMP = true;
    private static final boolean LOG = true;

    public static void reportError(String message, Throwable e) {
        if (message == null) {
            message = "No message given";
        }
        ErrorHandler.reportError(message, false, e);
    }

    public static void reportError(String message, boolean showDialog, Throwable e) {
        if (message == null) {
            message = "No message given";
        }
        System.err.println(message);
        e.printStackTrace();
        ErrorHandler.logError(message, e);
        if (showDialog) {
            MessageDialog.openError(null, (String)"IMP Error", (String)message);
        }
    }

    public static void reportError(String message) {
        if (message == null) {
            message = "No message given";
        }
        ErrorHandler.reportError(message, false);
    }

    public static void reportError(String message, boolean showDialog) {
        if (message == null) {
            message = "No message given";
        }
        ErrorHandler.reportError(message, showDialog, true);
    }

    public static void reportError(String message, boolean showDialog, boolean noDump) {
        final String checkedMessage = message != null ? message : "No message given";
        System.err.println(checkedMessage);
        if (!noDump) {
            new Error(checkedMessage).printStackTrace();
        }
        ErrorHandler.logError(checkedMessage, new Error(checkedMessage));
        if (showDialog) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"IMP Error", (String)checkedMessage);
                }
            });
        }
    }

    public static void logError(String msg, Throwable e) {
        if (msg == null) {
            msg = "No message given";
        }
        RuntimePlugin.getInstance().logException(msg, e);
    }

    public static void logMessage(String msg, Throwable e) {
        if (msg == null) {
            msg = "No message given";
        }
        RuntimePlugin.getInstance().logException(msg, e);
    }
}

