/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.debug.core;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpressionDelegate;
import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.m2m.qvt.oml.debug.core.QVTODebugCore;
import org.eclipse.m2m.qvt.oml.debug.core.QVTOStackFrame;
import org.eclipse.m2m.qvt.oml.debug.core.QVTOThread;
import org.eclipse.m2m.qvt.oml.debug.core.QVTOWatchExpressionResult;
import org.eclipse.m2m.qvt.oml.debug.core.SequentialSchedulingRule;

public class QVTOWatchExpressionDelegate
implements IWatchExpressionDelegate {
    private String myExpressionText;
    private IWatchExpressionListener myListener;

    public void evaluateExpression(String expression, IDebugElement context, IWatchExpressionListener listener) {
        this.myExpressionText = expression;
        this.myListener = listener;
        IStackFrame frame = null;
        if (context instanceof IStackFrame) {
            frame = (IStackFrame)context;
        } else if (context instanceof IThread) {
            try {
                frame = ((IThread)context).getTopStackFrame();
            }
            catch (DebugException debugException) {}
        }
        if (!(frame instanceof QVTOStackFrame)) {
            this.myListener.watchEvaluationFinished(null);
            return;
        }
        QVTOStackFrame qvtFrame = (QVTOStackFrame)frame;
        this.evaluate(qvtFrame);
    }

    protected void evaluate(final QVTOStackFrame qvtFrame) {
        QVTOThread thread = (QVTOThread)qvtFrame.getThread();
        if (!this.canEvaluate(thread)) {
            this.myListener.watchEvaluationFinished(null);
            return;
        }
        Job evalJob = new Job("Evaluating " + this.myExpressionText){

            protected IStatus run(IProgressMonitor monitor) {
                IValue value = null;
                String[] errorMessages = new String[]{};
                try {
                    value = qvtFrame.evaluate(QVTOWatchExpressionDelegate.this.myExpressionText);
                }
                catch (Exception e) {
                    errorMessages = new String[]{e.getMessage()};
                }
                QVTOWatchExpressionResult watchResult = new QVTOWatchExpressionResult(QVTOWatchExpressionDelegate.this.myExpressionText, value, errorMessages);
                QVTOWatchExpressionDelegate.this.myListener.watchEvaluationFinished((IWatchExpressionResult)watchResult);
                return QVTODebugCore.createStatus(0, "");
            }
        };
        evalJob.setRule((ISchedulingRule)new SequentialSchedulingRule());
        evalJob.schedule();
    }

    private boolean canEvaluate(QVTOThread qvtThread) {
        return qvtThread != null;
    }
}

