/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.compiler;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.LinkedList;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtend.core.richstring.AbstractRichStringPartAcceptor;
import org.eclipse.xtend.core.richstring.DefaultIndentationHandler;
import org.eclipse.xtend.core.richstring.IRichStringIndentationHandler;
import org.eclipse.xtend.core.richstring.RichStringProcessor;
import org.eclipse.xtend.core.xtend.RichString;
import org.eclipse.xtend.core.xtend.RichStringForLoop;
import org.eclipse.xtend.core.xtend.RichStringIf;
import org.eclipse.xtend.core.xtend.RichStringLiteral;
import org.eclipse.xtend.core.xtend.XtendFormalParameter;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.core.xtend.XtendVariableDeclaration;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.generator.trace.LocationData;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XCatchClause;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XForLoopExpression;
import org.eclipse.xtext.xbase.XListLiteral;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.compiler.XbaseCompiler;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.typing.ITypeProvider;

@NonNullByDefault
public class XtendCompiler
extends XbaseCompiler {
    @Inject
    private RichStringProcessor richStringProcessor;
    @Inject
    private Provider<DefaultIndentationHandler> indentationHandler;
    @Inject
    private ITypeProvider typeProvider;

    protected String getFavoriteVariableName(EObject ex) {
        if (ex instanceof RichStringForLoop) {
            return "hasAnyElements";
        }
        return super.getFavoriteVariableName(ex);
    }

    protected XExpression normalizeBlockExpression(XExpression expr) {
        if (expr instanceof RichString) {
            return expr;
        }
        return super.normalizeBlockExpression(expr);
    }

    public void doInternalToJavaStatement(XExpression obj, ITreeAppendable appendable, boolean isReferenced) {
        if (obj instanceof RichString) {
            this._toJavaStatement((RichString)obj, appendable, isReferenced);
        } else {
            super.doInternalToJavaStatement(obj, appendable, isReferenced);
        }
    }

    public void _toJavaStatement(RichString richString, ITreeAppendable b, boolean isReferenced) {
        b = b.trace((EObject)richString);
        JvmTypeReference type = this.getTypeReferences().getTypeForName(StringConcatenation.class, (Notifier)richString, new JvmTypeReference[0]);
        String variableName = b.declareSyntheticVariable((Object)richString, "_builder");
        b.newLine();
        this.serialize(type, (EObject)richString, b);
        b.append((CharSequence)" ");
        b.append((CharSequence)variableName);
        b.append((CharSequence)" = new ");
        this.serialize(type, (EObject)richString, b);
        b.append((CharSequence)"();");
        RichStringPrepareCompiler compiler = new RichStringPrepareCompiler(b, variableName, richString);
        this.richStringProcessor.process(richString, compiler, (IRichStringIndentationHandler)this.indentationHandler.get());
    }

    public void internalToConvertedExpression(XExpression obj, ITreeAppendable appendable) {
        if (obj instanceof RichString) {
            this._toJavaExpression((RichString)obj, appendable);
        } else {
            super.internalToConvertedExpression(obj, appendable);
        }
    }

    public void _toJavaExpression(RichString richString, ITreeAppendable b) {
        b.append((CharSequence)this.getVarName(richString, b));
        if (this.getTypeReferences().is(this.typeProvider.getType((XExpression)richString), String.class)) {
            b.append((CharSequence)".toString()");
        }
    }

    protected void appendCatchClauseParameter(XCatchClause catchClause, JvmTypeReference parameterType, String parameterName, ITreeAppendable appendable) {
        this.appendExtensionAnnotation(catchClause.getDeclaredParam(), (EObject)catchClause, appendable, false);
        super.appendCatchClauseParameter(catchClause, parameterType, parameterName, appendable);
    }

    protected void appendExtensionAnnotation(JvmFormalParameter parameter, EObject context, ITreeAppendable appendable, boolean newLine) {
        XtendFormalParameter castedParameter;
        if (parameter instanceof XtendFormalParameter && (castedParameter = (XtendFormalParameter)parameter).isExtension()) {
            this.appendExtensionAnnotation(context, appendable, newLine);
        }
    }

    protected void appendExtensionAnnotation(EObject context, ITreeAppendable appendable, boolean newLine) {
        JvmType extension = this.getTypeReferences().findDeclaredType(Extension.class, (Notifier)context);
        if (extension != null) {
            appendable.append((CharSequence)"@");
            appendable.append(extension);
            if (!newLine) {
                appendable.append((CharSequence)" ");
            } else {
                appendable.newLine();
            }
        }
    }

    protected JvmTypeReference appendVariableTypeAndName(XVariableDeclaration varDeclaration, ITreeAppendable appendable) {
        if (varDeclaration instanceof XtendVariableDeclaration && ((XtendVariableDeclaration)varDeclaration).isExtension()) {
            this.appendExtensionAnnotation((EObject)varDeclaration, appendable, true);
        }
        return super.appendVariableTypeAndName(varDeclaration, appendable);
    }

    protected void appendForLoopParameter(XForLoopExpression expr, ITreeAppendable appendable) {
        this.appendExtensionAnnotation(expr.getDeclaredParam(), (EObject)expr, appendable, false);
        super.appendForLoopParameter(expr, appendable);
    }

    protected void appendClosureParameter(JvmFormalParameter closureParam, JvmTypeReference parameterType, XClosure closure, ITreeAppendable appendable) {
        this.appendExtensionAnnotation(closureParam, (EObject)closure, appendable, false);
        super.appendClosureParameter(closureParam, parameterType, closure, appendable);
    }

    protected boolean canUseArrayInitializer(XListLiteral literal, ITreeAppendable appendable) {
        EStructuralFeature feature = literal.eContainingFeature();
        if (feature == XtendPackage.Literals.XTEND_FIELD__INITIAL_VALUE) {
            return this.canUseArrayInitializerImpl(literal, appendable);
        }
        return super.canUseArrayInitializer(literal, appendable);
    }

    public class RichStringPrepareCompiler
    extends AbstractRichStringPartAcceptor.ForLoopOnce {
        private final LinkedList<ITreeAppendable> appendableStack;
        private final LinkedList<RichStringIf> ifStack = Lists.newLinkedList();
        private final LinkedList<RichStringForLoop> forStack = Lists.newLinkedList();
        private final String variableName;
        private ITreeAppendable appendable;
        private ITreeAppendable currentAppendable;

        public RichStringPrepareCompiler(ITreeAppendable appendable, String variableName, RichString richString) {
            this.appendableStack = Lists.newLinkedList();
            this.appendable = appendable;
            this.variableName = variableName;
            EList expressions = richString.getExpressions();
            if (!expressions.isEmpty() && expressions.get(0) instanceof RichStringLiteral) {
                this.setCurrentAppendable((RichStringLiteral)expressions.get(0));
            }
        }

        public void acceptSemanticLineBreak(int charCount, RichStringLiteral origin, boolean controlStructureSeen) {
            this.setCurrentAppendable(origin);
            this.currentAppendable.newLine();
            this.currentAppendable.append((CharSequence)this.variableName);
            if (!controlStructureSeen) {
                this.currentAppendable.append((CharSequence)".newLine();");
            } else {
                this.currentAppendable.append((CharSequence)".newLineIfNotEmpty();");
            }
        }

        protected void setCurrentAppendable(@Nullable RichStringLiteral origin) {
            if (this.currentAppendable == null && origin != null) {
                ITextRegionWithLineInformation region = (ITextRegionWithLineInformation)XtendCompiler.this.getLocationInFileProvider().getSignificantTextRegion((EObject)origin, (EStructuralFeature)XbasePackage.Literals.XSTRING_LITERAL__VALUE, 0);
                this.currentAppendable = this.appendable.trace((ILocationData)new LocationData(region, null), true);
            }
        }

        public void acceptTemplateLineBreak(int charCount, RichStringLiteral origin) {
            this.setCurrentAppendable(origin);
        }

        public void acceptSemanticText(CharSequence text, @Nullable RichStringLiteral origin) {
            this.setCurrentAppendable(origin);
            if (text.length() == 0) {
                return;
            }
            this.currentAppendable.newLine();
            this.currentAppendable.append((CharSequence)this.variableName);
            this.currentAppendable.append((CharSequence)".append(\"");
            this.currentAppendable.append((CharSequence)Strings.convertToJavaString((String)text.toString()));
            this.currentAppendable.append((CharSequence)"\");");
        }

        public void acceptIfCondition(XExpression condition) {
            this.currentAppendable = null;
            this.ifStack.add((RichStringIf)condition.eContainer());
            this.appendable.newLine();
            this.pushAppendable(condition.eContainer());
            this.appendable.append((CharSequence)"{").increaseIndentation();
            this.writeIf(condition);
        }

        protected void pushAppendable(EObject traceInfo) {
            this.appendableStack.add(this.appendable);
            this.appendable = this.appendable.trace(traceInfo);
        }

        protected void popAppendable() {
            this.appendable = this.appendableStack.removeLast();
        }

        public void acceptElseIfCondition(XExpression condition) {
            this.currentAppendable = null;
            this.writeElse();
            this.writeIf(condition);
        }

        protected void writeIf(XExpression condition) {
            ITreeAppendable debugAppendable = this.appendable.trace(condition.eContainer(), true);
            XtendCompiler.this.internalToJavaStatement(condition, debugAppendable, true);
            debugAppendable.newLine();
            debugAppendable.append((CharSequence)"if (");
            XtendCompiler.this.internalToJavaExpression(condition, debugAppendable);
            debugAppendable.append((CharSequence)") {").increaseIndentation();
        }

        protected void writeElse() {
            this.currentAppendable = null;
            this.appendable.decreaseIndentation();
            this.appendable.newLine();
            this.appendable.append((CharSequence)"} else {");
            this.appendable.increaseIndentation();
        }

        public void acceptElse() {
            this.currentAppendable = null;
            this.writeElse();
        }

        public void acceptEndIf() {
            this.currentAppendable = null;
            RichStringIf richStringIf = this.ifStack.removeLast();
            int i = 0;
            while (i < richStringIf.getElseIfs().size() + 2) {
                this.appendable.decreaseIndentation();
                this.appendable.newLine();
                this.appendable.append((CharSequence)"}");
                ++i;
            }
            this.popAppendable();
        }

        public void acceptForLoop(JvmFormalParameter parameter, @Nullable XExpression expression) {
            this.currentAppendable = null;
            super.acceptForLoop(parameter, expression);
            if (expression == null) {
                throw new IllegalArgumentException("expression may not be null");
            }
            RichStringForLoop forLoop = (RichStringForLoop)expression.eContainer();
            this.forStack.add(forLoop);
            this.appendable.newLine();
            this.pushAppendable((EObject)forLoop);
            this.appendable.append((CharSequence)"{").increaseIndentation();
            ITreeAppendable debugAppendable = this.appendable.trace((EObject)forLoop, true);
            XtendCompiler.this.internalToJavaStatement(expression, debugAppendable, true);
            String variableName = null;
            if (forLoop.getBefore() != null || forLoop.getSeparator() != null || forLoop.getAfter() != null) {
                variableName = debugAppendable.declareSyntheticVariable((Object)forLoop, "_hasElements");
                debugAppendable.newLine();
                debugAppendable.append((CharSequence)"boolean ");
                debugAppendable.append((CharSequence)variableName);
                debugAppendable.append((CharSequence)" = false;");
            }
            debugAppendable.newLine();
            debugAppendable.append((CharSequence)"for(final ");
            JvmTypeReference paramType = XtendCompiler.this.getTypeProvider().getTypeForIdentifiable((JvmIdentifiableElement)parameter);
            XtendCompiler.this.serialize(paramType, (EObject)parameter, debugAppendable);
            debugAppendable.append((CharSequence)" ");
            String loopParam = debugAppendable.declareVariable((Object)parameter, parameter.getName());
            debugAppendable.append((CharSequence)loopParam);
            debugAppendable.append((CharSequence)" : ");
            XtendCompiler.this.internalToJavaExpression(expression, debugAppendable);
            debugAppendable.append((CharSequence)") {").increaseIndentation();
        }

        public boolean forLoopHasNext(@Nullable XExpression before, @Nullable XExpression separator, CharSequence indentation) {
            this.currentAppendable = null;
            if (!super.forLoopHasNext(before, separator, indentation)) {
                return false;
            }
            RichStringForLoop forLoop = this.forStack.getLast();
            if (this.appendable.hasName((Object)forLoop)) {
                String varName = XtendCompiler.this.getVarName(forLoop, this.appendable);
                this.appendable.newLine();
                this.appendable.append((CharSequence)"if (!");
                this.appendable.append((CharSequence)varName);
                this.appendable.append((CharSequence)") {");
                this.appendable.increaseIndentation();
                this.appendable.newLine();
                this.appendable.append((CharSequence)varName);
                this.appendable.append((CharSequence)" = true;");
                if (before != null) {
                    this.writeExpression(before, indentation, false);
                }
                this.appendable.decreaseIndentation();
                this.appendable.newLine();
                this.appendable.append((CharSequence)"}");
                if (separator != null) {
                    this.appendable.append((CharSequence)" else {");
                    this.appendable.increaseIndentation();
                    this.writeExpression(separator, indentation, true);
                    this.appendable.decreaseIndentation();
                    this.appendable.newLine();
                    this.appendable.append((CharSequence)"}");
                }
            }
            return true;
        }

        public void acceptEndFor(@Nullable XExpression after, CharSequence indentation) {
            this.currentAppendable = null;
            super.acceptEndFor(after, indentation);
            this.appendable.decreaseIndentation();
            this.appendable.newLine();
            this.appendable.append((CharSequence)"}");
            RichStringForLoop forLoop = this.forStack.removeLast();
            if (after != null) {
                String varName = XtendCompiler.this.getVarName(forLoop, this.appendable);
                this.appendable.newLine();
                this.appendable.append((CharSequence)"if (");
                this.appendable.append((CharSequence)varName);
                this.appendable.append((CharSequence)") {");
                this.appendable.increaseIndentation();
                this.writeExpression(after, indentation, false);
                this.appendable.decreaseIndentation();
                this.appendable.newLine();
                this.appendable.append((CharSequence)"}");
            }
            this.appendable.decreaseIndentation();
            this.appendable.newLine();
            this.appendable.append((CharSequence)"}");
            this.popAppendable();
        }

        public void acceptExpression(XExpression expression, CharSequence indentation) {
            this.currentAppendable = null;
            this.writeExpression(expression, indentation, false);
        }

        protected void writeExpression(XExpression expression, CharSequence indentation, boolean immediate) {
            boolean referenced = !XtendCompiler.this.isPrimitiveVoid(expression);
            XtendCompiler.this.internalToJavaStatement(expression, this.appendable, referenced);
            if (referenced) {
                ITreeAppendable tracingAppendable = this.appendable.trace((EObject)expression, true);
                tracingAppendable.newLine();
                tracingAppendable.append((CharSequence)this.variableName);
                if (immediate) {
                    tracingAppendable.append((CharSequence)".appendImmediate(");
                } else {
                    tracingAppendable.append((CharSequence)".append(");
                }
                XtendCompiler.this.internalToJavaExpression(expression, tracingAppendable);
                tracingAppendable.append((CharSequence)", \"");
                tracingAppendable.append((CharSequence)indentation.toString());
                tracingAppendable.append((CharSequence)"\");");
            }
        }
    }
}

