/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.linking;

import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xtend.core.linking.LinkingProxyAwareResource;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.diagnostics.IDiagnosticConsumer;
import org.eclipse.xtext.diagnostics.IDiagnosticProducer;
import org.eclipse.xtext.linking.impl.ImportedNamesAdapter;
import org.eclipse.xtext.linking.impl.LinkingDiagnosticProducer;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.linking.XbaseLazyLinker;

public class Linker
extends XbaseLazyLinker {
    protected boolean shouldCheckParentNode(INode node) {
        return false;
    }

    protected void doLinkModel(final EObject model, IDiagnosticConsumer consumer) {
        final LinkingDiagnosticProducer producer = new LinkingDiagnosticProducer(consumer);
        this.getCache().execWithoutCacheClear((Resource)((LinkingProxyAwareResource)model.eResource()), (IUnitOfWork)new IUnitOfWork.Void<LinkingProxyAwareResource>(){

            public void process(LinkingProxyAwareResource state) throws Exception {
                state.clearEncodeURIs();
                Linker.this.clearReferences(model);
                Linker.this.installProxies(state, model, (IDiagnosticProducer)producer);
                TreeIterator iterator = model.eAllContents();
                while (iterator.hasNext()) {
                    EObject eObject = (EObject)iterator.next();
                    Linker.this.clearReferences(eObject);
                    Linker.this.installProxies(state, eObject, (IDiagnosticProducer)producer);
                }
            }
        });
    }

    protected void beforeModelLinked(EObject model, IDiagnosticConsumer diagnosticsConsumer) {
        ImportedNamesAdapter adapter = ImportedNamesAdapter.find((Resource)model.eResource());
        if (adapter != null) {
            adapter.clear();
        }
    }

    protected void installProxies(LinkingProxyAwareResource state, EObject obj, IDiagnosticProducer producer) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)obj);
        if (node == null) {
            return;
        }
        this.installProxies(state, obj, producer, node);
    }

    private void installProxies(LinkingProxyAwareResource state, EObject obj, IDiagnosticProducer producer, ICompositeNode parentNode) {
        EClass eClass = obj.eClass();
        if (eClass.getEAllReferences().size() - eClass.getEAllContainments().size() == 0) {
            return;
        }
        INode node = parentNode.getFirstChild();
        while (node != null) {
            EObject grammarElement = node.getGrammarElement();
            if (grammarElement instanceof CrossReference && this.hasLeafNodes(node)) {
                producer.setNode(node);
                EReference eRef = GrammarUtil.getReference((CrossReference)((CrossReference)grammarElement), (EClass)eClass);
                if (eRef == null) {
                    throw new IllegalStateException("Couldn't find EReference for crossreference " + grammarElement);
                }
                this.createAndSetProxy(state, obj, node, eRef);
            }
            node = node.getNextSibling();
        }
    }

    protected boolean hasLeafNodes(INode node) {
        if (node.getTotalLength() > 0) {
            return true;
        }
        if (node instanceof ICompositeNode) {
            return ((ICompositeNode)node).getLastChild() instanceof ILeafNode;
        }
        return false;
    }

    protected void createAndSetProxy(LinkingProxyAwareResource state, EObject obj, INode node, EReference eRef) {
        EObject proxy = this.createProxy(state, obj, node, eRef);
        if (eRef.isMany()) {
            ((InternalEList)obj.eGet((EStructuralFeature)eRef, false)).addUnique((Object)proxy);
        } else {
            obj.eSet((EStructuralFeature)eRef, (Object)proxy);
        }
    }

    protected EObject createProxy(LinkingProxyAwareResource resource, EObject obj, INode node, EReference eRef) {
        URI uri = resource.getURI();
        URI encodedLink = uri.appendFragment("|" + resource.registerEncodedURI(obj, eRef, node));
        EClass referenceType = this.getProxyType(eRef.getEReferenceType());
        EObject proxy = EcoreUtil.create((EClass)referenceType);
        ((InternalEObject)proxy).eSetProxyURI(encodedLink);
        return proxy;
    }

    private EClass getProxyType(EClass referenceType) {
        if (referenceType == TypesPackage.Literals.JVM_TYPE || referenceType == TypesPackage.Literals.JVM_IDENTIFIABLE_ELEMENT) {
            return TypesPackage.Literals.JVM_VOID;
        }
        if (referenceType == TypesPackage.Literals.JVM_DECLARED_TYPE) {
            return TypesPackage.Literals.JVM_GENERIC_TYPE;
        }
        return referenceType;
    }
}

