/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.core.macro.ActiveAnnotationContext;
import org.eclipse.xtend.core.macro.ProcessorInstanceForJvmTypeProvider;
import org.eclipse.xtend.core.macro.XAnnotationExtensions;
import org.eclipse.xtend.core.macro.declaration.CompilationUnitImpl;
import org.eclipse.xtend.core.xtend.XtendAnnotationTarget;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendConstructor;
import org.eclipse.xtend.core.xtend.XtendEnum;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendInterface;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendParameter;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.OnChangeEvictingCache;
import org.eclipse.xtext.util.internal.Stopwatches;
import org.eclipse.xtext.validation.EObjectDiagnosticImpl;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveAnnotationContextProvider {
    @Inject
    private OnChangeEvictingCache cache;
    @Inject
    @Extension
    private XAnnotationExtensions _xAnnotationExtensions;
    @Inject
    @Extension
    private ProcessorInstanceForJvmTypeProvider _processorInstanceForJvmTypeProvider;
    @Inject
    private Provider<CompilationUnitImpl> compilationUnitProvider;

    /*
     * Enabled aggressive exception aggregation
     */
    public List<? extends ActiveAnnotationContext> computeContext(final XtendFile file) {
        try {
            List _xblockexpression = null;
            Stopwatches.StoppedTask task = Stopwatches.forTask((String)"[macros] findActiveAnnotations (ActiveAnnotationContextProvider.computeContext)");
            task.start();
            List _xtrycatchfinallyexpression = null;
            try {
                try {
                    List _get;
                    Resource _eResource = file.eResource();
                    Provider<List<ActiveAnnotationContext>> _function = new Provider<List<ActiveAnnotationContext>>(){

                        public List<ActiveAnnotationContext> get() {
                            final LinkedHashMap annotatedElements = CollectionLiterals.newLinkedHashMap((Pair[])new Pair[0]);
                            final CompilationUnitImpl compilationUnit = (CompilationUnitImpl)ActiveAnnotationContextProvider.this.compilationUnitProvider.get();
                            compilationUnit.setXtendFile(file);
                            IAcceptor<Pair<JvmAnnotationType, XAnnotation>> _function = new IAcceptor<Pair<JvmAnnotationType, XAnnotation>>(){

                                public void accept(Pair<JvmAnnotationType, XAnnotation> it) {
                                    boolean _not;
                                    JvmAnnotationType _key = (JvmAnnotationType)it.getKey();
                                    boolean _containsKey = annotatedElements.containsKey(_key);
                                    boolean bl = _not = !_containsKey;
                                    if (_not) {
                                        boolean _notEquals;
                                        ActiveAnnotationContext _activeAnnotationContext;
                                        ActiveAnnotationContext fa = _activeAnnotationContext = new ActiveAnnotationContext();
                                        fa.setCompilationUnit(compilationUnit);
                                        JvmAnnotationType _key_1 = (JvmAnnotationType)it.getKey();
                                        JvmType processorType = ActiveAnnotationContextProvider.this._xAnnotationExtensions.getProcessorType(_key_1);
                                        Object processorInstance = ActiveAnnotationContextProvider.this._processorInstanceForJvmTypeProvider.getProcessorInstance(processorType);
                                        boolean bl2 = _notEquals = !Objects.equal((Object)processorInstance, null);
                                        if (_notEquals) {
                                            fa.setProcessorInstance(processorInstance);
                                        } else {
                                            Resource _eResource = file.eResource();
                                            EList _errors = _eResource.getErrors();
                                            String _identifier = processorType.getIdentifier();
                                            String _plus = "Couldn't instantiate the referenced annotation processor of type '" + _identifier;
                                            String _plus_1 = String.valueOf(_plus) + "'. This is usually the case when the processor resides in the same project as the annotated element.";
                                            int _minus = -1;
                                            EObjectDiagnosticImpl _eObjectDiagnosticImpl = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtend.core.validation.IssueCodes.processing_error", _plus_1, (EObject)file, null, _minus, null);
                                            _errors.add((Object)_eObjectDiagnosticImpl);
                                        }
                                        JvmAnnotationType _key_2 = (JvmAnnotationType)it.getKey();
                                        annotatedElements.put(_key_2, fa);
                                    }
                                    JvmAnnotationType _key_3 = (JvmAnnotationType)it.getKey();
                                    ActiveAnnotationContext _get = (ActiveAnnotationContext)annotatedElements.get(_key_3);
                                    List<XtendAnnotationTarget> _annotatedSourceElements = _get.getAnnotatedSourceElements();
                                    XAnnotation _value = (XAnnotation)it.getValue();
                                    XtendAnnotationTarget _annotatedTarget = ActiveAnnotationContextProvider.this._xAnnotationExtensions.getAnnotatedTarget(_value);
                                    _annotatedSourceElements.add(_annotatedTarget);
                                }
                            };
                            ActiveAnnotationContextProvider.this.searchAnnotatedElements(file, (IAcceptor<Pair<JvmAnnotationType, XAnnotation>>)((IAcceptor)_function));
                            Collection _values = annotatedElements.values();
                            return IterableExtensions.toList(_values);
                        }
                    };
                    _xtrycatchfinallyexpression = _get = (List)this.cache.get((Object)"annotation context", _eResource, (Provider)_function);
                }
                catch (Throwable _t) {
                    if (_t instanceof Throwable) {
                        Throwable e = _t;
                        boolean _matched = false;
                        if (!_matched && e instanceof VirtualMachineError) {
                            VirtualMachineError _virtualMachineError = (VirtualMachineError)e;
                            _matched = true;
                            throw _virtualMachineError;
                        }
                        if (!_matched && e instanceof LinkageError) {
                            LinkageError _linkageError = (LinkageError)e;
                            _matched = true;
                            throw _linkageError;
                        }
                        ArrayList arrayList = CollectionLiterals.newArrayList((Object[])new ActiveAnnotationContext[0]);
                        task.stop();
                        return arrayList;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
            finally {
                task.stop();
            }
            _xblockexpression = _xtrycatchfinallyexpression;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void searchAnnotatedElements(EObject element, final IAcceptor<Pair<JvmAnnotationType, XAnnotation>> acceptor) {
        EList<XtendParameter> _parameters;
        EList<XtendMember> _members;
        Object _function;
        boolean _matched = false;
        if (!_matched && element instanceof XtendFile) {
            XtendFile _xtendFile = (XtendFile)element;
            _matched = true;
            EList<XtendTypeDeclaration> _xtendTypes = _xtendFile.getXtendTypes();
            _function = new Procedures.Procedure1<XtendTypeDeclaration>(){

                public void apply(XtendTypeDeclaration it) {
                    ActiveAnnotationContextProvider.this.searchAnnotatedElements(it, (IAcceptor<Pair<JvmAnnotationType, XAnnotation>>)acceptor);
                }
            };
            IterableExtensions.forEach(_xtendTypes, (Procedures.Procedure1)_function);
        }
        if (!_matched && element instanceof XtendClass) {
            XtendClass _xtendClass = (XtendClass)element;
            _matched = true;
            this.registerMacroAnnotations(_xtendClass, acceptor);
            _members = _xtendClass.getMembers();
            _function = new Procedures.Procedure1<XtendMember>(){

                public void apply(XtendMember it) {
                    ActiveAnnotationContextProvider.this.searchAnnotatedElements(it, (IAcceptor<Pair<JvmAnnotationType, XAnnotation>>)acceptor);
                }
            };
            IterableExtensions.forEach(_members, (Procedures.Procedure1)_function);
        }
        if (!_matched && element instanceof XtendInterface) {
            XtendInterface _xtendInterface = (XtendInterface)element;
            _matched = true;
            this.registerMacroAnnotations(_xtendInterface, acceptor);
            _members = _xtendInterface.getMembers();
            _function = new Procedures.Procedure1<XtendMember>(){

                public void apply(XtendMember it) {
                    ActiveAnnotationContextProvider.this.searchAnnotatedElements(it, (IAcceptor<Pair<JvmAnnotationType, XAnnotation>>)acceptor);
                }
            };
            IterableExtensions.forEach(_members, (Procedures.Procedure1)_function);
        }
        if (!_matched && element instanceof XtendEnum) {
            XtendEnum _xtendEnum = (XtendEnum)element;
            _matched = true;
            this.registerMacroAnnotations(_xtendEnum, acceptor);
            _members = _xtendEnum.getMembers();
            _function = new Procedures.Procedure1<XtendMember>(){

                public void apply(XtendMember it) {
                    ActiveAnnotationContextProvider.this.searchAnnotatedElements(it, (IAcceptor<Pair<JvmAnnotationType, XAnnotation>>)acceptor);
                }
            };
            IterableExtensions.forEach(_members, (Procedures.Procedure1)_function);
        }
        if (!_matched && element instanceof XtendFunction) {
            XtendFunction _xtendFunction = (XtendFunction)element;
            _matched = true;
            this.registerMacroAnnotations(_xtendFunction, acceptor);
            _parameters = _xtendFunction.getParameters();
            _function = new Procedures.Procedure1<XtendParameter>(){

                public void apply(XtendParameter it) {
                    ActiveAnnotationContextProvider.this.searchAnnotatedElements(it, (IAcceptor<Pair<JvmAnnotationType, XAnnotation>>)acceptor);
                }
            };
            IterableExtensions.forEach(_parameters, (Procedures.Procedure1)_function);
        }
        if (!_matched && element instanceof XtendConstructor) {
            XtendConstructor _xtendConstructor = (XtendConstructor)element;
            _matched = true;
            this.registerMacroAnnotations(_xtendConstructor, acceptor);
            _parameters = _xtendConstructor.getParameters();
            _function = new Procedures.Procedure1<XtendParameter>(){

                public void apply(XtendParameter it) {
                    ActiveAnnotationContextProvider.this.searchAnnotatedElements(it, (IAcceptor<Pair<JvmAnnotationType, XAnnotation>>)acceptor);
                }
            };
            IterableExtensions.forEach(_parameters, (Procedures.Procedure1)_function);
        }
        if (!_matched && element instanceof XtendAnnotationTarget) {
            XtendAnnotationTarget _xtendAnnotationTarget = (XtendAnnotationTarget)element;
            _matched = true;
            this.registerMacroAnnotations(_xtendAnnotationTarget, acceptor);
        }
    }

    private void registerMacroAnnotations(XtendAnnotationTarget candidate, IAcceptor<Pair<JvmAnnotationType, XAnnotation>> acceptor) {
        EList<XAnnotation> _annotations = candidate.getAnnotations();
        Functions.Function1<XAnnotation, Boolean> _function = new Functions.Function1<XAnnotation, Boolean>(){

            public Boolean apply(XAnnotation it) {
                boolean _isProcessed = ActiveAnnotationContextProvider.this._xAnnotationExtensions.isProcessed(it);
                return _isProcessed;
            }
        };
        Iterable _filter = IterableExtensions.filter(_annotations, (Functions.Function1)_function);
        for (XAnnotation annotation : _filter) {
            boolean _isValid;
            boolean _notEquals;
            JvmAnnotationType activeAnnotationDeclaration = this._xAnnotationExtensions.tryFindAnnotationType(annotation);
            boolean bl = _notEquals = !Objects.equal((Object)activeAnnotationDeclaration, null);
            if (!_notEquals || !(_isValid = this.isValid(annotation, activeAnnotationDeclaration))) continue;
            Pair _mappedTo = Pair.of((Object)activeAnnotationDeclaration, (Object)annotation);
            acceptor.accept((Object)_mappedTo);
        }
    }

    private boolean isValid(XAnnotation annotation, JvmAnnotationType activeAnnotationDeclaration) {
        return !Objects.equal((Object)annotation, null);
    }
}

