/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.core.macro.declaration.CompilationUnitImpl;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.lib.macro.RegisterGlobalsContext;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.documentation.IFileHeaderProvider;
import org.eclipse.xtext.xbase.jvmmodel.IJvmDeclaredTypeAcceptor;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypesBuilder;
import org.eclipse.xtext.xbase.lib.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegisterGlobalsContextImpl
implements RegisterGlobalsContext {
    private IJvmDeclaredTypeAcceptor _acceptor;
    private CompilationUnitImpl _compilationUnit;

    public IJvmDeclaredTypeAcceptor getAcceptor() {
        return this._acceptor;
    }

    public void setAcceptor(IJvmDeclaredTypeAcceptor acceptor) {
        this._acceptor = acceptor;
    }

    public CompilationUnitImpl getCompilationUnit() {
        return this._compilationUnit;
    }

    public void setCompilationUnit(CompilationUnitImpl compilationUnit) {
        this._compilationUnit = compilationUnit;
    }

    public void registerAnnotationType(String qualifiedName) throws IllegalArgumentException {
        JvmAnnotationType newType = TypesFactory.eINSTANCE.createJvmAnnotationType();
        newType.setVisibility(JvmVisibility.PUBLIC);
        this.setNameAndAccept((JvmDeclaredType)newType, qualifiedName);
    }

    public void registerClass(String qualifiedName) throws IllegalArgumentException {
        JvmGenericType newType = TypesFactory.eINSTANCE.createJvmGenericType();
        newType.setVisibility(JvmVisibility.PUBLIC);
        EList _superTypes = newType.getSuperTypes();
        CompilationUnitImpl _compilationUnit = this.getCompilationUnit();
        TypeReferences _typeReferences = _compilationUnit.getTypeReferences();
        CompilationUnitImpl _compilationUnit_1 = this.getCompilationUnit();
        XtendFile _xtendFile = _compilationUnit_1.getXtendFile();
        JvmTypeReference _typeForName = _typeReferences.getTypeForName(Object.class, (Notifier)_xtendFile, new JvmTypeReference[0]);
        _superTypes.add((Object)_typeForName);
        this.setNameAndAccept((JvmDeclaredType)newType, qualifiedName);
    }

    public void registerEnumerationType(String qualifiedName) throws IllegalArgumentException {
        JvmEnumerationType newType = TypesFactory.eINSTANCE.createJvmEnumerationType();
        newType.setVisibility(JvmVisibility.PUBLIC);
        this.setNameAndAccept((JvmDeclaredType)newType, qualifiedName);
    }

    public void registerInterface(String qualifiedName) throws IllegalArgumentException {
        JvmGenericType newType = TypesFactory.eINSTANCE.createJvmGenericType();
        newType.setVisibility(JvmVisibility.PUBLIC);
        newType.setInterface(true);
        this.setNameAndAccept((JvmDeclaredType)newType, qualifiedName);
    }

    private void setNameAndAccept(JvmDeclaredType newType, String qualifiedName) {
        boolean _notEquals;
        CompilationUnitImpl _compilationUnit = this.getCompilationUnit();
        _compilationUnit.checkCanceled();
        Pair<String, String> namespaceAndName = this.getNameParts(qualifiedName);
        CompilationUnitImpl _compilationUnit_1 = this.getCompilationUnit();
        IFileHeaderProvider _fileHeaderProvider = _compilationUnit_1.getFileHeaderProvider();
        CompilationUnitImpl _compilationUnit_2 = this.getCompilationUnit();
        XtendFile _xtendFile = _compilationUnit_2.getXtendFile();
        Resource _eResource = _xtendFile.eResource();
        String headerText = _fileHeaderProvider.getFileHeader(_eResource);
        CompilationUnitImpl _compilationUnit_3 = this.getCompilationUnit();
        JvmTypesBuilder _jvmTypesBuilder = _compilationUnit_3.getJvmTypesBuilder();
        _jvmTypesBuilder.setFileHeader(newType, headerText);
        String _key = (String)namespaceAndName.getKey();
        boolean bl = _notEquals = !Objects.equal((Object)_key, null);
        if (_notEquals) {
            boolean _notEquals_1;
            String _key_1 = (String)namespaceAndName.getKey();
            JvmDeclaredType parentType = this.findType(_key_1);
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)parentType, null);
            if (_notEquals_1) {
                EList _members = parentType.getMembers();
                _members.add((Object)newType);
                newType.setStatic(true);
            } else {
                String _key_2 = (String)namespaceAndName.getKey();
                newType.setPackageName(_key_2);
                IJvmDeclaredTypeAcceptor _acceptor = this.getAcceptor();
                _acceptor.accept(newType);
            }
        } else {
            IJvmDeclaredTypeAcceptor _acceptor_1 = this.getAcceptor();
            _acceptor_1.accept(newType);
        }
        String _value = (String)namespaceAndName.getValue();
        newType.setSimpleName(_value);
    }

    private JvmDeclaredType findType(String string) {
        CompilationUnitImpl _compilationUnit = this.getCompilationUnit();
        XtendFile _xtendFile = _compilationUnit.getXtendFile();
        Resource _eResource = _xtendFile.eResource();
        EList _contents = _eResource.getContents();
        Iterable _filter = Iterables.filter((Iterable)_contents, JvmDeclaredType.class);
        return this.findRecursively(string, _filter);
    }

    private JvmDeclaredType findRecursively(String string, Iterable<? extends JvmDeclaredType> types) {
        for (JvmDeclaredType jvmDeclaredType : types) {
            boolean _notEquals;
            String _identifier = jvmDeclaredType.getIdentifier();
            boolean _startsWith = string.startsWith(_identifier);
            if (!_startsWith) continue;
            String _identifier_1 = jvmDeclaredType.getIdentifier();
            boolean _equals = Objects.equal((Object)string, (Object)_identifier_1);
            if (_equals) {
                return jvmDeclaredType;
            }
            EList _members = jvmDeclaredType.getMembers();
            Iterable _filter = Iterables.filter((Iterable)_members, JvmDeclaredType.class);
            JvmDeclaredType result = this.findRecursively(string, _filter);
            boolean bl = _notEquals = !Objects.equal((Object)result, null);
            if (!_notEquals) continue;
            return result;
        }
        return null;
    }

    private Pair<String, String> getNameParts(String string) {
        int _minus;
        boolean _notEquals;
        int dot = 46;
        int index = string.lastIndexOf(46);
        boolean bl = _notEquals = index != (_minus = -1);
        if (_notEquals) {
            String _substring = string.substring(0, index);
            int _plus = index + 1;
            String _substring_1 = string.substring(_plus);
            return Pair.of((Object)_substring, (Object)_substring_1);
        }
        return Pair.of(null, (Object)string);
    }
}

