/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typing;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.JvmAnyTypeReference;
import org.eclipse.xtext.common.types.JvmCompoundTypeReference;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDelegateTypeReference;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmLowerBound;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmSpecializedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.access.TypeResource;
import org.eclipse.xtext.common.types.util.TypeArgumentContextProvider;
import org.eclipse.xtext.common.types.util.TypeConformanceComputer;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.util.IResourceScopeCache;
import org.eclipse.xtext.util.OnChangeEvictingCache;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.PolymorphicDispatcher;
import org.eclipse.xtext.util.Triple;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.jvmmodel.ILogicalContainerProvider;
import org.eclipse.xtext.xbase.resource.LinkingAssumptions;
import org.eclipse.xtext.xbase.typing.ITypeProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTypeProvider
implements ITypeProvider {
    private static final Logger logger = Logger.getLogger(AbstractTypeProvider.class);
    @Inject
    private TypeConformanceComputer typeConformanceComputer;
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private TypeArgumentContextProvider typeArgumentContextProvider;
    @Inject
    private ILogicalContainerProvider logicalContainerProvider;
    @Inject
    private LinkingAssumptions linkingAssumptions;
    @Inject
    private IResourceScopeCache resourceScopeCache;
    private OnChangeEvictingCache typeReferenceAwareCache;
    protected CyclicHandlingSupport<Pair<XExpression, JvmTypeReference>> getType;
    protected CyclicHandlingSupport<XExpression> getExpectedType;
    protected CyclicHandlingSupport<JvmIdentifiableElement> getTypeForIdentifiable;
    private PolymorphicDispatcher<Void> earlyExits;

    public AbstractTypeProvider() {
        this.checkIsSingelton();
        this.typeReferenceAwareCache = new OnChangeEvictingCache(){

            public <T> T get(Object key, Resource resource, Provider<T> provider) {
                boolean validEntry;
                if (resource == null || resource instanceof TypeResource) {
                    return (T)provider.get();
                }
                OnChangeEvictingCache.CacheAdapter adapter = this.getOrCreate(resource);
                Object element = adapter.get(key);
                boolean bl = validEntry = element != null;
                if (validEntry && element instanceof EObject) {
                    boolean bl2 = validEntry = !((EObject)element).eIsProxy();
                }
                if (!validEntry) {
                    this.cacheMiss(adapter);
                    LinkingAssumptions.Tracker tracker = AbstractTypeProvider.this.linkingAssumptions.trackAssumptions(resource);
                    element = provider.get();
                    tracker.stopTracking();
                    Triple castedKey = (Triple)key;
                    CyclicHandlingSupport cyclicHandlingSupport = (CyclicHandlingSupport)castedKey.getFirst();
                    ImmutableLinkedItem linkedItem = (ImmutableLinkedItem)castedKey.getSecond();
                    boolean rawType = (Boolean)castedKey.getThird();
                    if (!(tracker.isIndependentOfAssumptions() && linkedItem.object instanceof EObject && AbstractTypeProvider.this.isResolved((JvmTypeReference)element, AbstractTypeProvider.this.getNearestTypeParameterDeclarator(cyclicHandlingSupport.getPrimaryEObject(linkedItem.object)), rawType))) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)(String.valueOf(AbstractTypeProvider.this.getDebugIndentation(rawType)) + "cache skip: " + element));
                        }
                        return (T)element;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(String.valueOf(AbstractTypeProvider.this.getDebugIndentation(rawType)) + "cache: " + element));
                    }
                    adapter.set(key, element);
                } else {
                    this.cacheHit(adapter);
                }
                return (T)element;
            }
        };
        this.getType = new CyclicHandlingSupport<Pair<XExpression, JvmTypeReference>>(){

            @Override
            protected JvmTypeReference doComputation(Pair<XExpression, JvmTypeReference> t, boolean rawType) {
                return AbstractTypeProvider.this.type((XExpression)t.getFirst(), (JvmTypeReference)t.getSecond(), rawType);
            }

            @Override
            protected EObject getPrimaryEObject(Pair<XExpression, JvmTypeReference> pair) {
                return (EObject)pair.getFirst();
            }

            @Override
            protected JvmTypeReference doHandleCyclicCall(Pair<XExpression, JvmTypeReference> t, boolean rawType) {
                return AbstractTypeProvider.this.handleCyclicGetType((XExpression)t.getFirst(), (JvmTypeReference)t.getSecond(), rawType);
            }
        };
        this.getExpectedType = new CyclicHandlingSupport<XExpression>(){

            @Override
            protected JvmTypeReference doComputation(XExpression t, boolean rawType) {
                Triple<EObject, EReference, Integer> triple = AbstractTypeProvider.this.getContainingInfo(t);
                if (triple == null) {
                    return null;
                }
                return AbstractTypeProvider.this.expectedType((EObject)triple.getFirst(), (EReference)triple.getSecond(), (Integer)triple.getThird(), rawType);
            }

            @Override
            protected JvmTypeReference doHandleCyclicCall(XExpression t, boolean rawType) {
                return AbstractTypeProvider.this.handleCycleGetExpectedType(t, rawType);
            }

            @Override
            protected EObject getPrimaryEObject(XExpression expression) {
                return expression;
            }
        };
        this.getTypeForIdentifiable = new CyclicHandlingSupport<JvmIdentifiableElement>(){

            @Override
            protected JvmTypeReference doComputation(JvmIdentifiableElement t, boolean rawType) {
                return AbstractTypeProvider.this.typeForIdentifiable(t, rawType);
            }

            @Override
            protected JvmTypeReference doHandleCyclicCall(JvmIdentifiableElement t, boolean rawType) {
                return AbstractTypeProvider.this.handleCycleGetTypeForIdentifiable(t, rawType);
            }

            @Override
            protected EObject getPrimaryEObject(JvmIdentifiableElement identifiable) {
                return identifiable;
            }
        };
        this.earlyExits = PolymorphicDispatcher.createForSingleTarget((String)"_earlyExits", (int)2, (int)2, (Object)this);
    }

    protected void checkIsSingelton() {
        Singleton singleton = this.getClass().getAnnotation(Singleton.class);
        if (singleton == null) {
            throw new IllegalStateException("The class " + this.getClass().getSimpleName() + " must be annotated with @Singleton annotation.");
        }
    }

    protected boolean isResolved(JvmTypeReference reference, JvmTypeParameterDeclarator declarator, boolean rawType) {
        return this.isResolved(reference, declarator, rawType, true, Sets.newHashSet());
    }

    protected boolean isResolved(JvmTypeReference reference, JvmTypeParameterDeclarator declarator, boolean rawType, boolean allowAnyType, Set<JvmTypeReference> visited) {
        if (reference == null || reference instanceof JvmParameterizedTypeReference && reference.getType() == null || !visited.add(reference)) {
            return false;
        }
        if (reference instanceof JvmCompoundTypeReference) {
            for (JvmTypeReference component : ((JvmCompoundTypeReference)reference).getReferences()) {
                if (this.isResolved(component, declarator, rawType, allowAnyType, visited)) continue;
                return false;
            }
            return true;
        }
        if (reference.getType() instanceof JvmTypeParameter) {
            if (this.isDeclaratorOf(declarator, (JvmTypeParameter)reference.getType())) {
                return true;
            }
            for (JvmTypeConstraint constraint : ((JvmTypeParameter)reference.getType()).getConstraints()) {
                if (this.isResolved(constraint.getTypeReference(), declarator, rawType, false, visited)) continue;
                return false;
            }
            return false;
        }
        if (reference instanceof JvmParameterizedTypeReference) {
            if (rawType) {
                return true;
            }
            JvmParameterizedTypeReference parameterized = (JvmParameterizedTypeReference)reference;
            JvmType type = parameterized.getType();
            if (type instanceof JvmTypeParameterDeclarator && parameterized.getArguments().size() != ((JvmTypeParameterDeclarator)type).getTypeParameters().size()) {
                return false;
            }
            for (JvmTypeReference argument : parameterized.getArguments()) {
                if (this.isResolved(argument, declarator, rawType, false, visited)) continue;
                return false;
            }
        }
        if (reference instanceof JvmWildcardTypeReference) {
            for (JvmTypeConstraint constraint : ((JvmWildcardTypeReference)reference).getConstraints()) {
                if (!this.isResolved(constraint.getTypeReference(), declarator, rawType, false, visited)) {
                    return false;
                }
                if (!(constraint instanceof JvmLowerBound) || !this.typeReferences.is(constraint.getTypeReference(), Object.class)) continue;
                return false;
            }
        }
        if (reference instanceof JvmDelegateTypeReference) {
            return this.isResolved(((JvmDelegateTypeReference)reference).getDelegate(), declarator, rawType, allowAnyType, visited);
        }
        if (reference instanceof JvmSpecializedTypeReference) {
            return this.isResolved(((JvmSpecializedTypeReference)reference).getEquivalent(), declarator, rawType, allowAnyType, visited);
        }
        if (reference instanceof JvmAnyTypeReference) {
            return allowAnyType;
        }
        if (reference instanceof JvmGenericArrayTypeReference) {
            return this.isResolved(((JvmGenericArrayTypeReference)reference).getComponentType(), declarator, rawType, allowAnyType, visited);
        }
        return true;
    }

    protected JvmTypeParameterDeclarator getNearestTypeParameterDeclarator(EObject obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof JvmTypeParameterDeclarator) {
            return (JvmTypeParameterDeclarator)obj;
        }
        return this.getNearestTypeParameterDeclarator(this.getLogicalOrRealContainer(obj));
    }

    protected EObject getLogicalOrRealContainer(EObject obj) {
        JvmIdentifiableElement container;
        if (obj.eResource() != null && (container = this.logicalContainerProvider.getLogicalContainer(obj)) != null) {
            return container;
        }
        return obj.eContainer();
    }

    protected <T> T getLogicalOrRealContainer(EObject obj, Class<T> type) {
        EObject container = this.getLogicalOrRealContainer(obj);
        while (container != null && !type.isInstance(container)) {
            container = this.getLogicalOrRealContainer(container);
        }
        return (T)container;
    }

    protected boolean isDeclaratorOf(JvmTypeParameterDeclarator declarator, JvmTypeParameter param) {
        return param.getDeclarator() == declarator;
    }

    protected JvmTypeReference _type(XExpression expression, JvmTypeReference rawExpectation, boolean rawType) {
        throw new IllegalArgumentException("Type computation is not implemented for " + expression);
    }

    protected JvmIdentifiableElement getFeature(XAbstractFeatureCall expr, boolean resolve) {
        return this.linkingAssumptions.getFeature(expr, resolve);
    }

    protected JvmIdentifiableElement getFeature(XAbstractFeatureCall expr) {
        return this.getFeature(expr, true);
    }

    protected JvmConstructor getConstructor(XConstructorCall expr, boolean resolve) {
        return this.linkingAssumptions.getConstructor(expr, resolve);
    }

    protected JvmConstructor getConstructor(XConstructorCall expr) {
        return this.getConstructor(expr, true);
    }

    protected JvmTypeReference type(XExpression expression, JvmTypeReference rawExpectation, boolean rawType) {
        return this._type(expression, rawExpectation, rawType);
    }

    protected String getDebugIndentation(boolean rawType) {
        int size = this.getType.getOngoingComputationsSize(rawType) + this.getExpectedType.getOngoingComputationsSize(rawType) + this.getTypeForIdentifiable.getOngoingComputationsSize(rawType);
        char[] chars = new char[size];
        Arrays.fill(chars, ' ');
        return String.valueOf(chars);
    }

    protected <T> JvmTypeReference doGetType(String key, T object, boolean rawType, CyclicHandlingSupport<T> typeComputer) {
        String debugIndentation = null;
        if (logger.isDebugEnabled()) {
            debugIndentation = this.getDebugIndentation(rawType);
            if (debugIndentation.length() == 0) {
                StackTraceElement[] stackTrace;
                StackTraceElement[] stackTraceElementArray = stackTrace = new RuntimeException().getStackTrace();
                int n = stackTrace.length;
                int n2 = 0;
                while (n2 < n) {
                    StackTraceElement element = stackTraceElementArray[n2];
                    if (!element.isNativeMethod() && !AbstractTypeProvider.class.getName().equals(element.getClassName())) {
                        logger.debug((Object)(String.valueOf(debugIndentation) + key + "(" + (rawType ? "raw" : "parameterized") + ") : " + element));
                        break;
                    }
                    ++n2;
                }
            }
            logger.debug((Object)(String.valueOf(debugIndentation) + key + ": " + object));
        }
        JvmTypeReference result = typeComputer.getType(object, rawType);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(String.valueOf(debugIndentation) + "result: " + result + " " + key + "(" + (rawType ? "raw" : "parameterized") + ") : " + object));
        }
        return result;
    }

    @Override
    public JvmTypeReference getType(XExpression expression) {
        return this.getType(expression, null, false);
    }

    @Override
    public JvmTypeReference getType(XExpression expression, boolean rawType) {
        return this.getType(expression, null, rawType);
    }

    @Override
    public JvmTypeReference getType(XExpression expression, JvmTypeReference rawExpectation, boolean rawType) {
        return this.doGetType("getType", Tuples.create((Object)expression, (Object)rawExpectation), rawType, this.getType);
    }

    protected JvmTypeReference handleCyclicGetType(XExpression expression, JvmTypeReference rawExpectation, boolean rawType) {
        return null;
    }

    protected JvmTypeReference _expectedType(EObject container, EReference reference, int index, boolean rawType) {
        return null;
    }

    protected JvmTypeReference expectedType(EObject container, EReference reference, int index, boolean rawType) {
        return this._expectedType(container, reference, index, rawType);
    }

    @Override
    public JvmTypeReference getExpectedType(XExpression expression) {
        return this.getExpectedType(expression, false);
    }

    @Override
    public JvmTypeReference getExpectedType(XExpression expression, boolean rawType) {
        return this.doGetType("getExpectedType", expression, rawType, this.getExpectedType);
    }

    protected JvmTypeReference handleCycleGetExpectedType(XExpression expression, boolean rawType) {
        return null;
    }

    protected Triple<EObject, EReference, Integer> getContainingInfo(XExpression obj) {
        if (obj == null) {
            return null;
        }
        if (obj.eIsProxy()) {
            return null;
        }
        EReference containmentReference = obj.eContainmentFeature();
        if (containmentReference == null) {
            return null;
        }
        EObject container = obj.eContainer();
        int index = containmentReference.isMany() ? ((List)container.eGet((EStructuralFeature)containmentReference)).indexOf(obj) : -1;
        Triple triple = Tuples.create((Object)container, (Object)containmentReference, (Object)index);
        return triple;
    }

    protected JvmTypeReference _typeForIdentifiable(JvmIdentifiableElement identifiable, boolean rawType) {
        throw new IllegalArgumentException("Type computation is not implemented for " + identifiable);
    }

    protected JvmTypeReference typeForIdentifiable(JvmIdentifiableElement identifiable, boolean rawType) {
        return this._typeForIdentifiable(identifiable, rawType);
    }

    @Override
    public JvmTypeReference getTypeForIdentifiable(JvmIdentifiableElement identifiableElement) {
        return this.getTypeForIdentifiable(identifiableElement, false);
    }

    @Override
    public JvmTypeReference getTypeForIdentifiable(JvmIdentifiableElement identifiableElement, boolean rawType) {
        return this.doGetType("getTypeForIdentifiable", identifiableElement, rawType, this.getTypeForIdentifiable);
    }

    protected JvmTypeReference handleCycleGetTypeForIdentifiable(JvmIdentifiableElement identifiableElement, boolean rawType) {
        return null;
    }

    @Override
    public JvmTypeReference getCommonReturnType(XExpression expression, boolean assumeImplicitReturnExpression) {
        JvmTypeReference implicitReturnType;
        EarlyExitAcceptor acceptor = new EarlyExitAcceptor();
        this.internalCollectEarlyExits(expression, acceptor);
        List<JvmTypeReference> returns = acceptor.returns;
        if (assumeImplicitReturnExpression && (implicitReturnType = this.getType(expression)) != null && !this.typeReferences.is(implicitReturnType, Void.TYPE)) {
            acceptor.returns.add(implicitReturnType);
        }
        if (returns.isEmpty()) {
            if (expression != null) {
                return this.typeReferences.getTypeForName(Void.TYPE, (EObject)expression, new JvmTypeReference[0]);
            }
            return null;
        }
        JvmTypeReference superType = this.typeConformanceComputer.getCommonSuperType(returns);
        return superType;
    }

    @Override
    public Iterable<JvmTypeReference> getThrownExceptionTypes(XExpression expression) {
        EarlyExitAcceptor acceptor = new EarlyExitAcceptor();
        this.internalCollectEarlyExits(expression, acceptor);
        HashMap result = Maps.newHashMap();
        for (JvmTypeReference thrownType : acceptor.thrown) {
            result.put(thrownType.getType(), thrownType);
        }
        return result.values();
    }

    protected void internalCollectEarlyExits(final EObject expr, EarlyExitAcceptor acceptor) {
        if (expr == null || expr.eResource() == null) {
            return;
        }
        EarlyExitAcceptor child = (EarlyExitAcceptor)this.resourceScopeCache.get((Object)Tuples.create((Object)"internalCollectEarlyExits", (Object)expr), expr.eResource(), (Provider)new Provider<EarlyExitAcceptor>(){

            public EarlyExitAcceptor get() {
                EarlyExitAcceptor result = new EarlyExitAcceptor();
                AbstractTypeProvider.this.earlyExits.invoke(new Object[]{expr, result});
                return result;
            }
        });
        acceptor.returns.addAll(child.returns);
        acceptor.thrown.addAll(child.thrown);
    }

    protected void _earlyExits(Void expr, EarlyExitAcceptor a) {
    }

    protected void _earlyExits(JvmTypeReference ref, EarlyExitAcceptor a) {
    }

    protected void _earlyExits(EObject expr, EarlyExitAcceptor acceptor) {
        EList list = expr.eContents();
        for (EObject eObject : list) {
            this.internalCollectEarlyExits(eObject, acceptor);
        }
    }

    protected TypeConformanceComputer getTypeConformanceComputer() {
        return this.typeConformanceComputer;
    }

    protected TypeReferences getTypeReferences() {
        return this.typeReferences;
    }

    protected TypeArgumentContextProvider getTypeArgumentContextProvider() {
        return this.typeArgumentContextProvider;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class CyclicHandlingSupport<T> {
        private final ThreadLocal<ComputationData> ongoingComputations = new ThreadLocal<ComputationData>(){

            @Override
            protected ComputationData initialValue() {
                return CyclicHandlingSupport.this.createComputationData();
            }
        };
        private final ThreadLocal<ComputationData> ongoingRawTypeComputations = new ThreadLocal<ComputationData>(){

            @Override
            protected ComputationData initialValue() {
                return CyclicHandlingSupport.this.createComputationData();
            }
        };

        CyclicHandlingSupport() {
        }

        protected abstract EObject getPrimaryEObject(T var1);

        protected ComputationData getTypeComputations(boolean rawType) {
            ThreadLocal<ComputationData> computations = rawType ? this.ongoingRawTypeComputations : this.ongoingComputations;
            ComputationData result = computations.get();
            return result;
        }

        public JvmTypeReference getType(final T t, final boolean rawType) {
            if (t == null) {
                return null;
            }
            EObject eObject = this.getPrimaryEObject(t);
            if (eObject == null || eObject.eIsProxy()) {
                return null;
            }
            ComputationData computationData = this.getTypeComputations(rawType);
            if (computationData.add(t)) {
                try {
                    if (computationData.resource == eObject.eResource() && !computationData.resourceLeftOrCyclic) {
                        Triple cacheKey = Tuples.create((Object)this, computationData.queryState, (Object)rawType);
                        final boolean[] hit = new boolean[]{true};
                        JvmTypeReference result = (JvmTypeReference)AbstractTypeProvider.this.typeReferenceAwareCache.get((Object)cacheKey, computationData.resource, (Provider)new Provider<JvmTypeReference>(){

                            public JvmTypeReference get() {
                                hit[0] = false;
                                JvmTypeReference result = CyclicHandlingSupport.this.doComputation(t, rawType);
                                return result;
                            }
                        });
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)(String.valueOf(AbstractTypeProvider.this.getDebugIndentation(rawType)) + "cache hit: " + hit[0] + " for: " + t));
                        }
                        JvmTypeReference jvmTypeReference = result;
                        return jvmTypeReference;
                    }
                    if (computationData.resourceLeftOrCyclic) {
                        JvmTypeReference jvmTypeReference = this.doComputation(t, rawType);
                        return jvmTypeReference;
                    }
                    try {
                        computationData.resourceLeftOrCyclic = true;
                        JvmTypeReference jvmTypeReference = this.doComputation(t, rawType);
                        computationData.resourceLeftOrCyclic = false;
                        return jvmTypeReference;
                    }
                    catch (Throwable throwable) {
                        computationData.resourceLeftOrCyclic = false;
                        throw throwable;
                    }
                }
                finally {
                    computationData.remove(t);
                }
            }
            if (computationData.resourceLeftOrCyclic) {
                return this.doHandleCyclicCall(t, rawType);
            }
            try {
                computationData.resourceLeftOrCyclic = true;
                JvmTypeReference jvmTypeReference = this.doHandleCyclicCall(t, rawType);
                return jvmTypeReference;
            }
            finally {
                computationData.resourceLeftOrCyclic = false;
            }
        }

        protected int getOngoingComputationsSize(boolean rawType) {
            return this.getTypeComputations(rawType).size();
        }

        protected abstract JvmTypeReference doComputation(T var1, boolean var2);

        protected abstract JvmTypeReference doHandleCyclicCall(T var1, boolean var2);

        protected ComputationData createComputationData() {
            return new ComputationData();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected class ComputationData {
            protected final Set<T> computations = Sets.newHashSet();
            protected ImmutableLinkedItem<T> queryState = null;
            protected Resource resource;
            protected boolean resourceLeftOrCyclic;

            protected ComputationData() {
            }

            protected boolean add(T t) {
                boolean result = this.computations.add(t);
                if (result) {
                    if (this.queryState == null) {
                        this.resource = CyclicHandlingSupport.this.getPrimaryEObject(t).eResource();
                    }
                    this.queryState = new ImmutableLinkedItem(t, this.queryState);
                }
                return result;
            }

            protected void remove(T t) {
                this.computations.remove(t);
                this.queryState = this.queryState.prev;
                if (this.queryState == null) {
                    this.resource = null;
                }
            }

            protected int size() {
                return this.computations.size();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EarlyExitAcceptor {
        protected List<JvmTypeReference> returns = Lists.newArrayListWithCapacity((int)2);
        protected List<JvmTypeReference> thrown = Lists.newArrayListWithCapacity((int)2);

        public List<JvmTypeReference> getReturns() {
            return this.returns;
        }

        public List<JvmTypeReference> getThrown() {
            return this.thrown;
        }

        public void appendThrown(Iterable<JvmTypeReference> exceptions) {
            Iterables.addAll(this.thrown, exceptions);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class ImmutableLinkedItem<T> {
        protected final T object;
        protected final ImmutableLinkedItem<T> prev;
        protected final int hashCode;
        protected final int size;

        public ImmutableLinkedItem(T object, ImmutableLinkedItem<T> immutableStack) {
            this.object = object;
            this.prev = immutableStack;
            this.size = immutableStack == null ? 1 : immutableStack.size + 1;
            this.hashCode = this.prev != null ? 31 * this.size * this.prev.hashCode() + object.hashCode() : object.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.hashCode() != this.hashCode() || obj.getClass() != ImmutableLinkedItem.class) {
                return false;
            }
            ImmutableLinkedItem other = (ImmutableLinkedItem)obj;
            return other.object.equals(this.object) && other.size == this.size && (other.prev == this.prev || this.prev != null && this.prev.equals(other.prev));
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

