/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.AbstractMetamodelDeclaration;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.XtextPackage;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.AbstractScopeProvider;
import org.eclipse.xtext.scoping.impl.GlobalResourceDescriptionProvider;
import org.eclipse.xtext.scoping.impl.SelectableBasedScope;
import org.eclipse.xtext.scoping.impl.SimpleScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtextScopeProvider
extends AbstractScopeProvider {
    @Inject
    private GlobalResourceDescriptionProvider resourceDecriptionProvider;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public IScope getScope(EObject context, EReference reference) {
        if (reference == XtextPackage.eINSTANCE.getTypeRef_Classifier()) {
            if (!(context instanceof TypeRef)) return this.createReferencedPackagesScope(GrammarUtil.getGrammar(context));
            TypeRef typeRef = (TypeRef)context;
            AbstractMetamodelDeclaration metaModel = typeRef.getMetamodel();
            if (metaModel == null) return this.createReferencedPackagesScope(GrammarUtil.getGrammar(context));
            EPackage pack = metaModel.getEPackage();
            if (pack == null) return IScope.NULLSCOPE;
            return this.createClassifierScope((Iterable<EClassifier>)pack.getEClassifiers());
        }
        if (reference != XtextPackage.eINSTANCE.getEnumLiteralDeclaration_EnumLiteral()) return this.createScope(context.eResource(), reference.getEReferenceType());
        EnumRule rule = GrammarUtil.containingEnumRule(context);
        if (rule.getType() == null || rule.getType().getClassifier() == null || !(rule.getType().getClassifier() instanceof EEnum)) return IScope.NULLSCOPE;
        return this.createEnumLiteralsScope((EEnum)rule.getType().getClassifier());
    }

    protected IScope createEnumLiteralsScope(EEnum eEnum) {
        return new SimpleScope(IScope.NULLSCOPE, Iterables.transform((Iterable)eEnum.getELiterals(), (Function)new Function<EEnumLiteral, IEObjectDescription>(){

            public IEObjectDescription apply(EEnumLiteral param) {
                return EObjectDescription.create(QualifiedName.create(param.getName()), (EObject)param);
            }
        }));
    }

    protected IScope createClassifierScope(Iterable<EClassifier> classifiers) {
        return new SimpleScope(IScope.NULLSCOPE, Iterables.transform(classifiers, (Function)new Function<EClassifier, IEObjectDescription>(){

            public IEObjectDescription apply(EClassifier param) {
                return EObjectDescription.create(QualifiedName.create(param.getName()), (EObject)param);
            }
        }));
    }

    protected IScope createReferencedPackagesScope(Grammar g) {
        ArrayList<EClassifier> allClassifiers = new ArrayList<EClassifier>();
        for (AbstractMetamodelDeclaration decl : g.getMetamodelDeclarations()) {
            if (decl.getEPackage() == null) continue;
            allClassifiers.addAll((Collection<EClassifier>)decl.getEPackage().getEClassifiers());
        }
        return this.createClassifierScope(allClassifiers);
    }

    protected IScope createScope(Resource resource, EClass type) {
        if (resource.getContents().size() < 1) {
            throw new IllegalArgumentException("resource is not as expected: contents.size == " + resource.getContents().size() + " but expected: >= 1");
        }
        EObject firstContent = (EObject)resource.getContents().get(0);
        if (!(firstContent instanceof Grammar)) {
            return IScope.NULLSCOPE;
        }
        return this.createScope((Grammar)firstContent, type);
    }

    protected IScope createScope(Grammar grammar, EClass type) {
        if (EcorePackage.Literals.EPACKAGE == type) {
            return this.createEPackageScope(grammar);
        }
        if (AbstractMetamodelDeclaration.class.isAssignableFrom(type.getInstanceClass())) {
            return new SimpleScope(IScope.NULLSCOPE, Iterables.transform(grammar.getMetamodelDeclarations(), (Function)new Function<AbstractMetamodelDeclaration, IEObjectDescription>(){

                public IEObjectDescription apply(AbstractMetamodelDeclaration from) {
                    String name = from.getAlias() != null ? from.getAlias() : "";
                    return EObjectDescription.create(QualifiedName.create(name), (EObject)from);
                }
            }));
        }
        List<Grammar> allGrammars = this.getAllGrammars(grammar);
        IScope current = IScope.NULLSCOPE;
        int i = allGrammars.size() - 1;
        while (i >= 0) {
            current = this.createScope(allGrammars.get(i), type, current);
            --i;
        }
        return current;
    }

    protected IScope createScope(Grammar grammar, EClass type, IScope parent) {
        IResourceDescription resourceDescription = this.resourceDecriptionProvider.getResourceDescription(grammar.eResource());
        return SelectableBasedScope.createScope(parent, resourceDescription, type, false);
    }

    protected List<Grammar> getAllGrammars(Grammar grammar) {
        LinkedHashSet<Grammar> visitedGrammars = new LinkedHashSet<Grammar>();
        this.collectAllUsedGrammars(grammar, visitedGrammars);
        return new ArrayList<Grammar>(visitedGrammars);
    }

    protected void collectAllUsedGrammars(Grammar grammar, Collection<Grammar> visited) {
        if (!visited.add(grammar)) {
            return;
        }
        for (Grammar usedGrammar : grammar.getUsedGrammars()) {
            this.collectAllUsedGrammars(usedGrammar, visited);
        }
    }

    protected IScope createEPackageScope(Grammar grammar, IScope parent) {
        return new SimpleScope(parent, Iterables.transform((Iterable)Iterables.filter(grammar.getMetamodelDeclarations(), (Predicate)new Predicate<AbstractMetamodelDeclaration>(){

            public boolean apply(AbstractMetamodelDeclaration input) {
                return input.getEPackage() != null;
            }
        }), (Function)new Function<AbstractMetamodelDeclaration, IEObjectDescription>(){

            public IEObjectDescription apply(AbstractMetamodelDeclaration from) {
                return EObjectDescription.create(QualifiedName.create(from.getEPackage().getNsURI()), (EObject)from.getEPackage());
            }
        }));
    }

    protected IScope createEPackageScope(Grammar grammar) {
        List<Grammar> allGrammars = this.getAllGrammars(grammar);
        IScope current = new SimpleScope(IScope.NULLSCOPE, Iterables.transform((Iterable)EPackage.Registry.INSTANCE.keySet(), (Function)new Function<String, IEObjectDescription>(){

            public IEObjectDescription apply(String from) {
                InternalEObject proxyPackage = (InternalEObject)EcoreFactory.eINSTANCE.createEPackage();
                proxyPackage.eSetProxyURI(URI.createURI((String)from));
                return EObjectDescription.create(QualifiedName.create(from), (EObject)proxyPackage, Collections.singletonMap("nsURI", "true"));
            }
        }));
        int i = allGrammars.size() - 1;
        while (i >= 0) {
            current = this.createEPackageScope(allGrammars.get(i), current);
            --i;
        }
        return current;
    }
}

