/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.linking;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.diagnostics.DiagnosticMessage;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.linking.ILinkingDiagnosticMessageProvider;
import org.eclipse.xtext.linking.impl.IllegalNodeException;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XUnaryOperation;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.annotations.validation.UnresolvedAnnotationTypeAwareMessageProducer;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationsPackage;
import org.eclipse.xtext.xbase.util.FeatureCallAsTypeLiteralHelper;

public class XtendLinkingDiagnosticMessageProvider
extends UnresolvedAnnotationTypeAwareMessageProducer {
    public static final String TYPE_LITERAL = "key:TypeLiteral";
    @Inject
    private FeatureCallAsTypeLiteralHelper typeLiteralHelper;

    public DiagnosticMessage getUnresolvedProxyMessage(ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext context) {
        XAbstractFeatureCall featureCall;
        XtendTypeDeclaration xtendType;
        if (this.isPropertyOfUnresolvedAnnotation(context)) {
            return null;
        }
        String linkText = "";
        try {
            linkText = context.getLinkText();
        }
        catch (IllegalNodeException e) {
            linkText = e.getNode().getText();
        }
        if (linkText == null) {
            return null;
        }
        EObject contextObject = context.getContext();
        if (this.isStaticMemberCallTarget(contextObject)) {
            String message = String.format("%s cannot be resolved to a type.", linkText);
            return new DiagnosticMessage(message, Severity.ERROR, "org.eclipse.xtext.diagnostics.Diagnostic.Linking", new String[]{TYPE_LITERAL});
        }
        if (contextObject instanceof XAbstractFeatureCall && !(contextObject instanceof XBinaryOperation) && !(contextObject instanceof XUnaryOperation) && (xtendType = (XtendTypeDeclaration)EcoreUtil2.getContainerOfType((EObject)(featureCall = (XAbstractFeatureCall)contextObject), XtendTypeDeclaration.class)) != null) {
            String clazzName = xtendType.getName();
            EList explicitArguments = featureCall.getExplicitArguments();
            String firstPartOfMessage = "The method ";
            if (explicitArguments.size() == 0 || featureCall instanceof XAssignment) {
                firstPartOfMessage = String.valueOf(firstPartOfMessage) + "or field ";
            }
            if (featureCall instanceof XFeatureCall && this.typeLiteralHelper.isPotentialTypeLiteral((XExpression)featureCall, null)) {
                return new DiagnosticMessage(String.valueOf(firstPartOfMessage) + linkText + " is undefined for the type " + clazzName, Severity.ERROR, "org.eclipse.xtend.core.validation.IssueCodes.feature_linking", new String[]{linkText, TYPE_LITERAL});
            }
            return new DiagnosticMessage(String.valueOf(firstPartOfMessage) + linkText + " is undefined for the type " + clazzName, Severity.ERROR, "org.eclipse.xtend.core.validation.IssueCodes.feature_linking", new String[]{linkText});
        }
        EClass referenceType = context.getReference().getEReferenceType();
        String msg = String.format("%s cannot be resolved%s.", linkText, this.getTypeName(referenceType, (EStructuralFeature)context.getReference()));
        return new DiagnosticMessage(msg, Severity.ERROR, "org.eclipse.xtext.diagnostics.Diagnostic.Linking", new String[]{linkText});
    }

    protected boolean isStaticMemberCallTarget(EObject contextObject) {
        XMemberFeatureCall memberFeatureCall;
        boolean candidate;
        boolean bl = candidate = contextObject instanceof XFeatureCall && contextObject.eContainingFeature() == XbasePackage.Literals.XMEMBER_FEATURE_CALL__MEMBER_CALL_TARGET;
        return candidate && (memberFeatureCall = (XMemberFeatureCall)contextObject.eContainer()).isExplicitStatic();
    }

    @Nullable
    protected String getTypeName(EClass c, EStructuralFeature referingFeature) {
        if (referingFeature == XAnnotationsPackage.Literals.XANNOTATION__ANNOTATION_TYPE) {
            return " to an annotation type";
        }
        if (c == TypesPackage.Literals.JVM_ENUMERATION_TYPE) {
            return " to an enum type";
        }
        if (EcoreUtil2.isAssignableFrom((EClass)TypesPackage.Literals.JVM_TYPE, (EClass)c)) {
            return " to a type";
        }
        if (c == TypesPackage.Literals.JVM_OPERATION) {
            return " to an operation";
        }
        return "";
    }
}

