/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.typesystem;

import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtend.core.typesystem.ExtensionAwareClosureTypeComputer;
import org.eclipse.xtend.core.xtend.RichString;
import org.eclipse.xtend.core.xtend.RichStringElseIf;
import org.eclipse.xtend.core.xtend.RichStringForLoop;
import org.eclipse.xtend.core.xtend.RichStringIf;
import org.eclipse.xtend.core.xtend.RichStringLiteral;
import org.eclipse.xtend.core.xtend.XtendFormalParameter;
import org.eclipse.xtend.core.xtend.XtendVariableDeclaration;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.annotations.typesystem.XbaseWithAnnotationsTypeComputer;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationState;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

@NonNullByDefault
public class XtendTypeComputer
extends XbaseWithAnnotationsTypeComputer {
    public void computeTypes(XExpression expression, ITypeComputationState state) {
        if (expression instanceof RichString) {
            this._computeTypes((RichString)expression, state);
        } else if (expression instanceof RichStringForLoop) {
            this._computeTypes((RichStringForLoop)expression, state);
        } else if (expression instanceof RichStringIf) {
            this._computeTypes((RichStringIf)expression, state);
        } else if (expression instanceof RichStringLiteral) {
            this._computeTypes((RichStringLiteral)expression, state);
        } else {
            super.computeTypes(expression, state);
        }
    }

    protected void _computeTypes(RichString object, ITypeComputationState state) {
        EList expressions = object.getExpressions();
        if (!expressions.isEmpty()) {
            for (XExpression expression : expressions) {
                ITypeComputationState expressionState = state.withoutExpectation();
                expressionState.computeTypes(expression);
                if (!(expression instanceof XVariableDeclaration)) continue;
                this.addLocalToCurrentScope((XVariableDeclaration)expression, state);
            }
        }
        for (ITypeExpectation expectation : state.getExpectations()) {
            LightweightTypeReference type;
            LightweightTypeReference expectedType = expectation.getExpectedType();
            if (expectedType != null && expectedType.isType(StringConcatenation.class)) {
                expectation.acceptActualType(expectedType, new ConformanceHint[]{ConformanceHint.SUCCESS, ConformanceHint.CHECKED, ConformanceHint.DEMAND_CONVERSION});
                continue;
            }
            if (expectedType != null && expectedType.isType(StringConcatenationClient.class)) {
                expectation.acceptActualType(expectedType, new ConformanceHint[]{ConformanceHint.SUCCESS, ConformanceHint.CHECKED, ConformanceHint.DEMAND_CONVERSION});
                continue;
            }
            if (expectedType != null && expectedType.isType(String.class)) {
                expectation.acceptActualType(expectedType, new ConformanceHint[]{ConformanceHint.SUCCESS, ConformanceHint.CHECKED, ConformanceHint.DEMAND_CONVERSION});
                continue;
            }
            if (!(object.eContainer() instanceof XCastedExpression) && object.eContainingFeature() != XbasePackage.Literals.XMEMBER_FEATURE_CALL__MEMBER_CALL_TARGET && (expectedType != null && !expectedType.isResolved() || expectedType == null && !expectation.isVoidTypeAllowed())) {
                type = this.getTypeForName(String.class, state);
                expectation.acceptActualType(type, new ConformanceHint[]{ConformanceHint.UNCHECKED, ConformanceHint.DEMAND_CONVERSION});
                continue;
            }
            type = this.getTypeForName(CharSequence.class, state);
            expectation.acceptActualType(type, new ConformanceHint[]{ConformanceHint.UNCHECKED});
        }
    }

    protected void _computeTypes(RichStringForLoop object, ITypeComputationState state) {
        LightweightTypeReference charSequence = this.getTypeForName(CharSequence.class, state);
        ITypeComputationState eachState = state.withExpectation(charSequence);
        JvmFormalParameter parameter = object.getDeclaredParam();
        if (parameter != null) {
            LightweightTypeReference parameterType = this.computeForLoopParameterType(object, state);
            eachState = eachState.assignType((JvmIdentifiableElement)parameter, parameterType);
        }
        eachState.computeTypes(object.getEachExpression());
        state.withNonVoidExpectation().computeTypes(object.getBefore());
        state.withNonVoidExpectation().computeTypes(object.getSeparator());
        state.withNonVoidExpectation().computeTypes(object.getAfter());
        LightweightTypeReference primitiveVoid = this.getPrimitiveVoid(state);
        state.acceptActualType(primitiveVoid);
        state.acceptActualType(charSequence);
    }

    protected void _computeTypes(RichStringIf object, ITypeComputationState state) {
        LightweightTypeReference charSequence = this.getTypeForName(CharSequence.class, state);
        LightweightTypeReference booleanType = this.getTypeForName(Boolean.TYPE, state);
        ITypeComputationState conditionExpectation = state.withExpectation(booleanType);
        XExpression condition = object.getIf();
        conditionExpectation.computeTypes(condition);
        XExpression thenExpression = object.getThen();
        ITypeComputationState thenState = this.reassignCheckedType(condition, thenExpression, state);
        thenState.withExpectation(charSequence).computeTypes(thenExpression);
        for (RichStringElseIf elseIf : object.getElseIfs()) {
            state.withExpectation(booleanType).computeTypes(elseIf.getIf());
            state.withExpectation(charSequence).computeTypes(elseIf.getThen());
        }
        state.withExpectation(charSequence).computeTypes(object.getElse());
        state.acceptActualType(charSequence);
    }

    protected void _computeTypes(RichStringLiteral object, ITypeComputationState state) {
        LightweightTypeReference type = this.getTypeForName(CharSequence.class, state);
        state.acceptActualType(type);
    }

    protected void addLocalToCurrentScope(XVariableDeclaration localVariable, ITypeComputationState state) {
        super.addLocalToCurrentScope(localVariable, state);
        if (localVariable instanceof XtendVariableDeclaration && ((XtendVariableDeclaration)localVariable).isExtension()) {
            state.addExtensionToCurrentScope((JvmIdentifiableElement)localVariable);
        }
    }

    protected ITypeComputationState assignType(JvmFormalParameter param, @Nullable LightweightTypeReference type, ITypeComputationState state) {
        ITypeComputationState result = super.assignType(param, type, state);
        if (param instanceof XtendFormalParameter && ((XtendFormalParameter)param).isExtension()) {
            result.addExtensionToCurrentScope((JvmIdentifiableElement)param);
        }
        return result;
    }

    protected void _computeTypes(XClosure object, ITypeComputationState state) {
        for (ITypeExpectation expectation : state.getExpectations()) {
            new ExtensionAwareClosureTypeComputer(object, expectation, state).computeTypes();
        }
    }
}

