/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.parser.packrat;

import java.io.CharArrayWriter;

public class CharArrayWriterAsSequence
extends CharArrayWriter
implements CharSequence {
    public char charAt(int index) {
        return this.buf[index];
    }

    public int length() {
        return this.count;
    }

    public CharArrayWriterAsSequence(int initial) {
        super(initial <= 32 ? 512 : initial);
    }

    public CharArrayWriterAsSequence() {
        super(1024);
    }

    public CharSequence subSequence(int start, int end) {
        return new SubSequence(this, start, end);
    }

    public static class SubSequence
    implements CharSequence {
        private final CharArrayWriterAsSequence base;
        private final int start;
        private final int end;

        public SubSequence(CharArrayWriterAsSequence base, int start, int end) {
            this.base = base;
            this.start = start;
            this.end = end;
        }

        public char charAt(int index) {
            return this.base.charAt(index + this.start);
        }

        public int length() {
            return this.end - this.start;
        }

        public CharSequence subSequence(int start, int end) {
            return new SubSequence(this.base, this.start + start, this.start + end);
        }

        public String toString() {
            return new String(this.base.buf, this.start, this.end - this.start);
        }
    }
}

