/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.nosql.entities;

import java.math.BigDecimal;
import java.util.Currency;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import net.datafaker.Faker;

public record Money(Currency currency, BigDecimal value) {
    public Money {
        Objects.requireNonNull(currency, "currency is required");
        Objects.requireNonNull(value, "value is required");
    }

    public static Money of(Faker faker) {
        Currency currency = Currency.getInstance(faker.money().currencyCode());
        BigDecimal value = BigDecimal.valueOf(ThreadLocalRandom.current().nextDouble(0.0, 1000.0));
        return new Money(currency, value);
    }

    @Override
    public String toString() {
        return this.currency.getCurrencyCode() + " " + this.value.toPlainString();
    }
}

