/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.tests;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.oomph.setup.internal.core.StringFilterRegistry;
import org.eclipse.oomph.setup.util.SetupUtil;
import org.eclipse.oomph.setup.util.StringExpander;
import org.eclipse.oomph.tests.AbstractTest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.JVM)
public class StringExpanderTests
extends AbstractTest {
    private final StringExpander expander = new WindowsStringExpander();

    @Test
    public void testNull() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString(null), (Matcher)StringExpanderTests.isNull());
    }

    @Test
    public void testVariable() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${windows.path}END"), (Matcher)StringExpanderTests.is((Object)"STARTC:\\develop\\java-latestEND"));
    }

    @Test
    public void testVariableSlash() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${windows.path/}END"), (Matcher)StringExpanderTests.is((Object)"STARTC:\\develop\\java-latest\\END"));
    }

    @Test
    public void testVariableSlashSlash() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${windows.path//}END"), (Matcher)StringExpanderTests.is((Object)"STARTC:\\develop\\java-latest\\END"));
    }

    @Test
    public void testVariableSlashPipe() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${windows.path/|}END"), (Matcher)StringExpanderTests.is((Object)"STARTC:\\develop\\java-latest\\END"));
    }

    @Test
    public void testVariablePipe() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${windows.path|}END"), (Matcher)StringExpanderTests.is((Object)"STARTC:\\develop\\java-latestEND"));
    }

    @Test
    public void testVariablePipePipe() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${windows.path||}END"), (Matcher)StringExpanderTests.is((Object)"STARTC:\\develop\\java-latestEND"));
    }

    @Test
    public void testVariablePipeSlash() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${windows.path|/}END"), (Matcher)StringExpanderTests.is((Object)"STARTC:\\develop\\java-latest\\END"));
    }

    @Test
    public void testVariableFilter() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${windows.path|property}END"), (Matcher)StringExpanderTests.is((Object)"STARTC:\\\\develop\\\\java-latestEND"));
    }

    @Test
    public void testVariableUnresolvedFilter() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${windows.path|unknown}END"), (Matcher)StringExpanderTests.is((Object)"STARTC:\\develop\\java-latestEND"));
    }

    @Test
    public void testVariablePath() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${windows.path/ws}END"), (Matcher)StringExpanderTests.is((Object)"STARTC:\\develop\\java-latest\\wsEND"));
    }

    @Test
    public void testVariableFilterPath() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${windows.path|property/ws}END"), (Matcher)StringExpanderTests.is((Object)"STARTC:\\\\develop\\\\java-latest\\wsEND"));
    }

    @Test
    public void testVariableUnresolvedFilterPath() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${windows.path|unknown/ws}END"), (Matcher)StringExpanderTests.is((Object)"STARTC:\\develop\\java-latest\\wsEND"));
    }

    @Test
    public void testVariablePathFilter() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${windows.path/ws|property}END"), (Matcher)StringExpanderTests.is((Object)"STARTC:\\\\develop\\\\java-latest\\\\wsEND"));
    }

    @Test
    public void testVariablePathUnresolvedFilter() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${windows.path/ws|unknown}END"), (Matcher)StringExpanderTests.is((Object)"STARTC:\\develop\\java-latest\\wsEND"));
    }

    @Test
    public void testUnresolvedVariable() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${unknown.path}END"), (Matcher)StringExpanderTests.is((Object)"START${unknown.path}END"));
    }

    @Test
    public void testUnresolvedVariableFilter() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${unknown.path|property}END"), (Matcher)StringExpanderTests.is((Object)"START${unknown.path|property}END"));
    }

    @Test
    public void testUnresolvedVariableUnresolvedFilter() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${unknown.path|unknown}END"), (Matcher)StringExpanderTests.is((Object)"START${unknown.path|unknown}END"));
    }

    @Test
    public void testUnresolvedVariablePath() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${unknown.path/ws}END"), (Matcher)StringExpanderTests.is((Object)"START${unknown.path/ws}END"));
    }

    @Test
    public void testUnresolvedVariableFilterPath() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${unknown.path|property/ws}END"), (Matcher)StringExpanderTests.is((Object)"START${unknown.path|property/ws}END"));
    }

    @Test
    public void testUnresolvedVariablePathFilter() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${unknown.path/ws|property}END"), (Matcher)StringExpanderTests.is((Object)"START${unknown.path/ws|property}END"));
    }

    @Test
    public void testTwice() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${windows.path/ws|property}${windows.path/ws|property}END"), (Matcher)StringExpanderTests.is((Object)"STARTC:\\\\develop\\\\java-latest\\\\wsC:\\\\develop\\\\java-latest\\\\wsEND"));
    }

    @Test
    public void testTwiceWithText() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${windows.path/ws|property}MIDDLE${windows.path/ws|property}END"), (Matcher)StringExpanderTests.is((Object)"STARTC:\\\\develop\\\\java-latest\\\\wsMIDDLEC:\\\\develop\\\\java-latest\\\\wsEND"));
    }

    @Test
    public void testDollar() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START$END"), (Matcher)StringExpanderTests.is((Object)"START$END"));
        MatcherAssert.assertThat((Object)this.expander.expandString("START$$END"), (Matcher)StringExpanderTests.is((Object)"START$END"));
    }

    @Test
    public void testEscaped() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START$${windows.path}END"), (Matcher)StringExpanderTests.is((Object)"START${windows.path}END"));
    }

    @Test
    public void testEscaped_Bug473706() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("<timestamp>${maven.build.timestamp}</timestamp>"), (Matcher)StringExpanderTests.is((Object)"<timestamp>${maven.build.timestamp}</timestamp>"));
        MatcherAssert.assertThat((Object)this.expander.expandString("<timestamp>$${maven.build.timestamp}</timestamp>"), (Matcher)StringExpanderTests.is((Object)"<timestamp>${maven.build.timestamp}</timestamp>"));
        MatcherAssert.assertThat((Object)this.expander.expandString("<timestamp>$$${maven.build.timestamp}</timestamp>"), (Matcher)StringExpanderTests.is((Object)"<timestamp>$${maven.build.timestamp}</timestamp>"));
        MatcherAssert.assertThat((Object)this.expander.expandString("<timestamp>$$$${maven.build.timestamp}</timestamp>"), (Matcher)StringExpanderTests.is((Object)"<timestamp>$${maven.build.timestamp}</timestamp>"));
        MatcherAssert.assertThat((Object)this.expander.expandString("<timestamp>$$$$${maven.build.timestamp}</timestamp>"), (Matcher)StringExpanderTests.is((Object)"<timestamp>$$${maven.build.timestamp}</timestamp>"));
        MatcherAssert.assertThat((Object)this.expander.expandString("<timestamp>${windows.path}</timestamp>"), (Matcher)StringExpanderTests.is((Object)"<timestamp>C:\\develop\\java-latest</timestamp>"));
        MatcherAssert.assertThat((Object)this.expander.expandString("<timestamp>$${windows.path}</timestamp>"), (Matcher)StringExpanderTests.is((Object)"<timestamp>${windows.path}</timestamp>"));
        MatcherAssert.assertThat((Object)this.expander.expandString("<timestamp>$$${windows.path}</timestamp>"), (Matcher)StringExpanderTests.is((Object)"<timestamp>$C:\\develop\\java-latest</timestamp>"));
        MatcherAssert.assertThat((Object)this.expander.expandString("<timestamp>$$$${windows.path}</timestamp>"), (Matcher)StringExpanderTests.is((Object)"<timestamp>$${windows.path}</timestamp>"));
        MatcherAssert.assertThat((Object)this.expander.expandString("<timestamp>$$$$${windows.path}</timestamp>"), (Matcher)StringExpanderTests.is((Object)"<timestamp>$$C:\\develop\\java-latest</timestamp>"));
        MatcherAssert.assertThat((Object)SetupUtil.escape((String)"<timestamp>$</timestamp>"), (Matcher)StringExpanderTests.is((Object)"<timestamp>$</timestamp>"));
        MatcherAssert.assertThat((Object)SetupUtil.escape((String)"<timestamp>${}</timestamp>"), (Matcher)StringExpanderTests.is((Object)"<timestamp>${}</timestamp>"));
        MatcherAssert.assertThat((Object)SetupUtil.escape((String)"<timestamp>${maven.build.timestamp}</timestamp>"), (Matcher)StringExpanderTests.is((Object)"<timestamp>$${maven.build.timestamp}</timestamp>"));
        MatcherAssert.assertThat((Object)SetupUtil.escape((String)"<timestamp>$${maven.build.timestamp}</timestamp>"), (Matcher)StringExpanderTests.is((Object)"<timestamp>$$$${maven.build.timestamp}</timestamp>"));
        MatcherAssert.assertThat((Object)SetupUtil.escape((String)"<timestamp>$$${maven.build.timestamp}</timestamp>"), (Matcher)StringExpanderTests.is((Object)"<timestamp>$$$$$${maven.build.timestamp}</timestamp>"));
    }

    @Test
    public void testEscapedPathFilter() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START$${windows.path/ws|property}END"), (Matcher)StringExpanderTests.is((Object)"START${windows.path/ws|property}END"));
    }

    @Test
    public void testEscapedPathFilterUnescaped() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START$${windows.path/ws|property}${windows.path/ws|property}END"), (Matcher)StringExpanderTests.is((Object)"START${windows.path/ws|property}C:\\\\develop\\\\java-latest\\\\wsEND"));
    }

    @Test
    public void testBase64FilterTextWithDefaultEncoding() throws Exception {
        String base64 = XMLTypeFactory.eINSTANCE.convertBase64Binary("CAFEBABE".getBytes(Charset.defaultCharset()));
        MatcherAssert.assertThat((Object)this.expander.expandString("START${text.ascii|base64}END"), (Matcher)StringExpanderTests.is((Object)("START" + base64 + "END")));
    }

    @Test
    public void testBase64FilterTextWithExplicitEncoding() throws Exception {
        MatcherAssert.assertThat((Object)this.expander.expandString("START${text.extended|base64.iso-8859-1}END"), (Matcher)StringExpanderTests.is((Object)"STARTx8Teyd/F38s=END"));
        MatcherAssert.assertThat((Object)this.expander.expandString("START${text.extended|base64.utf-8}END"), (Matcher)StringExpanderTests.is((Object)"STARTw4fDhMOew4nDn8OFw5/Diw==END"));
    }

    @Test
    public void testBase64FilterXmlWithDefaultEncoding() throws Exception {
        String expected = "STARTPD94bWwgdmVyc2lvbj0iMS4wIj8+DQo8cm9vdCBpZD0idTEyMyI+DQoJPGNoaWxkPkNBRkVCQUJFPC9jaGlsZD4NCjwvcm9vdD4=END";
        MatcherAssert.assertThat((Object)this.expander.expandString("START${xml.default|base64}END"), (Matcher)StringExpanderTests.is((Object)expected));
        MatcherAssert.assertThat((Object)this.expander.expandString("START${xml.default|base64.iso-8859-1}END"), (Matcher)StringExpanderTests.is((Object)expected));
    }

    @Test
    public void testBase64FilterXmlWithExplicitEncoding() throws Exception {
        String expected = "STARTPD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iSVNPLTg4NTktMSI/Pg0KPHJvb3QgaWQ9IrW5srMiPg0KCTxjaGlsZD7HxN7J38XfyzwvY2hpbGQ+DQo8L3Jvb3Q+END";
        MatcherAssert.assertThat((Object)this.expander.expandString("START${xml.iso-8859-1|base64}END"), (Matcher)StringExpanderTests.is((Object)expected));
        MatcherAssert.assertThat((Object)this.expander.expandString("START${xml.iso-8859-1|base64.utf-8}END"), (Matcher)StringExpanderTests.is((Object)expected));
    }

    private static final class WindowsStringExpander
    extends StringExpander {
        private final Map<String, String> variables = new HashMap<String, String>();

        public WindowsStringExpander() {
            this.variables.put("windows.path", "C:\\develop\\java-latest");
            this.variables.put("unix.path", "/develop/java-latest");
            this.variables.put("user.name", "stepper");
            this.variables.put("text.ascii", "CAFEBABE");
            this.variables.put("text.extended", "\u00c7\u00c4\u00de\u00c9\u00df\u00c5\u00df\u00cb");
            this.variables.put("xml.default", "<?xml version=\"1.0\"?>\r\n<root id=\"u123\">\r\n\t<child>CAFEBABE</child>\r\n</root>");
            this.variables.put("xml.iso-8859-1", "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\r\n<root id=\"\u00b5\u00b9\u00b2\u00b3\">\r\n\t<child>\u00c7\u00c4\u00de\u00c9\u00df\u00c5\u00df\u00cb</child>\r\n</root>");
        }

        protected String getFileSeparator() {
            return "\\";
        }

        protected String resolve(String key) {
            return this.variables.get(key);
        }

        protected boolean isUnexpanded(String key) {
            return !this.variables.containsKey(key);
        }

        protected String filter(String value, String filterName) {
            return StringFilterRegistry.INSTANCE.filter(value, filterName);
        }
    }
}

