/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.maven.util;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;

public class ConvertM2RepositoryToUTF8Handler
extends AbstractHandler {
    private static final Pattern ISO_LATIN = Pattern.compile("^([^>]+encoding=['\"])ISO-8859-1(['\"])", 2);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Path m2 = Path.of(System.getProperty("user.home"), new String[0]).resolve(".m2");
        if (Files.isDirectory(m2, new LinkOption[0])) {
            try {
                Files.walkFileTree(m2, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (file.getFileName().toString().endsWith(".pom")) {
                            try {
                                String string = Files.readString(file, StandardCharsets.ISO_8859_1);
                                Matcher matcher = ISO_LATIN.matcher(string);
                                if (matcher.find()) {
                                    System.out.println("Converting " + String.valueOf(file));
                                    String utf8 = matcher.replaceFirst("$1UTF-8$2");
                                    Files.writeString(file, (CharSequence)utf8, StandardCharsets.UTF_8, new OpenOption[0]);
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        return super.visitFile(file, attrs);
                    }
                });
            }
            catch (IOException ex) {
                throw new ExecutionException(ex.getMessage(), (Throwable)ex);
            }
        }
        return null;
    }
}

