/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.entity;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.HttpEntityWrapper;
import org.apache.hc.core5.util.Args;

public final class DeflateCompressingEntity
extends HttpEntityWrapper {
    private static final String DEFLATE_CODEC = "deflate";

    public DeflateCompressingEntity(HttpEntity entity) {
        super(entity);
    }

    public String getContentEncoding() {
        return DEFLATE_CODEC;
    }

    public long getContentLength() {
        return -1L;
    }

    public boolean isChunked() {
        return true;
    }

    public InputStream getContent() throws IOException {
        throw new UnsupportedOperationException("getContent() not supported");
    }

    public void writeTo(OutputStream out) throws IOException {
        Args.notNull((Object)out, (String)"Output stream");
        try (DeflaterOutputStream deflater = new DeflaterOutputStream(out, new Deflater(-1, false));){
            super.writeTo((OutputStream)deflater);
        }
    }
}

