/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.Optional;
import java.util.StringTokenizer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFileManager;
import org.eclipse.swt.internal.cocoa.NSMenu;
import org.eclipse.swt.internal.cocoa.NSMenuItem;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSOpenPanel;
import org.eclipse.swt.internal.cocoa.NSPopUpButton;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSavePanel;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSURL;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTOpenSavePanelDelegate;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FileDialog
extends Dialog {
    Callback callback_completion_handler;
    Callback callback_overwrite_existing_file;
    Callback callback_performKeyEquivalent;
    NSSavePanel panel;
    NSPopUpButton popup;
    String[] filterNames = new String[0];
    String[] filterExtensions = new String[0];
    String[] fileNames = new String[0];
    String filterPath = "";
    String fileName = "";
    String fullPath;
    SWTOpenSavePanelDelegate delegate = null;
    int filterIndex = -1;
    long jniRef = 0L;
    long method_overwriteExistingFileCheck = 0L;
    long methodImpl_overwriteExistingFileCheck = 0L;
    long method_performKeyEquivalent = 0L;
    long methodImpl_performKeyEquivalent = 0L;
    static final char EXTENSION_SEPARATOR = ';';
    private String selectedExtension;
    boolean overwrite;

    public FileDialog(Shell parent) {
        this(parent, 65536);
    }

    public FileDialog(Shell parent, int style) {
        super(parent, FileDialog.checkStyle(parent, style));
        boolean bl = this.overwrite = OS.VERSION >= OS.VERSION(10, 15, 0);
        if (Display.getSheetEnabled() && parent != null && (style & 0x10000000) != 0) {
            this.style |= 0x10000000;
        }
        this.checkSubclass();
    }

    long _completionHandler(long result) {
        this.handleResponse(result);
        return result;
    }

    long _overwriteExistingFileCheck(long id2, long sel, long str) {
        return 1L;
    }

    long _performKeyEquivalent(long id2, long sel, long event) {
        boolean result = false;
        NSEvent nsEvent = new NSEvent(event);
        NSWindow window = nsEvent.window();
        if (window != null) {
            result = this.parent.display.performKeyEquivalent(window, nsEvent);
        }
        return result ? 1 : 0;
    }

    private NSString appendSelectedExtension(NSString filename) {
        String extension = this.getSelectedExtension();
        if (filename != null && extension != null) {
            NSString ext = filename.pathExtension();
            if (ext == null || ext.length() == 0L) {
                filename = filename.stringByAppendingPathExtension(NSString.stringWith(extension));
            } else if (!ext.getString().equalsIgnoreCase(extension)) {
                NSString newFilename;
                NSString originalName = filename.stringByDeletingPathExtension();
                filename = newFilename = originalName.stringByAppendingPathExtension(NSString.stringWith(extension));
            }
        }
        return filename;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public int getFilterIndex() {
        return this.filterIndex;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    private String getSelectedExtension() {
        return this.selectedExtension;
    }

    private NSMutableArray getSelectedExtensions() {
        int filterIndex;
        int n = filterIndex = this.popup != null ? (int)this.popup.indexOfSelectedItem() : -1;
        if (this.filterExtensions != null && this.filterExtensions.length != 0 && filterIndex >= 0 && filterIndex < this.filterExtensions.length) {
            String[] stringArray;
            String exts = this.filterExtensions[filterIndex];
            int index = exts.indexOf(59);
            if (index != -1) {
                stringArray = exts.split(";");
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = exts;
            }
            String[] extensions = stringArray;
            int length = extensions.length;
            NSMutableArray allowedFileTypes = NSMutableArray.arrayWithCapacity(length);
            int j = length - 1;
            while (j >= 0) {
                String ext = extensions[j];
                String filter = ext.trim();
                if (!filter.equals("*") && !filter.equals("*.*")) {
                    if (filter.startsWith("*.")) {
                        filter = filter.substring(2);
                    } else if (filter.startsWith(".")) {
                        filter = filter.substring(1);
                    }
                    this.selectedExtension = filter;
                    int i = filter.lastIndexOf(".");
                    if (i != -1 && i + 1 < filter.length()) {
                        filter = filter.substring(i + 1);
                    }
                } else {
                    this.selectedExtension = null;
                    return null;
                }
                allowedFileTypes.insertObject(NSString.stringWith(filter), 0L);
                --j;
            }
            return allowedFileTypes;
        }
        return null;
    }

    void handleResponse(long response) {
        if (this.parent != null && (this.style & 0x10000000) != 0) {
            NSApplication.sharedApplication().stopModal();
        }
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        display.setModalDialog(null);
        this.filterIndex = this.popup != null ? (int)this.popup.indexOfSelectedItem() : -1;
        this.fullPath = null;
        if (response == 1L) {
            NSString filename = this.panel.filename();
            if ((this.style & 0x2000) != 0) {
                this.fullPath = filename.getString();
                this.fileNames = new String[1];
                this.fileName = this.fileNames[0] = filename.lastPathComponent().getString();
                this.filterPath = filename.stringByDeletingLastPathComponent().getString();
            } else {
                this.fullPath = filename.getString();
                NSArray filenames = ((NSOpenPanel)this.panel).filenames();
                int count = (int)filenames.count();
                this.fileNames = new String[count];
                int i = 0;
                while (i < count) {
                    filename = new NSString(filenames.objectAtIndex(i));
                    NSString filenameOnly = filename.lastPathComponent();
                    NSString pathOnly = filename.stringByDeletingLastPathComponent();
                    if (i == 0) {
                        this.filterPath = pathOnly.getString();
                        this.fileName = this.fileNames[0] = filenameOnly.getString();
                    } else {
                        this.fileNames[i] = pathOnly.getString().equals(this.filterPath) ? filenameOnly.getString() : filename.getString();
                    }
                    ++i;
                }
            }
        }
        this.releaseHandles();
        if (response != 1L && response != 0L) {
            throw new SWTException(51);
        }
    }

    public String open() {
        try {
            return this.openDialog().orElse(null);
        }
        catch (SWTException e) {
            if (e.code == 51) {
                return null;
            }
            throw e;
        }
    }

    public Optional<String> openDialog() {
        this.fullPath = null;
        if ((this.style & 0x2000) != 0) {
            NSSavePanel savePanel = NSSavePanel.savePanel();
            if (savePanel == null) {
                this.error(51);
            }
            this.panel = savePanel;
            if (!this.overwrite) {
                this.callback_overwrite_existing_file = new Callback(this, "_overwriteExistingFileCheck", 3);
                long proc = this.callback_overwrite_existing_file.getAddress();
                this.method_overwriteExistingFileCheck = OS.class_getInstanceMethod(OS.class_NSSavePanel, OS.sel_overwriteExistingFileCheck);
                if (this.method_overwriteExistingFileCheck != 0L) {
                    this.methodImpl_overwriteExistingFileCheck = OS.method_setImplementation(this.method_overwriteExistingFileCheck, proc);
                }
            }
        } else {
            NSOpenPanel openPanel = NSOpenPanel.openPanel();
            if (openPanel == null) {
                this.error(51);
            }
            openPanel.setAllowsMultipleSelection((this.style & 2) != 0);
            this.panel = openPanel;
        }
        this.callback_performKeyEquivalent = new Callback(this, "_performKeyEquivalent", 3);
        long proc = this.callback_performKeyEquivalent.getAddress();
        this.method_performKeyEquivalent = OS.class_getInstanceMethod(OS.class_NSSavePanel, OS.sel_performKeyEquivalent_);
        if (this.method_performKeyEquivalent != 0L) {
            this.methodImpl_performKeyEquivalent = OS.method_setImplementation(this.method_performKeyEquivalent, proc);
        }
        this.panel.setCanCreateDirectories(true);
        this.panel.setTitle(NSString.stringWith(this.title != null ? this.title : ""));
        if (this.filterPath != null && this.filterPath.length() > 0) {
            NSString dir = NSString.stringWith(this.filterPath);
            this.panel.setDirectoryURL(NSURL.fileURLWithPath(dir));
        }
        if (this.fileName != null && this.fileName.length() > 0) {
            this.panel.setNameFieldStringValue(NSString.stringWith(this.fileName));
        }
        this.jniRef = 0L;
        this.delegate = null;
        if (this.filterExtensions != null && this.filterExtensions.length != 0) {
            this.delegate = (SWTOpenSavePanelDelegate)new SWTOpenSavePanelDelegate().alloc().init();
            this.jniRef = OS.NewGlobalRef(this);
            if (this.jniRef == 0L) {
                this.error(2);
            }
            OS.object_setInstanceVariable(this.delegate.id, Display.SWT_OBJECT, this.jniRef);
            this.panel.setDelegate(this.delegate);
            NSPopUpButton widget = (NSPopUpButton)new NSPopUpButton().alloc();
            widget.initWithFrame(new NSRect(), false);
            widget.setTarget(this.delegate);
            widget.setAction(OS.sel_sendSelection_);
            NSMenu menu = widget.menu();
            menu.setAutoenablesItems(false);
            int i = 0;
            while (i < this.filterExtensions.length) {
                String str = this.filterExtensions[i];
                if (this.filterNames != null && this.filterNames.length > i) {
                    str = this.filterNames[i];
                }
                NSMenuItem nsItem = (NSMenuItem)new NSMenuItem().alloc();
                nsItem.initWithTitle(NSString.stringWith(str), 0L, NSString.string());
                menu.addItem(nsItem);
                nsItem.release();
                ++i;
            }
            int selectionIndex = this.filterIndex >= 0 && this.filterIndex < this.filterExtensions.length ? this.filterIndex : 0;
            widget.selectItemAtIndex(selectionIndex);
            widget.sizeToFit();
            this.panel.setAccessoryView(widget);
            this.popup = widget;
            this.panel.setTreatsFilePackagesAsDirectories(this.shouldTreatAppAsDirectory(this.filterExtensions[selectionIndex]));
            if ((this.style & 0x2000) != 0) {
                NSMutableArray extensions = this.getSelectedExtensions();
                if (extensions != null) {
                    this.panel.setAllowedFileTypes(extensions);
                }
                this.panel.setAllowsOtherFileTypes(true);
            } else if (OS.VERSION >= OS.VERSION(10, 11, 0)) {
                ((NSOpenPanel)this.panel).setAccessoryViewDisclosed(true);
            }
        } else {
            this.panel.setTreatsFilePackagesAsDirectories(false);
        }
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        display.setModalDialog(this, this.panel);
        if (this.parent != null && (this.style & 0x10000000) != 0) {
            this.callback_completion_handler = new Callback(this, "_completionHandler", 1);
            long handler = this.callback_completion_handler.getAddress();
            OS.beginSheetModalForWindow(this.panel, this.parent.view.window(), handler);
            NSApplication.sharedApplication().runModalForWindow(this.parent.view.window());
        } else {
            long response = this.panel.runModal();
            this.handleResponse(response);
        }
        return Optional.ofNullable(this.fullPath);
    }

    long panel_shouldEnableURL(long id2, long sel, long arg0, long arg1) {
        if ((this.style & 0x2000) != 0) {
            return 1L;
        }
        NSURL url = new NSURL(arg1);
        NSString path = url.path();
        if (this.filterExtensions != null && this.filterExtensions.length != 0) {
            NSFileManager manager = NSFileManager.defaultManager();
            long ptr = C.malloc(1L);
            boolean found = manager.fileExistsAtPath(path, ptr);
            byte[] isDirectory = new byte[1];
            C.memmove(isDirectory, ptr, 1L);
            C.free(ptr);
            if (found) {
                if (isDirectory[0] != 0) {
                    return 1L;
                }
                if (this.popup != null) {
                    String fileName = path.lastPathComponent().getString();
                    int filterIndex = (int)this.popup.indexOfSelectedItem();
                    String extensions = this.filterExtensions[filterIndex];
                    int start = 0;
                    int length = extensions.length();
                    while (start < length) {
                        String filter;
                        int index = extensions.indexOf(59, start);
                        if (index == -1) {
                            index = length;
                        }
                        if ((filter = extensions.substring(start, index).trim()).equalsIgnoreCase(fileName)) {
                            return 1L;
                        }
                        if (filter.equals("*") || filter.equals("*.*")) {
                            return 1L;
                        }
                        if (filter.startsWith("*.")) {
                            filter = filter.substring(2);
                        } else if (filter.startsWith(".")) {
                            filter = filter.substring(1);
                        }
                        if (fileName.toLowerCase().endsWith("." + filter.toLowerCase())) {
                            return 1L;
                        }
                        start = index + 1;
                    }
                    return 0L;
                }
            }
        }
        return 1L;
    }

    long panel_userEnteredFilename_confirmed(long id2, long sel, long sender, long filename, long okFlag) {
        if (okFlag == 0L) {
            return filename;
        }
        NSString filenameWithExtension = new NSString(filename);
        filenameWithExtension = this.appendSelectedExtension(filenameWithExtension);
        return filenameWithExtension.id;
    }

    void releaseHandles() {
        if (!this.overwrite) {
            if (this.method_overwriteExistingFileCheck != 0L) {
                OS.method_setImplementation(this.method_overwriteExistingFileCheck, this.methodImpl_overwriteExistingFileCheck);
            }
            if (this.callback_overwrite_existing_file != null) {
                this.callback_overwrite_existing_file.dispose();
            }
            this.callback_overwrite_existing_file = null;
        }
        if (this.method_performKeyEquivalent != 0L) {
            OS.method_setImplementation(this.method_performKeyEquivalent, this.methodImpl_performKeyEquivalent);
        }
        if (this.callback_performKeyEquivalent != null) {
            this.callback_performKeyEquivalent.dispose();
        }
        this.callback_performKeyEquivalent = null;
        if (this.callback_completion_handler != null) {
            this.callback_completion_handler.dispose();
            this.callback_completion_handler = null;
        }
        if (this.popup != null) {
            this.panel.setAccessoryView(null);
            this.popup.release();
            this.popup = null;
        }
        if (this.delegate != null) {
            this.panel.setDelegate(null);
            this.delegate.release();
            this.delegate = null;
        }
        if (this.jniRef != 0L) {
            OS.DeleteGlobalRef(this.jniRef);
        }
        this.jniRef = 0L;
        this.panel = null;
    }

    void sendSelection(long id2, long sel, long arg) {
        if (this.filterExtensions != null && this.filterExtensions.length > 0) {
            String fileTypes = this.filterExtensions[(int)this.popup.indexOfSelectedItem()];
            this.panel.setTreatsFilePackagesAsDirectories(this.shouldTreatAppAsDirectory(fileTypes));
            if ((this.style & 0x2000) != 0) {
                this.panel.setAllowedFileTypes(this.getSelectedExtensions());
                return;
            }
        }
        this.panel.validateVisibleColumns();
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setFilterExtensions(String[] extensions) {
        this.filterExtensions = extensions;
    }

    public void setFilterIndex(int index) {
        this.filterIndex = index;
    }

    public void setFilterNames(String[] names) {
        this.filterNames = names;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = OS.VERSION >= OS.VERSION(10, 15, 0) ? true : overwrite;
    }

    boolean shouldTreatAppAsDirectory(String extensions) {
        if ((this.style & 0x2000) != 0) {
            return false;
        }
        StringTokenizer fileTypesToken = new StringTokenizer(extensions, String.valueOf(';'));
        while (fileTypesToken.hasMoreTokens()) {
            String fileType = fileTypesToken.nextToken();
            if (fileType.equals("*") || fileType.equals("*.*")) {
                return true;
            }
            if (!fileType.equals("*.app") && !fileType.equals(".app")) continue;
            return false;
        }
        return true;
    }
}

