/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.zephyr;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;
import org.eclipse.rcptt.internal.zephyr.ZephyrRestClient;

public final class ZephyrProject {
    private static final String URL_GET_PROJECTS = "%s/rest/api/2/issue/createmeta";
    private static final String TEST_ISSSUETYPE_NAME = "Test";

    public static Map<String, Long> getAllProjects(ZephyrRestClient restClient) {
        HashMap<String, Long> projects;
        block18: {
            projects = new HashMap<String, Long>();
            String url = String.format(URL_GET_PROJECTS, restClient.getUrl());
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (CloseableHttpResponse response = restClient.get(url);){
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode >= 200 && statusCode < 300) {
                        HttpEntity entity = response.getEntity();
                        String string = null;
                        try {
                            string = EntityUtils.toString((HttpEntity)entity);
                        }
                        catch (IOException | ParseException e) {
                            throw new IllegalArgumentException(String.format("Bad response entity upon receipt of projects <%s>", url), e);
                        }
                        JsonObject projObject = new JsonParser().parse(string).getAsJsonObject();
                        JsonArray projArray = projObject.get("projects").getAsJsonArray();
                        int i = 0;
                        while (i < projArray.size()) {
                            JsonObject project = projArray.get(i).getAsJsonObject();
                            Long id = project.get("id").getAsLong();
                            String projName = project.get("name").getAsString();
                            JsonArray issueTypes = project.get("issuetypes").getAsJsonArray();
                            boolean issueTypeTesstExists = false;
                            int j = 0;
                            while (j < issueTypes.size()) {
                                JsonObject issueType = issueTypes.get(j).getAsJsonObject();
                                String issueTypeName = issueType.get("name").getAsString();
                                if (issueTypeName.trim().equalsIgnoreCase(TEST_ISSSUETYPE_NAME)) {
                                    issueTypeTesstExists = true;
                                    break;
                                }
                                ++j;
                            }
                            if (issueTypeTesstExists) {
                                projects.put(projName, id);
                            }
                            ++i;
                        }
                        break block18;
                    }
                    throw new IllegalArgumentException(String.format("Unexpected response status <%s> upon receipt of projects <%s>", statusCode, url));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return projects;
    }

    public static Long getProjectIdByName(String projectName, ZephyrRestClient restClient) {
        Map<String, Long> projects = ZephyrProject.getAllProjects(restClient);
        Long projectId = projects.get(projectName);
        if (projectId == null) {
            throw new IllegalArgumentException(String.format("Project <%s> not found among <%s>", projectName, String.join((CharSequence)", ", projects.keySet())));
        }
        return projectId;
    }
}

