/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core;

import java.util.Map;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.rcptt.core.Q7Features;
import org.eclipse.rcptt.tesla.core.TeslaFeatures;
import org.eclipse.rcptt.tesla.core.utils.AbstractFeatureManager;

public class OptionsHandler {
    private AbstractFeatureManager[] featureManagers = new AbstractFeatureManager[]{TeslaFeatures.getInstance(), Q7Features.getInstance()};
    protected final String TEST_EXEC_TIMEOUT = "testExecTimeout";
    protected final String RESTART_AUT_ON_FAILURE = "restartAUTOnFailure";

    public void applyOptions(Map<String, String> options) {
        for (Map.Entry<String, String> option : options.entrySet()) {
            this.applyOption(option.getKey(), option.getValue());
        }
    }

    public void applyOptions(EMap<String, String> options) {
        for (Map.Entry option : options.entrySet()) {
            this.applyOption((String)option.getKey(), (String)option.getValue());
        }
    }

    public void applyOption(String key, String value) {
        if (this.handleSpecialOption(key, value)) {
            return;
        }
        String suffix = this.guessSuffix(key);
        AbstractFeatureManager[] abstractFeatureManagerArray = this.featureManagers;
        int n = this.featureManagers.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractFeatureManager manager = abstractFeatureManagerArray[n2];
            String featureName = OptionsHandler.guessFeature(manager, suffix);
            if (featureName != null) {
                manager.getOption(featureName).setValue(value);
                System.out.println(String.format("%s set to %s", featureName, value));
                break;
            }
            ++n2;
        }
    }

    private static String guessFeature(AbstractFeatureManager manager, String suffix) {
        String[] stringArray = manager.getOptionNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.endsWith(suffix)) {
                return name;
            }
            ++n2;
        }
        return null;
    }

    private String guessSuffix(String value) {
        StringBuilder sb = new StringBuilder();
        char[] cArray = value.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (Character.isUpperCase(ch)) {
                sb.append(".");
                sb.append(Character.toLowerCase(ch));
            } else {
                sb.append(ch);
            }
            ++n2;
        }
        return sb.toString();
    }

    protected boolean handleSpecialOption(String key, String value) {
        return false;
    }
}

