/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.verifications.tree;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CollapseType implements Enumerator
{
    AS_IS(0, "AS_IS", "As is"),
    EXPAND_ALL(1, "EXPAND_ALL", "Expand all"),
    COLLAPSE_ALL(2, "COLLAPSE_ALL", "Collapse all");

    public static final int AS_IS_VALUE = 0;
    public static final int EXPAND_ALL_VALUE = 1;
    public static final int COLLAPSE_ALL_VALUE = 2;
    private static final CollapseType[] VALUES_ARRAY;
    public static final List<CollapseType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CollapseType[]{AS_IS, EXPAND_ALL, COLLAPSE_ALL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CollapseType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CollapseType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CollapseType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CollapseType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CollapseType get(int value) {
        switch (value) {
            case 0: {
                return AS_IS;
            }
            case 1: {
                return EXPAND_ALL;
            }
            case 2: {
                return COLLAPSE_ALL;
            }
        }
        return null;
    }

    private CollapseType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

