/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spin;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.parser.ParsedBooleanQuery;
import org.eclipse.rdf4j.query.parser.ParsedGraphQuery;
import org.eclipse.rdf4j.query.parser.ParsedOperation;
import org.eclipse.rdf4j.query.parser.ParsedTupleQuery;
import org.eclipse.rdf4j.query.parser.ParsedUpdate;
import org.eclipse.rdf4j.spin.Argument;
import org.eclipse.rdf4j.spin.MalformedSpinException;
import org.eclipse.rdf4j.spin.ParsedBooleanTemplate;
import org.eclipse.rdf4j.spin.ParsedGraphTemplate;
import org.eclipse.rdf4j.spin.ParsedTupleTemplate;
import org.eclipse.rdf4j.spin.ParsedUpdateTemplate;

public class Template {
    private final IRI IRI;
    private ParsedOperation parsedOp;
    private final List<Argument> arguments = new ArrayList<Argument>(4);

    public Template(IRI IRI2) {
        this.IRI = IRI2;
    }

    public IRI getUri() {
        return this.IRI;
    }

    public void setParsedOperation(ParsedOperation op) {
        this.parsedOp = op;
    }

    public ParsedOperation getParsedOperation() {
        return this.parsedOp;
    }

    public void addArgument(Argument arg) {
        this.arguments.add(arg);
    }

    public List<Argument> getArguments() {
        return this.arguments;
    }

    public ParsedOperation call(Map<IRI, Value> argValues) throws MalformedSpinException {
        ParsedOperation callOp;
        MapBindingSet args = new MapBindingSet();
        for (Argument arg : this.arguments) {
            IRI argPred = arg.getPredicate();
            Value argValue = argValues.get(argPred);
            if (argValue == null && !arg.isOptional()) {
                throw new MalformedSpinException("Missing value for template argument: " + String.valueOf(argPred));
            }
            if (argValue == null) {
                argValue = arg.getDefaultValue();
            }
            if (argValue == null) continue;
            args.addBinding(argPred.getLocalName(), argValue);
        }
        if (this.parsedOp instanceof ParsedBooleanQuery) {
            callOp = new ParsedBooleanTemplate(this, args);
        } else if (this.parsedOp instanceof ParsedTupleQuery) {
            callOp = new ParsedTupleTemplate(this, args);
        } else if (this.parsedOp instanceof ParsedGraphQuery) {
            callOp = new ParsedGraphTemplate(this, args);
        } else if (this.parsedOp instanceof ParsedUpdate) {
            callOp = new ParsedUpdateTemplate(this, args);
        } else {
            throw new AssertionError((Object)("Unrecognised ParsedOperation: " + String.valueOf(this.parsedOp.getClass())));
        }
        return callOp;
    }

    public String toString() {
        return String.valueOf(this.IRI) + "(" + Joiner.on((String)", ").join(this.arguments) + ")";
    }
}

