/*
 * Decompiled with CFR 0.152.
 */
package no.hasmac.jsonld.context;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public final class InverseContext {
    private final Map<String, Map<String, Map<String, Map<String, String>>>> context = new LinkedHashMap<String, Map<String, Map<String, Map<String, String>>>>();

    private void set(String variable, String container, String type, String key, String value) {
        this.context.computeIfAbsent(variable, x -> new LinkedHashMap()).computeIfAbsent(container, x -> new LinkedHashMap()).computeIfAbsent(type, x -> new LinkedHashMap()).put(key, value);
    }

    private boolean doesNotContain(String variable, String container, String type, String key) {
        Map<String, String> stringStringMap;
        Map<String, Map<String, String>> stringMapMap1;
        Map<String, Map<String, Map<String, String>>> stringMapMap = this.context.get(variable);
        if (stringMapMap != null && (stringMapMap1 = stringMapMap.get(container)) != null && (stringStringMap = stringMapMap1.get(type)) != null) {
            return !stringStringMap.containsKey(key);
        }
        return true;
    }

    public boolean contains(String variable) {
        return this.context.containsKey(variable);
    }

    public boolean contains(String variable, String container, String type) {
        Map<String, Map<String, String>> stringMapMap1;
        Map<String, Map<String, Map<String, String>>> stringMapMap = this.context.get(variable);
        if (stringMapMap != null && (stringMapMap1 = stringMapMap.get(container)) != null) {
            return stringMapMap1.containsKey(type);
        }
        return false;
    }

    public boolean contains(String variable, String container, String type, String key) {
        return this.contains(variable) && this.context.get(variable).containsKey(container) && this.context.get(variable).get(container).containsKey(type) && this.context.get(variable).get(container).get(type).containsKey(key);
    }

    public InverseContext setIfAbsent(String variable, String container, String type, String key, String value) {
        if (this.doesNotContain(variable, container, type, key)) {
            this.set(variable, container, type, key, value);
        }
        return this;
    }

    public Optional<String> get(String variable, String container, String type, String key) {
        if (this.doesNotContain(variable, container, type, key)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.context.get(variable).get(container).get(type).get(key));
    }

    public String getNullable(String variable, String container, String type, String key) {
        Map<String, Map<String, Map<String, String>>> map1 = this.context.get(variable);
        if (map1 == null) {
            return null;
        }
        Map<String, Map<String, String>> map2 = map1.get(container);
        if (map2 == null) {
            return null;
        }
        Map<String, String> map3 = map2.get(type);
        if (map3 == null) {
            return null;
        }
        return map3.get(key);
    }

    public Map<String, String> getNullable(String variable, String container, String type) {
        Map<String, Map<String, Map<String, String>>> map1 = this.context.get(variable);
        if (map1 == null) {
            return null;
        }
        Map<String, Map<String, String>> map2 = map1.get(container);
        if (map2 == null) {
            return null;
        }
        return map2.get(type);
    }
}

