/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.elsa;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import org.mapdb.elsa.ElsaSerializerPojo;
import org.mapdb.elsa.ElsaUtil;

final class ObjectInputStream2
extends ObjectInputStream {
    private ElsaSerializerPojo serializerPojo;
    private ObjectStreamClass lastDescriptor;
    private Class lastDescriptorClass;

    protected ObjectInputStream2(ElsaSerializerPojo serializerPojo, InputStream in) throws IOException, SecurityException {
        super(in);
        this.serializerPojo = serializerPojo;
    }

    @Override
    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        ObjectStreamClass descriptor;
        int classId = ElsaUtil.unpackInt(this);
        String className = classId == -1 ? this.readUTF() : this.serializerPojo.classInfoResolver.getClassInfo((int)classId).name;
        Class<?> clazz = this.serializerPojo.loadClass(className);
        this.lastDescriptor = descriptor = ObjectStreamClass.lookup(clazz);
        this.lastDescriptorClass = clazz;
        return descriptor;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        if (desc == this.lastDescriptor) {
            return this.lastDescriptorClass;
        }
        Class<?> clazz = this.serializerPojo.loadClass(desc.getName());
        if (clazz != null) {
            return clazz;
        }
        return super.resolveClass(desc);
    }
}

