/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.impl.AbstractMemoryOverflowModel;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.base.SailStore;
import org.eclipse.rdf4j.sail.nativerdf.SailSourceModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class MemoryOverflowModel
extends AbstractMemoryOverflowModel<SailSourceModel> {
    private static final long serialVersionUID = 4119844228099208169L;
    final Logger logger = LoggerFactory.getLogger(MemoryOverflowModel.class);
    private volatile LinkedHashModel memory;
    private transient File dataDir;
    private transient SailStore store;

    MemoryOverflowModel() {
    }

    protected abstract SailStore createSailStore(File var1) throws IOException, SailException;

    @Override
    protected void overflowToDiskInner(Model memory) {
        try {
            assert (this.disk == null);
            this.dataDir = Files.createTempDirectory("model", new FileAttribute[0]).toFile();
            this.logger.debug("memory overflow using temp directory {}", (Object)this.dataDir);
            this.store = this.createSailStore(this.dataDir);
            this.disk = new SailSourceModel(this.store, memory);
            this.logger.debug("overflow synced to disk");
        }
        catch (IOException | SailException e) {
            String path = this.dataDir != null ? this.dataDir.getAbsolutePath() : "(unknown)";
            this.logger.error("Error while writing to overflow directory " + path, (Throwable)e);
        }
    }
}

