/*
 * Decompiled with CFR 0.152.
 */
package no.hasmac.jsonld.http.media;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.IntPredicate;
import no.hasmac.jsonld.StringUtils;
import no.hasmac.jsonld.http.HttpAlphabet;
import no.hasmac.jsonld.http.media.MediaType;
import no.hasmac.jsonld.http.media.MediaTypeParameters;

final class MediaTypeParser {
    protected static final IntPredicate NAME_FIRST = ch -> ch >= 48 && ch <= 57 || ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90;
    protected static final IntPredicate NAME_CHARS = ch -> ch >= 48 && ch <= 57 || ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90 || ch == 33 || ch == 35 || ch == 36 || ch == 38 || ch == 45 || ch == 94 || ch == 95 || ch == 46 || ch == 43;
    private final char[] input;

    public MediaTypeParser(String input) {
        this.input = input.toCharArray();
    }

    public MediaType parse() {
        State state = State.INIT;
        String type = null;
        String subtype = null;
        String paramName = null;
        StringBuilder stringValue = new StringBuilder();
        LinkedHashMap<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        int index = -1;
        block16: for (int i = 0; i < this.input.length; ++i) {
            char ch = this.input[i];
            switch (state.ordinal()) {
                case 0: {
                    if (HttpAlphabet.WHITESPACE.test(ch)) continue block16;
                    if (NAME_FIRST.test(ch)) {
                        state = State.TYPE;
                        index = i;
                        continue block16;
                    }
                    return null;
                }
                case 1: {
                    if (NAME_CHARS.test(ch)) continue block16;
                    if (ch == '/') {
                        type = StringUtils.strip(String.valueOf(this.input, index, i - index));
                        state = State.SUBTYPE;
                        index = i + 1;
                        continue block16;
                    }
                    return null;
                }
                case 2: {
                    if (i == index && NAME_FIRST.test(ch) || i > index && NAME_CHARS.test(ch)) continue block16;
                    if (ch == ';') {
                        subtype = StringUtils.strip(String.valueOf(this.input, index, i - index));
                        state = State.PARAM_NAME;
                        index = i + 1;
                        continue block16;
                    }
                    if (HttpAlphabet.WHITESPACE.test(ch)) {
                        subtype = StringUtils.strip(String.valueOf(this.input, index, i - index));
                        state = State.PARAMS;
                        continue block16;
                    }
                    return null;
                }
                case 3: {
                    if (HttpAlphabet.WHITESPACE.test(ch)) continue block16;
                    if (ch != ';') {
                        return new MediaType(type, subtype, new MediaTypeParameters(params));
                    }
                    state = State.PARAM_NAME;
                    index = i + 1;
                    continue block16;
                }
                case 4: {
                    if (ch == '=') {
                        paramName = StringUtils.strip(String.valueOf(this.input, index, i - index)).toLowerCase();
                        state = State.PARAM_VALUE;
                        continue block16;
                    }
                    if (ch != ';') continue block16;
                    paramName = StringUtils.strip(String.valueOf(this.input, index, i - index)).toLowerCase();
                    params.computeIfAbsent(paramName, p -> new ArrayList()).add(paramName);
                    index = i + 1;
                    continue block16;
                }
                case 5: {
                    if (Character.isSpaceChar(ch) || ch == '\t') continue block16;
                    if (ch == '\"') {
                        index = i + 1;
                        state = State.STRING_VALUE;
                        continue block16;
                    }
                    index = i;
                    state = State.LITERAL_VALUE;
                    continue block16;
                }
                case 7: {
                    if (ch != ';') continue block16;
                    params.computeIfAbsent(paramName, p -> new ArrayList()).add(StringUtils.strip(String.valueOf(this.input, index, i - index)));
                    index = i + 1;
                    paramName = null;
                    state = State.PARAM_NAME;
                    continue block16;
                }
                case 6: {
                    if (ch == '\"') {
                        params.computeIfAbsent(paramName, p -> new ArrayList()).add(stringValue.toString());
                        stringValue.setLength(0);
                        paramName = null;
                        state = State.PARAMS;
                        continue block16;
                    }
                    if (ch == '\\') {
                        state = State.ESCAPE;
                        continue block16;
                    }
                    stringValue.append(ch);
                    continue block16;
                }
                case 8: {
                    stringValue.append(ch);
                    state = State.STRING_VALUE;
                }
            }
        }
        switch (state.ordinal()) {
            case 2: {
                if (index >= this.input.length) break;
                subtype = StringUtils.strip(String.valueOf(this.input, index, this.input.length - index)).toLowerCase();
                break;
            }
            case 4: {
                if (index >= this.input.length) break;
                paramName = StringUtils.strip(String.valueOf(this.input, index, this.input.length - index)).toLowerCase();
                break;
            }
            case 7: {
                if (index >= this.input.length) break;
                params.computeIfAbsent(paramName, p -> new ArrayList()).add(StringUtils.strip(String.valueOf(this.input, index, this.input.length - index)));
                paramName = null;
                break;
            }
        }
        if (paramName != null) {
            if (stringValue.length() > 0) {
                params.computeIfAbsent(paramName, p -> new ArrayList()).add(stringValue.toString());
            } else {
                params.computeIfAbsent(paramName, p -> new ArrayList()).add(paramName);
            }
        }
        if (type == null || subtype == null) {
            return null;
        }
        return new MediaType(type, subtype, new MediaTypeParameters(params));
    }

    private static enum State {
        INIT,
        TYPE,
        SUBTYPE,
        PARAMS,
        PARAM_NAME,
        PARAM_VALUE,
        STRING_VALUE,
        LITERAL_VALUE,
        ESCAPE;

    }
}

