/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation.iterator;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.ConvertingIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.federated.algebra.StatementSource;
import org.eclipse.rdf4j.federated.algebra.StatementSourcePattern;
import org.eclipse.rdf4j.federated.endpoint.Endpoint;
import org.eclipse.rdf4j.federated.evaluation.FederationEvalStrategy;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.DescribeIteration;

public class FederatedDescribeIteration
extends DescribeIteration {
    private final QueryInfo queryInfo;
    private final List<StatementSource> allSources;

    public FederatedDescribeIteration(CloseableIteration<BindingSet> sourceIter, FederationEvalStrategy strategy, Set<String> describeExprNames, BindingSet parentBindings, QueryInfo queryInfo) {
        super(sourceIter, (EvaluationStrategy)strategy, describeExprNames, parentBindings);
        this.queryInfo = queryInfo;
        this.allSources = Lists.newArrayList();
        for (Endpoint member : queryInfo.getFederationContext().getFederation().getMembers()) {
            this.allSources.add(new StatementSource(member.getId(), StatementSource.StatementSourceType.REMOTE));
        }
    }

    protected CloseableIteration<BindingSet> createNextIteration(final Value subject, final Value object) throws QueryEvaluationException {
        if (subject == null && object == null) {
            return new EmptyIteration();
        }
        Var subjVar = Var.of((String)"subject", (Value)subject);
        Var predVar = Var.of((String)"predicate");
        Var objVar = Var.of((String)"object", (Value)object);
        StatementSourcePattern stmtSourcePattern = new StatementSourcePattern(new StatementPattern(subjVar, predVar, objVar), this.queryInfo);
        this.allSources.forEach(stmtSourcePattern::addStatementSource);
        CloseableIteration<BindingSet> res = stmtSourcePattern.evaluate(this.parentBindings);
        return new ConvertingIteration<BindingSet, BindingSet>(res){

            protected BindingSet convert(BindingSet sourceObject) throws QueryEvaluationException {
                QueryBindingSet bs = new QueryBindingSet(sourceObject);
                if (subject != null && !bs.hasBinding("subject")) {
                    bs.addBinding("subject", subject);
                }
                if (object != null && !bs.hasBinding("object")) {
                    bs.addBinding("object", object);
                }
                return bs;
            }
        };
    }

    protected void handleClose() throws QueryEvaluationException {
        try {
            super.handleClose();
        }
        finally {
            this.queryInfo.close();
        }
    }
}

