/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.volume;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.DBException;
import org.mapdb.volume.ByteBufferVol;
import org.mapdb.volume.ByteBufferVolSingle;
import org.mapdb.volume.FileChannelVol;
import org.mapdb.volume.Volume;
import org.mapdb.volume.VolumeFactory;

public final class MappedFileVolSingle
extends ByteBufferVolSingle {
    protected static final VolumeFactory FACTORY = new VolumeFactory(){

        @Override
        public Volume makeVolume(String file, boolean readOnly, long fileLockWait, int sliceShift, long initSize, boolean fixedSize) {
            if (initSize > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("startSize larger 2GB");
            }
            return new MappedFileVolSingle(new File(file), readOnly, fileLockWait, initSize, false);
        }

        @Override
        @NotNull
        public boolean exists(@Nullable String file) {
            return new File(file).exists();
        }

        @Override
        public boolean handlesReadonly() {
            return true;
        }
    };
    protected static final VolumeFactory FACTORY_WITH_CLEANER_HACK = new VolumeFactory(){

        @Override
        public Volume makeVolume(String file, boolean readOnly, long fileLockWait, int sliceShift, long initSize, boolean fixedSize) {
            if (initSize > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("startSize larger 2GB");
            }
            return new MappedFileVolSingle(new File(file), readOnly, fileLockWait, initSize, true);
        }

        @Override
        @NotNull
        public boolean exists(@Nullable String file) {
            return new File(file).exists();
        }

        @Override
        public boolean handlesReadonly() {
            return true;
        }
    };
    protected final File file;
    protected final FileChannel.MapMode mapMode;
    protected final RandomAccessFile raf;
    protected final FileLock fileLock;

    public MappedFileVolSingle(File file, boolean readOnly, long fileLockWait, long maxSize, boolean cleanerHackEnabled) {
        super(readOnly, maxSize, cleanerHackEnabled);
        this.file = file;
        this.mapMode = readOnly ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE;
        try {
            FileChannelVol.checkFolder(file, readOnly);
            this.raf = new RandomAccessFile(file, readOnly ? "r" : "rw");
            this.fileLock = Volume.lockFile(file, this.raf.getChannel(), readOnly, fileLockWait);
            long fileSize = this.raf.length();
            if (readOnly) {
                maxSize = Math.min(maxSize, fileSize);
            } else if (fileSize < maxSize) {
                this.raf.seek(fileSize);
                long offset = fileSize;
                do {
                    this.raf.write(CLEAR, 0, (int)Math.min((long)CLEAR.length, maxSize - offset));
                } while ((offset += (long)CLEAR.length) < maxSize);
            }
            this.buffer = this.raf.getChannel().map(this.mapMode, 0L, maxSize);
            if (readOnly) {
                this.buffer = this.buffer.asReadOnlyBuffer();
            }
        }
        catch (IOException e) {
            throw new DBException.VolumeIOError(e);
        }
    }

    @Override
    public synchronized void close() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        try {
            if (this.fileLock != null && this.fileLock.isValid()) {
                this.fileLock.release();
            }
            this.raf.close();
        }
        catch (IOException e) {
            throw new DBException.VolumeIOError(e);
        }
        if (this.cleanerHackEnabled && this.buffer != null && this.buffer instanceof MappedByteBuffer) {
            ByteBufferVol.unmap((MappedByteBuffer)this.buffer);
        }
        this.buffer = null;
    }

    @Override
    public synchronized void sync() {
        if (this.readOnly) {
            return;
        }
        if (this.buffer instanceof MappedByteBuffer) {
            ((MappedByteBuffer)this.buffer).force();
        }
    }

    @Override
    public long length() {
        return this.file.length();
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public boolean getFileLocked() {
        return this.fileLock != null && this.fileLock.isValid();
    }

    @Override
    public void truncate(long size) {
    }

    @Override
    public boolean fileLoad() {
        ((MappedByteBuffer)this.buffer).load();
        return true;
    }
}

