/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf.btree;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.rdf4j.common.io.ByteArrayUtil;
import org.eclipse.rdf4j.sail.nativerdf.btree.BTree;
import org.eclipse.rdf4j.sail.nativerdf.btree.Node;
import org.eclipse.rdf4j.sail.nativerdf.btree.NodeListener;
import org.eclipse.rdf4j.sail.nativerdf.btree.NodeListenerHandle;
import org.eclipse.rdf4j.sail.nativerdf.btree.RecordIterator;

class RangeIterator
implements RecordIterator,
NodeListener {
    private final BTree tree;
    private final byte[] searchKey;
    private final byte[] searchMask;
    private final byte[] minValue;
    private final byte[] maxValue;
    private volatile boolean started;
    private volatile Node currentNode;
    private final AtomicBoolean revisitValue = new AtomicBoolean();
    private final Deque<StackFrame> parentStack = new ArrayDeque<StackFrame>();
    private NodeListenerHandle currentNodeHandle;
    private volatile int currentIdx;
    private volatile boolean closed = false;

    public RangeIterator(BTree tree, byte[] searchKey, byte[] searchMask, byte[] minValue, byte[] maxValue) {
        this.tree = tree;
        this.searchKey = searchKey;
        this.searchMask = searchMask;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.started = false;
    }

    @Override
    public byte[] next() throws IOException {
        this.tree.btreeLock.readLock().lock();
        try {
            if (!this.started) {
                this.started = true;
                this.findMinimum();
            }
            byte[] value = this.findNext(this.revisitValue.getAndSet(false));
            while (value != null) {
                if (this.maxValue != null && this.tree.comparator.compareBTreeValues(this.maxValue, value, 0, value.length) < 0) {
                    this.close();
                    value = null;
                    break;
                }
                if (this.searchKey == null || ByteArrayUtil.matchesPattern(value, this.searchMask, this.searchKey)) break;
                value = this.findNext(false);
            }
            byte[] byArray = value;
            return byArray;
        }
        finally {
            this.tree.btreeLock.readLock().unlock();
        }
    }

    private void findMinimum() {
        this.currentNode = this.tree.readRootNode();
        Node nextCurrentNode = this.currentNode;
        if (nextCurrentNode == null) {
            return;
        }
        this.currentNodeHandle = nextCurrentNode.register(this);
        this.currentIdx = 0;
        while (true) {
            if (this.minValue != null) {
                this.currentIdx = nextCurrentNode.search(this.minValue);
                if (this.currentIdx >= 0) break;
                this.currentIdx = -this.currentIdx - 1;
            }
            if (nextCurrentNode.isLeaf()) break;
            Node childNode = nextCurrentNode.getChildNode(this.currentIdx);
            this.pushStacks(childNode);
            nextCurrentNode = this.currentNode;
        }
    }

    private byte[] findNext(boolean returnedFromRecursion) throws IOException {
        Node nextCurrentNode = this.currentNode;
        if (nextCurrentNode == null) {
            return null;
        }
        if (returnedFromRecursion || nextCurrentNode.isLeaf()) {
            if (this.currentIdx >= nextCurrentNode.getValueCount()) {
                this.popStacks();
                return this.findNext(true);
            }
            return nextCurrentNode.getValue(this.currentIdx++);
        }
        Node childNode = nextCurrentNode.getChildNode(this.currentIdx);
        this.pushStacks(childNode);
        return this.findNext(false);
    }

    @Override
    public void set(byte[] value) {
        this.tree.btreeLock.readLock().lock();
        try {
            Node nextCurrentNode = this.currentNode;
            if (nextCurrentNode == null || this.currentIdx > nextCurrentNode.getValueCount()) {
                throw new IllegalStateException();
            }
            nextCurrentNode.setValue(this.currentIdx - 1, value);
        }
        finally {
            this.tree.btreeLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.closed) {
            RangeIterator rangeIterator = this;
            synchronized (rangeIterator) {
                if (!this.closed) {
                    this.closed = true;
                    this.tree.btreeLock.readLock().lock();
                    try {
                        this.clearTraversalState();
                        assert (this.parentStack.isEmpty());
                    }
                    finally {
                        this.tree.btreeLock.readLock().unlock();
                    }
                }
            }
        }
    }

    private void pushStacks(Node newChildNode) {
        NodeListenerHandle childHandle = newChildNode.register(this);
        this.parentStack.addLast(new StackFrame(this.currentNode, this.currentIdx, this.currentNodeHandle));
        this.currentNode = newChildNode;
        this.currentNodeHandle = childHandle;
        this.currentIdx = 0;
    }

    private synchronized boolean popStacks() throws IOException {
        if (this.currentNode == null && this.parentStack.isEmpty()) {
            return false;
        }
        this.releaseCurrentFrame();
        StackFrame previous = this.parentStack.pollLast();
        if (previous != null) {
            this.currentNode = previous.node;
            this.currentIdx = previous.childIndex;
            this.currentNodeHandle = previous.handle;
            return true;
        }
        this.currentNode = null;
        this.currentIdx = 0;
        this.currentNodeHandle = null;
        return false;
    }

    private void clearTraversalState() throws IOException {
        while (this.currentNode != null || !this.parentStack.isEmpty()) {
            this.releaseCurrentFrame();
            StackFrame previous = this.parentStack.pollLast();
            if (previous == null) {
                this.currentNode = null;
                this.currentIdx = 0;
                this.currentNodeHandle = null;
                break;
            }
            this.currentNode = previous.node;
            this.currentIdx = previous.childIndex;
            this.currentNodeHandle = previous.handle;
        }
    }

    private void releaseCurrentFrame() throws IOException {
        Node nextCurrentNode = this.currentNode;
        if (nextCurrentNode != null) {
            if (this.currentNodeHandle != null) {
                this.currentNodeHandle.remove();
                this.currentNodeHandle = null;
            }
            nextCurrentNode.release();
        }
    }

    @Override
    public boolean valueAdded(Node node, int addedIndex) {
        block3: {
            block2: {
                assert (this.tree.btreeLock.isWriteLockedByCurrentThread());
                if (node != this.currentNode) break block2;
                if (addedIndex >= this.currentIdx) break block3;
                ++this.currentIdx;
                break block3;
            }
            for (StackFrame frame : this.parentStack) {
                if (node != frame.node) continue;
                if (addedIndex >= frame.childIndex) break;
                ++frame.childIndex;
                break;
            }
        }
        return false;
    }

    @Override
    public boolean valueRemoved(Node node, int removedIndex) {
        block3: {
            block2: {
                assert (this.tree.btreeLock.isWriteLockedByCurrentThread());
                if (node != this.currentNode) break block2;
                if (removedIndex >= this.currentIdx) break block3;
                --this.currentIdx;
                break block3;
            }
            for (StackFrame frame : this.parentStack) {
                if (node != frame.node) continue;
                if (removedIndex >= frame.childIndex) break;
                --frame.childIndex;
                break;
            }
        }
        return false;
    }

    @Override
    public boolean rotatedLeft(Node node, int valueIndex, Node leftChildNode, Node rightChildNode) throws IOException {
        block4: {
            block5: {
                Node nextCurrentNode;
                block3: {
                    nextCurrentNode = this.currentNode;
                    if (nextCurrentNode != node) break block3;
                    if (valueIndex != this.currentIdx - 1) break block4;
                    this.currentIdx = valueIndex;
                    this.revisitValue.set(true);
                    if (!node.isLeaf()) {
                        this.pushStacks(leftChildNode);
                        leftChildNode.use();
                    }
                    break block4;
                }
                if (nextCurrentNode != rightChildNode) break block5;
                if (this.currentIdx != 0) break block4;
                this.popStacks();
                this.currentIdx = valueIndex;
                this.revisitValue.set(true);
                break block4;
            }
            for (StackFrame frame : this.parentStack) {
                if (frame.node != rightChildNode) continue;
                int stackIdx = frame.childIndex;
                if (stackIdx != 0) break;
                NodeListenerHandle replacedHandle = frame.handle;
                if (replacedHandle != null) {
                    replacedHandle.remove();
                }
                rightChildNode.release();
                leftChildNode.use();
                NodeListenerHandle leftHandle = leftChildNode.register(this);
                frame.node = leftChildNode;
                frame.handle = leftHandle;
                frame.childIndex = leftChildNode.getValueCount();
                break;
            }
        }
        return false;
    }

    @Override
    public boolean rotatedRight(Node node, int valueIndex, Node leftChildNode, Node rightChildNode) throws IOException {
        for (StackFrame frame : this.parentStack) {
            if (frame.node != leftChildNode) continue;
            int stackIdx = frame.childIndex;
            if (stackIdx != leftChildNode.getValueCount()) break;
            NodeListenerHandle replacedHandle = frame.handle;
            if (replacedHandle != null) {
                replacedHandle.remove();
            }
            leftChildNode.release();
            rightChildNode.use();
            NodeListenerHandle rightHandle = rightChildNode.register(this);
            frame.node = rightChildNode;
            frame.handle = rightHandle;
            frame.childIndex = 0;
            break;
        }
        return false;
    }

    @Override
    public boolean nodeSplit(Node node, Node newNode, int medianIdx) throws IOException {
        boolean deregister;
        block5: {
            block4: {
                assert (this.tree.btreeLock.isWriteLockedByCurrentThread());
                deregister = false;
                Node nextCurrentNode = this.currentNode;
                if (node != nextCurrentNode) break block4;
                if (this.currentIdx <= medianIdx) break block5;
                if (this.currentNodeHandle != null) {
                    this.currentNodeHandle.remove();
                    this.currentNodeHandle = null;
                }
                nextCurrentNode.release();
                deregister = true;
                newNode.use();
                NodeListenerHandle newHandle = newNode.register(this);
                this.currentNode = newNode;
                this.currentNodeHandle = newHandle;
                this.currentIdx -= medianIdx + 1;
                break block5;
            }
            for (StackFrame frame : this.parentStack) {
                if (node != frame.node) continue;
                int parentIdx = frame.childIndex;
                if (parentIdx <= medianIdx) break;
                NodeListenerHandle replacedHandle = frame.handle;
                if (replacedHandle != null) {
                    replacedHandle.remove();
                }
                Node parentNode = frame.node;
                parentNode.release();
                deregister = true;
                newNode.use();
                NodeListenerHandle newHandle = newNode.register(this);
                frame.node = newNode;
                frame.handle = newHandle;
                frame.childIndex = parentIdx - medianIdx - 1;
                break;
            }
        }
        return deregister;
    }

    @Override
    public boolean nodeMergedWith(Node sourceNode, Node targetNode, int mergeIdx) throws IOException {
        assert (this.tree.btreeLock.isWriteLockedByCurrentThread());
        boolean deregister = false;
        Node nextCurrentNode = this.currentNode;
        if (sourceNode == nextCurrentNode) {
            if (this.currentNodeHandle != null) {
                this.currentNodeHandle.remove();
                this.currentNodeHandle = null;
            }
            nextCurrentNode.release();
            deregister = true;
            targetNode.use();
            NodeListenerHandle newHandle = targetNode.register(this);
            this.currentNode = targetNode;
            this.currentNodeHandle = newHandle;
            this.currentIdx += mergeIdx;
        } else {
            for (StackFrame frame : this.parentStack) {
                if (sourceNode != frame.node) continue;
                NodeListenerHandle replacedHandle = frame.handle;
                if (replacedHandle != null) {
                    replacedHandle.remove();
                }
                Node parentNode = frame.node;
                parentNode.release();
                deregister = true;
                targetNode.use();
                NodeListenerHandle newHandle = targetNode.register(this);
                frame.node = targetNode;
                frame.handle = newHandle;
                frame.childIndex = mergeIdx + frame.childIndex;
                break;
            }
        }
        return deregister;
    }

    public String toString() {
        return "RangeIterator{tree=" + String.valueOf(this.tree) + "}";
    }

    private static final class StackFrame {
        Node node;
        int childIndex;
        NodeListenerHandle handle;

        StackFrame(Node node, int childIndex, NodeListenerHandle handle) {
            this.node = node;
            this.childIndex = childIndex;
            this.handle = handle;
        }
    }
}

