/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.ir.util.transform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.queryrender.sparql.TupleExprIRRenderer;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrBGP;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrFilter;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrGraph;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNode;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrPathTriple;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrSelect;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrStatementPattern;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrSubSelect;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrText;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrTripleLike;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrUnion;
import org.eclipse.rdf4j.queryrender.sparql.ir.util.transform.BaseTransform;
import org.eclipse.rdf4j.queryrender.sparql.ir.util.transform.PathTextUtils;

public final class NormalizeZeroOrOneSubselectTransform
extends BaseTransform {
    private NormalizeZeroOrOneSubselectTransform() {
    }

    public static IrBGP apply(IrBGP bgp, TupleExprIRRenderer r) {
        if (bgp == null) {
            return null;
        }
        ArrayList<IrNode> out = new ArrayList<IrNode>();
        Iterator<IrNode> iterator = bgp.getLines().iterator();
        while (iterator.hasNext()) {
            IrNode n;
            IrNode transformed = n = iterator.next();
            if (n instanceof IrSubSelect) {
                IrNode repl = NormalizeZeroOrOneSubselectTransform.tryRewriteZeroOrOneNode((IrSubSelect)n, r);
                if (repl != null) {
                    transformed = repl;
                } else {
                    IrPathTriple pt = NormalizeZeroOrOneSubselectTransform.tryRewriteZeroOrOne((IrSubSelect)n, r);
                    if (pt != null) {
                        transformed = pt;
                    }
                }
            }
            transformed = transformed.transformChildren(child -> {
                if (child instanceof IrBGP) {
                    return NormalizeZeroOrOneSubselectTransform.apply((IrBGP)child, r);
                }
                return child;
            });
            out.add(transformed);
        }
        return BaseTransform.bgpWithLines(bgp, out);
    }

    public static IrPathTriple tryRewriteZeroOrOne(IrSubSelect ss, TupleExprIRRenderer r) {
        String[] so;
        IrBGP w0;
        Z01Analysis a = NormalizeZeroOrOneSubselectTransform.analyzeZeroOrOne(ss, r);
        if (a != null) {
            String expr = PathTextUtils.applyQuantifier(a.exprInner, '?');
            return new IrPathTriple(NormalizeZeroOrOneSubselectTransform.varNamed(a.sName), expr, NormalizeZeroOrOneSubselectTransform.varNamed(a.oName), false, Collections.emptySet());
        }
        IrSelect sel = ss.getSelect();
        if (sel == null || sel.getWhere() == null) {
            return null;
        }
        List<IrNode> inner = sel.getWhere().getLines();
        if (inner.isEmpty()) {
            return null;
        }
        IrUnion u = null;
        if (inner.size() == 1 && inner.get(0) instanceof IrUnion) {
            u = (IrUnion)inner.get(0);
        } else if (inner.size() == 1 && inner.get(0) instanceof IrBGP && (w0 = (IrBGP)inner.get(0)).getLines().size() == 1 && w0.getLines().get(0) instanceof IrUnion) {
            u = (IrUnion)w0.getLines().get(0);
        }
        if (u == null) {
            return null;
        }
        IrBGP filterBranch = null;
        ArrayList<IrBGP> stepBranches = new ArrayList<IrBGP>();
        for (IrBGP b : u.getBranches()) {
            if (NormalizeZeroOrOneSubselectTransform.isSameTermFilterBranch(b)) {
                if (filterBranch != null) {
                    return null;
                }
                filterBranch = b;
                continue;
            }
            stepBranches.add(b);
        }
        if (filterBranch == null || stepBranches.isEmpty()) {
            return null;
        }
        IrNode fbLine = filterBranch.getLines().get(0);
        if (fbLine instanceof IrText) {
            so = NormalizeZeroOrOneSubselectTransform.parseSameTermVars(((IrText)fbLine).getText());
        } else if (fbLine instanceof IrFilter) {
            String cond = ((IrFilter)fbLine).getConditionText();
            so = NormalizeZeroOrOneSubselectTransform.parseSameTermVarsFromCondition(cond);
        } else {
            so = null;
        }
        if (so == null) {
            return null;
        }
        String sName = so[0];
        String oName = so[1];
        ArrayList<Object> steps = new ArrayList<Object>();
        Var commonGraph = null;
        for (IrBGP b : stepBranches) {
            Object sp;
            if (b.getLines().size() != 1) {
                return null;
            }
            IrNode ln = b.getLines().get(0);
            if (ln instanceof IrStatementPattern) {
                sp = (IrStatementPattern)ln;
            } else if (ln instanceof IrGraph && ((IrGraph)ln).getWhere() != null && ((IrGraph)ln).getWhere().getLines().size() == 1 && ((IrGraph)ln).getWhere().getLines().get(0) instanceof IrStatementPattern) {
                IrGraph irGraph = (IrGraph)ln;
                sp = (IrStatementPattern)irGraph.getWhere().getLines().get(0);
                if (commonGraph == null) {
                    commonGraph = irGraph.getGraph();
                } else if (!NormalizeZeroOrOneSubselectTransform.sameVar(commonGraph, irGraph.getGraph())) {
                    return null;
                }
            } else {
                if (ln instanceof IrPathTriple) {
                    IrPathTriple irPathTriple = (IrPathTriple)ln;
                    if (NormalizeZeroOrOneSubselectTransform.sameVar(NormalizeZeroOrOneSubselectTransform.varNamed(sName), irPathTriple.getSubject()) && NormalizeZeroOrOneSubselectTransform.sameVar(NormalizeZeroOrOneSubselectTransform.varNamed(oName), irPathTriple.getObject())) {
                        steps.add(irPathTriple.getPathText());
                        continue;
                    }
                    return null;
                }
                if (ln instanceof IrGraph && ((IrGraph)ln).getWhere() != null && ((IrGraph)ln).getWhere().getLines().size() == 1 && ((IrGraph)ln).getWhere().getLines().get(0) instanceof IrPathTriple) {
                    IrGraph irGraph = (IrGraph)ln;
                    IrPathTriple pt = (IrPathTriple)irGraph.getWhere().getLines().get(0);
                    if (commonGraph == null) {
                        commonGraph = irGraph.getGraph();
                    } else if (!NormalizeZeroOrOneSubselectTransform.sameVar(commonGraph, irGraph.getGraph())) {
                        return null;
                    }
                    if (NormalizeZeroOrOneSubselectTransform.sameVar(NormalizeZeroOrOneSubselectTransform.varNamed(sName), pt.getSubject()) && NormalizeZeroOrOneSubselectTransform.sameVar(NormalizeZeroOrOneSubselectTransform.varNamed(oName), pt.getObject())) {
                        steps.add(BaseTransform.normalizeCompactNps(pt.getPathText()));
                        continue;
                    }
                    if (NormalizeZeroOrOneSubselectTransform.sameVar(NormalizeZeroOrOneSubselectTransform.varNamed(sName), pt.getObject()) && NormalizeZeroOrOneSubselectTransform.sameVar(NormalizeZeroOrOneSubselectTransform.varNamed(oName), pt.getSubject())) {
                        String inv = NormalizeZeroOrOneSubselectTransform.invertNpsIfPossible(BaseTransform.normalizeCompactNps(pt.getPathText()));
                        if (inv == null) {
                            return null;
                        }
                        steps.add(inv);
                        continue;
                    }
                    return null;
                }
                return null;
            }
            Var var = ((IrStatementPattern)sp).getPredicate();
            if (!NormalizeZeroOrOneSubselectTransform.isConstantIriPredicate((IrStatementPattern)sp)) {
                return null;
            }
            String step = r.convertIRIToString((IRI)var.getValue());
            if (NormalizeZeroOrOneSubselectTransform.sameVar(NormalizeZeroOrOneSubselectTransform.varNamed(sName), ((IrTripleLike)sp).getSubject()) && NormalizeZeroOrOneSubselectTransform.sameVar(NormalizeZeroOrOneSubselectTransform.varNamed(oName), ((IrTripleLike)sp).getObject())) {
                steps.add(step);
                continue;
            }
            if (NormalizeZeroOrOneSubselectTransform.sameVar(NormalizeZeroOrOneSubselectTransform.varNamed(sName), ((IrTripleLike)sp).getObject()) && NormalizeZeroOrOneSubselectTransform.sameVar(NormalizeZeroOrOneSubselectTransform.varNamed(oName), ((IrTripleLike)sp).getSubject())) {
                steps.add("^" + step);
                continue;
            }
            return null;
        }
        boolean allNps = true;
        ArrayList<String> npsMembers = new ArrayList<String>();
        for (String string : steps) {
            String t;
            String string2 = t = string == null ? null : string.trim();
            if (t == null || !t.startsWith("!(") || !t.endsWith(")")) {
                allNps = false;
                break;
            }
            String innerMembers = t.substring(2, t.length() - 1).trim();
            if (innerMembers.isEmpty()) continue;
            npsMembers.add(innerMembers);
        }
        Object exprInner = allNps && !npsMembers.isEmpty() ? "!(" + String.join((CharSequence)"|", npsMembers) + ")" : (steps.size() == 1 ? (String)steps.get(0) : "(" + String.join((CharSequence)"|", steps) + ")");
        String expr = PathTextUtils.applyQuantifier((String)exprInner, '?');
        return new IrPathTriple(NormalizeZeroOrOneSubselectTransform.varNamed(sName), expr, NormalizeZeroOrOneSubselectTransform.varNamed(oName), false, Collections.emptySet());
    }

    public static IrNode tryRewriteZeroOrOneNode(IrSubSelect ss, TupleExprIRRenderer r) {
        String[] so;
        IrBGP w0;
        Z01Analysis a = NormalizeZeroOrOneSubselectTransform.analyzeZeroOrOne(ss, r);
        if (a != null) {
            String expr = PathTextUtils.applyQuantifier(a.exprInner, '?');
            IrPathTriple pt = new IrPathTriple(NormalizeZeroOrOneSubselectTransform.varNamed(a.sName), expr, NormalizeZeroOrOneSubselectTransform.varNamed(a.oName), ss.isNewScope(), Collections.emptySet());
            if (a.allGraphWrapped && a.commonGraph != null) {
                IrBGP innerBgp = new IrBGP(false);
                innerBgp.add(pt);
                return new IrGraph(a.commonGraph, innerBgp, false);
            }
            return pt;
        }
        IrSelect sel = ss.getSelect();
        if (sel == null || sel.getWhere() == null) {
            return null;
        }
        List<IrNode> inner = sel.getWhere().getLines();
        if (inner.isEmpty()) {
            return null;
        }
        IrUnion u = null;
        if (inner.size() == 1 && inner.get(0) instanceof IrUnion) {
            u = (IrUnion)inner.get(0);
        } else if (inner.size() == 1 && inner.get(0) instanceof IrBGP && (w0 = (IrBGP)inner.get(0)).getLines().size() == 1 && w0.getLines().get(0) instanceof IrUnion) {
            u = (IrUnion)w0.getLines().get(0);
        }
        if (u == null) {
            return null;
        }
        IrBGP filterBranch = null;
        ArrayList<IrBGP> stepBranches = new ArrayList<IrBGP>();
        for (IrBGP b : u.getBranches()) {
            if (NormalizeZeroOrOneSubselectTransform.isSameTermFilterBranch(b)) {
                if (filterBranch != null) {
                    return null;
                }
                filterBranch = b;
                continue;
            }
            stepBranches.add(b);
        }
        if (filterBranch == null || stepBranches.isEmpty()) {
            return null;
        }
        IrNode fbLine = filterBranch.getLines().get(0);
        if (fbLine instanceof IrText) {
            so = NormalizeZeroOrOneSubselectTransform.parseSameTermVars(((IrText)fbLine).getText());
        } else if (fbLine instanceof IrFilter) {
            String cond = ((IrFilter)fbLine).getConditionText();
            so = NormalizeZeroOrOneSubselectTransform.parseSameTermVarsFromCondition(cond);
        } else {
            so = null;
        }
        if (so == null) {
            return null;
        }
        String sName = so[0];
        String oName = so[1];
        ArrayList<Object> steps = new ArrayList<Object>();
        boolean allGraphWrapped = true;
        Var commonGraph = null;
        for (IrBGP b : stepBranches) {
            if (b.getLines().size() != 1) {
                return null;
            }
            IrNode ln = b.getLines().get(0);
            if (ln instanceof IrStatementPattern) {
                allGraphWrapped = false;
                IrStatementPattern irStatementPattern = (IrStatementPattern)ln;
                Var p = irStatementPattern.getPredicate();
                if (!NormalizeZeroOrOneSubselectTransform.isConstantIriPredicate(irStatementPattern)) {
                    return null;
                }
                String step = r.convertIRIToString((IRI)p.getValue());
                if (NormalizeZeroOrOneSubselectTransform.sameVar(NormalizeZeroOrOneSubselectTransform.varNamed(sName), irStatementPattern.getSubject()) && NormalizeZeroOrOneSubselectTransform.sameVar(NormalizeZeroOrOneSubselectTransform.varNamed(oName), irStatementPattern.getObject())) {
                    steps.add(step);
                    continue;
                }
                if (NormalizeZeroOrOneSubselectTransform.sameVar(NormalizeZeroOrOneSubselectTransform.varNamed(sName), irStatementPattern.getObject()) && NormalizeZeroOrOneSubselectTransform.sameVar(NormalizeZeroOrOneSubselectTransform.varNamed(oName), irStatementPattern.getSubject())) {
                    steps.add("^" + step);
                    continue;
                }
                return null;
            }
            if (ln instanceof IrGraph) {
                IrGraph irGraph = (IrGraph)ln;
                if (irGraph.getWhere() == null || irGraph.getWhere().getLines().size() != 1) {
                    return null;
                }
                IrNode innerLn = irGraph.getWhere().getLines().get(0);
                if (innerLn instanceof IrStatementPattern) {
                    IrStatementPattern sp = (IrStatementPattern)innerLn;
                    Var p = sp.getPredicate();
                    if (p == null || !p.hasValue() || !(p.getValue() instanceof IRI)) {
                        return null;
                    }
                    if (commonGraph == null) {
                        commonGraph = irGraph.getGraph();
                    } else if (!NormalizeZeroOrOneSubselectTransform.sameVar(commonGraph, irGraph.getGraph())) {
                        return null;
                    }
                    String step = NormalizeZeroOrOneSubselectTransform.iri(p, r);
                    if (NormalizeZeroOrOneSubselectTransform.sameVar(NormalizeZeroOrOneSubselectTransform.varNamed(sName), sp.getSubject()) && NormalizeZeroOrOneSubselectTransform.sameVar(NormalizeZeroOrOneSubselectTransform.varNamed(oName), sp.getObject())) {
                        steps.add(step);
                        continue;
                    }
                    if (NormalizeZeroOrOneSubselectTransform.sameVar(NormalizeZeroOrOneSubselectTransform.varNamed(sName), sp.getObject()) && NormalizeZeroOrOneSubselectTransform.sameVar(NormalizeZeroOrOneSubselectTransform.varNamed(oName), sp.getSubject())) {
                        steps.add("^" + step);
                        continue;
                    }
                    return null;
                }
                if (innerLn instanceof IrPathTriple) {
                    IrPathTriple pt = (IrPathTriple)innerLn;
                    if (commonGraph == null) {
                        commonGraph = irGraph.getGraph();
                    } else if (!NormalizeZeroOrOneSubselectTransform.sameVar(commonGraph, irGraph.getGraph())) {
                        return null;
                    }
                    if (NormalizeZeroOrOneSubselectTransform.sameVar(NormalizeZeroOrOneSubselectTransform.varNamed(sName), pt.getSubject()) && NormalizeZeroOrOneSubselectTransform.sameVar(NormalizeZeroOrOneSubselectTransform.varNamed(oName), pt.getObject())) {
                        steps.add(BaseTransform.normalizeCompactNps(pt.getPathText()));
                        continue;
                    }
                    if (NormalizeZeroOrOneSubselectTransform.sameVar(NormalizeZeroOrOneSubselectTransform.varNamed(sName), pt.getObject()) && NormalizeZeroOrOneSubselectTransform.sameVar(NormalizeZeroOrOneSubselectTransform.varNamed(oName), pt.getSubject())) {
                        String inv = NormalizeZeroOrOneSubselectTransform.invertNpsIfPossible(BaseTransform.normalizeCompactNps(pt.getPathText()));
                        if (inv == null) {
                            return null;
                        }
                        steps.add(inv);
                        continue;
                    }
                    return null;
                }
                return null;
            }
            if (ln instanceof IrPathTriple) {
                allGraphWrapped = false;
                IrPathTriple irPathTriple = (IrPathTriple)ln;
                if (NormalizeZeroOrOneSubselectTransform.sameVar(NormalizeZeroOrOneSubselectTransform.varNamed(sName), irPathTriple.getSubject()) && NormalizeZeroOrOneSubselectTransform.sameVar(NormalizeZeroOrOneSubselectTransform.varNamed(oName), irPathTriple.getObject())) {
                    steps.add(BaseTransform.normalizeCompactNps(irPathTriple.getPathText()));
                    continue;
                }
                if (NormalizeZeroOrOneSubselectTransform.sameVar(NormalizeZeroOrOneSubselectTransform.varNamed(sName), irPathTriple.getObject()) && NormalizeZeroOrOneSubselectTransform.sameVar(NormalizeZeroOrOneSubselectTransform.varNamed(oName), irPathTriple.getSubject())) {
                    String inv = NormalizeZeroOrOneSubselectTransform.invertNpsIfPossible(BaseTransform.normalizeCompactNps(irPathTriple.getPathText()));
                    if (inv == null) {
                        return null;
                    }
                    steps.add(inv);
                    continue;
                }
                return null;
            }
            return null;
        }
        boolean allNps = true;
        ArrayList<String> npsMembers = new ArrayList<String>();
        for (String string : steps) {
            String t;
            String string2 = t = string == null ? null : string.trim();
            if (t == null || !t.startsWith("!(") || !t.endsWith(")")) {
                allNps = false;
                break;
            }
            String innerMembers = t.substring(2, t.length() - 1).trim();
            if (innerMembers.isEmpty()) continue;
            npsMembers.add(innerMembers);
        }
        Object exprInner = allNps && !npsMembers.isEmpty() ? "!(" + String.join((CharSequence)"|", npsMembers) + ")" : (steps.size() == 1 ? (String)steps.get(0) : "(" + String.join((CharSequence)"|", steps) + ")");
        String string = PathTextUtils.applyQuantifier((String)exprInner, '?');
        IrPathTriple pt = new IrPathTriple(NormalizeZeroOrOneSubselectTransform.varNamed(sName), string, NormalizeZeroOrOneSubselectTransform.varNamed(oName), false, Collections.emptySet());
        if (allGraphWrapped && commonGraph != null) {
            IrBGP innerBgp = new IrBGP(false);
            innerBgp.add(pt);
            return new IrGraph(commonGraph, innerBgp, false);
        }
        return pt;
    }

    private static String invertNpsIfPossible(String nps) {
        if (nps == null) {
            return null;
        }
        String s = BaseTransform.normalizeCompactNps(nps);
        if (!s.startsWith("!(") || !s.endsWith(")")) {
            return null;
        }
        String inner = s.substring(2, s.length() - 1);
        if (inner.isEmpty()) {
            return s;
        }
        String[] toks = inner.split("\\|");
        ArrayList<Object> out = new ArrayList<Object>(toks.length);
        for (String tok : toks) {
            String t = tok.trim();
            if (t.isEmpty()) continue;
            if (t.startsWith("^")) {
                out.add(t.substring(1));
                continue;
            }
            out.add("^" + t);
        }
        return "!(" + String.join((CharSequence)"|", out) + ")";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Z01Analysis analyzeZeroOrOne(IrSubSelect ss, TupleExprIRRenderer r) {
        String oName;
        String sName;
        String[] so;
        IrBGP w0;
        IrSelect sel = ss.getSelect();
        if (sel == null || sel.getWhere() == null) {
            return null;
        }
        List<IrNode> inner = sel.getWhere().getLines();
        if (inner.isEmpty()) {
            return null;
        }
        IrUnion u = null;
        if (inner.size() == 1 && inner.get(0) instanceof IrUnion) {
            u = (IrUnion)inner.get(0);
        } else if (inner.size() == 1 && inner.get(0) instanceof IrBGP && (w0 = (IrBGP)inner.get(0)).getLines().size() == 1 && w0.getLines().get(0) instanceof IrUnion) {
            u = (IrUnion)w0.getLines().get(0);
        }
        if (u == null) {
            return null;
        }
        IrBGP filterBranch = null;
        ArrayList<IrBGP> stepBranches = new ArrayList<IrBGP>();
        for (IrBGP b : u.getBranches()) {
            if (NormalizeZeroOrOneSubselectTransform.isSameTermFilterBranch(b)) {
                if (filterBranch != null) {
                    return null;
                }
                filterBranch = b;
                continue;
            }
            stepBranches.add(b);
        }
        if (filterBranch == null || stepBranches.isEmpty()) {
            return null;
        }
        IrNode fbLine = filterBranch.getLines().get(0);
        if (fbLine instanceof IrText) {
            so = NormalizeZeroOrOneSubselectTransform.parseSameTermVars(((IrText)fbLine).getText());
        } else if (fbLine instanceof IrFilter) {
            String cond = ((IrFilter)fbLine).getConditionText();
            so = NormalizeZeroOrOneSubselectTransform.parseSameTermVarsFromCondition(cond);
        } else {
            so = null;
        }
        if (so != null) {
            sName = so[0];
            oName = so[1];
        } else {
            Var oVar;
            Var sVar;
            IrBGP first = (IrBGP)stepBranches.get(0);
            if (first.getLines().size() != 1) {
                return null;
            }
            IrNode ln = first.getLines().get(0);
            if (ln instanceof IrStatementPattern) {
                IrStatementPattern sp = (IrStatementPattern)ln;
                sVar = sp.getSubject();
                oVar = sp.getObject();
            } else if (ln instanceof IrGraph) {
                IrGraph g = (IrGraph)ln;
                if (g.getWhere() == null || g.getWhere().getLines().size() != 1) {
                    return null;
                }
                IrNode gln = g.getWhere().getLines().get(0);
                if (gln instanceof IrStatementPattern) {
                    IrStatementPattern irStatementPattern = (IrStatementPattern)gln;
                    sVar = irStatementPattern.getSubject();
                    oVar = irStatementPattern.getObject();
                } else {
                    if (!(gln instanceof IrPathTriple)) return null;
                    IrPathTriple irPathTriple = (IrPathTriple)gln;
                    sVar = irPathTriple.getSubject();
                    oVar = irPathTriple.getObject();
                }
            } else {
                if (!(ln instanceof IrPathTriple)) return null;
                IrPathTriple pt = (IrPathTriple)ln;
                sVar = pt.getSubject();
                oVar = pt.getObject();
            }
            if (sVar == null || sVar.hasValue() || sVar.getName() == null) {
                return null;
            }
            if (oVar == null || oVar.hasValue() || oVar.getName() == null) {
                return null;
            }
            sName = sVar.getName();
            oName = oVar.getName();
        }
        ArrayList<Object> steps = new ArrayList<Object>();
        boolean allGraphWrapped = true;
        Var commonGraph = null;
        for (IrBGP b : stepBranches) {
            if (b.getLines().size() != 1) {
                return null;
            }
            IrNode ln = b.getLines().get(0);
            if (ln instanceof IrStatementPattern) {
                allGraphWrapped = false;
                IrStatementPattern irStatementPattern = (IrStatementPattern)ln;
                Var p = irStatementPattern.getPredicate();
                if (p == null) return null;
                if (!p.hasValue() || !(p.getValue() instanceof IRI)) {
                    return null;
                }
                String step = NormalizeZeroOrOneSubselectTransform.iri(p, r);
                if (NormalizeZeroOrOneSubselectTransform.sameVar(NormalizeZeroOrOneSubselectTransform.varNamed(sName), irStatementPattern.getSubject()) && NormalizeZeroOrOneSubselectTransform.sameVar(NormalizeZeroOrOneSubselectTransform.varNamed(oName), irStatementPattern.getObject())) {
                    steps.add(step);
                    continue;
                }
                if (!NormalizeZeroOrOneSubselectTransform.sameVar(NormalizeZeroOrOneSubselectTransform.varNamed(sName), irStatementPattern.getObject()) || !NormalizeZeroOrOneSubselectTransform.sameVar(NormalizeZeroOrOneSubselectTransform.varNamed(oName), irStatementPattern.getSubject())) return null;
                steps.add("^" + step);
                continue;
            }
            if (ln instanceof IrGraph) {
                IrGraph irGraph = (IrGraph)ln;
                if (irGraph.getWhere() == null || irGraph.getWhere().getLines().size() != 1) {
                    return null;
                }
                IrNode innerLn = irGraph.getWhere().getLines().get(0);
                if (innerLn instanceof IrStatementPattern) {
                    IrStatementPattern sp = (IrStatementPattern)innerLn;
                    Var p = sp.getPredicate();
                    if (p == null || !p.hasValue() || !(p.getValue() instanceof IRI)) {
                        return null;
                    }
                    if (commonGraph == null) {
                        commonGraph = irGraph.getGraph();
                    } else if (!NormalizeZeroOrOneSubselectTransform.sameVar(commonGraph, irGraph.getGraph())) {
                        return null;
                    }
                    String step = r.convertIRIToString((IRI)p.getValue());
                    if (NormalizeZeroOrOneSubselectTransform.sameVar(NormalizeZeroOrOneSubselectTransform.varNamed(sName), sp.getSubject()) && NormalizeZeroOrOneSubselectTransform.sameVar(NormalizeZeroOrOneSubselectTransform.varNamed(oName), sp.getObject())) {
                        steps.add(step);
                        continue;
                    }
                    if (!NormalizeZeroOrOneSubselectTransform.sameVar(NormalizeZeroOrOneSubselectTransform.varNamed(sName), sp.getObject()) || !NormalizeZeroOrOneSubselectTransform.sameVar(NormalizeZeroOrOneSubselectTransform.varNamed(oName), sp.getSubject())) return null;
                    steps.add("^" + step);
                    continue;
                }
                if (!(innerLn instanceof IrPathTriple)) return null;
                IrPathTriple pt = (IrPathTriple)innerLn;
                if (commonGraph == null) {
                    commonGraph = irGraph.getGraph();
                } else if (!NormalizeZeroOrOneSubselectTransform.sameVar(commonGraph, irGraph.getGraph())) {
                    return null;
                }
                String txt = BaseTransform.normalizeCompactNps(pt.getPathText());
                if (NormalizeZeroOrOneSubselectTransform.sameVar(NormalizeZeroOrOneSubselectTransform.varNamed(sName), pt.getSubject()) && NormalizeZeroOrOneSubselectTransform.sameVar(NormalizeZeroOrOneSubselectTransform.varNamed(oName), pt.getObject())) {
                    steps.add(txt);
                    continue;
                }
                if (!NormalizeZeroOrOneSubselectTransform.sameVar(NormalizeZeroOrOneSubselectTransform.varNamed(sName), pt.getObject()) || !NormalizeZeroOrOneSubselectTransform.sameVar(NormalizeZeroOrOneSubselectTransform.varNamed(oName), pt.getSubject())) return null;
                String inv = NormalizeZeroOrOneSubselectTransform.invertNpsIfPossible(txt);
                if (inv == null) {
                    return null;
                }
                steps.add(inv);
                continue;
            }
            if (!(ln instanceof IrPathTriple)) return null;
            allGraphWrapped = false;
            IrPathTriple irPathTriple = (IrPathTriple)ln;
            String txt = BaseTransform.normalizeCompactNps(irPathTriple.getPathText());
            if (NormalizeZeroOrOneSubselectTransform.sameVar(NormalizeZeroOrOneSubselectTransform.varNamed(sName), irPathTriple.getSubject()) && NormalizeZeroOrOneSubselectTransform.sameVar(NormalizeZeroOrOneSubselectTransform.varNamed(oName), irPathTriple.getObject())) {
                steps.add(txt);
                continue;
            }
            if (!NormalizeZeroOrOneSubselectTransform.sameVar(NormalizeZeroOrOneSubselectTransform.varNamed(sName), irPathTriple.getObject()) || !NormalizeZeroOrOneSubselectTransform.sameVar(NormalizeZeroOrOneSubselectTransform.varNamed(oName), irPathTriple.getSubject())) return null;
            String inv = NormalizeZeroOrOneSubselectTransform.invertNpsIfPossible(txt);
            if (inv == null) {
                return null;
            }
            steps.add(inv);
        }
        if (steps.isEmpty()) {
            return null;
        }
        boolean allNps = true;
        ArrayList<String> npsMembers = new ArrayList<String>();
        for (String string : steps) {
            String t;
            String string2 = t = string == null ? null : string.trim();
            if (t == null || !t.startsWith("!(") || !t.endsWith(")")) {
                allNps = false;
                break;
            }
            String innerMembers = t.substring(2, t.length() - 1).trim();
            if (innerMembers.isEmpty()) continue;
            npsMembers.add(innerMembers);
        }
        Object exprInner = allNps && !npsMembers.isEmpty() ? "!(" + String.join((CharSequence)"|", npsMembers) + ")" : (steps.size() == 1 ? (String)steps.get(0) : "(" + String.join((CharSequence)"|", steps) + ")");
        return new Z01Analysis(sName, oName, (String)exprInner, allGraphWrapped, commonGraph);
    }

    public static String[] parseSameTermVars(String text) {
        if (text == null) {
            return null;
        }
        Matcher m = Pattern.compile("(?i)\\s*FILTER\\s*(?:\\(\\s*)?sameTerm\\s*\\(\\s*\\?(?<s>[A-Za-z_][\\w]*)\\s*,\\s*\\?(?<o>[A-Za-z_][\\w]*)\\s*\\)\\s*(?:\\)\\s*)?").matcher(text);
        if (!m.matches()) {
            return null;
        }
        return new String[]{m.group("s"), m.group("o")};
    }

    public static boolean isSameTermFilterBranch(IrBGP b) {
        if (b == null || b.getLines().size() != 1) {
            return false;
        }
        IrNode ln = b.getLines().get(0);
        if (ln instanceof IrText) {
            String t = ((IrText)ln).getText();
            if (t == null) {
                return false;
            }
            if (NormalizeZeroOrOneSubselectTransform.parseSameTermVars(t) != null) {
                return true;
            }
            return t.contains("sameTerm(");
        }
        if (ln instanceof IrFilter) {
            String cond = ((IrFilter)ln).getConditionText();
            if (NormalizeZeroOrOneSubselectTransform.parseSameTermVarsFromCondition(cond) != null) {
                return true;
            }
            return cond != null && cond.contains("sameTerm(");
        }
        return false;
    }

    public static Var varNamed(String name) {
        if (name == null) {
            return null;
        }
        return Var.of((String)name, (boolean)name.contains("_anon_"));
    }

    private static String[] parseSameTermVarsFromCondition(String cond) {
        if (cond == null) {
            return null;
        }
        Matcher m = Pattern.compile("(?i)\\s*sameTerm\\s*\\(\\s*\\?(?<s>[A-Za-z_][\\w]*)\\s*,\\s*\\?(?<o>[A-Za-z_][\\w]*)\\s*\\)\\s*").matcher(cond);
        if (!m.matches()) {
            return null;
        }
        return new String[]{m.group("s"), m.group("o")};
    }

    private static final class Z01Analysis {
        final String sName;
        final String oName;
        final String exprInner;
        final boolean allGraphWrapped;
        final Var commonGraph;

        Z01Analysis(String sName, String oName, String exprInner, boolean allGraphWrapped, Var commonGraph) {
            this.sName = sName;
            this.oName = oName;
            this.exprInner = exprInner;
            this.allGraphWrapped = allGraphWrapped;
            this.commonGraph = commonGraph;
        }
    }
}

